//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: tvout_board_def.h
//
//  Defines macros, structures, pre-defined functions, and etc for the TVout Driver.
//
#ifndef __TVOUT_BOARD_DEP_H
#define __TVOUT_BOARD_DEP_H

#if __cplusplus
	extern "C"
	{
#endif

#include <windows.h>
#include <bsp.h> 
#include <bsp_cfg.h>
#include <register_map.h>

#include "tvout_internal.h"

static volatile PGPIO_REG g_pGpioReg;

void TVout_board_dep_power_on(void);

void TVout_board_dep_power_off(void);

TVOUT_POWER_ERROR Tvout_board_dep_initialize_register_address (void * pGpioReg);
TVOUT_POWER_ERROR Tvout_board_dep_deinitialize_register_address (void * pGpioReg);

#if __cplusplus
	}
#endif

#endif    // __TVOUT_BOARD_DEP_H

