//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: sdout.h
//
//  Defines macros, structures, pre-defined functions, and etc for the SDOUT.
//
#ifndef __SDOUT_H
#define __SDOUT_H

#if __cplusplus
    extern "C"
    {
#endif

#include "tvout_internal.h"


/*============================================================================*/
// Pre-defined functions
/*============================================================================*/

// initialization
//  - iniization functions are only called under stopping sdout
SDOUT_ERROR Sdout_initialize_register_address(void *pSdoutReg);
SDOUT_ERROR Sdout_initialize_display_mode(TVOUT_DISPLAY_MODE dispMode,
                                          TVOUT_OUTPUT_MODE outMode);
SDOUT_ERROR Sdout_initialize_video_scale_cfg(SDOUT_LEVEL componentLevel,
                                             SDOUT_VIDEO_SYNC_RATIO componentRatio,
                                             SDOUT_LEVEL compositeLevel,
                                             SDOUT_VIDEO_SYNC_RATIO compositeRatio);
SDOUT_ERROR Sdout_initialize_sync_signal_pin(SDOUT_SYNC_SIG_PIN pin);
SDOUT_ERROR Sdout_initialize_vbi(BOOL wssCVBS,
                                SDOUT_CLOSED_CAPTION_INS captionCVBS,
                                BOOL wssYSideo,
                                SDOUT_CLOSED_CAPTION_INS captionYSideo,
                                BOOL cgmsaRGB,
                                BOOL wssRGB,
                                SDOUT_CLOSED_CAPTION_INS captionRGB,
                                BOOL cgmsaYPbPr,
                                BOOL wssYPbPr,
                                SDOUT_CLOSED_CAPTION_INS captionYPbPr);
SDOUT_ERROR Sdout_initialize_offset_gain(SDOUT_CHANNEL_SEL channel,
                                               unsigned int uiOffset,
                                               unsigned int uiGain);
void Sdout_initialize_delay(unsigned int uiDelayY,
                                 unsigned int uiOffsetVideoStart,
                                 unsigned int uiOffsetVideoEnd);
void Sdout_initialize_schlock(BOOL bColorSubCarrierPhaseAdjustment);
SDOUT_ERROR Sdout_initialize_dac_power_onoff(SDOUT_CHANNEL_SEL channel,
                                                       BOOL bDacOn);
//SDOUT_ERROR Sdout_initialize_antialias_filter_coeff
//                                    (SDOUT_ANTIALIAS_FILTER_COEFFICIENTS coeff);
void Sdout_initialize_color_compensaton_onoff(BOOL bBrightHueSaturationAdj,
                                                BOOL bYPbPrColorCompensation,
                                                BOOL bRGBcolorCompensation,
                                                BOOL bYCcolorCompensaton,
                                                BOOL bCVBSCcolorCompensaton);
void Sdout_initialize_brightness_hue_saturation
                                        (unsigned int uiGainBrightness,
                                         unsigned int uiOffsetBrightness,
                                         unsigned int uiGain0CbHueSaturation,
                                         unsigned int uiGain1CbHueSaturation,
                                         unsigned int uiGain0CrHueSaturation,
                                         unsigned int uiGain1CrHueSaturation,
                                         unsigned int uiOffsetCbHueSaturation,
                                         unsigned int uiOffsetCrHueSaturation);
void Sdout_initialize_rgb_color_compensation(unsigned int uiMaxRGBCube,
                                              unsigned int uiMinRGBCube);
void Sdout_initialize_cvbs_color_compensation(unsigned int uiYLowerMid,
                                                unsigned int uiYBottom,
                                                unsigned int uiYTop,
                                                unsigned int uiYUpperMid,
                                                unsigned int uiRadius);
void Sdout_initialize_svideo_color_compensation(unsigned int uiYTop,
                                                  unsigned int uiYBottom,
                                                  unsigned int uiYCCylinder);
void Sdout_initialize_component_porch(unsigned int ui525Back,
                                        unsigned int ui525Front,
                                        unsigned int ui625Back,
                                        unsigned int ui625Front);
SDOUT_ERROR Sdout_initialize_vesa_rgb_sync(SDOUT_VESA_RGB_SYNC_TYPE syncType,
                                            TVOUT_ACTIVE_POLARITY vsyncActive,
                                            TVOUT_ACTIVE_POLARITY hsyncActive);
void Sdout_initialize_oversampling_filter_coeff(unsigned int uiSize,
                                               unsigned int* puiCoeff0,
                                               unsigned int* puiCoeff1,
                                               unsigned int* puiCoeff2);
SDOUT_ERROR Sdout_initialize_channel_xtalk_cancellation_coeff
                                            (SDOUT_CHANNEL_SEL channel,
                                             unsigned int uiCoeff2,
                                             unsigned int uiCoeff1);
void Sdout_initialize_closed_caption(unsigned int uiDisplayCC,
                                     unsigned int uiNonDisplayCC);
SDOUT_ERROR Sdout_initialize_wss525_data
                           (SDOUT_525_DATA_COPY_PERMIT_MODE copyPermit,
                            SDOUT_525_DATA_MV_PSP_MODE mvPsp,
                            SDOUT_525_DATA_COPY_INFO_MODE copyInfo,
                            BOOL bAnalogOn,
                            SDOUT_525_DATA_DISPLAY_ASPECT_RATIO displayRatio);
SDOUT_ERROR Sdout_initialize_wss625_data
                            (BOOL bSurrounfSound,
                             BOOL bCopyright,
                             BOOL bCopyProtection,
                             BOOL bTextSubtitles,
                             SDOUT_625_DATA_OPEN_SUBTITLES openSubtitles,
                             SDOUT_625_DATA_CAMERA_FILM_MODE cameraFilm,
                             SDOUT_625_DATA_COLOR_ENCODING colorEncoding,
                             BOOL bHelperSignal,
                             SDOUT_625_DATA_DISPLAY_ASPECT_RATIO displayRatio);
SDOUT_ERROR Sdout_initialize_cgmsa525_data
                           (SDOUT_525_DATA_COPY_PERMIT_MODE copyPermit,
                            SDOUT_525_DATA_MV_PSP_MODE mvPsp,
                            SDOUT_525_DATA_COPY_INFO_MODE copyInfo,
                            BOOL bAnalogOn,
                            SDOUT_525_DATA_DISPLAY_ASPECT_RATIO displayRatio);
SDOUT_ERROR Sdout_initialize_cgmsa625_data
                            (BOOL bSurrounfSound,
                             BOOL bCopyright,
                             BOOL bCopyProtection,
                             BOOL bTextSubtitles,
                             SDOUT_625_DATA_OPEN_SUBTITLES openSubtitles,
                             SDOUT_625_DATA_CAMERA_FILM_MODE cameraFilm,
                             SDOUT_625_DATA_COLOR_ENCODING colorEncoding,
                             BOOL bHelperSignal,
                             SDOUT_625_DATA_DISPLAY_ASPECT_RATIO displayRatio);


// set
//  - set functions are only called under running sdout


// etc
//  -


// start
//  - start functions are only called under stopping sdout
void Sdout_start(void);


// stop
//  - stop functions are only called under running sdout
void Sdout_stop(void);


// reset
//  - reset function
void Sdout_sw_reset(BOOL bActive);


// interrupt
//  -
void Sdout_set_interrupt_enable(BOOL bVsyncIntrEn);
void Sdout_clear_interrupt_pending(void);//bVsyncIntr
BOOL Sdout_get_interrupt_pending(void);


/*============================================================================*/


#if __cplusplus
    }
#endif

#endif    // __SDOUT_H
