//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: hdmi_audio.h
//
//  Defines macros, structures, pre-defined functions, and etc for the HDMI VIDEO.
//
#ifndef __HDMI_AUDIO_H
#define __HDMI_AUDIO_H

#if __cplusplus
    extern "C"
    {
#endif

#include "tvd_api.h"




typedef enum {
	NONE=0, PCM, AC3, MP3, WMA
} AUDIO_CODEC_TYPE;


// SPDIFIN_IRQ_MASK
#define    IRQ_WRONG_SIGNAL_ENABLE                          (1<<0)
#define    IRQ_CH_STATUS_RECOVERED_ENABLE                       (1<<1)
#define    IRQ_WRONG_PREAMBLE_ENABLE                            (1<<2)
#define    IRQ_STREAM_HEADER_NOT_DETECTED_ENABLE                (1<<3)
#define    IRQ_STREAM_HEADER_DETECTED_ENABLE                    (1<<4)
#define    IRQ_STREAM_HEADER_NOT_DETECTED_AT_RIGHTTIME_ENABLE   (1<<5)
#define    IRQ_ABNORMAL_PD_ENABLE                               (1<<6)
#define    IRQ_BUFFER_OVERFLOW_ENABLE                           (1<<7)


//SPDIFIN_CONFIG_1

#define CONFIG_FILTER_3_SAMPLE              (0<<6)
#define CONFIG_FILTER_2_SAMPLE              (1<<6)
#define CONFIG_LINEAR_PCM_TYPE              (0<<5)
#define CONFIG_NON_LINEAR_PCM_TYPE          (1<<5)
#define CONFIG_PCPD_AUTO_SET                (0<<4)
#define CONFIG_PCPD_MANUAL_SET              (1<<4)
#define CONFIG_WORD_LENGTH_AUTO_SET         (0<<3)
#define CONFIG_WORD_LENGTH_MANUAL_SET       (1<<3)
#define CONFIG_U_V_C_P_NEGLECT              (0<<2)
#define CONFIG_U_V_C_P_REPORT               (1<<2)
#define CONFIG_BURST_SIZE_1                 (0<<1)
#define CONFIG_BURST_SIZE_2                 (1<<1)
#define CONFIG_DATA_ALIGN_16BIT             (0<<0)
#define CONFIG_DATA_ALIGN_32BIT             (1<<0)



// audio


HDMI_ERROR
HDMI_Audio_Init(AUDIO_CODEC_TYPE AudioCodec, DWORD dwSampleRate, DWORD dwBits, DWORD dwFrameSizeCode);


HDMI_ERROR
HDMI_audio_initialize_register_address(void *pHDMIReg, void *pSPDIFReg);

void
HDMI_Audio_Set_Config(AUDIO_CODEC_TYPE AudioCodec);

void
HDMI_Audio_Set_ACR(DWORD dwSampleRate);

void
HDMI_Audio_Set_ASP();

void
HDMI_Audio_Set_AUI(AUDIO_CODEC_TYPE AudioCodec, DWORD dwSampleRate, DWORD dwBits);

void    
HDMI_Audio_Clock_Enable();

void
HDMI_Audio_Set_Repetition_Time(AUDIO_CODEC_TYPE AudioCodec, DWORD dwBits, DWORD dwFrameSizeCode);

void
HDMI_Audio_IRQ_ENABLE(DWORD   dwIRQEn);

/*============================================================================*/

#if __cplusplus
    }
#endif

#endif    // __HDMI_AUDIO_H


