//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: hdmi_internal.h
//
//  Defines macros, structures, pre-defined functions, and etc for the HDMI.
//
#ifndef __HDMI_INTERNAL_H
#define __HDMI_INTERNAL_H

#if __cplusplus
    extern "C"
    {
#endif

// macro
#include "hdmi_macro.h"

#include "hdmi_phy.h"
#include "tvout_global.h"
#include <hdmireg.h>

// global variables
////static volatile PHDMI_REG g_pHDMIConfig = NULL;     // HDMI Register

static volatile PHDMI_SS_REG g_pHDMISSConfig = NULL;
static volatile PHDMI_CORE_REG g_pHDMICoreConfig = NULL;
static volatile PHDMI_HDCP_REG g_pHDCPConfig = NULL;     // HDMI Register
static volatile PHDMI_TG_REG g_pHDMITGConfig = NULL;         // TG Register

static volatile GPIO_REG     *g_pGPIOReg     = NULL;
static volatile CMU_CLK_REG     *g_pSysConReg     = NULL;
static volatile IIC_REG     *g_pIICReg        = NULL;

// Video parameters to set HDMI HW

static const struct params
{
	UINT16 	vHBlank;          	// H Blank
	UINT32 	vVBlank;          	// V Blank
	UINT32 	vHVLine;          	// HVLine
	UINT32 	vHSYNCGEN;        	// HSYNCGen
	UINT32 	vVSYNCGEN;		// VSYCGen don't care the frequency (50/60)
	UINT8  	vAVI_VIC;		// CEA VIC
	UINT8  	vAVI_VIC_16_9;	// CEA VIC
	UINT8  	interlaced;		// 0 - non-interlaced, 1 - interlaced
	UINT8  	repetition;		// pixel repetition
	UINT8  	polarity;			// VSYNC polarity
	UINT32 	VBLANK_F;		// VBLANK for Interlaced
	UINT32 	VSYNCGEN2;		// VSYNC for Interlaced
	UINT32 	VSYNCGEN3;		//
	PHYFreq PixelClock;	// pixel clock
} 	aVideoParams[] =
	{
		{ 0xA0 , 0x16A0D, 0x32020D, 0x11B80E, 0xA00C , 1 , 1 , 0, 0, 1, 0			, 0			, 0       		, PHY_FREQ_25_200,  	},  // v640x480p_60Hz   
		{ 0x8A , 0x16A0D, 0x35A20D, 0x11300E, 0x900F , 2 , 3 , 0, 0, 1, 0			, 0			, 0       		, PHY_FREQ_27_027,  	},  // v720x480p_60Hz
		{ 0x172, 0xF2EE , 0x6722EE, 0x2506C , 0x500A , 4 , 4 , 0, 0, 0, 0			, 0			, 0       		, PHY_FREQ_74_250, 	},  // v1280x720p_60Hz
		{ 0x118, 0xB232 , 0x898465, 0x20856 , 0x2007 , 5 , 5 , 1, 0, 0, 0x232A49	, 0x234239	, 0x4A44A4	, PHY_FREQ_74_250, 	},  // v1920x1080i_60Hz
		{ 0x114, 0xB106 , 0x6B420D, 0x128024, 0x4007 , 6 , 7 , 1, 1, 1, 0x10691D	, 0x10A10D	, 0x380380	, PHY_FREQ_27_027,  	},  // v720x480i_60Hz   
		{ 0x114, 0xB106 , 0x6B4106, 0x128024, 0x4007 , 8 , 9 , 0, 1, 1, 0			, 0       		, 0       		, PHY_FREQ_27_027,  	},  // v720x240p_60Hz   
		{ 0x228, 0xB106 , 0xD6820D, 0x15084A, 0x4007 , 10, 11, 1, 1, 1, 0x10691D	, 0x10A10D	, 0x700700	, PHY_FREQ_54_054,  	},  // v2880x480i_60Hz   
		{ 0x228, 0xB106 , 0x6B4106, 0x15084A, 0x4007 , 12, 13, 0, 1, 1, 0			, 0       		, 0       		, PHY_FREQ_54_054,  	},  // v2880x240p_60Hz   
		{ 0x114, 0x16A0D, 0x6B420D, 0x12681E, 0x900F , 14, 15, 0, 1, 1, 0			, 0			, 0			, PHY_FREQ_54_054,  	},  // v1440x480p_60Hz
		{ 0x118, 0x16C65, 0x898465, 0x20856 , 0x4009 , 16, 16, 0, 0, 0, 0			, 0			, 0			, PHY_FREQ_148_500, 	},  // v1920x1080p_60Hz
		
		{ 0x90 , 0x18A71, 0x360271, 0x11280A, 0x500A , 17, 18, 0, 0, 1, 0			, 0			, 0			, PHY_FREQ_27,      	},  // v720x576p_50Hz
		{ 0x2BC, 0xF2EE , 0x7BC2EE, 0x779B6 , 0x500A , 19, 19, 0, 0, 0, 0			, 0			, 0			, PHY_FREQ_74_250,  	},  // v1280x720p_50Hz
		{ 0x2D0, 0xB232 , 0xA50465, 0x8EA0E , 0x2007 , 20, 20, 1, 0, 0, 0x232A49	, 0x234239	, 0x738738	, PHY_FREQ_74_250,  	},  // v1920x1080i_50Hz
		{ 0x120, 0xC138 , 0x6C0271, 0x125016, 0x2005 , 21, 22, 1, 1, 1, 0x138951	, 0x13A13D	, 0x378378	, PHY_FREQ_27,      	},  // v720x576i_50Hz
		{ 0x120, 0xC138 , 0x6C0138, 0x125016, 0x3006 , 23, 24, 0, 1, 1, 0       		, 0       		, 0       		, PHY_FREQ_27,      	},  // v720x288p_50Hz
		{ 0x240, 0xC138 , 0xD80271, 0x14A82E, 0x2005 , 25, 26, 1, 1, 1, 0x138951	, 0x13A13D	, 0x6F06F0	, PHY_FREQ_54,      	},  // v2880x576i_50Hz
		{ 0x240, 0xC138 , 0xD80138, 0x14A82E, 0x2005 , 27, 28, 0, 1, 1, 0       		, 0       		, 0       		, PHY_FREQ_54,      	},  // v2880x288p_50Hz
		{ 0x120, 0x18A71, 0x6C0271, 0x125816, 0x500A , 29, 30, 0, 1, 1, 0       		, 0       		, 0       		, PHY_FREQ_54,      	},  // v1440x576p_50Hz
		{ 0x2D0, 0x16C65, 0xA50465, 0x8EA0E , 0x4009 , 31, 31, 0, 0, 0, 0       		, 0       		, 0       		, PHY_FREQ_148_500, 	},  // v1920x1080p_50Hz
		{ 0x33E, 0x16C65, 0xABE465, 0xAA27C , 0x4009 , 32, 32, 0, 0, 0, 0       		, 0       		, 0       		, PHY_FREQ_74_250,  	},  // v1920x1080p_24Hz

		{ 0x2D0, 0x16C65, 0xA50465, 0x8EA0E , 0x4009 , 33, 33, 0, 0, 0, 0       		, 0       		, 0       		, PHY_FREQ_74_250,  	},  // v1920x1080p_25Hz
		{ 0x118, 0x16C65, 0x898465, 0x20856 , 0x4009 , 34, 34, 0, 0, 0, 0       		, 0       		, 0       		, PHY_FREQ_74_250,  	},  // v1920x1080p_30Hz
		{ 0x228, 0x16A0D, 0xD6820D, 0x14D83E, 0x900F , 35, 36, 0, 0, 1, 0       		, 0       		, 0       		, PHY_FREQ_108_108, 	},  // v2880x480p_60Hz
		{ 0x240, 0x18A71, 0xD80271, 0x14B82E, 0x500A , 37, 38, 0, 1, 1, 0       		, 0       		, 0       		, PHY_FREQ_108,     	},  // v2880x576p_50Hz
		{ 0x180, 0x2AA71, 0x9004E2, 0x3181E , 0x1701C, 39, 39, 0, 0, 0, 0x2712C6	, 0x28728F	, 0x4a44a4	, PHY_FREQ_72,      	},  // v1920x1080i_50Hz(1250)
		{ 0x2D0, 0xB232 , 0xA50465, 0x8EA0E , 0x2007 , 40, 40, 1, 0, 0, 0x232A49	, 0x234239	, 0x738738	, PHY_FREQ_148_500, 	},  // v1920x1080i_100Hz
		{ 0x2BC, 0xF2EE , 0x7BC2EE, 0x779B6 , 0x500A , 41, 41, 0, 0, 0, 0       		, 0       		, 0       		, PHY_FREQ_148_500, 	},  // v1280x720p_100Hz
		{ 0x90 , 0x18A71, 0x360271, 0x11280A, 0x500A , 42, 43, 0, 0, 1, 0       		, 0       		, 0       		, PHY_FREQ_54,      	},  // v720x576p_100Hz
		{ 0x120, 0xC138 , 0x6C0271, 0x125016, 0x2005 , 44, 45, 1, 1, 1, 0x138951	, 0x13A13D	, 0x378378	, PHY_FREQ_54,      	},  // v720x576i_100Hz
		{ 0x118, 0xB232 , 0x898465, 0x20856 , 0x2007 , 46, 46, 1, 0, 0, 0x232A49	, 0x234239	, 0x4A44A4	, PHY_FREQ_148_500, 	},  // v1920x1080i_120Hz

		{ 0x172, 0xF2EE , 0x6722EE, 0x2506C , 0x500A , 47, 47, 0, 0, 0, 0       		, 0       		, 0       		, PHY_FREQ_148_500, 	},  // v1280x720p_120Hz
		{ 0x8A , 0x16A0D, 0x35A20D, 0x11300E, 0x900F , 48, 49, 0, 0, 1, 0       		, 0       		, 0       		, PHY_FREQ_54_054,  	},  // v720x480p_120Hz
		{ 0x114, 0xB106 , 0x6B420D, 0x128024, 0x4007 , 50, 51, 1, 1, 1, 0x10691D	, 0x10A10D	, 0x380380	, PHY_FREQ_54_054,  	},  // v720x480i_120Hz
		{ 0x90 , 0x18A71, 0x360271, 0x11280A, 0x500A , 52, 53, 0, 0, 1, 0       		, 0       		, 0       		, PHY_FREQ_108,     	},  // v720x576p_200Hz
		{ 0x120, 0xC138 , 0x6C0271, 0x125016, 0x2005 , 54, 55, 1, 1, 1, 0x138951	, 0x13A13D	, 0x378378	, PHY_FREQ_108,     	},  // v720x576i_200Hz
		{ 0x8A , 0x16A0D, 0x35A20D, 0x11300E, 0x900F , 56, 57, 0, 0, 1, 0       		, 0       		, 0       		, PHY_FREQ_108_108, 	},  // v720x480p_240Hz
		{ 0x114, 0xB106 , 0x6B420D, 0x128024, 0x4007 , 58, 59, 1, 1, 1, 0x10691D	, 0x10A10D	, 0x380380	, PHY_FREQ_108_108, 	},  // v720x480i_240Hz   
/*
		{ 0x8A , 0x16A0D, 0x35A20D, 0x11300E, 0x900F , 2 , 3 , 0, 0, 1, 0			, 0 		, 0 		, PHY_FREQ_27_027,	},	// v720x480p_60Hz
		{ 0x172, 0xF2EE , 0x6722EE, 0x2506C , 0x500A , 4 , 4 , 0, 0, 0, 0			, 0 		, 0 		, PHY_FREQ_74_250,	},	// v1280x720p_60Hz
		{ 0x118, 0xB232 , 0x898465, 0x20856 , 0x2007 , 5 , 5 , 1, 0, 0, 0x232A49	, 0x234239	, 0x4A44A4	, PHY_FREQ_74_250,	},	// v1920x1080i_60Hz
		{ 0x118, 0x16C65, 0x898465, 0x20856 , 0x4009 , 16, 16, 0, 0, 0, 0			, 0 		, 0 		, PHY_FREQ_148_500, },	// v1920x1080p_60Hz
		{ 0x90 , 0x18A71, 0x360271, 0x11280A, 0x500A , 17, 18, 0, 0, 1, 0			, 0 		, 0 		, PHY_FREQ_27,		},	// v720x576p_50Hz
		
		{ 0x2BC, 0xF2EE , 0x7BC2EE, 0x779B6 , 0x500A , 19, 19, 0, 0, 0, 0			, 0 		, 0 		, PHY_FREQ_74_250,	},	// v1280x720p_50Hz
		{ 0x2D0, 0xB232 , 0xA50465, 0x8EA0E , 0x2007 , 20, 20, 1, 0, 0, 0x232A49	, 0x234239	, 0x738738	, PHY_FREQ_74_250,	},	// v1920x1080i_50Hz
		{ 0x2D0, 0x16C65, 0xA50465, 0x8EA0E , 0x4009 , 31, 31, 0, 0, 0, 0			, 0 		, 0 		, PHY_FREQ_148_500, },	// v1920x1080p_50Hz
		{ 0x33E, 0x16C65, 0xABE465, 0xAA27C , 0x4009 , 32, 32, 0, 0, 0, 0			, 0 		, 0 		, PHY_FREQ_74_250,	},	// v1920x1080p_24Hz
		{ 0x2D0, 0x16C65, 0xA50465, 0x8EA0E , 0x4009 , 33, 33, 0, 0, 0, 0			, 0 		, 0 		, PHY_FREQ_74_250,	},	// v1920x1080p_25Hz
		
		{ 0x118, 0x16C65, 0x898465, 0x20856 , 0x4009 , 34, 34, 0, 0, 0, 0			, 0 		, 0 		, PHY_FREQ_74_250,	},	// v1920x1080p_30Hz
		{ 0x8A , 0x16A0D, 0x35A20D, 0x11300E, 0x900F , 2 , 3 , 0, 0, 1, 0			, 0 		, 0 		, PHY_FREQ_27,		},	// v720x480p_59.94Hz
		{ 0x172, 0xF2EE , 0x6722EE, 0x2506C , 0x500A , 4 , 4 , 0, 0, 0, 0			, 0 		, 0 		, PHY_FREQ_74_176,	},	// v1280x720p_59.94Hz
		{ 0x118, 0xB232 , 0x898465, 0x20856 , 0x2007 , 5 , 5 , 1, 0, 0, 0x232A49	, 0x234239	, 0x4A44A4	, PHY_FREQ_74_176,	},	// v1920x1080i_59.94Hz
		{ 0x118, 0x16C65, 0x898465, 0x20856 , 0x4009 , 16, 16, 0, 0, 0, 0			, 0 		, 0 		, PHY_FREQ_148_352, },	// v1920x1080p_59.94Hz
*/
	};

// HDMI Timing generation register setting
static const struct HDMI_TG_param
{
	UINT16 	tg_H_FSZ;
	UINT16 	tg_HACT_ST;
	UINT16 	tg_HACT_SZ;
	UINT16 	tg_V_FSZ;
	UINT16 	tg_VSYNC;
	UINT16	tg_VSYNC2;
	UINT16	tg_VACT_ST;
	UINT16	tg_VACT_SZ;
	UINT16	tg_FIELD_CHG;
	UINT16	tg_VACT_ST2;	
	UINT16 	tg_VSYNC_TOP_HDMI;
	UINT16 	tg_VSYNC_BOT_HDMI;
	UINT16 	tg_FIELD_TOP_HDMI;
	UINT16	tg_FIELD_BOT_HDMI;
	UINT8	tg_MHL_HSYNC_WIDTH;
	UINT8	tg_MHL_VSYNC_WIDTH;
} oHDMI_TG_Param[]=
	{
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0x35a	,0x8a	,0x2d0	,0x20d	,0x1	,0x233	,0x2d	,0x1e0	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v720x480p_60Hz
		{0x672	,0x172	,0x500	,0x2ee	,0x1	,0x233	,0x1e	,0x2d0	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1280x720p_60Hz
		{0x898	,0x118	,0x780	,0x465	,0x1	,0x233	,0x16	,0x21c	,0x233	,0x249	,0x1	,0x233	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080i_60Hz
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},	
		{0x898	,0x118	,0x780	,0x465	,0x1	,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080p_60Hz

		{0x360	,0x90	,0x2d0	,0x271	,0x1	,0x233	,0x31	,0x240	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v720x576p_50Hz
		{0x7bc	,0x2bc	,0x500	,0x2ee	,0x1	,0x233	,0x1e	,0x2d0	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1280x720p_50Hz		
		{0xa50	,0x2d0	,0x780	,0x465	,0x1	,0x233	,0x16	,0x21c	,0x233	,0x249	,0x1	,0x233	,0x1	,0x233	,0xf	,0x1	},	//1920*1080i 50Hz
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0xa50	,0x2d0	,0x780	,0x465	,0x1	,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080p_50Hz
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},	//v1920x1080p_24Hz

		{0xa50	,0x2d0	,0x780	,0x465	,0x1	,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080p_25Hz
		{0x898	,0x118	,0x780	,0x465	,0x1	,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080p_30Hz
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
/*
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0x35a	,0x8a	,0x2d0	,0x20d	,0x1	 	,0x233	,0x2d	,0x1e0	,0x233	,0x248	,0x1		,0x1		,0x1		,0x233	,0xf		,0x1	},
		{0x672	,0x172	,0x500	,0x2ee	,0x1		,0x233	,0x1e	,0x2d0	,0x233	,0x248	,0x1		,0x1		,0x1		,0x233	,0xf		,0x1	},
		{0x898	,0x118	,0x780	,0x465	,0x1		,0x233	,0x16	,0x21c	,0x233	,0x248	,0x1		,0x1		,0x1		,0x233	,0xf		,0x1	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},	
		{0x898	,0x118	,0x780	,0x465	,0x1		,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1		,0x1		,0x1		,0x233	,0xf		,0x1	},

		{0x360	,0x90	,0x2d0	,0x271	,0x1	 	,0x233	,0x31	,0x240	,0x233	,0x248	,0x1		,0x1		,0x1		,0x233	,0xf		,0x1	},
		{0x7bc	,0x2bc	,0x500	,0x2ee	,0x1		,0x233	,0x1e	,0x2d0	,0x233	,0x248	,0x1		,0x1		,0x1		,0x233	,0xf		,0x1	},		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0xa50	,0x2d0	,0x780	,0x465	,0x1		,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1		,0x1		,0x1		,0x233	,0xf		,0x1	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},

		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0	},
*/
/*
		{0x35a	,0x8a	,0x2d0	,0x20d	,0x1	,0x233	,0x2d	,0x1e0	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v720x480p_60Hz
		{0x672	,0x172	,0x500	,0x2ee	,0x1	,0x233	,0x1e	,0x2d0	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1280x720p_60Hz
		{0x898	,0x118	,0x780	,0x465	,0x1	,0x233	,0x16	,0x21c	,0x233	,0x249	,0x1	,0x233	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080i_60Hz
		{0x898	,0x118	,0x780	,0x465	,0x1	,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080p_60Hz
		{0x360	,0x90	,0x2d0	,0x271	,0x1	,0x233	,0x31	,0x240	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v720x576p_50Hz
		
		{0x7bc	,0x2bc	,0x500	,0x2ee	,0x1	,0x233	,0x1e	,0x2d0	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1280x720p_50Hz		
		{0xa50	,0x2d0	,0x780	,0x465	,0x1	,0x233	,0x16	,0x21c	,0x233	,0x249	,0x1	,0x233	,0x1	,0x233	,0xf	,0x1	},	//1920*1080i 50Hz
		{0xa50	,0x2d0	,0x780	,0x465	,0x1	,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080p_50Hz
		{0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		,0		},	//v1920x1080p_24Hz
		{0xa50	,0x2d0	,0x780	,0x465	,0x1	,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080p_25Hz
		
		{0x898	,0x118	,0x780	,0x465	,0x1	,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080p_30Hz
		{0x35a	,0x8a	,0x2d0	,0x20d	,0x1	,0x233	,0x2d	,0x1e0	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v720x480p_59.94Hz
		{0x672	,0x172	,0x500	,0x2ee	,0x1	,0x233	,0x1e	,0x2d0	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1280x720p_59.94Hz
		{0x898	,0x118	,0x780	,0x465	,0x1	,0x233	,0x16	,0x21c	,0x233	,0x249	,0x1	,0x233	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080i_59.94Hz
		{0x898	,0x118	,0x780	,0x465	,0x1	,0x233	,0x2d	,0x438	,0x233	,0x248	,0x1	,0x1	,0x1	,0x233	,0xf	,0x1	},	//v1920x1080p_59.94Hz
*/
	};


#ifdef HDMI_HW_TEST

#define HDMI_ASP_ENABLE                             (1<<2)
#define HDMI_SYS_ENABLE                             (1<<0)

// mode 
#define MODE_SEL_HDMI_MODE_MASK			(1<<1)

#define TRANSMIT_EVERY_VSYNC		(1<<1)

/////////////////////////////////////
// AVI InfoFrame
/////////////////////////////////////
                        
#define AVI_HEADER					(0x82 + 0x02 + 0x0D)
#define AVI_PACKET_BYTE_LENGTH	13


#define AUI_INFOFRAME_HEADER			(0x84 + 0x01 + 0x0A)
#define AUI_PACKET_BYTE_LENGTH		10
#define AUI_CC_2CH						1
#define AUI_CC_3CH						2
#define AUI_CC_4CH						3
#define AUI_CC_5CH						4
#define AUI_CC_6CH						5
#define AUI_CC_7CH						6
#define AUI_CC_8CH						7


// AVI PB1
// Y1, Y0 
#define AVI_CS_RGB					0
#define AVI_CS_Y422					(1<<5)
#define AVI_CS_Y444					(1<<6)


#define HDMI_MODE_SEL_HDMI          (1<<1)
#define HDMI_MODE_SEL_DVI               (1<<0)

#define SYSCON2_HDMI                            (0)
#define SYSCON2_DVI                            (1<<5|1<<1)

#define HDMI_CON_PXL_REP_RATIO_MASK (1<<1|1<<0)
#define HDMI_DOUBLE_PIXEL_REPETITION (0x01)
#define AVI_PIXEL_REPETITION_DOUBLE     (1<<0)

#define AVI_PICTURE_ASPECT_4_3                  (1<<4)
#define AVI_PICTURE_ASPECT_16_9                 (1<<5)

// Color Depth
// CD0, CD1, CD2, CD3
#define GCP_CD_NOT_INDICATED		0
#define GCP_CD_24BPP				(1<<2)
#define GCP_CD_30BPP				(1<<0 | 1<<2)
#define GCP_CD_36BPP				(1<<1 | 1<<2)
#define GCP_CD_48BPP				(1<<0 | 1<<1 | 1<<2)

#define GCP_DEFAULT_PHASE			1

// for DC_CONTRAL
#define HDMI_DC_CTL_8 				0
#define HDMI_DC_CTL_10				(1<<0)
#define HDMI_DC_CTL_12				(1<<1)

#define HPD_DO_NOT_TRANSMIT             0

#endif


#if __cplusplus
    }
#endif

#endif    // __HDMI_INTERNAL_H

