//-------------------------------------------------------------------

// Copyright SAMSUNG Electronics Co., Ltd

// All right reserved.

//

// This software is the confidential and proprietary information

// of Samsung Electronics, Inc. ("Confidential Information").  You

// shall not disclose such Confidential Information and shall use

// it only in accordance with the terms of the license agreement

// you entered into with Samsung Electronics.

//-------------------------------------------------------------------


/**
 
 * @file video.h
 
 * @brief Definition for video
 
 *
 
 * @author   Link Arch Team (mrkim@samsung.com)
 
 * @author   HSI, SystemLSI, Samsung Electronics
 
 * @version  1.0
 
 *
 
 * 09-30-2008 1.0 Initial version
 */


#ifndef __VIDEO_H__
#define __VIDEO_H__

#include <windows.h>

#if __cplusplus
    extern "C"
    {
#endif

#ifndef __HDMI_VIDEO_VIDEOFORMAT__
#define __HDMI_VIDEO_VIDEOFORMAT__
/**
 * @enum VideoFormat
 * Video format
 */
typedef enum
{
    /** 640x480p\@60Hz */
    v640x480p_60Hz = 0,
    /** 720x480p\@60Hz */
    v720x480p_60Hz,
    /** 1280x700p\@60Hz */
    v1280x720p_60Hz,
    /** 1920x1080i\@60Hz */
    v1920x1080i_60Hz,
    /** 720x480i\@60Hz */
    v720x480i_60Hz,
    /** 720x240p\@60Hz */
    v720x240p_60Hz,
    /** 2880x480i\@60Hz */
    v2880x480i_60Hz,
    /** 2880x240p\@60Hz */
    v2880x240p_60Hz,
    /** 1440x480p\@60Hz */
    v1440x480p_60Hz,
    /** 1920x1080p\@60Hz */
    v1920x1080p_60Hz,
    /** 720x576p\@60Hz */
    v720x576p_50Hz,
    /** 1280x720p\@50Hz */
    v1280x720p_50Hz,
    /** 1920x1080i\@50Hz (V total = 1125) */
    v1920x1080i_50Hz,
    /** 720x576i\@50Hz */
    v720x576i_50Hz,
    /** 720x288p\@50Hz */
    v720x288p_50Hz,
    /** 2880x576i\@50Hz */
    v2880x576i_50Hz,
    /** 2880x288p\@50Hz */
    v2880x288p_50Hz,
    /** 1440x576p\@50Hz */
    v1440x576p_50Hz,
    /** 1920x1080p\@50Hz */
    v1920x1080p_50Hz,
    /** 1920x1080p\@24Hz */
    v1920x1080p_24Hz,
    /** 1920x1080p\@25Hz */
    v1920x1080p_25Hz,
    /** 1920x1080p\@30Hz */
    v1920x1080p_30Hz,
    /** 2880x480p\@60Hz */
    v2880x480p_60Hz,
    /** 2880x576p\@60Hz */
    v2880x576p_50Hz,
    /** 1920x1080i\@50Hz (V total = 1250) */
    v1920x1080i_50Hz_1250,
    /** 1920x1080i\@100Hz */
    v1920x1080i_100Hz,
    /** 1280x720p\@100Hz */
    v1280x720p_100Hz,
    /** 720x576p\@100Hz */
    v720x576p_100Hz,
    /** 720x576i\@100Hz */
    v720x576i_100Hz,
    /** 1920x1080i\@120Hz */
    v1920x1080i_120Hz,
    /** 1280x720p\@120Hz */
    v1280x720p_120Hz,
    /** 720x480p\@120Hz */
    v720x480p_120Hz,
    /** 720x480i\@120Hz */
    v720x480i_120Hz,
    /** 720x576p\@200Hz */
    v720x576p_200Hz,
    /** 720x576i\@200Hz */
    v720x576i_200Hz,
    /** 720x480p\@240Hz */
    v720x480p_240Hz,
    /** 720x480i\@240Hz */
    v720x480i_240Hz,
}
VIDEO_FORMAT, VideoFormat;

#endif /* __HDMI_VIDEO_VIDEOFORMAT__ */
#ifndef __HDMI_VIDEO_COLORSPACE__
#define __HDMI_VIDEO_COLORSPACE__
/**
 * @enum ColorSpace
 * Color space of video stream.
 */
typedef enum
{
    /** RGB color space */
    HDMI_CS_RGB,
    /** YCbCr 4:4:4 color space */
    HDMI_CS_YCBCR444,
    /** YCbCr 4:2:2 color space */
    HDMI_CS_YCBCR422
}
COLOR_SPACE, ColorSpace;

#endif /* __HDMI_VIDEO_COLORSPACE__ */

#ifndef __HDMI_VIDEO_COLORDEPTH__
#define __HDMI_VIDEO_COLORDEPTH__
/**
 * @enum ColorDepth
 * Color depth per pixel of video stream
 */
typedef enum
{
    /** 36 bit color depth per pixel */
    HDMI_CD_36,
    /** 30 bit color depth per pixel */
    HDMI_CD_30,
    /** 24 bit color depth per pixel */
    HDMI_CD_24
}
COLOR_DEPTH, ColorDepth;

#endif /* __HDMI_VIDEO_COLORDEPTH__ */

#ifndef __HDMI_VIDEO_HDMIMODE__
#define __HDMI_VIDEO_HDMIMODE__
/**
 * @enum HDMIMode
 * System mode
 */
typedef enum 
{
    /** DVI mode */
    DVI = 0,
    /** HDMI mode */
    HDMI
}
HDMI_MODE, HDMIMode;

#endif /* __HDMI_VIDEO_HDMIMODE__ */

#ifndef __HDMI_VIDEO_COLORIMETRY__
#define __HDMI_VIDEO_COLORIMETRY__
/**
 * @enum HDMIColorimetry
 * Colorimetry of video stream
 */
typedef enum
{
    /** Colorimetry is not defined */
    HDMI_COLORIMETRY_NO_DATA,
    /** ITU601 colorimetry */
    HDMI_COLORIMETRY_ITU601,
    /** ITU709 colorimetry */
    HDMI_COLORIMETRY_ITU709,
    /** Extended ITU601 colorimetry */
    HDMI_COLORIMETRY_EXTENDED_xvYCC601,
    /** Extended ITU709 colorimetry */
    HDMI_COLORIMETRY_EXTENDED_xvYCC709
}
HDMI_COLORMETRY, HDMIColorimetry;

#endif /* __HDMI_VIDEO_COLORIMETRY__ */

#ifndef __HDMI_VIDEO_PIXELASPECTRATIO__
#define __HDMI_VIDEO_PIXELASPECTRATIO__
/**
 * @enum PixelAspectRatio
 * Pixel aspect ratio of video stream
 */
typedef enum 
{
    /** 4:3 pixel ratio */
    HDMI_PIXEL_RATIO_4_3,
    /** 16:9 pixel ratio */
    HDMI_PIXEL_RATIO_16_9
}
PIXEL_ASPECT_RATIO, PixelAspectRatio;
#endif /* __HDMI_VIDEO_PIXELASPECTRATIO__ */

#ifndef __HDMI_VIDEO_PIXELFREQUENCY__
#define __HDMI_VIDEO_PIXELFREQUENCY__
/**
 * @enum PixelFreq
 * Pixel Frequency
 */
typedef enum  {
    /** 25.2 MHz pixel frequency */
    PIXEL_FREQ_25_200 = 2520,
    /** 25.175 MHz pixel frequency */
    PIXEL_FREQ_25_175 = 2517,
    /** 27 MHz pixel frequency */
    PIXEL_FREQ_27 = 2700,
    /** 27.027 MHz pixel frequency */
    PIXEL_FREQ_27_027 = 2702,
    /** 54 MHz pixel frequency */
    PIXEL_FREQ_54 = 5400,
    /** 54.054 MHz pixel frequency */
    PIXEL_FREQ_54_054 = 5405,
    /** 74.25 MHz pixel frequency */
    PIXEL_FREQ_74_250 = 7425,
    /** 74.176 MHz pixel frequency */
    PIXEL_FREQ_74_176 = 7417,
    /** 148.5 MHz pixel frequency */
    PIXEL_FREQ_148_500 = 14850,
    /** 148.352 MHz pixel frequency */
    PIXEL_FREQ_148_352 = 14835,
    /** 108.108 MHz pixel frequency */
    PIXEL_FREQ_108_108 = 10810,
    /** 72 MHz pixel frequency */
    PIXEL_FREQ_72 = 7200,
    /** 25 MHz pixel frequency */
    PIXEL_FREQ_25 = 2500,
    /** 65 MHz pixel frequency */
    PIXEL_FREQ_65 = 6500,
    /** 108 MHz pixel frequency */
    PIXEL_FREQ_108 = 10800,
    /** 162 MHz pixel frequency */
    PIXEL_FREQ_162 = 16200,
}
PIXEL_FREQ, PixelFreq;

#endif /* __HDMI_VIDEO_PIXELFREQUENCY__ */

#ifndef __HDMI_PHY_PIXELFREQUENCY__
#define __HDMI_PHY_PIXELFREQUENCY__

typedef enum  
{
    /** 25.2 MHz pixel frequency */
    PHY_FREQ_25_200 = 0,
    /** 25.175 MHz pixel frequency */
    PHY_FREQ_25_175,
    /** 27 MHz pixel frequency */
    PHY_FREQ_27,
    /** 27.027 MHz pixel frequency */
    PHY_FREQ_27_027,
    /** 54 MHz pixel frequency */
    PHY_FREQ_54,
    /** 54.054 MHz pixel frequency */
    PHY_FREQ_54_054,
    /** 74.25 MHz pixel frequency */
    PHY_FREQ_74_250,
    /** 74.176 MHz pixel frequency */
    PHY_FREQ_74_176,
    /** 148.5 MHz pixel frequency */
    PHY_FREQ_148_500,
    /** 148.352 MHz pixel frequency */
    PHY_FREQ_148_352,
    /** 108.108 MHz pixel frequency */
    PHY_FREQ_108_108,
    /** 72 MHz pixel frequency */
    PHY_FREQ_72,
    /** 25 MHz pixel frequency */
    PHY_FREQ_25,
    /** 65 MHz pixel frequency */
    PHY_FREQ_65,
    /** 108 MHz pixel frequency */
    PHY_FREQ_108,
    /** 162 MHz pixel frequency */
    PHY_FREQ_162,
}
PHYFreq;

#endif /* __HDMI_PHY_PIXELFREQUENCY__ */

#ifndef __HDMI_VIDEO_PARAMETER__
#define __HDMI_VIDEO_PARAMETER__
//! Structure for HDMI video
typedef struct  {
    /** Video interface */
    HDMIMode mode;
    /** Video format */
    VideoFormat resolution;
    /** Color space */
    ColorSpace colorSpace;
    /** Color depth */
    ColorDepth colorDepth;
    /** Colorimetry */
    HDMIColorimetry colorimetry;
    /** Pixel aspect ratio */
    PixelAspectRatio pixelAspectRatio;
}
HDMI_VIDEO_PARAMETER, HDMIVideoParameter;
#endif /* __HDMI_VIDEO_PARAMETER__ */


//! Structure for BlueScreen
typedef struct  
{
    BYTE ucCbB;
    BYTE ucYG;
    BYTE ucCrR;
}
BLUE_SCREEN_COLOR, BlueScreenColor;

//! Structure for BlueScreen
typedef struct  
{
	BYTE ucYMin;
	BYTE ucYMax;
	BYTE ucCMin;
	BYTE ucCMax;
}
COLOR_RANGE, ColorRange;

#if __cplusplus
    }
#endif

#endif /* __VIDEO_H__ */
