
/**
 *  SPDIF library is responsible for setting SPDIF Receiver.
 */

#ifndef __SPDIF_LIBRARY__
#define __SPDIF_LIBRARY__

#include "audio.h"
#include "hdmireg.h"
#include "libspdif.h"
#include "libi2s.h"

#if __cplusplus
    extern "C"
    {
#endif

// initialize SPDIF library
// enable SPDIF interrupt
BOOL SPDIFInit(PHDMI_SS_REG pSsReg,
                PHDMI_I2S_REG pI2SReg, 
                PHDMI_SPDIF_REG pSPDIFReg);

// deinitialize SPDIF library
BOOL SPDIFDeInit(VOID);

// set encoding type of input audio stream
BOOL SPDIFSetEncodingType(AUDIO_CODING type);

// start processing input audio stream
BOOL SPDIFStart(VOID);

// stop processing input audio stream
BOOL SPDIFStop(VOID);

// handle SPDIF event
BOOL SPDIFHandleEvent(VOID);

#if __cplusplus
    }
#endif

#endif /* __SPDIF_LIBRARY__ */