
/**
 * I2S library is responsible for setting I2S Receiver.
 */
#ifndef __I2S_LIBRARY__
#define __I2S_LIBRARY__

#include "audio.h"
#include "hdmireg.h"

#if __cplusplus
    extern "C"
    {
#endif

// Initialize I2S library
BOOL I2SInit(PHDMI_I2S_REG pReg);

// Deinitialize I2S library
// unmap physical address.
BOOL I2SDeInit(VOID);

// Set the sampling frequency in I2S Receiver.
BOOL I2SSetCUVSamplingFreq(SAMPLEING_FREG);

// Set the audio encoding type in I2S Receiver.
BOOL I2SSetCUVEncodingType(AUDIO_CODING);

// Set the word length in I2S Receiver.
BOOL I2SSetCUVWordLength(CUV_WORD_LENGTH);

// Set the bits per channel in I2S Receiver.
BOOL I2SSetBitPerChannel(I2S_BITS_PER_CHANNEL);

// Set the data format in I2S Receiver.
BOOL I2SSetDataFormat(I2S_DATA_FORMAT);

// Set the clock per frame in I2S Receiver.
BOOL I2SSetClockPerFrame(I2S_CLOCK_PER_FRAME);

// Start I2S receiver
BOOL I2SStart(VOID);

// Stop I2S receiver
BOOL I2SStop(VOID);

#if __cplusplus
    }
#endif

#endif /* __I2S_LIBRARY__ */