
/**
 * EDID library is responsible for reading and parsing EDID.
 */

#ifndef __EDID_LIBRARY__
#define __EDID_LIBRARY__

#include <windows.h>
#include "video.h"
#include "audio.h"

#if __cplusplus
    extern "C"
    {
#endif

// Initialize EDID library. Initialize DDC library
BOOL EDIDInit(VOID);

// Deinitialize EDID library. Deinitialize DDC library
BOOL EDIDDeInit(VOID);

// Read EDID data
BOOL EDIDRead(VOID);

// Reset EDID data
VOID EDIDReset(VOID);

// check EDID data related to video
BOOL EDIDHDMIModeSupport(VOID);
BOOL EDIDVideoResolutionSupport(VIDEO_FORMAT, PIXEL_ASPECT_RATIO);
BOOL EDIDColorDepthSupport(COLOR_DEPTH, COLOR_SPACE);
BOOL EDIDColorSpaceSupport(COLOR_SPACE);
BOOL EDIDColorimetrySupport(HDMI_COLORMETRY);

// check EDID data related to audio
BOOL EDIDAudioModeSupport(HDMI_AUDIO_PARAMETER*);

// for CEC 
BOOL EDIDGetCECPhysicalAddress(PDWORD);

#if __cplusplus
    }
#endif

#endif /* __EDID_LIBRARY__ */