//-------------------------------------------------------------------
// Copyright SAMSUNG Electronics Co., Ltd
// All right reserved.
//
// This software is the confidential and proprietary information
// of Samsung Electronics, Inc. ("Confidential Information").  You
// shall not disclose such Confidential Information and shall use
// it only in accordance with the terms of the license agreement
// you entered into with Samsung Electronics.
//-------------------------------------------------------------------
/**
 * @file audio.h
 * @brief Definition for audio.
 *
 * @author   Link Arch Team (mrkim@samsung.com) \n
 *           HSI, SystemLSI, Samsung Electronics
 * @version  1.0
 *
 * @remarks  09-30-2008 1.0 Initial version
 */


#ifndef __AUDIO_H__
#define __AUDIO_H__

#include <windows.h>

#if __cplusplus
    extern "C"
    {
#endif


#ifndef __HDMI_AUDIO_HDMIAUDIOPORT__
#define __HDMI_AUDIO_HDMIAUDIOPORT__
/**
 * @enum HDMIAudioPort
 * Available audio inputs on HDMI HW module.
 */
typedef enum
{
    /** I2S input port */
    I2S_PORT,
    /** SPDIF input port */
    SPDIF_PORT,
}
HDMI_AUDIO_PORT, HDMIAudioPort;
#endif /* __HDMI_AUDIO_HDMIAUDIOPORT__ */

#ifndef __HDMI_AUDIO_AUDIOFORMAT__
#define __HDMI_AUDIO_AUDIOFORMAT__

/**
 * @enum AudioFormat
 * The encoding format of audio stream
 */
typedef enum
{
    /** LPCM encoding format */
    LPCM_FORMAT = 1,
    /** AC3 encoding format */
    AC3_FORMAT,
    /** MPEG1 encoding format */
    MPEG1_FORMAT,
    /** MP3 encoding format */
    MP3_FORMAT,
    /** MPEG2 encoding format */
    MPEG2_FORMAT,
    /** AAC encoding format */
    AAC_FORMAT,
    /** DTS encoding format */
    DTS_FORMAT,
    /** ATRAC encoding format */
    ATRAC_FORMAT,
    /** DSD encoding format */
    DSD_FORMAT,
    /** Dolby Digital+ encoding format */
    Dolby_Digital_Plus_FORMAT,
    /** DTS HD encoding format */
    DTS_HD_FORMAT,
    /** MAT encoding format */
    MAT_FORMAT,
    /** DST encoding format */
    DST_FORMAT,
    /** WAM_Pro encoding format */
    WAM_Pro_FORMAT
}
AUDIO_FORMAT, AudioFormat;
#endif /* __HDMI_AUDIO_AUDIOFORMAT__ */

#ifndef __HDMI_AUDIO_LPCMWORDLENGTH__
#define __HDMI_AUDIO_LPCMWORDLENGTH__
/**
 * @enum LPCM_WordLen
 * Word length of LPCM audio stream.
 */
typedef enum
{
    /** 16bit word length */
    WORD_16 = 0,
    /** 17bit word length */
    WORD_17,
    /** 18bit word length */
    WORD_18,
    /** 19bit word length */
    WORD_19,
    /** 20bit word length */
    WORD_20,
    /** 21bit word length */
    WORD_21,
    /** 22bit word length */
    WORD_22,
    /** 23bit word length */
    WORD_23,
    /** 24bit word length */
    WORD_24
}
LPCM_WORD_LEN, LPCM_WordLen;
#endif /* __HDMI_AUDIO_LPCMWORDLENGTH__ */

#ifndef __HDMI_AUDIO_SAMPLINGFREQUENCY__
#define __HDMI_AUDIO_SAMPLINGFREQUENCY__

/**
 * @enum SamplingFreq
 * Sampling frequency of audio stream.
 */
typedef enum
{
    /** 32KHz sampling frequency */
    SF_32KHZ = 0,
    /** 44.1KHz sampling frequency */
    SF_44KHZ,
    /** 48KHz sampling frequency */
    SF_48KHZ,
    /** 88.2KHz sampling frequency */
    SF_88KHZ,
    /** 96KHz sampling frequency */
    SF_96KHZ,
    /** 176.4KHz sampling frequency */
    SF_176KHZ,
    /** 192KHz sampling frequency */
    SF_192KHZ
}
SAMPLEING_FREG, SamplingFreq;
#endif /* __HDMI_AUDIO_SAMPLINGFREQUENCY__ */

#ifndef __HDMI_AUDIO_CHANNELNUMBER__
#define __HDMI_AUDIO_CHANNELNUMBER__

/**
 * @enum ChannelNum
 * Channel number of audio stream.
 */
typedef enum
{
    /** 2 channel audio stream */
    CH_2 = 2,
    /** 3 channel audio stream */
    CH_3,
    /** 4 channel audio stream */
    CH_4,
    /** 5 channel audio stream */
    CH_5,
    /** 6 channel audio stream */
    CH_6,
    /** 7 channel audio stream */
    CH_7,
    /** 8 channel audio stream */
    CH_8,
}
CHANNEL_NUM, ChannelNum;
#endif /* __HDMI_AUDIO_CHANNELNUMBER__ */


#ifndef __HDMI_AUDIO_AUDIOSAMPLEPACKETTYPE__
#define __HDMI_AUDIO_AUDIOSAMPLEPACKETTYPE__
/**
 * @enum HDMIASPType
 * Type of HDMI audio sample packet
 */
typedef enum
{
    /** Audio Sample Packet Type */
    HDMI_ASP,
    /** One Bit Audio Packet Type */
    HDMI_DSD,
    /** High Bit Rate Packet Type */
    HDMI_HBR,
    /** DST Packet Type */
    HDMI_DST
}
HDMI_ASP_TYPE, HDMIASPType;
#endif /* __HDMI_AUDID_AUDIOSAMPLEPACKETTYPE__ */

#ifndef __HDMI_AUDIO_CODING_TYPE__
#define __HDMI_AUDIO_CODING_TYPE__
/**
 * @enum AudioCoding
 * Audio coding type information.
 */
typedef enum
{
    /** Linear PCM coding type */
    AUDIO_LPCM,
    /** Non-linear PCM coding type */
    AUDIO_NLPCM
}
AUDIO_CODING,AudioCoding;
#endif /* __HDMI_AUDIO_CODING_TYPE__ */

#ifndef __HDMI_AUDIO_I2S_CUV_WORD_LENGTH__
#define __HDMI_AUDIO_I2S_CUV_WORD_LENGTH__
/**
 * @CUV_WORD_LENGTH
 * Word length information of LPCM audio stream for CUV fields.
 */
typedef enum
{
    /** Max word length is 20 bits, number of valid bits is not defined */
    CUV_WL_20_NOT_DEFINED,
    /** Max word length is 20 bits, 16 bits are valid */
    CUV_WL_20_16,
    /** Max word length is 20 bits, 18 bits are valid */
    CUV_WL_20_18,
    /** Max word length is 20 bits, 19 bits are valid */
    CUV_WL_20_19,
    /** Max word length is 20 bits, 20 bits are valid */
    CUV_WL_20_20,
    /** Max word length is 20 bits, 17 bits are valid */
    CUV_WL_20_17,
    /** Max word length is 24 bits, number of valid bits is not defined */
    CUV_WL_24_NOT_DEFINED,
    /** Max word length is 24 bits, 20 bits are valid */
    CUV_WL_24_20,
    /** Max word length is 24 bits, 22 bits are valid */
    CUV_WL_24_22,
    /** Max word length is 24 bits, 23 bits are valid */
    CUV_WL_24_23,
    /** Max word length is 24 bits, 24 bits are valid */
    CUV_WL_24_24,
    /** Max word length is 24 bits, 21 bits are valid */
    CUV_WL_24_21,
}
CUV_WORD_LENGTH, CUVWordLength;
#endif /* __HDMI_AUDIO_I2S_CUV_WORD_LENGTH__ */


#ifndef __HDMI_AUDIO_I2S_BITS_PER_CHANNEL__
#define __HDMI_AUDIO_I2S_BITS_PER_CHANNEL__
/**
 * @I2S_BITS_PER_CHANNEL
 * Serial data bit per channel in I2S audio stream.
 */
typedef enum
{
    /** 16 bits per channel */
    I2S_BPC_16,
    /** 20 bits per channel */
    I2S_BPC_20,
    /** 24 bits per channel */
    I2S_BPC_24
}
I2S_BITS_PER_CHANNEL, I2SBitsPerChannel;
#endif /* __HDMI_AUDIO_I2S_BITS_PER_CHANNEL__ */

#ifndef __HDMI_AUDIO_I2S_DATA_FORMAT__
#define __HDMI_AUDIO_I2S_DATA_FORMAT__
/**
 * @I2S_DATA_FORMAT
 * Foramt of data in I2S audio stream.
 */
typedef enum
{
    /** Basic format */
    I2S_BASIC,
    /** Left justified format */
    I2S_LEFT_JUSTIFIED,
    /** Right justified format */
    I2S_RIGHT_JUSTIFIED
}
I2S_DATA_FORMAT, I2SDataFormat;
#endif /* __HDMI_AUDIO_I2S_DATA_FORMAT__ */

#ifndef __HDMI_AUDIO_I2S_CLOCK_PER_FRAME__
#define __HDMI_AUDIO_I2S_CLOCK_PER_FRAME__
/**
 * @I2S_CLOCK_PER_FRAME
 * Bit clock per Frame in I2S audio stream.
 */
typedef enum
{
    /** 32 clock per Frame */
    I2S_32FS,
    /** 48 clock per Frame */
    I2S_48FS,
    /** 64 clock per Frame */
    I2S_64FS
}
I2S_CLOCK_PER_FRAME, I2SClockPerFrame;
#endif /* __HDMI_AUDIO_I2S_CLOCK_PER_FRAME__ */

#ifndef __HDMI_AUDIO_I2S_PARAMETER__
#define __HDMI_AUDIO_I2S_PARAMETER__
//! Structure for I2S audio stream
typedef struct 
{
    I2S_BITS_PER_CHANNEL bpc;
    I2S_DATA_FORMAT format;
    I2S_CLOCK_PER_FRAME clk;
}
I2S_PARAMETER;
#endif /* __HDMI_AUDIO_I2S_PARAMETER__ */

#ifndef __HDMI_AUDIO_PARAMETER__
#define __HDMI_AUDIO_PARAMETER__
//! Structure for HDMI audio input
typedef struct
{
    /** Input audio port to HDMI HW */
    HDMI_AUDIO_PORT inputPort;
    /** Output Packet type **/
    HDMI_ASP_TYPE outPacket;  
    /** Encoding format */
    AUDIO_FORMAT formatCode;
    /** Channel number */
    CHANNEL_NUM channelNum;
    /** Sampling frequency */
    SAMPLEING_FREG sampleFreq;
    /** Word length. This is avaliable only if LPCM encoding format */
    LPCM_WORD_LEN wordLength;
    /** structure for I2S audio stream */
    I2S_PARAMETER I2SParam;
}
HDMI_AUDIO_PARAMETER, HDMIAudioParameter;
#endif /* __HDMI_AUDIO_PARAMETER__ */

#if __cplusplus
    }
#endif

#endif /* __AUDIO_H__ */ 
