//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
//
//
//
//
/*++

Module Name:    tvout_clock.c

Abstract:       Implementation of tvout clock Library
                This module implements Low Level HW control

Functions:


Notes:


--*/

#include <windows.h>
#include <bsp_cfg.h>    // for reference HCLK, ECLK
#include <register_map.h>
#include "tvout_global.h"
#include "tvout_message.h"
#include "tvout_clock.h"
#include "tvout_clock_internal.h"
#include <drvmsg.h>
#include "Libhdmi.h"

void Tvout_clk_print()
{

	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuClkCon->PLL_LOCK.VPLL_LOCK = [0x%08x]\n\r"),
						g_pCmuClkCon->PLL_LOCK.VPLL_LOCK));
	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuClkCon->PLL_CON.VPLL_CON = [0x%08x]\n\r"),
						g_pCmuClkCon->PLL_CON.VPLL_CON));

	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuClkCon->CLK_SRC.CLK_SRC0 = [0x%08x]\n\r"),
						g_pCmuClkCon->CLK_SRC.CLK_SRC0));
	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuClkCon->CLK_SRC.CLK_SRC1 = [0x%08x]\n\r"),
						g_pCmuClkCon->CLK_SRC.CLK_SRC1));
	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0 = [0x%08x]\n\r"),
						g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0));

	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1 = [0x%08x]\n\r"),
						g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1));
	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuClkCon->CLK_GATE.CLK_GATE_IP2 = [0x%08x]\n\r"),
						g_pCmuClkCon->CLK_GATE.CLK_GATE_IP2));
	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuClkCon->CLK_GATE.CLK_GATE_IP3 = [0x%08x]\n\r"),
						g_pCmuClkCon->CLK_GATE.CLK_GATE_IP3));

	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuMiscCon->TEST_REG.HDMI_PHY_CON0 = [0x%08x]\n\r"),
						g_pCmuMiscCon->TEST_REG.HDMI_PHY_CON0));


	DBGMSG(TV_FUNC,(_T("[TVCLK_PRT]  g_pCmuClkCon->CLK_GATE.CLK_GATE_BLOCK = [0x%08x]\n\r"),
						g_pCmuClkCon->CLK_GATE.CLK_GATE_BLOCK));

	return;
}

// initialization
//  - iniization functions are only called under stopping tvout clock
TVOUT_CLK_ERROR
Tvout_clk_initialize_register_address
(void * pCmuClkCon,
void* pCmuMiscCon)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_initialize_register_address(0x%08x,0x%08x)\n\r"), pCmuClkCon,pCmuMiscCon));

	if (pCmuClkCon == NULL)
	{
		DBGMSG(TV_USR1,(_T("[TVCLK:ERR] Tvout_clk_initialize_register_address() : pClkConReg NULL pointer parameter\n\r")));
		return TVOUT_CLK_ERROR_INVALID_PARAM;
	}
	else if (pCmuMiscCon == NULL)
	{
		DBGMSG(TV_USR1,(_T("[TVCLK:ERR] Tvout_clk_initialize_register_address() : pMISCConConfig NULL pointer parameter\n\r")));
		return TVOUT_CLK_ERROR_INVALID_PARAM;
	}
	else
	{
		g_pCmuClkCon = (PCMU_CLK_REG)pCmuClkCon;
		g_pCmuMiscCon = (PCMU_MISC_REG)pCmuMiscCon;

	}

	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_initialize_register_address(0x%08x,0x%08x)\n\r"), pCmuClkCon,pCmuMiscCon));

	return TVOUT_CLK_ERROR_NO_ERROR;
}


void
Tvout_clk_set_clk_mask_onoff
(BOOL bEn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_clk_mask_onoff(%d)\n\r"),bEn));

	if (bEn)
	{
		g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0 |= (BW_MUX_VPLLSRC_MASK<<BP_MUX_VPLLSRC_MASK);

		//Pass MIXER_MASK
		g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0 |= (/*(0x1<<BP_MUX_VPLLSRC_MASK)|*/(0x1<<BP_MUX_MIXER_MASK));
		g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0 |=  (BW_MUX_DAC_MASK<<BP_MUX_DAC_MASK);
		g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0 |=  (BW_MUX_HDMI_MASK<<BP_MUX_HDMI_MASK);

	}
	else
	{
		//Block MIXER_MASK
		g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0 &= ~(BW_MUX_MIXER_MASK<<BP_MUX_MIXER_MASK);

		//Block DAC_MASK
		g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0 &= ~(BW_MUX_DAC_MASK<<BP_MUX_DAC_MASK);
		g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0 &= ~(BW_MUX_HDMI_MASK<<BP_MUX_HDMI_MASK);
	}

	DBGMSG(TV_FUNC,(_T("  g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0 = [0x%08x]\n\r"),g_pCmuClkCon->CLK_SRC.CLK_SRC_MASK0));
	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_clk_mask_onoff()\n\r")));
}

//Set Vclk 54MHz
TVOUT_CLK_ERROR
Tvout_clk_set_clk_src_init()
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_clk_src_init(%d)\n\r")));

	//VPLL SRC->FinPll
	g_pCmuClkCon->CLK_SRC.CLK_SRC1 &= ~(BW_MUX_VPLLSRC_SEL<<BP_MUX_VPLLSRC_SEL);
	//VPLL SEL->FOUT VPLL
	g_pCmuClkCon->CLK_SRC.CLK_SRC0 |= (BW_MUX_VPLL_SEL<<BP_MUX_VPLL_SEL);

	//DAC SEL -> SCLK VPLL
	g_pCmuClkCon->CLK_SRC.CLK_SRC1 &=~ (BW_MUX_DAC_SEL<<BP_MUX_DAC_SEL);

	//MIXER SEL -> SCLK DAC
	g_pCmuClkCon->CLK_SRC.CLK_SRC1 &=~ (BW_MUX_MIXER_SEL<<BP_MUX_MIXER_SEL);

	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_SRC.CLK_SRC0 = [0x%08x]\n\r"),g_pCmuClkCon->CLK_SRC.CLK_SRC0));
	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_SRC.CLK_SRC1 = [0x%08x]\n\r"),g_pCmuClkCon->CLK_SRC.CLK_SRC1));

	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_clk_src_init()\n\r")));

	return TVOUT_CLK_ERROR_NO_ERROR;

}


TVOUT_CLK_ERROR
Tvout_clk_set_mixer_src
(TVOUT_MIXER_CLK_SRCCLK srcClk)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_clk_src_onoff(%d)\n\r"),srcClk));

	switch(srcClk)
	{
		case TVOUT_MIXER_CLK_SRCCLK_VCLK_54:
		{
			//MIXER SEL -> SCLK_HDMI
			g_pCmuClkCon->CLK_SRC.CLK_SRC1 &= ~(BW_MUX_HDMI_SEL<<BP_MUX_HDMI_SEL);
			//DAC SEL -> SCLK VPLL
			g_pCmuClkCon->CLK_SRC.CLK_SRC1 &= ~(BW_MUX_MIXER_SEL<<BP_MUX_MIXER_SEL);
			break;			
		}
		case TVOUT_MIXER_CLK_SRCCLK_HDMI_PHY:
		{
			//HDMI SEL(MUX_hdmi) -> SCLK_HDMIPHY
			g_pCmuClkCon->CLK_SRC.CLK_SRC1 |= (BW_MUX_HDMI_SEL<<BP_MUX_HDMI_SEL);
			//MIXER SEL(MUX_mixer) -> SCLK VPLL
			g_pCmuClkCon->CLK_SRC.CLK_SRC1 |= (BW_MUX_MIXER_SEL<<BP_MUX_MIXER_SEL);
			break;
		}
		default:
		{
			DBGMSG(TV_USR1,(_T("[TVCLK:ERR] Tvout_clk_set_clk_src_onoff() : invalid srcClk parameter = %d\n\r"),srcClk));
			return TVOUT_CLK_ERROR_INVALID_PARAM;
			break;
		}
	}

	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_SRC.CLK_SRC0 = [0x%08x]\n\r"),g_pCmuClkCon->CLK_SRC.CLK_SRC0));
	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_SRC.CLK_SRC1 = [0x%08x]\n\r"),g_pCmuClkCon->CLK_SRC.CLK_SRC1));

	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_clk_src_onoff()\n\r")));

	return TVOUT_CLK_ERROR_NO_ERROR;
}


TVOUT_CLK_ERROR
Tvout_clk_set_clk_src_onoff
(TVOUT_CLK_SRCCLK srcClk, BOOL bEn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_clk_src_onoff(%d)\n\r"),srcClk));

	switch(srcClk)
	{
		case TVOUT_CLK_SRCCLK_VCLK_54:
		{
			if(bEn == TRUE)
			{
				//VPLL SRC->FinPll
				g_pCmuClkCon->CLK_SRC.CLK_SRC1 &= ~(BW_MUX_VPLLSRC_SEL<<BP_MUX_VPLLSRC_SEL);
				//VPLL SEL->FOUT VPLL
				g_pCmuClkCon->CLK_SRC.CLK_SRC0 |= (BW_MUX_VPLL_SEL<<BP_MUX_VPLL_SEL);

				//DAC SEL -> SCLK VPLL
				g_pCmuClkCon->CLK_SRC.CLK_SRC1 &=~ (BW_MUX_DAC_SEL<<BP_MUX_DAC_SEL);

				//MIXER SEL -> SCLK DAC
				g_pCmuClkCon->CLK_SRC.CLK_SRC1 &=~ (BW_MUX_MIXER_SEL<<BP_MUX_MIXER_SEL);
			}
			else
			{
			}
			break;
		}
		case TVOUT_CLK_SRCCLK_HDMI_PHY:
		{
			if(bEn == TRUE)
			{
				//HDMI SEL -> SCLK_HDMIPHY
				g_pCmuClkCon->CLK_SRC.CLK_SRC1 |= (BW_MUX_HDMI_SEL<<BP_MUX_HDMI_SEL);
				//DAC SEL -> SCLK VPLL
				g_pCmuClkCon->CLK_SRC.CLK_SRC1 |= (BW_MUX_MIXER_SEL<<BP_MUX_MIXER_SEL);
			}
			else
			{
				//MIXER SEL -> SCLK_HDMI
				g_pCmuClkCon->CLK_SRC.CLK_SRC1 &= ~(BW_MUX_HDMI_SEL<<BP_MUX_HDMI_SEL);
				//DAC SEL -> SCLK VPLL
				g_pCmuClkCon->CLK_SRC.CLK_SRC1 &= ~(BW_MUX_MIXER_SEL<<BP_MUX_MIXER_SEL);

			}

			break;
		}
		default:
		{
			DBGMSG(TV_USR1,(_T("[TVCLK:ERR] Tvout_clk_set_clk_src_onoff() : invalid srcClk parameter = %d\n\r"),srcClk));
			return TVOUT_CLK_ERROR_INVALID_PARAM;
			break;
		}
	}

	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_SRC.CLK_SRC0 = [0x%08x]\n\r"),g_pCmuClkCon->CLK_SRC.CLK_SRC0));
	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_SRC.CLK_SRC1 = [0x%08x]\n\r"),g_pCmuClkCon->CLK_SRC.CLK_SRC1));

	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_clk_src_onoff()\n\r")));

	return TVOUT_CLK_ERROR_NO_ERROR;
}


void
Tvout_clk_initialize_vpll
(unsigned int uiLockTime,
 unsigned int uiMdiv,
 unsigned int uiPdiv,
 unsigned int uiSdiv)
{

	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_initialize_vpll(%d,%d,%d,%d)\n\r"),uiLockTime,uiMdiv,uiPdiv,uiSdiv));

#if VPLL_ON_OFF
	g_pCmuClkCon->PLL_LOCK.VPLL_LOCK = uiLockTime;//HPLL_LOCKTIME(uiLockTime);
	g_pCmuClkCon->PLL_CON.VPLL_CON = (/* (PLL_ON<<BP_PLL_ENABLE) |*/
								(PLL_LOCKED_HWDETECT_OFF<<BP_PLL_ENABLE_LOCKED_DET) |
								(0x0<<BP_PLL_VCO_FREQ_SEL) |
								(uiMdiv<<BP_PLL_MDIV) |
								(uiPdiv<<BP_PLL_PDIV) |
								(uiSdiv<<BP_PLL_SDIV));
#endif

	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_initialize_vpll(0x%08x,0x%08x)\n\r"),g_pCmuClkCon->PLL_LOCK.VPLL_LOCK,g_pCmuClkCon->PLL_CON.VPLL_CON));

}

void
Tvout_clk_vpll_onoff
(BOOL bEn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_vpll_onoff(%d)\n\r"),bEn));

#if VPLL_ON_OFF
	if(bEn)
	{
		g_pCmuClkCon->PLL_CON.VPLL_CON |= (PLL_ON<<BP_PLL_ENABLE);

		while(!((g_pCmuClkCon->PLL_CON.VPLL_CON)&(0x1<<BP_PLL_LOCKED)))
		{
			Sleep(1);
		}
	}
	else
	{
		g_pCmuClkCon->PLL_CON.VPLL_CON &= ~(PLL_ON<<BP_PLL_ENABLE);
	}
#endif

	DBGMSG(TV_FUNC,(_T("  g_pCmuClkCon->PLL_LOCK.VPLL_LOCK[0x%08x], g_pCmuClkCon->PLL_CON.VPLL_CON[0x%08x]\n\r"),g_pCmuClkCon->PLL_LOCK.VPLL_LOCK,g_pCmuClkCon->PLL_CON.VPLL_CON));
	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_vpll_onoff()\n\r")));

}


// set
//  - set functions are only called under running tvout clock
void
Tvout_clk_set_vp_clk_onoff
(BOOL bClkOn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_vp_clk_onoff(%d)\n\r"),bClkOn));

	if (bClkOn)
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1 |= (0x1<<BP_CLK_IP_VP);
	}
	else
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1 &= ~(0x1<<BP_CLK_IP_VP);
	}

	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1[0x%08x]\n\r"),g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1));
	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_vp_clk_onoff()\n\r")));
}

void
Tvout_clk_set_vmixer_clk_onoff
(BOOL bClkOn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_vmixer_clk_onoff(%d)\n\r"),bClkOn));

	if (bClkOn)
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1 |= (0x1<<BP_CLK_IP_MIXER);

	}
	else
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1 &= ~(0x1<<BP_CLK_IP_MIXER);
	}

	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1[0x%08x]\n\r"),g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1));

	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_vmixer_clk_onoff()\n\r")));
    
}


void
Tvout_clk_set_tvenc_clk_onoff
(BOOL bClkOn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_tvenc_clk_onoff(%d)\n\r"),bClkOn));

	if (bClkOn)
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1 |= (0x1<<BP_CLK_IP_TVENC);
	}
	else
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1 &= ~(0x1<<BP_CLK_IP_TVENC);
	}


	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1[0x%08x]\n\r"),
							g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1));

	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_sdout_clk_onoff()\n\r")));
    
}



void
Tvout_clk_set_tvblock_on_off
(BOOL bClkOn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_tvblock_on_off(%d)\n\r"),bClkOn));
/*
	if (bClkOn)
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_BLOCK |= (0x1<<BP_CLK_BLK_TV);
	}
	else
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_BLOCK &= ~(0x1<<BP_CLK_BLK_TV);
	}
*/
	DBGMSG(TV_INFO,(_T("  g_pCmuClkCon->CLK_GATE.CLK_GATE_BLOCK [0x%08x]\n\r"),g_pCmuClkCon->CLK_GATE.CLK_GATE_BLOCK ));
	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_tvblock_on_off()\n\r")));

}

void
TVout_clk_set_hdmi_i2c_phy_clk_onoff
(BOOL bClkOn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++TVout_clk_set_hdmi_i2c_phy_clk_onoff(%d)\n\r"),bClkOn));
	
	if (bClkOn)
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP3 |= (0x1<<BP_CLK_IP_I2C_HDMI_PHY);

	}
	else
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP3 &= ~(0x1<<BP_CLK_IP_I2C_HDMI_PHY);
	}

	DBGMSG(TV_FUNC,(_T("[TVCLK]--TVout_clk_set_hdmi_i2c_phy_clk_onoff()\n\r")));
}

void
Tvout_clk_set_hdmi_clk_onoff
(BOOL bClkOn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_hdmi_clk_onoff(%d)\n\r"),bClkOn));

	if (bClkOn)
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1 |= (0x1<<BP_CLK_IP_HDMI);
	}
	else
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP1 &= ~(0x1<<BP_CLK_IP_HDMI);
	}

	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_hdmi_clk_onoff()\n\r")));


}

void
Tvout_clk_set_ddc_clk_onoff
(BOOL bClkOn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_set_ddc_clk_onoff(%d)\n\r"),bClkOn));

	if (bClkOn)
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP3 |= (0x1<<BP_CLK_IP_I2C_HDMI_DDC);
	}
	else
	{
		g_pCmuClkCon->CLK_GATE.CLK_GATE_IP3 &= ~(0x1<<BP_CLK_IP_I2C_HDMI_DDC);
	}

	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_set_ddc_clk_onoff()\n\r")));

}


void
TVout_clk_set_hdmi_phy_con_onoff()
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++TVout_clk_set_hdmi_phy_con_onoff()\n\r")));

	if(g_pCmuMiscCon->TEST_REG.HDMI_PHY_CON0  != 0)
		g_pCmuMiscCon->TEST_REG.HDMI_PHY_CON0 = 0; 

	DBGMSG(TV_FUNC,(_T("[TVCLK]--TVout_clk_set_hdmi_phy_con_onoff()\n\r")));
}

// start
//  - start functions are only called under stopping tvout clock
void
Tvout_clk_start
(BOOL bVideoProcessorHclkOn,
 BOOL bSDoutHclkOn,
 BOOL bHDMIHclkOn)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_start(%d,%d,%d)\n\r"),bVideoProcessorHclkOn,bSDoutHclkOn,bHDMIHclkOn));


	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_start()\n\r")));

}


// stop
//  - stop functions are only called under running tvout clock
void
Tvout_clk_stop
(void)
{
	DBGMSG(TV_FUNC,(_T("[TVCLK]++Tvout_clk_stop()\n\r")));

    //Tvout_clk_set_hdmi_i2c_clk_onoff(FALSE);

//    Tvout_clk_set_hdmi_sclk_onoff(FALSE);
//    Tvout_clk_set_hdmi_hclk_onoff(FALSE);
    
	Tvout_clk_set_vp_clk_onoff(FALSE);
	Tvout_clk_set_vmixer_clk_onoff(FALSE);

	Tvout_clk_set_tvenc_clk_onoff(FALSE);
	Tvout_clk_set_hdmi_clk_onoff(FALSE);
	TVout_clk_set_hdmi_i2c_phy_clk_onoff(FALSE);

	Tvout_clk_set_tvblock_on_off(FALSE);

#if VPLL_ON_OFF
	Tvout_clk_set_clk_mask_onoff(FALSE);    
	Tvout_clk_vpll_onoff(FALSE);
	Tvout_clk_set_clk_mask_onoff(TRUE);
#endif

/*
    Tvout_clk_set_vp_clk_onoff(FALSE);
    Tvout_clk_set_vmixer_clk_onoff(FALSE);    
    Tvout_clk_set_hdmi_clk_onoff(FALSE);

    Tvout_power_set_hdmi_en(FALSE);
*/    
	DBGMSG(TV_FUNC,(_T("[TVCLK]--Tvout_clk_stop()\n\r")));

}


