//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
/*++
  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
  ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
  PARTICULAR PURPOSE.

  Module Name: ser_dma.h

  Notes: 
--*/
#ifdef USE_DMA

#ifndef __PDDSER_DMA_H_
#define __PDDSER_DMA_H_

/****************************************************************************************
 ***** INCLUDE
 ****************************************************************************************/


#include <cmthread.h>
#include <intr_reg.h>
#include <bsp_cfg.h>
#include <dma_controller.h>

/****************************************************************************************
 ***** DEFINITIONS
 ****************************************************************************************/

#define RX_DMA_THREAD_PRIORITY 106 // need to tune 
#define TX_DMA_THREAD_PRIORITY 106 // need to tune 

//DMA Buffer Address Alloc
#define RX_BUFFER_SIZE 4096    // 4K buffer
#define Buffer_Mem_Size 4096    // 4K buffer


/* DMA Related Start*/

#define WRITE_TIME_OUT_CONSTANT     5000
#define WRITE_TIME_OUT_MULTIPLIER   1

#define READ_TIME_OUT_CONSTANT      5000
#define READ_TIME_OUT_MULTIPLIER    1




/****************************************************************************************
 ***** STRUCTURES
 ****************************************************************************************/


typedef struct {
        volatile DMAC_REG       *pDMAC0regs;
        volatile DMAC_REG       *pDMAC1regs;
        volatile DMAC_REG       *pDMACregs;
        volatile CMU_CLK_REG    *pSYSCONregs;

        DWORD m_chnum;

        // RX    
        DWORD   dwRxDmaDoneThreadId;
        DWORD   dwRxDmaThreadPrio;
        DWORD   dwRxDmaDoneSysIntr;
        HANDLE  hRxDmaDoneEvent;
        HANDLE  hRxDmaDoneThread;
        HANDLE  hRxDmaTimeoutEvent;
        HANDLE RXDMAEventHandles[2];


        // TX    
        DWORD   dwTxDmaDoneThreadId;
        DWORD   dwTxDmaThreadPrio;
        DWORD   dwTxDmaDoneSysIntr;
        HANDLE  hTxDmaDoneEvent;
        HANDLE  hTxDmaDoneThread;

} DMA_PUBLIC_CONTEXT, *PDMA_PUBLIC_CONTEXT;


/****************************************************************************************
 ***** FUNCTIONS
 ****************************************************************************************/

BOOL DmaPowerUp();
BOOL DmaPowerDown();

/* DMA Related End */

#endif

#endif //#ifdef USE_DMA
