//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
#ifndef _SDMMC_CH1_H_
#define _SDMMC_CH1_H_

#include "../SDMMC_LIB/SDHC.h"


// Macros on Clock gating

// Clock & Power
#define CLK_SRC0_EPLL_SEL           (~(0x1<<8))     // Control MUXepll
#define CLK_SRC0_MUXepll            (0x1<<8)        // FOUTepll

#define CLK_SRC2_MMC1_SEL           (~(0x3<<4))     // Control MUXmmc1
#define CLK_SRC2_MUXmmc1            (0x0<<4)        // MOUTepll

#define CLK_DIV3_MMC1_RATIO         (~(0xf<<4))     // DIVmmc0 clock divider ratio
#define CLK_DIV3_DIVmmc1            (0x0<<4)        // CLKMMC0 = CLKMMC1in / 1

#define CLK_GATE_D1_0_MMC1          (~(0x1<<6))     // HCLK for MMC1
#define CLK_GATE_D1_0_MMC1_PASS     (0x1<<6)        // HCLK for MMC1 pass

#define CLK_GATE_SCLK_0_MMC1        (~(0x1<<13))    // Special clock for MMC1
#define CLK_GATE_SCLK_0_MMC1_PASS   (0x1<<13)       // Special clock for MMC1 pass

#define CLK_GATE_SCLK_0_MMC1_48     (~(0x1<<16))    // Special clock 48MHz for MMC1
#define CLK_GATE_SCLK_0_MMC1_48_PASS (0x1<<16)      // Special clock 48MHz for MMC1 pass


typedef class CSDHControllerCh1 : public CSDHCBase {

    public:

        // Constructor
        CSDHControllerCh1() : CSDHCBase() {}

        // Destructor
        virtual ~CSDHControllerCh1() {}

        // Perform basic initialization including initializing the hardware
        // so that the capabilities register can be read.
        virtual BOOL Init(LPCTSTR pszActiveKey);

        virtual VOID PowerUp();

        virtual LPSDHC_DESTRUCTION_PROC GetDestructionProc()
        {
            return &DestroySDMMCHCCh1Object;
        }

        static VOID DestroySDMMCHCCh1Object(PCSDHCBase pSDHC);

    protected:

        BOOL InitClkPwr(void);

        BOOL InitGPIO(void);

        BOOL InitSDMMC(void);

        BOOL InitCh(void);

} *PCSDHControllerCh1;

#endif // _SDMMC_CH1_H_

