/*
 * Project Name MFC DRIVER IN WINCE
 * Copyright  2009 Samsung Electronics Co, Ltd. All Rights Reserved.
 *
 * This file implements MFC driver.
 *
 * @name MFC DRIVER Module (MfcMemory.h)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 2009/06/05
 */


#ifndef __SAMSUNG_SYSLSI_APDEV_MFC_MEMORY_H__
#define __SAMSUNG_SYSLSI_APDEV_MFC_MEMORY_H__

#include <windows.h>
#include "mfc_reg.h"
#include "MfcCommon.h"
#include <bsp.h>


#ifdef __cplusplus
extern "C" {
#endif

#define MFC_MAX_INSTANCE_NUM                        (2) 
#define MFC_MAX_WIDTH                               (1920)
#define MFC_MAX_HEIGHT                              (1088)

// The base address of all buffer has to be aligned to 64kB
// firmware code area & local buffer
#define MFC_FIRMWARE_CODE_SIZE                      (512*1024)      // 512kB
#define MFC_FIRMWARE_INSTANCE_BUFF_SIZE             (640*1024)      // 640kB

// common decoder buffer
#define MFC_DEC_DESC_BUFF_SIZE                      (128*1024)      // 128kB

// H.264 decoder only
#define MFC_DEC_VERT_NB_MV_BUFF_SIZE                (64*1024)       // 16kB
#define MFC_DEC_NB_PIXEL_INTRA_BUFF_SIZE            (64*1024)       // 32kB

//decoder buffer execpt H.264
#define MFC_DEC_NB_ACDC_COEFF_BUFF_SIZE             (128*1024)      // 16kB
#define MFC_DEC_UPPER_NB_MV_BUFF_IZE                (128*1024)      // 68kB
#define MFC_DEC_ANCHOR_MV_BUFF_SIZE                 (192*1024)      // 136kB
#define MFC_DEC_OVERLAP_TRANS_BUFF_SIZE             (64*1024)       // 32kB
#define MFC_DEC_BITBPLANE_3_BUFF_SIZE               (64*1024)       // 1kB
#define MFC_DEC_BITBPLANE_2_BUFF_SIZE               (64*1024)       // 1kB
#define MFC_DEC_BITBPLANE_1_BUFF_SIZE               (64*1024)       // 1kB
#define MFC_DEC_SYNTAX_PASESR_BUFF_SIZE             (128*1024)      // 68kB
#define MFC_DEC_SHARED_MEMORY_SIZE                  (64*1024)       // 64kB

// encoder buffer
#define MFC_ENC_UPPER_MV_BUFF_SIZE                  (64*1024)       //64kB
#define MFC_ENC_DIRECT_COZERO_FLAG_BUFF_SIZE        (64*1024)       //64kB
#define MFC_ENC_UPPER_INTRA_MD_BUFF_SIZE            (64*1024)       //64kB
#define MFC_ENC_UPPER_INTRA_PRED_BUFF_SIZE          (64*1024)       //64kB
#define MFC_ENC_NBOR_INFO_MPENC_BUFF_SIZE           (64*1024)       //64kB
#define MFC_ENC_MV_BUFF_SIZE                        (64*1024)       //64kB
#define MFC_ENC_STAT_LOG_SIZE                       (64*1024)       //64kB

#define MFC_SFR_BUF_SIZE                            sizeof(MFC_SFR)

#define MFC_FW_DEC_BUFF_SIZE                        (MFC_DEC_DESC_BUFF_SIZE\
                                                        + MFC_DEC_VERT_NB_MV_BUFF_SIZE\
                                                        + MFC_DEC_NB_PIXEL_INTRA_BUFF_SIZE\
                                                        + MFC_DEC_NB_ACDC_COEFF_BUFF_SIZE\
                                                        + MFC_DEC_UPPER_NB_MV_BUFF_IZE\
                                                        + MFC_DEC_ANCHOR_MV_BUFF_SIZE\
                                                        + MFC_DEC_OVERLAP_TRANS_BUFF_SIZE\
                                                        + MFC_DEC_BITBPLANE_3_BUFF_SIZE\
                                                        + MFC_DEC_BITBPLANE_2_BUFF_SIZE\
                                                        + MFC_DEC_BITBPLANE_1_BUFF_SIZE\
                                                        + MFC_DEC_SYNTAX_PASESR_BUFF_SIZE\
                                                        + MFC_DEC_SHARED_MEMORY_SIZE)  //1152KB

#define MFC_FW_ENC_BUFF_SIZE                        (MFC_ENC_UPPER_MV_BUFF_SIZE\
                                                        + MFC_ENC_DIRECT_COZERO_FLAG_BUFF_SIZE\
                                                        + MFC_ENC_UPPER_INTRA_MD_BUFF_SIZE\
                                                        + MFC_ENC_UPPER_INTRA_PRED_BUFF_SIZE\
                                                        + MFC_ENC_NBOR_INFO_MPENC_BUFF_SIZE\
                                                        + MFC_ENC_STAT_LOG_SIZE\
                                                        + MFC_ENC_MV_BUFF_SIZE)  // 448KB

#define MFC_FW_BUFF_SIZE                            (MFC_FIRMWARE_CODE_SIZE\
                                                        + MFC_MAX_INSTANCE_NUM\
                                                        * (MFC_FIRMWARE_INSTANCE_BUFF_SIZE + MFC_FW_DEC_BUFF_SIZE + MFC_FW_ENC_BUFF_SIZE))
                                                     //6272KB


BOOL MFCMemorySetup();
volatile MFC_SFR *GetSfrVirAddr();
volatile unsigned char *GetFWCodeBufVirAddr();
volatile unsigned char * GetFWCtxBufVirAddr(int instanceNo);
volatile unsigned char * GetSharedMemVirAddr(int instanceNo);
unsigned int GetSfrPhyAddr();
unsigned int GetFWCodeBufPhyAddr();
unsigned int GetFWDataBufPhyAddr(int instanceNo);
unsigned int GetFWCtxBufPhyAddr(int instanceNo);
unsigned int GetSharedMemPhyAddr(int instanceNo);
unsigned int GetDramAPhyBaseAddr();
unsigned int GetDramBPhyBaseAddr();

#ifdef __cplusplus
}
#endif

#endif //__SAMSUNG_SYSLSI_APDEV_MFC_MEMORY_H__
