/*
 * Project Name JPEG DRIVER IN WINCE
 * Copyright  2007 Samsung Electronics Co, Ltd. All Rights Reserved.
 *
 * This software is the confidential and proprietary information
 * of Samsung Electronics  ("Confidential Information").
 * you shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Samsung Electronics
 *
 * This file implements JPEG driver.
 *
 * @name JPEG DRIVER MODULE Module (JPGMem.c)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 28-03-07
 */

#include "JPGMem.h"
#include "JPGMisc.h"
#include "image_cfg.h"
#include "CMMAPI.h"
#include "base_regs.h"
#include "bsp_args.h"
#include "jpg_reg.h"
#include "DrvLib_mem.h"

static volatile JPG_SFR  *virJPGReg;
/*----------------------------------------------------------------------------
*Function: Phy2VirAddr

*Parameters: 		dwContext		:
*Return Value:		True/False
*Implementation Notes: memory mapping from physical addr to virtual addr
-----------------------------------------------------------------------------*/
void *Phy2VirAddr(UINT32 phy_addr, int mem_size)
{
    void *mappedAddr = NULL;

    DBGMSG(JPG_FUNC,(_T("[JPGDRV] %s++\r\n"), _T(__FUNCTION__)));
    mappedAddr = DrvLib_MapIoSpace(phy_addr, mem_size, FALSE);
    if (mappedAddr == NULL)
    {
        ERRMSG((_T("[JPGDRV] %s :: Mapping Failed [PA:0x%08x]\r\n"), _T(__FUNCTION__), phy_addr));
        return FALSE;
    }
    DBGMSG(JPG_FUNC,(_T("[JPGAPI] %s--\r\n"), _T(__FUNCTION__)));
    return mappedAddr;
}


/*----------------------------------------------------------------------------
*Function: JPGSfrMemMapping

*Parameters:         dwContext        :
*Return Value:        True/False
*Implementation Notes: JPG register mapping from physical addr to virtual addr
-----------------------------------------------------------------------------*/
BOOL JPGSfrMemMapping()
{

    // JPG HOST Register
    DBGMSG(JPG_FUNC,(_T("[JPGDRV] %s++\r\n"), _T(__FUNCTION__)));
    virJPGReg = (volatile JPG_SFR *)Phy2VirAddr(BASE_REG_PA_JPEG, sizeof(JPG_SFR));
    if (virJPGReg == NULL)
    {
        ERRMSG((_T("[JPGDRV] %s :: virJPGReg - VirtualAlloc failed!\r\n"), _T(__FUNCTION__)));
        return FALSE;
    }
    DBGMSG(JPG_FUNC,(_T("[JPGAPI] %s--\r\n"), _T(__FUNCTION__)));
    return TRUE;
}

volatile JPG_SFR * GetJPGSfrVirAddr()
{
    return virJPGReg;
}

int GetJPGSfrPhyAddr()
{
    return BASE_REG_PA_JPEG;
}
