/*
 * Project Name JPEG API for HW JPEG IP IN WINCE
 * Copyright  2007 Samsung Electronics Co, Ltd. All Rights Reserved. 
 *
 * This software is the confidential and proprietary information
 * of Samsung Electronics  ("Confidential Information").   
 * you shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Samsung Electronics 
 *
 * This file implements JPEG driver.
 *
 * @name JPEG DRIVER MODULE Module (JPGApi.h)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 28-05-07
 */

 #ifndef __JPG_API_H__
#define __JPG_API_H__

#define MAX_JPG_WIDTH				3264
#define MAX_JPG_HEIGHT				2448
#define MAX_YUV_SIZE				(MAX_JPG_WIDTH * MAX_JPG_HEIGHT * 2)
#define	MAX_FILE_SIZE				(MAX_JPG_WIDTH * MAX_JPG_HEIGHT)
#define MAX_JPG_THUMBNAIL_WIDTH		160
#define MAX_JPG_THUMBNAIL_HEIGHT	120
#define MAX_YUV_THUMB_SIZE			(MAX_JPG_THUMBNAIL_WIDTH * MAX_JPG_THUMBNAIL_HEIGHT * 2)
#define	MAX_FILE_THUMB_SIZE			(MAX_JPG_THUMBNAIL_WIDTH * MAX_JPG_THUMBNAIL_HEIGHT)
#define MAX_RGB_WIDTH				800
#define MAX_RGB_HEIGHT				480
#define EXIF_FILE_SIZE				28800


typedef enum tagJPEGConf{
	JPEG_GET_DECODE_WIDTH,
	JPEG_GET_DECODE_HEIGHT,
	JPEG_GET_DECODE_YUV_WIDTH,
	JPEG_GET_DECODE_YUV_HEIGHT,
	JPEG_SET_DECODE_OUT_FORMAT,
	JPEG_GET_SAMPING_MODE,
	JPEG_SET_ENCODE_WIDTH,
	JPEG_SET_ENCODE_HEIGHT,
	JPEG_SET_ENCODE_QUALITY,
	JPEG_SET_ENCODE_THUMBNAIL,
	JPEG_SET_ENCODE_IN_FORMAT,
	JPEG_SET_ENCODE_Y16,
	JPEG_SET_SAMPING_MODE,
	JPEG_SET_THUMBNAIL_WIDTH,
	JPEG_SET_THUMBNAIL_HEIGHT
}JPEGConf;

typedef enum tagJPEG_ERRORTYPE{
	JPEG_FAIL,
	JPEG_OK,
	JPEG_ENCODE_FAIL,
	JPEG_ENCODE_OK,
	JPEG_DECODE_FAIL,
	JPEG_DECODE_OK,
	JPEG_HEADER_PARSE_FAIL,
	JPEG_HEADER_PARSE_OK,
	JPEG_DISPLAY_FAIL,
	JPEG_OUT_OF_MEMORY,
	JPEG_UNKNOWN_ERROR
}JPEG_ERRORTYPE;

typedef enum tagIMAGE_TYPE_T
{
    JPG_RGB16,
    JPG_YCBYCR,
    JPG_TYPE_UNKNOWN
} IMAGE_TYPE_T;

typedef enum tagSAMPLE_MODE_T
{
    JPG_444 = 0,
    JPG_422,
    JPG_420, 
    JPG_400,
    JPG_SAMPLE_UNKNOWN
} SAMPLE_MODE_T;


typedef enum tagOUT_MODE_T
{
    YCBCR_422,
    YCBCR_420, 
    YCBCR_SAMPLE_UNKNOWN
} OUT_MODE_T;

typedef enum tagIN_MODE_T
{
    JPG_MODESEL_YCBCR = 1,
    JPG_MODESEL_RGB, 
    JPG_MODESEL_UNKNOWN
} IN_MODE_T;

typedef enum tagMODE_Y16
{
    JPG_MODE_Y16_0,
    JPG_MODE_Y16_16, 
    JPG_MODE_Y16_UNKNOWN
} MODE_Y16;

typedef enum tagENCDEC_TYPE_T
{
    JPG_MAIN,
    JPG_THUMBNAIL
} ENCDEC_TYPE_T;

typedef enum tagIMAGE_QUALITY_TYPE_T
{
    JPG_QUALITY_LEVEL_1 = 0, /*high quality*/
    JPG_QUALITY_LEVEL_2,
    JPG_QUALITY_LEVEL_3,
    JPG_QUALITY_LEVEL_4     /*low quality*/
} IMAGE_QUALITY_TYPE_T;

typedef struct tagExifFileInfo{
	char	Make[32]; 
	char	Model[32]; 
	char	Version[32]; 
	char	DateTime[32]; 
	char	CopyRight[32]; 

	UINT	Height; 
	UINT	Width;
	UINT	Orientation; 
	UINT	ColorSpace; 
	UINT	Process;
	UINT	Flash; 

	UINT	FocalLengthNum; 
	UINT	FocalLengthDen; 

	UINT	ExposureTimeNum; 
	UINT	ExposureTimeDen; 

	UINT	FNumberNum; 
	UINT	FNumberDen; 

	UINT	ApertureFNumber; 

	int		SubjectDistanceNum; 
	int		SubjectDistanceDen; 

	UINT	CCDWidth;

	int		ExposureBiasNum; 
	int		ExposureBiasDen; 


	int		WhiteBalance; 

	UINT	MeteringMode; 

	int		ExposureProgram;

	UINT	ISOSpeedRatings[2]; 
	
	UINT	FocalPlaneXResolutionNum;
	UINT	FocalPlaneXResolutionDen;

	UINT	FocalPlaneYResolutionNum;
	UINT	FocalPlaneYResolutionDen;

	UINT	FocalPlaneResolutionUnit;

	UINT	XResolutionNum;
	UINT	XResolutionDen;
	UINT	YResolutionNum;
	UINT	YResolutionDen;
	UINT	RUnit; 

	int		BrightnessNum; 
	int		BrightnessDen; 

	char	UserComments[150];
}ExifFileInfo;

void *SsbSipJPEGDecodeInit(void);
void *SsbSipJPEGEncodeInit(void);
JPEG_ERRORTYPE SsbSipJPEGDecodeExe(void *openHandle);
JPEG_ERRORTYPE SsbSipJPEGEncodeExe(void *openHandle, ExifFileInfo *Exif);
void *SsbSipJPEGGetDecodeInBuf(void *openHandle, long size);
void *SsbSipJPEGGetDecodeOutBuf (void *openHandle, long *size);
void *SsbSipJPEGGetEncodeInBuf(void *openHandle, long size);
void *SsbSipJPEGGetEncodeOutBuf (void *openHandle, long *size);
JPEG_ERRORTYPE SsbSipJPEGSetConfig (void *openHandle, JPEGConf type, INT32 value);
JPEG_ERRORTYPE SsbSipJPEGGetConfig (void *openHandle, JPEGConf type, INT32 *value);
JPEG_ERRORTYPE SsbSipJPEGDecodeDeInit (void *openHandle);
JPEG_ERRORTYPE SsbSipJPEGEncodeDeInit (void *openHandle);
void *SsbSipJPEGGetDecodeOutPhyBuf(void *openHandle);
void *SsbSipJPEGGetRGBPhyBuf(void *openHandle, int Width, int Height);

#endif
