#include <windows.h>


HANDLE InitMutex(LPCTSTR name)
{
   HANDLE hMutex;
   
   hMutex = CreateMutex (
            NULL,                             // No security attributes
            FALSE,                            // Initially not owned
            name);  // Name of mutex object
   
   if (NULL == hMutex)
   {
      // Your code to deal with the error goes here.
      RETAILMSG(1, (_T("[DRVLIB]Cann't initialize mutex %s\r\n"),name));
   }
   
   return hMutex;
}

DWORD GetMutex(HANDLE handle)
{
   DWORD result;

   result = WaitForSingleObject( handle, INFINITE);
   
   switch(result)
   {
      case WAIT_OBJECT_0:
         break;
      case WAIT_TIMEOUT:
         RETAILMSG(1, (_T("[DRVLIB]ERROR:Mutex Timeout\r\n")));
         break;
      case WAIT_ABANDONED:
         RETAILMSG(1, (_T("[DRVLIB]ERROR:Mutex abandoned\r\n")));
         break;
      default:
         RETAILMSG(1, (_T("[DRVLIB]ERROR:others\r\n")));
         break;
   }
   return result;
}
