//
// Copyright (c) Samsung Electronics.  All rights reserved.
//
//
//------------------------------------------------------------------------------
//
//  File:  drvmsg.c
//
//  This file defines g_oalCacheInfo global variable used to cache subsystem
//  to specify cache memory parameters.
//

#include <windows.h>
#include <oal.h>
#include <bsp_args.h>
#include <ioctl_cfg.h>
#include <image_cfg.h>

#define DRVMSG_LIBRARY
#include <drvmsg.h>
#undef DRVMSG_LIBRARY

#define DRVLIB_LIBRARY
#include <drvlib_mem.h>
#undef DRVLIB_LIBRARY


//------------------------------------------------------------------------------
//
//  Global:  g_DrvMsgMask
//

unsigned int g_DrvMsgMask[DRVLOG_PART_NUM] = 
{	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL, 
	INITIAL_LOGMASK_VAL
};


__declspec(dllexport) void Print_DrvMsgMask(void)
{
	DWORD idx;
	for(idx=0;idx<DRVLOG_PART_NUM;idx++)
	{
		DBGMSG(DRVLIB_INFO,(TEXT("g_DrvMsgMask[%d] = 0x%X\r\n"),idx,g_DrvMsgMask[idx]));
	}
}
static void Update_DriverMask(void)
{
	BOOL bEnableDrvMsg = FALSE;
	DWORD dwOutbytes;

	KernelIoControl(IOCTL_HAL_QUERY_DRVLOG, NULL, 0, &bEnableDrvMsg, sizeof(BOOL), &dwOutbytes);

	if (bEnableDrvMsg)
	{
	    DBGMSG(DRVLIB_INFO,(TEXT("bEnableDrvMsg\r\n")));
		KernelIoControl(IOCTL_HAL_QUERY_DRVMASK, NULL, 0, &g_DrvMsgMask, sizeof(g_DrvMsgMask), &dwOutbytes);
		Print_DrvMsgMask();
	}
	else
	{
	    DBGMSG(DRVLIB_INFO,(TEXT(" NO bEnableDrvMsg\r\n")));
		memset(g_DrvMsgMask, 0, sizeof(g_DrvMsgMask));
	}
}


//static void DrvMSGInitialize(void)
void DrvMSGInitialize(void)
{
	static BOOL drvmsgInitialized = FALSE;

	DBGMSG(DRVLIB_INFO, (L"DMSG: DrvMSGInitialize\r\n"));
	
	if (!drvmsgInitialized) {
		drvmsgInitialized = TRUE;
		Update_DriverMask();
#ifndef SHIP_BUILD		
		//CloseHandle(CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) DrvMsgThreadProc, NULL, 0, NULL));
#endif
	}
}

//static void DrvMSGDeinitialize(void)
void DrvMSGDeinitialize(void)
{
	DBGMSG(DRVLIB_INFO, (TEXT("DMSG: DrvMSGDeinitialize ...\r\n")));
	
}
