
#ifndef _SVENGINE_H_
#define _SVENGINE_H_

#include <SVEDriverAPI.h>
#include <display_con.h>
#include <ldi.h>
#include <image_rotator.h>
#include "CAMDriver.h"
#include <SVE_API.h>
#if 0
#define __MODULE__  "S5PV210 Video Driver"

#define ZONEID_ERROR                0
#define ZONEID_WARNING              1
#define ZONEID_PERF                 2
#define ZONEID_TEMP                 3
#define ZONEID_ENTER                4
#define ZONEID_INIT                 5
#define ZONEID_POST                 6
#define ZONEID_ROTATOR              7
#define ZONEID_TVENCODER            8
#define ZONEID_TVSCALER             9
#define ZONEID_IOCTL                10

#define VDE_ZONE_ERROR             DEBUGZONE(ZONEID_ERROR)
#define VDE_ZONE_WARNING           DEBUGZONE(ZONEID_WARNING)
#define VDE_ZONE_PERF              DEBUGZONE(ZONEID_PERF)
#define VDE_ZONE_TEMP              DEBUGZONE(ZONEID_TEMP)
#define VDE_ZONE_ENTER             DEBUGZONE(ZONEID_ENTER)
#define VDE_ZONE_INIT              DEBUGZONE(ZONEID_INIT)
#define VDE_ZONE_POST              DEBUGZONE(ZONEID_POST)
#define VDE_ZONE_ROTATOR           DEBUGZONE(ZONEID_ROTATOR)
#define VDE_ZONE_TVENCODER         DEBUGZONE(ZONEID_TVENCODER)
#define VDE_ZONE_TVSCALER          DEBUGZONE(ZONEID_TVSCALER)
#define VDE_ZONE_IOCTL             DEBUGZONE(ZONEID_IOCTL)

#define ZONEMASK_ERROR         (1 << ZONEID_ERROR)
#define ZONEMASK_WARNING       (1 << ZONEID_WARNING)
#define ZONEMASK_PERF          (1 << ZONEID_PERF)
#define ZONEMASK_TEMP          (1 << ZONEID_TEMP)
#define ZONEMASK_ENTER         (1 << ZONEID_ENTER)
#define ZONEMASK_INIT          (1 << ZONEID_INIT)
#define ZONEMASK_POST          (1 << ZONEID_POST)
#define ZONEMASK_ROTATOR       (1 << ZONEID_ROTATOR)
#define ZONEMASK_TVENCODER     (1 << ZONEID_TVENCODER)
#define ZONEMASK_TVSCALER      (1 << ZONEID_TVSCALER)
#define ZONEMASK_IOCTL         (1 << ZONEID_IOCTL)

#ifndef VDE_DEBUGZONES
#define VDE_DEBUGZONES          (ZONEMASK_ERROR | ZONEMASK_WARNING | ZONEID_POST | ZONEID_TEMP | ZONEID_ENTER | ZONEID_INIT | \
                                 ZONEID_ROTATOR | ZONEID_IOCTL )
#endif
#ifndef VDE_RETAILZONES
#define VDE_RETAILZONES          (ZONEMASK_ERROR)
#endif
#ifdef  DEBUG
#define VDE_ZONES VDE_DEBUGZONES
#else
#define VDE_ZONES VDE_RETAILZONES
#endif

#define VDE_MSG(x)      DEBUGMSG(VDE_ZONE_WARNING, x)
#define VDE_INF(x)      DEBUGMSG(VDE_ZONE_TEMP, x)
#define VDE_ERR(x)      RETAILMSG(VDE_ZONE_ERROR, x)

#else

#ifdef DEBUG
#define __MODULE__  "S5PV210 Video Driver"

#define ZONEID_ERROR                0
#define ZONEID_WARNING              1
#define ZONEID_PERF                 2
#define ZONEID_TEMP                 3
#define ZONEID_ENTER                4
#define ZONEID_INIT                 5
#define ZONEID_POST                 6
#define ZONEID_ROTATOR              7
#define ZONEID_TVENCODER            8
#define ZONEID_TVSCALER             9
#define ZONEID_IOCTL                10

#define VDE_ZONE_ERROR             DEBUGZONE(ZONEID_ERROR)
#define VDE_ZONE_WARNING           DEBUGZONE(ZONEID_WARNING)
#define VDE_ZONE_PERF              DEBUGZONE(ZONEID_PERF)
#define VDE_ZONE_TEMP              DEBUGZONE(ZONEID_TEMP)
#define VDE_ZONE_ENTER             DEBUGZONE(ZONEID_ENTER)
#define VDE_ZONE_INIT              DEBUGZONE(ZONEID_INIT)
#define VDE_ZONE_POST              DEBUGZONE(ZONEID_POST)
#define VDE_ZONE_ROTATOR           DEBUGZONE(ZONEID_ROTATOR)
#define VDE_ZONE_TVENCODER         DEBUGZONE(ZONEID_TVENCODER)
#define VDE_ZONE_TVSCALER          DEBUGZONE(ZONEID_TVSCALER)
#define VDE_ZONE_IOCTL             DEBUGZONE(ZONEID_IOCTL)

#define ZONEMASK_ERROR         (1 << ZONEID_ERROR)
#define ZONEMASK_WARNING       (1 << ZONEID_WARNING)
#define ZONEMASK_PERF          (1 << ZONEID_PERF)
#define ZONEMASK_TEMP          (1 << ZONEID_TEMP)
#define ZONEMASK_ENTER         (1 << ZONEID_ENTER)
#define ZONEMASK_INIT          (1 << ZONEID_INIT)
#define ZONEMASK_POST          (1 << ZONEID_POST)
#define ZONEMASK_ROTATOR       (1 << ZONEID_ROTATOR)
#define ZONEMASK_TVENCODER     (1 << ZONEID_TVENCODER)
#define ZONEMASK_TVSCALER      (1 << ZONEID_TVSCALER)
#define ZONEMASK_IOCTL         (1 << ZONEID_IOCTL)

#ifndef VDE_DEBUGZONES
#define VDE_DEBUGZONES          (ZONEMASK_ERROR | ZONEMASK_WARNING | ZONEID_POST | ZONEID_TEMP | ZONEID_ENTER | ZONEID_INIT | \
                                 ZONEID_ROTATOR | ZONEID_IOCTL )
#endif
#ifndef VDE_RETAILZONES
#define VDE_RETAILZONES          (ZONEMASK_ERROR)
#endif
#ifdef  DEBUG
#define VDE_ZONES VDE_DEBUGZONES
#else
#define VDE_ZONES VDE_RETAILZONES
#endif

#endif // DEBUG

#define VDE_MSG(x)      DBGMSG(DISP_USR4, x)
#define VDE_INF(x)      DBGMSG(DISP_USR4, x)
#define VDE_ERR(x)      DBGMSG(DISP_INFO, x)
#endif

#define PC_REG_DISPLAY_CONFIG   _T("\\Drivers\\Display\\S5PV210\\Config\\")
#define PC_REG_LOCALPATHPORT    _T("UseAsPost")
#define CAMIF_DEFAULT_PORT      _T("CAM2:")

#define SVE_DRIVER_SIGNITURE            (0xD3EC6400)
#define SVE_ERROR_BASE                  (0x20000000)        // Non system error code

#define SVE_IST_PRIORITY                (100)

#define SVE_DISP_CMD_TIMEOUT            (100)    // Optimal Period of Vsync is 16.7ms (60Hz)
#define SVE_POST_CMD_TIMEOUT            (100)    //(35)    // Optimal Period of Vsync is 16.7ms (60Hz)
#define SVE_ROTATOR_FINISH_TIMEOUT      (100)    // Optimal Period of Vsync is 16.7ms (60Hz)

#ifdef USE_LOCALPATH_EMUL_WITH_MEM2MEM
#define CMM_MEMAREA_FOR_LPE DRAM_0
#endif

//extern DBGPARAM dpCurSettings;

typedef struct _DispConCommandContext
{
    CRITICAL_SECTION    csCmd;
    BOOL    bCmdSetBuffer;
    BOOL    bCmdSetPosition;
    DWORD    dwBuffer;
    DWORD    dwOffsetX;
    DWORD    dwOffsetY;
} DispConCommandContext;
/*
typedef struct _PostCommandContext
{
    CRITICAL_SECTION    csCmd;
    BOOL    bCmdSetSrcBuffer;
    BOOL    bCmdSetDstBuffer;
} PostCommandContext;
*/
typedef struct _LocalPathCommandContext
{
    CRITICAL_SECTION    csCmd;
    BOOL    bCmdSetWin0Enable;        // Depricated
    BOOL    bCmdSetWin0Disable;
    BOOL    bCmdSetWin1Enable;        // Depricated
    BOOL    bCmdSetWin1Disable;
    BOOL    bCmdSetWin2Enable;        // Depricated
    BOOL    bCmdSetWin2Disable;
} LocalPathCommandContext;

typedef struct _SVEngineContext
{
    // Driver Signature
    DWORD    dwSignature;

    // Video-related Hardware SFR
    volatile DISPLAY_REG    *pDispConReg;    // Display Controller SFR
    // ROTATOR IP was changed, so new rotator d/d will be developed
    //volatile IMAGE_ROTATOR_REG      *pRotatorReg;
    volatile CMU_CLK_REG    *pCMUCLKReg;    // CMU_Clock SFR
    volatile CMU_MISC_REG    *pCMUMISCReg;    // CMU_MISC SFR
    volatile GPIO_REG       *pGPIOReg;        // GPIO SFR
    volatile SPI_REG        *pSPIReg;        // SPI Controller SFR
    volatile BSP_ARGS       *pBSPArgs;

    // Interrupt
    DWORD    dwSysIntrDisp;        // LCD VSYNC SysIntr
    DWORD    dwSysIntrRotator;        // Rotator SysIntr
    HANDLE    hInterruptDisp;
    HANDLE    hInterruptPost;
    HANDLE    hInterruptRotator;

    // Interrupt Thread
    HANDLE    hDisplayIST;
    HANDLE    hPostIST;
    HANDLE    hRotatorIST;

    // Handle for Power Control Driver
    HANDLE    hPowerControl;
    // Handle for Camera Driver for Post Processor
    HANDLE    hCamera;


    // Critical Section for IOCTL Proc
    CRITICAL_SECTION csProc;

    // HW status Flags
    volatile BOOL bVideoEnable;
    volatile BOOL bWindowEnable[5];
    volatile BOOL bRotatorBusy;

    // Command Event
    HANDLE hDispCmdDone;        // Display Controller Cmd Event

    // Operation Finish Event
    HANDLE hRotatorFinish;        // Image Rotator Finish Event

    // Thread Loop Termination Trigger
    BOOL bDispThrdExit;
    BOOL bPostThrdExit;
    BOOL bRotatorThrdExit;


    // Open Context of Resource Occupant
    DWORD dwOccupantFIMD;
    DWORD dwOccupantFIMDWindow[5];
    DWORD dwOccupantPost;
    DWORD dwOccupantRotator;

    DWORD dwOpenCount;
    DWORD dwLastOpenContext;
} SVEngineContext, *pSVEngineContext;


typedef struct _SVEnginePowerContext
{
    // Power State
    BOOL bPowerOn;

    // SVE_FIMD_SET_INTERFACE_PARAM
    BOOL bFIMDOutputParam;
    SVEARG_FIMD_OUTPUT_IF tFIMDOutputParam;

    // SVD_FIMD_SET_OUTPUT_PATH
    DISP_VIDOUT_PATH eVideoOutPath;

    // SVE_FIMD_SET_WB_ENABLE/DISABLE
    BOOL bFIMDOutputWB;
    DWORD dwCaptureFrameRate;

    // SVE_FIMD_SET_GAMMA
    BOOL bFIMDOutputGamma;
    unsigned char ucFIMDOutputGammaValue[DISP_GAMMA_VALUE_NUM];

    // SVE_FIMD_SET_COLORGAIN
    BOOL bFIMDOutputColorGain;
    unsigned short usFIMDOutputColorGainR;
    unsigned short usFIMDOutputColorGainG;
    unsigned short usFIMDOutputColorGainB;

    // SVE_FIMD_SET_HUE
    BOOL bFIMDOutputHue;
    DISP_HUE_CONTROL tFIMDOutputHueControl;

    // SVE_FIMD_SET_ALPS
    BOOL bFIMDOutALPS;

    // SVE_FIMD_SET_DITHERING
    BOOL bFIMDOutDithering;
    DISP_DITHER_MODE eFIMDOutputDitheringMode;

    // SVE_FIMD_SET_OUTPUT_ENABLE/DISABLE
    BOOL bFIMDOutputEnable;

    // SVE_FIMD_SET_WINDOW_MODE/POSITION
    BOOL bFIMDWinMode[DISP_WIN_MAX];
    SVEARG_FIMD_WIN_MODE tFIMDWinMode[DISP_WIN_MAX];

    // SVE_FIMD_SET_WINDOW_FRAMEBUFFER
    BOOL bFIMDWinFBuffer[DISP_WIN_MAX];
    SVEARG_FIMD_WIN_FRAMEBUFFER tFIMDWinFBuffer[DISP_WIN_MAX];    // Doesn't care about which window number, "dwWinNum"

    // SVE_FIMD_SET_WINDOW_BLEND_COLORKEY
    BOOL bFIMDColorKey[DISP_WIN_MAX];
    SVEARG_FIMD_WIN_COLORKEY tFIMDColorKey[DISP_WIN_MAX];    // Doesn't care about which window number, "dwWinNum"

    // SVE_FIMD_SET_WINDOW_BLEND_ALPHA
    BOOL bFIMDAlpha[DISP_WIN_MAX];
    SVEARG_FIMD_WIN_ALPHA tFIMDAlpha[DISP_WIN_MAX];    // Doesn't care about which window number, "dwWinNum"

    // SVE_FIMD_SET_WINDOW_BLEND_ALPHA_EX
    BOOL bFIMDAlphaEx[DISP_WIN_MAX];
    SVEARG_FIMD_WIN_ALPHA_EX tFIMDAlphaEx[DISP_WIN_MAX];    // Doesn't care about which window number, "dwWinNum"

    // SVE_FIMD_SET_WINDOW_COLORMAP
    BOOL bFIMDWinColormap[DISP_WIN_MAX];
    unsigned int uiFIMDWinColormapColorValue[DISP_WIN_MAX];

    // SVE_FIMD_SET_WONDOW_QOS
    BOOL bFIMDWinQos[DISP_WIN_MAX];
    unsigned int ucFIMDWinQosFifoLevel[DISP_WIN_MAX];

    // SVE_FIMD_SET_WINDOW_ENABLE/DISABLE
    BOOL bFIMDWinEnable[DISP_WIN_MAX];

    // SVE_LOCALPATH_SET_WINX_START/STOP
    BOOL bLocalPathWin0Enable;
    BOOL bLocalPathWin1Enable;
    BOOL bLocalPathWin2Enable;

    // SVE_ROTATOR_SET_OPERATION_PARAM
    BOOL bRotatorParam;
    SVEARG_ROTATOR_PARAMETER tRotatorParam;

    // SVE_ROTATOR_SET_SOURCE_BUFFER
    BOOL bRotatorSrcBuffer;
    SVEARG_ROTATOR_BUFFER tRotatorSrcBuffer;

    // SVE_ROTATOR_SET_DESTINATION_BUFFER
    BOOL bRotatorDstBuffer;
    SVEARG_ROTATOR_BUFFER tRotatorDstBuffer;

    // SVE_ROTATOR_SET_OPERATION_START/STOP
    BOOL bRotatorStart;        // Need to Trigger

} SVEnginePowerContext, *pSVEnginePowerContext;

typedef enum
{
    HWCLK_ALL_ON = 0,        // 2D Clock is not included
    HWCLK_ALL_OFF,        // 2D Clock is not included
    HWCLK_DISPLAY_ON,
    HWCLK_DISPLAY_OFF,
    HWCLK_MSMIF_ON,
    HWCLK_MSMIF_OFF,
    HWCLK_POST_ON,
    HWCLK_POST_OFF,
    HWCLK_ROTATOR_ON,
    HWCLK_ROTATOR_OFF,
    HWCLK_TV_ON,
    HWCLK_TV_OFF,
    HWCLK_2D_ON,
    HWCLK_2D_OFF,
    HWCLK_MIPI_DSI_ON,
    HWCLK_MIPI_DSI_OFF
} HWCLK_GATING;

typedef enum
{
    HWPWR_ALL_ON = 0,        // 2D Power is not included
    HWPWR_ALL_OFF,        // 2D Power is not included
    HWPWR_DISPLAY_ON,
    HWPWR_DISPLAY_OFF,
    HWPWR_POST_ON,
    HWPWR_POST_OFF,
    HWPWR_ROTATOR_ON,
    HWPWR_ROTATOR_OFF,
    HWPWR_TV_ON,
    HWPWR_TV_OFF,
    HWPWR_2D_ON,
    HWPWR_2D_OFF,
    HWPWR_MIPI_DSI_DPHY_ON,
    HWPWR_MIPI_DSI_DPHY_OFF
} HWPWR_GATING;

// SVEngine
BOOL SVE_initialize_video_engine(void);
void SVE_deinitialize_video_engine(void);
void SVE_initialize_context(void);
void SVE_deinitialize_context(void);
SVEngineContext* SVE_get_context(void);
SVEnginePowerContext* SVE_get_power_context(void);
BOOL SVE_map_device_address(void);
void SVE_unmap_device_address(void);
DWORD SVE_get_api_function_code(DWORD dwCode);
DWORD SVE_get_driver_signature(void);
DWORD SVE_add_open_context(void);
BOOL SVE_remove_open_context(DWORD dwOpenContext);
DWORD SVE_get_current_open_count(void);

// H/W Resource management
BOOL SVE_resource_request_FIMD_interface(DWORD dwOpenContext);
BOOL SVE_resource_release_FIMD_interface(DWORD dwOpenContext);
BOOL SVE_resource_compare_FIMD_interface(DWORD dwOpenContext);
BOOL SVE_resource_request_FIMD_window(DWORD dwWinNum, DWORD dwOpenContext);
BOOL SVE_resource_release_FIMD_window(DWORD dwWinNum, DWORD dwOpenContext);
BOOL SVE_resource_compare_FIMD_window(DWORD dwWinNum, DWORD dwOpenContext);
BOOL SVE_resource_request_Post(DWORD dwOpenContext);
BOOL SVE_resource_release_Post(DWORD dwOpenContext);
BOOL SVE_resource_compare_Post(DWORD dwOpenContext);
BOOL SVE_resource_request_Rotator(DWORD dwOpenContext);
BOOL SVE_resource_release_Rotator(DWORD dwOpenContext);
BOOL SVE_resource_compare_Rotator(DWORD dwOpenContext);

// Interrupt & Command
BOOL SVE_initialize_interrupt(void);
void SVE_deinitialize_interrupt(void);
BOOL SVE_initialize_thread(void);
void SVE_deinitialize_thread(void);
DWORD SVE_DisplayIntrThread(void);
DWORD SVE_PostIntrThread(void);
DWORD SVE_RotatorIntrThread(void);
DWORD SVE_wait_disp_cmd_done(void);
DWORD SVE_wait_post_cmd_done(void);
DWORD SVE_wait_tvsc_cmd_done(void);
DWORD SVE_wait_rotator_finish(void);

// Power Control
void SVE_initialize_power_context(void);
void SVE_deinitialize_power_context(void);
BOOL SVE_initialize_power_control(void);
void SVE_deinitialize_power_control(void);
BOOL SVE_hw_clock_control(HWCLK_GATING eParams);
BOOL SVE_hw_power_control(HWPWR_GATING eParams);
void SVE_video_engine_power_on(void);
void SVE_video_engine_power_off(void);

// Camera Driver Control
// This functions are implemented in PostAPI.c
BOOL SVE_initialize_RAW_camera_driver();
void SVE_deinitialize_RAW_camera_driver();

#ifdef USE_LOCALPATH_EMUL_WITH_MEM2MEM
// local path emul functions
BOOL SVE_LpeInitialize(void);
void SVE_LpeDeinitialize(void);
BOOL SVE_LpeSetPostParam(CAMARG_POST_PARAMETER* ptPostParam);
BOOL SVE_LpeUpdateFB(PBYTE pBufIn, DWORD dwLenIn,
                        PBYTE pBufOut, DWORD dwLenOut, PDWORD pdwActualOut);
#endif

// Resource API Proc
BOOL SVE_Resource_API_Proc(
    DWORD hOpenContext,
    DWORD dwCode,
    PBYTE pBufIn,
    DWORD dwLenIn,
    PBYTE pBufOut,
    DWORD dwLenOut,
    PDWORD pdwActualOut
    );

// Display Controller API Proc
BOOL SVE_DispCon_API_Proc(
    DWORD hOpenContext,
    DWORD dwCode,
    PBYTE pBufIn,
    DWORD dwLenIn,
    PBYTE pBufOut,
    DWORD dwLenOut,
    PDWORD pdwActualOut
    );

// Post Processor API Proc
BOOL SVE_Post_API_Proc(
    HANDLE hOpenContext,
    DWORD dwCode,
    PBYTE pBufIn,
    DWORD dwLenIn,
    PBYTE pBufOut,
    DWORD dwLenOut,
    PDWORD pdwActualOut
    );

// Post-FIMD Local Path API Proc
BOOL SVE_LocalPath_API_Proc(
    DWORD hOpenContext,
    DWORD dwCode,
    PBYTE pBufIn,
    DWORD dwLenIn,
    PBYTE pBufOut,
    DWORD dwLenOut,
    PDWORD pdwActualOut
    );

// Image Rotator API Proc
BOOL SVE_Rotator_API_Proc(
    DWORD hOpenContext,
    DWORD dwCode,
    PBYTE pBufIn,
    DWORD dwLenIn,
    PBYTE pBufOut,
    DWORD dwLenOut,
    PDWORD pdwActualOut
    );

extern DWORD g_VideoMemoryPhysicalBase;

#endif    // _SVENGINE_H_

