//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    DDI_dummy.cpp

Abstract:       DDI_dummy LCD module control

Functions:


Notes:


--*/

#include <windows.h>
#include <bsp.h>
//#include <bsp_cfg.h>
#include <register_map.h>

#include "DDI_dummy.h"

#define MIPI_MSG(x) DBGMSG(DISP_USR3,x);

static DDI_Infor* g_pDDIInfor;
#define DDI_CMD(x,a,b)        DSIM_WrData(g_pDDIInfor->pDSIProtocol,x,a,b);

// To build in Eboot
BYTE pDDIInfor_mem_DDI_dummy[sizeof(DDI_Infor)];

static const DDI_Configuration DDI_dummy_Spec =
{
    320,    //m_00uHoriSize
    480,    //m_01uVertiSize
    RGB16,    //m_02eBgBpp
    // VPorch
    9,        //m_03usVBack
    10,         //m_04usVFront
    // HPorch
    5,        //m_05usHBack
    2,         //m_06usHFront
    // Sync Area
    3,        //m_07usVertiSync
    2,        //m_08usHoriSync
    //VClk polarity
    true,    //m_09bVclkPolarity
    false,    //m_10bHSyncPolarity
    false,    //m_11bVSyncPolarity
    false,    //m_12bVideoDataEnPolarity
    60,        //m_13uFrameRate
    //for DSI Configuration
    DSIM_Video,                //m_40eInterface
    DSIM_16BPP_565,        //m_41ePixel
    VirtualCh_0,                //m_42eCh
    DSIM_Burst,    //m_43eVideoModeType
    0xf,                        //m_44usCmdAllowLen
};

DDI_Configuration* DDI_dummy_GetSpec(void)
{
    return (DDI_Configuration*) (&(DDI_dummy_Spec));
}


//////////
// Function Name : DDI_Init
// Function Description :
//   This function Initileze DDI to Display Image
// Input :     DDI_Infor* - DDI Handler
//            uVar0 - DSI Master Handler
//            uVar1 - DCS Handler
//            uVar2 - Not used
//            uVar3 - Not used
// Output : True/False
// Version : v0.0
DDI_Infor* DDI_Create(DWORD uVar0, DWORD uVar1, DWORD uVar2, DWORD uVar3)
{
    if ( uVar0 != 0 && uVar1 != 0)
    {
        //DDI_Infor* pDDIInfor = (DDI_Infor*) malloc(sizeof(DDI_Infor));
        DDI_Infor* pDDIInfor = (DDI_Infor*)pDDIInfor_mem_DDI_dummy;
        pDDIInfor->pDSIProtocol = (DSIM_Infor*) uVar0;
        pDDIInfor->pDCS = (DCS_Infor*) uVar1;
        pDDIInfor->m_pDDISpec = DDI_GetConfiguration();

        return pDDIInfor;
    }
    else
    {
        MIPI_MSG((_T("DSI Handler or DCS Handleris not embedded!!\n")));
        MIPI_MSG((_T("DDI is not initialied\n")));
        return FALSE;
    }
}

//////////
// Function Name : DDI_dummy_Init
// Function Description : This function initilize DSI DDI
// Input :     None
// Output :    None
// Version : v0.0
BYTE DDI_dummy_Init(DDI_Infor* pInfor, DWORD uVar0, DWORD uVar1)
{
    g_pDDIInfor = pInfor;
	
    DDI_CMD(DCSWrNoPara,0x1,0x00);             //S/W Reset
    DCS_ExitSleepMode(pInfor->pDCS);
    DCS_SetAddressMode(pInfor->pDCS, 0x50);    //Rotate 180
    DCS_EnterNormalMode(pInfor->pDCS);
    DCS_SetPixelFormat(pInfor->pDCS, (pInfor->m_pDDISpec->m_41ePixel << 4));            // Set Pixel Format
    DCS_SetDisplayOn(pInfor->pDCS);

    return TRUE;
}
