#ifndef __DSIM_H_
#define __DSIM_H_

#include <mipidsi_reg.h>

#define DBG_DSI
#ifdef DBG_DSI
#define DbgDSI    Disp
#else
#define DbgDSI(...)
#endif

#define DBG_DSIPrototocol
#ifdef DBG_DSIPrototocol
#define DbgDSIP    Disp
#else
#define DbgDSIP(...)
#endif

/*
typedef enum
{
    PAL1, PAL2, PAL4, PAL8,
    RGB8, ARGB8, RGB16, ARGB16, RGB18, RGB24, RGB30, ARGB24,
    YC420, YC422, // Non-interleave
    CRYCBY, CBYCRY, YCRYCB, YCBYCR, YUV444 // Interleave
}CSPACE;*/

typedef enum
{
    PAL1, PAL2, PAL4, PAL8,
    RGB8, ARGB8, ARGB8888, RGB16, ARGB16, RGB18, RGB24, RGB30, ARGB24, ARGB25, 
    YC420, YC422, YC444,// Non-interleave
    CRYCBY, CBYCRY, YCRYCB, YCBYCR, YUV444, // Interleave
    RGBA16, RGBX24, RGBA24
} CSPACE;


#define false FALSE


//DPHY Version
#define DPHY_65n    65
#define DPHY_45n    45

//DSI Version
#define DSIM_1_00    1
#define DSIM_1_02    2

//H/W Configuration
#define MIPI_FIN                    24000000            // MIPI Clock
#define DPHY_Version                DPHY_45n
#define DSIM_Version                DSIM_1_02    
#if ( DSIM_Version == DSIM_1_00 )
#define DSIM_NoOfInterrupt        27
#elif ( DSIM_Version == DSIM_1_02 )
#define DSIM_NoOfInterrupt        26
#endif

#define DSIM_HEADER_FIFO_SZ        16
#define DSIM_TIMEOUT_MS        	5000

typedef struct {
    volatile DWORD rDSIM_STATUS;        //0x0,        //R        // DSIM Status
    volatile DWORD rDSIM_SWRST;            //0x4,        //R/W    // DSIM Software Reset Register
    volatile DWORD rDSIM_CLKCTRL;         //0x8,        //R/W    // DSIM Clock control register
    volatile DWORD rDSIM_TIMEOUT;         //0xc,       //R/W    // DSIM Time-out Resgister
    volatile DWORD rDSIM_CONFIG;         //0x10,        //R/W    // DSIM Configuration
    volatile DWORD rDSIM_ESCMODE;        //0x14,        //R/W    // DSIM Escape Mode Register
    volatile DWORD rDSIM_MDRESOL;        //0x18,        //R/W    // DSIM Main Display Resolution Register
    volatile DWORD rDSIM_MVPORCH;         //0x1c,        //R/W    // DSIM Main Display Vertical Porch Register
    volatile DWORD rDSIM_MHPORCH;         //0x20,        //R/W    // DSIM Main Display Horizontal Porch Register
    volatile DWORD rDSIM_MSYNC;         //0x24,        //R/W    // DSIM Main Display Sync area Register
    volatile DWORD rDSIM_SDRESOL;        //0x28,        //R/W    // DSIM Sub Display Image Resolution Register
    volatile DWORD rDSIM_INTSRC;             //0x2c,        //R/W    // DSIM Interrupt Source Register
    volatile DWORD rDSIM_INTMASK;        //0x30,        //R/W    // DSIM Interrupt Mask Register
    volatile DWORD rDSIM_PKTHDR;        //0x34,        //W    // DSIM Packet header FIFO Register
    volatile DWORD rDSIM_PAYLOAD;        //0x38,        //W    // DSIM Payload FIFO Register
    volatile DWORD rDSIM_RXFIFO;             //0x3c,        //R        // DSIM Read FIFO Register
    volatile DWORD rDSIM_FIFOTHLD;        //HIDDEN    //0x40    //R/W    // Reserved    //not used this function                                        
    volatile DWORD rDSIM_FIFOCTRL;        //0x44,        //R/W    // DSIM FIFO Status & Control Register
    volatile DWORD rDSIM_MEMACCHR;    //0x48,        //R/W    // DSIM FIFO Memory AC Characteristic Register
    volatile DWORD rDSIM_PLLCTRL;        //0x4c,        //R/W    // DSIM PLL Contorl Register
    volatile DWORD rDSIM_PLLTMR;        //0x50,        //R/W    // DSIM PLL Timer Register
    volatile DWORD rDSIM_PHYACCHR;     //0x54,        //R/W    // DSIM D-PHY AC Characteristic Register
    volatile DWORD rDSIM_PHYACCHR1;    //0x58,        //R/W    // DSIM D-PHY AC Characteristic Register 1
}DSIM_SFR;

typedef enum
{
    Lane_Clock = 0,    
    Lane_Data0 = (1 << 0),
    Lane_Data1 = (1 << 1),
    Lane_Data2 = (1 << 2),
    Lane_Data3 = (1 << 3),
    Lane_DataAll = (0xf),
    Lane_All = 0x10,
}DSIM_LANE;

typedef enum
{
    LaneState_HsReady,
    LaneState_ULPS,
    LaneState_Stop,    
    LaneState_LPDT,
}DSIM_LaneState;

typedef enum 
{
    DSIM_FuncRst     = (1 << 16),            //Function Register Reset 
    DSIM_SwRst     = (1 << 0),    
}DSIM_Rst;

typedef enum {
    DataLane_1=0,
    DataLane_2=1,            
    DataLane_3=2,
    DataLane_4=3
}DSIM_NoOfDataLane;

typedef enum {
    VirtualCh_0=0,
    VirtualCh_1=1,
    VirtualCh_2=2,
    VirtualCh_3=3
}DSIM_VirtualChNo;

typedef enum 
{
    DSIM_Command = 0,         // I80 I/F
    DSIM_Video = 1,            // RGB I/F    
}DSIM_InterfaceType;

typedef enum
{
    DSIM_ByteClkSrc_DPhy = 0x0,
    DSIM_ByteClkSrc_ExtCLK_Divided_By4 = 0x1,
    DSIM_ByteClkSrc_ExtCLK = 0x2,
}DSIM_ByteClkSrc;

typedef enum {
    DSIM_I80_3BPP = 0,
    DSIM_I80_8BPP = 1,
    DSIM_I80_12BPP = 2,
    DSIM_I80_16BPP = 3,
    DSIM_16BPP_565 = 4,
    DSIM_18BPP_666PACKED = 5,
    DSIM_18BPP_666LOOSELYPACKED = 6,
    DSIM_24BPP_888 = 7
}DSIM_PixerFormat;

typedef enum{
    Transfer_ByCPU = (1 << 7),
    Transfer_ByLCDC = (1 << 6),
    Transfer_ByBoth = (0x3 << 6),
}DSIM_Transfer;

typedef enum{
    ULPS_Exit,
    ULPS_Entry
}DSIM_UlpsReques;

typedef enum{
    AllofIntr = 0xffffffff,
    PllStable = (1 << 31),
    SwRstRelease = (1 << 30),
    SFRFifoEmpty = (1 << 29), 
    #if (DSIM_Version == DSIM_1_00)
    SYNCOverride = (1 << 28),                //r03 - V210. it is removed what has r11
    #endif
    BusTunrOver = (1 << 25),
    FrameDone = (1 << 24),
    LPDRTimeOut = (1 << 21),
    BTAAckTimeOut = (1 << 20),
    RxDatDone = (1 << 18),
    RxTE = (1 << 17),
    RxAck = (1 << 16),
    ErrRxECC = (1 << 15),
    ErrRxCRC = (1 << 14),    
    ErrEscLane3 = (1 << 13),             //4th Data Lane : not be cofiguration
    ErrEscLane2 = (1 << 12),
    ErrEscLane1 = (1 << 11), 
    ErrEscLane0 = (1 << 10),    
    ErrSync3 = (1 << 9),                 //4th Data Lane : not be cofiguration
    ErrSync2 = (1 << 8),
    ErrSync1 = (1 << 7),
    ErrSync0 = (1 << 6),    
    ErrControl3 = (1 << 5),            //4th Data Lane : not be cofiguration
    ErrControl2 = (1 << 4),
    ErrControl1 = (1 << 3),
    ErrControl0 = (1 << 2),
    ErrContentLP0 = (1 << 1),
    ErrContnetLP1 = (1 << 0),    
}DSIM_IntSrc;

typedef enum{
    DSIM_RxFifo = (1 << 4),
    DSIM_TxSFRFifo = (1 << 3),
    DSIM_I80Fifo = (1 << 2),
    DSIM_SubDispFifo = (1 << 1),
    DSIM_MainDispFifo = (1 << 0),
}DSIM_Fifo;

typedef enum{
    DSIM_RxDataFull = (1 << 25),
    DSIM_RxDataEmpty = (1 << 24),
    SFRHeaderFull = (1 << 23),
    SFRHeaderEmpty = (1 << 22),
    SFRPayLoadFull = (1 << 21),
    SFRPayLoadEmpty = (1 << 20),
    I80HeaderFull = (1 << 19),
    I80HeaderEmpty = (1 << 18),
    I80PayLoadFull = (1 << 17),
    I80PayLoadEmpty = (1 << 16),
    SubDispHeaderFull = (1 << 15),
    SubDispHeaderEmpty = (1 << 14),
    SubDispPayLoadFull = (1 << 13),
    SubDispPayLoadEmpty = (1 << 12),
    MainDispHeaderFull = (1 << 11),
    MainDispHeaderEmpty = (1 << 10),
    MainDispPayLoadFull = (1 << 9),
    MainDispPayLoadEmpty = (1 << 8),
}DSIM_FifoState;

typedef enum {
    DSIM_NonBurstSyncEvent = 0x0,
    DSIM_NonBurstSyncPulse = 0x2,    
    DSIM_Burst = 0x3,
} DSIM_VideoModeType;
/////////////////////////////////////////////////
//From DSI Spec
#define RespCmd        (0x1 << 6)
#define ReadCmd        (0x1 << 7)

typedef struct 
{
    BYTE id;
     union 
    {
        WORD word_count;
        WORD err_flag;
         struct 
        {
            BYTE data0;
            BYTE data1;
        }data;
    } _inter;
    BYTE ecc;
}DSIM_Header;
typedef DSIM_Header    DSIM_ShortPktHeader;        

typedef enum
{
    //Packet Types for Command
    //Short Packet Type    
    GenShortWrNoPara    = 0x03,
    GenShortWr1Para        = 0x13,
    GenShortWr2Para        = 0x23,
    GenRdNoPara        = 0x04,
    GenRd1Para            = 0x14,
    GenRd2Para            = 0x24,
    DCSWrNoPara        = 0x05,
    DCSWr1para            = 0x15 ,
    DCSRdNoPara         = 0x06,
    SetMaxRtnPktsize        = 0x37,
    //Long Packet Type
    NullPkt                = 0x09,
    BlankingPkt            = 0x19,
    GenLongWr            = 0x29,
    DCSLongWr            = 0x39,

    //Generic Command
    //Short 
    CMOff                = 0x02,
    CMOn                = 0x12,
    ShutDown            = 0x22,
    TurnOn                = 0x32,    

    //Packet Types for Video Data - for test Data tranfer through Bus
    //Short
    VSyncStart            = 0x01,
    VSyncEnd            = 0x11,
    HSyncStart            = 0x21,
    HSyncEnd            = 0x31,
    EotPkt                = 0x08,
    //Long Packet Type
    RGB565Packed        = 0x0e,
    RGB666Packed        = 0x1e,
    RGB666Loosly        = 0x2e,
    RGB888Packed        = 0x3e,
}DSIM_DataID;

typedef enum
{
    Ack = 0x02,
    EoTp = 0x08,
    GenShort1B = 0x11,
    GenShort2B = 0x12,
    GenLong = 0x1a,
    DcsLong = 0x1c,
    DcsShort1B = 0x21,
    DcsShort2B = 0x22,
}DSIM_Response;

typedef enum
{
    Sot = (1 << 0),
    SotTSync = (1 << 1),
    EotSync = (1 << 2),
    ESCEntry = (1 << 3),
    LPTSync = (1 << 4),
    HSTimeout = (1 << 5),
    FalseControl = (1 << 6),
    //Reserved = (1 << 7),
    EccSingle = (1 << 8),
    EccMulti = (1 << 9),
    CheckSum = (1 << 10),
    DataType = (1 << 11),
    VC = (1 << 12),
    Length = (1 << 13),
    //Reserved = (1 << 14),
    Protocol = (1 << 15)
}DSIM_Error;    

//---------------------------------------------------------------------------------------------------------
//(DWORD width,DWORD height,FORMAT_t format,VIRTUAL_CHANNEL_t channel,DSIM_IF_TYPE mode,VIDEO_BURSTMODE_t burstMode, DSIM_VCNT_MODE vcntmode, NUMBER_OF_DATALANE datalane);

typedef enum {
    DSIM_State_Init = 0,
    DSIM_State_Stop = 1,
    DSIM_State_HSDT = 2,
    DSIM_State_ULPS = 3,
    DSIM_State_BTA = 4,    
    DSIM_State_LPDT = 5,
    //DSIM_State_LPDTCpu = (1 << 5),
    //DSIM_State_LPDTLcdC = (1 << 6),        
}DSIM_State;

//From DDI Spec for LCD Contorller 
//Polarity Reference is AP LCD Controller
//Some ddi has inverted polarity. 
typedef struct 
{
    //for LCDC Configuration
    //Resolution
    DWORD m_00uHoriSize;
    DWORD m_01uVertiSize;
    CSPACE    m_02eBgBpp;                        //LCDC Format            
    //for RGB Interface///////    
    // VPorch 
    WORD m_03usVBack;        
    WORD m_04usVFront;     
    // HPorch
    WORD m_05usHBack;                    
    WORD m_06usHFront;     
    // Sync Area
    WORD m_07usVertiSync;
    WORD m_08usHoriSync;        
    //VClk polarity
    BYTE m_09bVclkPolarity;
    BYTE m_10bHSyncPolarity;
    BYTE m_11bVSyncPolarity;
    BYTE m_12bVideoDataEnPolarity;
    // Frame Rate
    DWORD m_13uFrameRate;
    //for I80 Interface Type/////        
    //DSI Interface ///////////////////////////////////////////////////////
    //for DSI Configuration
    DSIM_InterfaceType    m_40eInterface;
    DSIM_PixerFormat    m_41ePixel;                    //Interface Format        
    DSIM_VirtualChNo    m_42eCh;                    //Virtual Channel Number
    DSIM_VideoModeType m_43eVideoModeType;                    
    WORD m_44usCmdAllowLen;                    
    //////////////////////////////////////////////////////////////////////    
}DDI_Configuration;

typedef struct
{
    #if ( DSIM_Version == DSIM_1_02)
    BYTE m_ucDSIM_Version;                        //EOT Packet Genration 
    #elif ( DSIM_Version == DSIM_1_00) 
    BYTE m_ucPacketThreshold;                    //Tx Packet Fifo Threshold Enable
    WORD m_usThresholdLevel;
    #endif    
    //Porch Option
    BYTE m_ucAutoVerticalCnt;                    //Auto Vertical Cnt Mode
    BYTE m_ucHSE;                                //Horizontal Sync Evnet Mode
    BYTE m_ucHFP;                                //Discard Horizontal Front Porch Time
    BYTE m_ucHBP;                                //Discard Horizontal Back Porch Time
    BYTE m_ucHSA;                                //Discard Horizontal Sync Area Timing    
    //Data Lane      
    DSIM_NoOfDataLane  m_eNoDataLane;        //Number of Data Lane using DSI Master
    //Pll
    BYTE m_bPllBypass;
    //Pll PMS Value
    BYTE m_ucP;
    WORD m_usM;
    BYTE m_ucS;
    // Pll Stable Time
    DWORD m_uPllStableTime;
    //Byte clock and Escape Clcoke
    DSIM_ByteClkSrc m_eByteclk;
    double m_dEscClk;
    //BTA Sequence
    WORD m_usAutoBTACnt;
    BYTE m_ucBTATimeOut;
    WORD m_usRxTimeOut;
    #if (DPHY_Version == DPHY_45n)            //for 45n Phy
    DWORD m_uPhyTunnig1;
    #endif

    //ISR Priority
    DSIM_IntSrc m_eIsrPriority[DSIM_NoOfInterrupt];
}DSIM_Configuration;

typedef struct _DSIM_Infor
{
    DSIM_SFR* m_pBaseAddr;
    
    DDI_Configuration* m_pMainDispConfiguration;        //Main Display DDI Configuration
    DWORD m_uMainDispFrameAddr;                        //Main Display Frame Address
    
    DDI_Configuration* m_pSubDispConfiguration;        //Sub Display DDI Configuration
    DWORD m_uSubDispFrameAddr;                        //Sub Display Frame Address
    
    DSIM_Configuration* m_oDSIConfiguration;
    DSIM_LANE    m_eDataLane;
        
    double m_dHSClk;                                //Maximum Clock of High Speed Mode
    double m_dByteClk;                                //Byte Clcok
    BYTE m_ucFreqBand;                                //Frequency Band indicator by PLL Clock
    //State 
    DSIM_State m_eState;
    BYTE m_ucPadding3[2];                                //Padding bits. not used
    // Rx Fifo 
    DSIM_ShortPktHeader m_oHeaderFifo[DSIM_HEADER_FIFO_SZ];
    char m_HeaderFifoIndex[DSIM_HEADER_FIFO_SZ];
    // ISR    
    void (*m_fnCallback[32])(DWORD);    // callback function pointer - for generate transfer completed signal
    DWORD m_uCallbackVar[32];            // callback function parameter
    BYTE m_bSetState[32];                // bit for state using interrupt
}DSIM_Infor;

//---------------------------------------------------------------------------------------------------------------------
DSIM_Infor* DSIM_Create(DSIM_Configuration, DDI_Configuration*, MIPIDSI_REG*, DDI_Configuration*, BYTE);
void DSIM_Destory(DSIM_Infor* pInfor);

DSIM_Configuration DSIM_DefaultLinkAndPhy(void);
/*---------------------------------- APIs of Status -----------------------------*/
BYTE DSIM_InitLink(DSIM_Infor* pInfor);
BYTE DSIM_SetLPDT(DSIM_Infor* pInfor);
BYTE DSIM_SetULPS(DSIM_Infor* pInfor);
BYTE DSIM_SetHSDT(DSIM_Infor* pInfor);
BYTE DSIM_SetBTA(DSIM_Infor* pInfor);
BYTE DSIM_SetStopState(DSIM_Infor* pInfor);
/*---------------------------------- APIs of DSI Command Transfer ---------------*/
void DSIM_Power(DSIM_Infor* pInfor, BYTE ucEn);
BYTE DSIM_SetClock(DSIM_Infor* pInfor, BYTE ucEn);
/*---------------------------------- APIs of DSI Command Transfer ---------------*/
void DSIM_CpuTransferMode(DSIM_Infor*, BYTE bMode);
BYTE DSIM_WrData(DSIM_Infor*, DSIM_DataID, DWORD, DWORD);
BYTE DSIM_ProcessResponse(DSIM_Infor*, DSIM_DataID eId);
/*---------------------------------- Header Parser of DSI Rx Data -----------------*/
DWORD DSIM_PopRxPayload(DSIM_ShortPktHeader*,BYTE* ,DWORD);
DSIM_Response DSIM_GetRxHeaderType(DSIM_ShortPktHeader *);
DWORD DSIM_GetRxPayloadDataSize(DSIM_ShortPktHeader *);
void DSIM_ShowResponseFlagInfo(DSIM_ShortPktHeader *);
DSIM_Error DSIM_GetErrorReportInPacket(DSIM_ShortPktHeader *pHead);
void DSIM_ShowErrorReportInPacket(DSIM_ShortPktHeader *);
/*---------------------------------- Fifo Apis of DSI Rx Data ----------------------*/
DWORD DSIM_PopRxHeader(DSIM_Infor*, DSIM_ShortPktHeader *pHead);
BYTE DSIM_PushHD(DSIM_Infor* pInfor, DSIM_ShortPktHeader *pHead);
BYTE DSIM_PopHD(DSIM_Infor* pInfor, DSIM_ShortPktHeader *pHead);
BYTE DSIM_InitHeaderFifo(DSIM_Infor* pInfor);
BYTE DSIM_IsHeaderFifoEmpty(DSIM_Infor* pInfor);
/*-------------------------- Basic APIs of DSIM Interrupt ------------------------*/
void DSIM_EnIntr(DSIM_Infor* pInfor, BYTE ucEn);
void DSIM_SetIsrCallBack(DSIM_Infor* pInfor, DSIM_IntSrc eIntSrc, void (*fnCallBack)(DWORD), DWORD CallbackVar);    
/*---------------------------------- APIs of DSIM State---------------------------------*/
BYTE DSIM_IsState(DSIM_IntSrc eIntSrc);
BYTE DSIM_WaitState(DSIM_IntSrc  eIntSrc);
/*---------------------------------- APIs of DSIM_STATUS ------------------------*/
BYTE DSIM_IsPllStable(void);
BYTE DSIM_IsSwRstRelease(void);
BYTE DSIM_IsDirection(void);
DSIM_LaneState DSIM_IsLaneState(DSIM_LANE eLane);
/*---------------------------------- APIs of DSIM_SWRST -------------------------*/
void DSIM_SWReset(DSIM_Rst eRst);
/*---------------------------------- APIs of DSIM_CLKCTRL ------------------------*/
void DSIM_EnHSClk(BYTE bEn);
void DSIM_SetEscClkPrs(BYTE bEn, DWORD usPrsVal);
void DSIM_EnEscClkPrs(BYTE bEn);
void DSIM_SetEscClkPrsVal(WORD usPrsVal);
void DSIM_EnPllBypass(BYTE bEn);
void DSIM_SetByteClockSrc(DSIM_ByteClkSrc eSrc);
void DSIM_EnByteClock(BYTE bEn);
void DSIM_EnEscClkOnLane(DSIM_LANE eLaneSel, BYTE ucEn);
/*---------------------------------- APIs of DSIM_TIMEOUT-------------------------*/
void DSIM_SetBTATimeOut(BYTE ucTimeOut);
void DSIM_SetLPDRTimeOut(WORD usTimeOut);
/*---------------------------------- APIs of DSIM_CONFIG--------------------------*/
void DSIM_InitConfiguration(DDI_Configuration* pMainDispConf, DDI_Configuration* pSubDispConf, DSIM_Configuration* oConfiguration);
void DSIM_EnLane(DSIM_LANE eLane, BYTE ucEn);
/*---------------------------------- APIs of DSIM_ESCMODE---------------------------------*/
void DSIM_SetStopStateCounter(WORD uCntVal);
void DSIM_ForceDPhyStopState(BYTE ucEn);
void DSIM_ForceBTA(void);
void DSIM_SetDataMode(DSIM_Transfer eData,DSIM_State eState);
void DSIM_ResetTrigger(void);
void DSIM_ULPSRequest(DSIM_UlpsReques ucRequest, BYTE ucBitSet);
/*---------------------------------- APIs of DSIM_MDRESOL---------------------------------*/
void DSIM_SetMainDispResolution(DWORD usVertiResol, DWORD usHorResol);
/*---------------------------------- APIs of DSIM_MVPORCH---------------------------------*/
void DSIM_SetMainDispVPorch(WORD usCmdAllow, WORD usFront, WORD usBack);
/*---------------------------------- APIs of DSIM_MHPORCH---------------------------------*/
void DSIM_SetMainDispHPorch(WORD usFront, WORD usBack);
void DSIM_SetMainDispSyncArea(WORD usVerti, WORD usHori);
/*---------------------------------- APIs of DSIM_SDRESOL---------------------------------*/
void DSIM_SetSubDispResolution(DWORD usVerti, DWORD usHori);
/*---------------------------------- APIs of DSIM_INTSRC---------------------------------*/
DSIM_IntSrc DSIM_GetIntrState(void);
void DSIM_ClrIntr(DSIM_IntSrc eIntSrc);
BYTE DSIM_WaitState(DSIM_IntSrc  eIntSrc);
/*---------------------------------- APIs of DSIM_INTMSK---------------------------------*/
void DSIM_SetIntrMask(DSIM_IntSrc eIntSel, BYTE ucMask);
DWORD DSIM_GetIntrMask(void);
/*---------------------------------- APIs of DSIM_PKTHDR---------------------------------*/
void DSIM_WrTxHeader( BYTE ucDI, BYTE ucDat0,BYTE ucDat1);
/*---------------------------------- APIs of DSIM_PAYLOAD---------------------------------*/
void DSIM_WrTxData(DWORD uTxData);
/*---------------------------------- APIs of DSIM_RXFIFO---------------------------------*/
DWORD DSIM_RdRxData(void);
/*---------------------------------- Hidden SFR--------------------------------------------*/
/*---------------------------------- APIs of DSIM_FIFOTHLD---------------------------------*/
void DSIM_FIFOThreshold(WORD usThresholdLevel);
/*---------------------------------- Hidden SFR--------------------------------------------*/
/*---------------------------------- APIs of DSIM_FIFOTHLD---------------------------------*/
DSIM_FifoState DSIM_GetFifoState(void);
void DSIM_InitFifoPointer(DSIM_Fifo eFifo);
/*---------------------------------- Hidden SFR--------------------------------------------*/
/*---------------------------------- APIs of DSIM_MEMACCHR-------------------------------*/
void DSIM_MemControl(DSIM_Fifo eFifo);
/*---------------------------------- APIs of DSIM_PLLCTRL-------------------------------*/
void DSIM_PllFreqBand(BYTE ucFreqBand);
void DSIM_EnPll(BYTE ucEn);
void DSIM_SetPllPMS(BYTE ucPredivider, WORD ucMaindivider, BYTE ucScaler);
#if (DSIM_Version == DSIM_1_00)
void DSIM_SwapDpDn(BYTE ucSwapEn);
#endif
/*---------------------------------- APIs of DSIM_PLLTMR-------------------------------*/
void DSIM_PllStatbleTime(DWORD uLockTime);
#ifndef S5PV210
/*---------------------------------- APIs of DSIM_PHYACCHR-------------------------------*/
void DSIM_SetPhyTunning(DWORD uTunnigValue);
void DSIM_EnAFC(BYTE ucEn, BYTE ucAFCCode);

/*---------------------------------- APIs of DSIM_PHYACCHR1------------------------------*/
void DSIM_DpDnSwap(DSIM_LANE eLane, BYTE ucSwapEn);
#endif

#endif
