#ifndef __DCS_H_
#define __DCS_H_

#include "dsim.h"

typedef enum 
{
    NOP = 0x0,
    SOFT_RESET=0x01,    

    ENTER_SLEEP        = 0x10,
    ENTER_PARTIAL    = 0x12,
    ENTER_NORMAL    = 0x13,
    ENTER_INVERT    = 0x21,
    ENTER_IDLE        = 0x39,

    EXIT_SLEEP        = 0x11,
    EXIT_INVERT        = 0x20,
    EXIT_IDLE        = 0x38,    
    
    GET_RED_CHANNEL        = 0x06,
    GET_GREEN_CHANNEL        = 0x07,
    GET_BLUE_CHANNEL        = 0x08,
    
    GET_POWER_MODE        = 0x0A,
    GET_ADDRESS_MODE        = 0x0B,
    GET_PIXEL_FORMAT        = 0x0C,
    GET_DISPLAY_MODE        = 0x0D,
    GET_SIGNAL_MODE        = 0x0E,
    GET_DIAGNOSTIC_RESULT    = 0x0F,
    
    GET_SCANLINE            = 0x45,    
    
    READ_DDB_CONTINUE=0xa8,
    READ_DDB_START=0xa1,
    READ_MEMORY_CONTINUE=0x3e,
    READ_MEMORY_START=0x2e,
    
    SET_ADDRESS_MODE=0x36,
    SET_COLUMN_ADDRESS=0x2a,
    SET_DISPLAY_OFF=0x28,
    SET_DISPLAY_ON=0x29,
    SET_GAMMA_CURVE=0x26,
    SET_PAGE_ADDRESS=0x2b,
    SET_PARTIAL_AREA=0x30,
    SET_PIXEL_FORMAT=0x3a,
    SET_SCROLL_AREA=0x33,
    SET_SCROLL_START=0x37,
    SET_TEAR_OFF=0x34,
    SET_TEAR_ON=0x35,
    SET_TEAR_SCANLINE=0x44,
    
    WRITE_LUT=0x2d,
    WRITE_MEMORY_CONTINUE=0x3c,
    WRITE_MEMORY_START=0x2c,        
}DCS_CmdSet;

/* types */
typedef enum {
    GAMMA_NONE = 0x0,
    GAMMA_CURVE1 = 0x1,
    GAMMA_CURVE2 = 0x2,
    GAMMA_CURVE3 = 0x4,
    GAMMA_CURVE4 = 0x8,
}GAMMA_CURVE_t;

typedef struct {
    BYTE bGot;
    BYTE value;
}REG_BUFFER;

typedef struct {
    REG_BUFFER diagnosticResult;
    REG_BUFFER addressMode;
    REG_BUFFER  displayMode;
    REG_BUFFER  powerMode;
    REG_BUFFER  signalMode;
} _INT_DATA_t;    

typedef struct
{
    /* member variables */
    _INT_DATA_t m_data;
    DSIM_Infor* m_pDsiProtocol;

    DSIM_ShortPktHeader m_oHeader;            //Temporary Space to Return Header data
}DCS_Infor;

/* methods */
DCS_Infor* DCS_Create(DSIM_Infor* pDSI);
void DCS_Destory(DCS_Infor* pInfor);


BYTE DCS_EnterIdle(DCS_Infor*);
BYTE DCS_EnterInvertMode(DCS_Infor*);
BYTE DCS_EnterNormalMode(DCS_Infor*);
BYTE DCS_EnterPartialMode(DCS_Infor*);
BYTE DCS_EnterSleepMode(DCS_Infor*);        // TODO : make sure TE output low
BYTE DCS_ExitIdleMode(DCS_Infor*);
BYTE DCS_ExitInvertMode(DCS_Infor* pInfor);
BYTE DCS_ExitSleepMode(DCS_Infor* pInfor);

BYTE DCS_GetAddressMode(DCS_Infor*, BYTE*);
BYTE DCS_GetBlueChannel(DCS_Infor* pInfor);
BYTE DCS_GetDisanosticResult(DCS_Infor* , BYTE*);
BYTE DCS_GetDisplayMode(DCS_Infor*, BYTE*);
BYTE DCS_GetGreenChannel(DCS_Infor*);
BYTE DCS_GetPixelFormat(DCS_Infor*, DSIM_PixerFormat*);
BYTE DCS_GetPowerMode(DCS_Infor*, BYTE*);
BYTE DCS_GetRedChannel(DCS_Infor*);
BYTE DCS_GetScanLine(DCS_Infor*, DWORD*);
BYTE DCS_GetSignalMode(DCS_Infor* , BYTE*);

BYTE DCS_Nop(DCS_Infor*);

BYTE DCS_ReadDDBStart(DCS_Infor* pInfor, BYTE* pBuf,DWORD bufSize,DWORD* pnRead);
BYTE DCS_ReadDDBContinue(DCS_Infor* pInfor,  BYTE* pBuf,DWORD bufSize,DWORD* pnRead);
BYTE DCS_DCS_ReadMemoryStart(DCS_Infor* pInfor, BYTE* pBuf,DWORD bufSize,DWORD* pnRead);
BYTE DCS_DCS_ReadMemoryContinue(DCS_Infor* pInfor, BYTE* pBuf,DWORD bufSize,DWORD* pnRead);

BYTE DCS_ReadDCSRegister(DCS_Infor* pInfor, BYTE cmd,BYTE *pBuf,DWORD nBufsize,DWORD* pRead);

BYTE DCS_SetAddressMode(DCS_Infor* pInfor, BYTE mode);
BYTE DCS_SetColumnAddress(DCS_Infor* pInfor, WORD sc,WORD ec);
BYTE DCS_SetDisplayOff(DCS_Infor* pInfor);
BYTE DCS_SetDisplayOn(DCS_Infor* pInfor);
BYTE DCS_SetGammaCurve(DCS_Infor* pInfor, GAMMA_CURVE_t curve);
BYTE DCS_SetPageAddress(DCS_Infor* pInfor, WORD startPage,WORD endPage);
BYTE DCS_SetPartialArea(DCS_Infor* pInfor, WORD startRow,WORD endRow);
BYTE DCS_SetPixelFormat(DCS_Infor* pInfor, BYTE format);
BYTE DCS_SetScrollArea(
    DCS_Infor* pInfor, 
    WORD top_fixed_area_lines,
    WORD vertical_scrolling_area_lines,
    WORD bottom_fixed_area_lines);
BYTE DCS_SetScrollStart(DCS_Infor* pInfor, WORD vertical_scroll_pointer);
BYTE DCS_SetTearOff(DCS_Infor* pInfor);
BYTE DCS_SetTearOn(DCS_Infor* pInfor, BYTE bothBlanking);
BYTE DCS_SetTearScanline(DCS_Infor* pInfor, WORD line);
BYTE DCS_SoftReset(DCS_Infor* pInfor);

BYTE DCS_WriteLUT(DCS_Infor* pInfor, BYTE* pBuf,DWORD size);
BYTE DCS_WriteMemoryContinue(DCS_Infor* pInfor, BYTE* pBuf,DWORD size);
BYTE DCS_WriteMemoryStart(DCS_Infor* pInfor, BYTE* pBuf,DWORD size);        


    
//Private Function
BYTE DCS_WriteLongPacketWithDCSCommand(DCS_Infor* pInfor, DCS_CmdSet cmd,BYTE* pDat,DWORD size);
BYTE _ReadLongPacketWithDCSCommand(DCS_Infor* pInfor, DCS_CmdSet cmd,BYTE* pDat,DWORD size,DWORD* pnRead);


#endif

