//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    dsi_init.c

Abstract:       Libray to control DSIM

Functions:


Notes:


--*/

#include <windows.h>
#include <bsp_cfg.h>
#include <register_map.h>

#include "dsi_init.h"
#include "dcs.h"
#include "dsim.h"


void Delay(DWORD count)
{
    volatile int i, j = 0;
    volatile static int loop = 15000; //  I think 15000 is optimaized value.. but not tested.

    for(; count > 0; count--)
    {
        for(i=0; i < loop; i++)
        {
            j++;
        }
    }
}

void DSI_Get_DeviceInfo(tDevInfo *pDeviceInfo)
{
    DDI_Configuration* pConfigInfo = DDI_GetConfiguration();
    pDeviceInfo->RGBINFO.uiWidth = pConfigInfo->m_00uHoriSize;
    pDeviceInfo->RGBINFO.uiHeight = pConfigInfo->m_01uVertiSize;
    pDeviceInfo->RGBINFO.VBPD_Value = pConfigInfo->m_03usVBack;
    pDeviceInfo->RGBINFO.VFPD_Value = pConfigInfo->m_04usVFront;
    pDeviceInfo->RGBINFO.VSPW_Value = pConfigInfo->m_07usVertiSync;
    pDeviceInfo->RGBINFO.HBPD_Value = pConfigInfo->m_05usHBack;
    pDeviceInfo->RGBINFO.HFPD_Value = pConfigInfo->m_06usHFront;
    pDeviceInfo->RGBINFO.HSPW_Value = pConfigInfo->m_08usHoriSync;
    pDeviceInfo->RGBINFO.VCLK_Polarity = pConfigInfo->m_09bVclkPolarity << 7;
    pDeviceInfo->RGBINFO.HSYNC_Polarity = pConfigInfo->m_10bHSyncPolarity << 6;
    pDeviceInfo->RGBINFO.VSYNC_Polarity = pConfigInfo->m_11bVSyncPolarity << 5;
    pDeviceInfo->RGBINFO.VDEN_Polarity = pConfigInfo->m_12bVideoDataEnPolarity << 4;
    pDeviceInfo->RGBINFO.Frame_Rate = pConfigInfo->m_13uFrameRate;
}

void DSI_initialize_LCD_module(void *pMIPIDSIReg)
{
    BYTE bPass = 0;
    DDI_Configuration* pMainDisp = DDI_GetConfiguration();
    DSIM_Infor* pDSIInfor = DSIM_Create(DSIM_DefaultLinkAndPhy(), pMainDisp, (MIPIDSI_REG *)pMIPIDSIReg, NULL, FALSE);
    DCS_Infor* pDCSInfor = DCS_Create(pDSIInfor);
    DDI_Infor* pDDIInfor = DDI_Create((DWORD)pDSIInfor,(DWORD)pDCSInfor,0, 0);

    DSIM_InitLink(pDSIInfor);
    DSIM_SetHSDT(pDSIInfor);
    DSIM_CpuTransferMode((DSIM_Infor *)pDSIInfor, (BYTE)0);
    DDI_Init(pDDIInfor);
}

