#include <windows.h>
#include <bsp.h>
//#include <bsp_cfg.h>
#include <register_map.h>

#include "dcs.h"
#include "dsi_init.h"

/*------------------------------------ macros for dcs.c----------------------------------------*/
#define SIMPLE_ARG1(x,a)    return DSIM_WrData(pInfor->m_pDsiProtocol, DCSWr1para,(x),(a))
#define SIMPLE_OP_LONG(size)        return DSIM_WrData(pInfor->m_pDsiProtocol, DCSLongWr,(DWORD)((BYTE*)dataToSend),(size))

#define HI_BYTE(x)        ((x&0xFF00)>>8)
#define LO_BYTE(x)        ((x)&0xFF)
#define BITBYTE(b7,b6,b5,b4,b3,b2,b1,b0)    ( (b7)<<7 | (b6)<<6 | (b5)<<5 | (b4)<<4 | (b3)<<3 | (b2)<<2 | (b1)<<1 | (b0) )

#define MIPI_MSG(x) DBGMSG(DISP_USR3,x);

//static DCS_Infor* g_pInfor;

//To Build in Eboot
BYTE pInfor_mem2[sizeof(DCS_Infor)];

/*---------------------------------- APIs of ------------------------*/


//////////
// Function Name : DCS_Create
// Function Description :
//   This function creates Display Command Set(DCS) information structure
// Input :     DSIM_Infor* : Information structure of Display Serial Interface(DSI) Driver.
// Output : DCS_Infor* : Information structure of DCS Driver
// Version : v0.0
DCS_Infor* DCS_Create(DSIM_Infor* pDSI)
{
    if ( pDSI != NULL)
    {
        //DCS_Infor* pInfor = (DCS_Infor*) malloc(sizeof(DCS_Infor));
        DCS_Infor* pInfor = (DCS_Infor*)pInfor_mem2;
        memset(pInfor,0,sizeof(DCS_Infor));

        pInfor->m_pDsiProtocol = pDSI;
        return pInfor;
    }
    else
    {
        MIPI_MSG((_T("DSI Device Driver is not created!!\n")));
        return FALSE;
    }
}

//////////
// Function Name : DCS_Destory
// Function Description :
//   This function destroys Display Command Set(DCS) information structure
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : None
// Version : v0.0
void DCS_Destory(DCS_Infor* pInfor)
{
    if( pInfor != NULL)
    {

        memset(pInfor,0,sizeof(DCS_Infor));

        //free(pInfor);
    }
}

/*---------------------------------- APIs of ------------------------*/
//////////
// Function Name : DCS_EnterIdle
// Function Description :
//   This function write Enter Idle on DCS.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_EnterIdle(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,ENTER_IDLE,0);
}

//////////
// Function Name : DCS_EnterInvertMode
// Function Description :
//   This function write Enter Inverter mode on DCS.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_EnterInvertMode(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,ENTER_INVERT,0);
}

//////////
// Function Name : DCS_EnterNormalMode
// Function Description :
//   This function write Enter Normal mode on DCS.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_EnterNormalMode(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,ENTER_NORMAL,0);
}

//////////
// Function Name : DCS_EnterPartialMode
// Function Description :
//   This function write Enter Partial mode on DCS.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_EnterPartialMode(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,ENTER_PARTIAL,0);
}


//////////
// Function Name : DCS_EnterSleepMode
// Function Description :
//   This function write Enter Sleep mode on DCS.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_EnterSleepMode(DCS_Infor* pInfor)
{
    BYTE ucRet = DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,ENTER_SLEEP,0);
    // see DCS spec v01-01-00 563 line
    if (ucRet)
    {
        Delay(60);
        // this value is meaning less anymore. spec 614 line
        // why?
        pInfor->m_data.diagnosticResult.bGot = FALSE;
    }
    return ucRet;
}

//////////
// Function Name : DCS_ExitIdleMode
// Function Description :
//   This function write Exit Sleep mode on DCS.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_ExitIdleMode(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,EXIT_IDLE,0);
}

//////////
// Function Name : DCS_ExitInvertMode
// Function Description :
//   This function write Exit Invert mode on DCS.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_ExitInvertMode(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,EXIT_INVERT,0);
}

//////////
// Function Name : DCS_ExitSleepMode
// Function Description :
//   This function write Exit sleep mode on DCS.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_ExitSleepMode(DCS_Infor* pInfor)
{
    BYTE ucRet=DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,EXIT_SLEEP,0);
    // see DCS spec v01-01-00 610 line
    if (ucRet)
        Delay(600);            //Wait 60ms
    return ucRet;
}

//////////
// Function Name : DCS_ExitSleepMode
// Function Description :
//   This function write Exit sleep mode on DCS.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetAddressMode(DCS_Infor* pInfor, BYTE *pMode)
{
    // Write GET_ADDRESS_MODE
    DSIM_ShortPktHeader header;
    if (DSIM_WrData(pInfor->m_pDsiProtocol, DCSRdNoPara, GET_ADDRESS_MODE,0))
    {
        // check rx fifo stack(?)//
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, &header))
        {
            if (DSIM_GetRxHeaderType(&header) == DcsShort1B)
            {
                pInfor->m_data.addressMode.bGot = TRUE;
                pInfor->m_data.addressMode.value = header._inter.data.data0;
                *pMode = (BYTE)(header._inter.data.data0);
            }
        }
        return TRUE;
    }
    else
        return FALSE;
}

//////////
// Function Name : DCS_GetBlueChannel
// Function Description :
//   This function get blue channel.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetBlueChannel(DCS_Infor* pInfor)
{
    DSIM_ShortPktHeader header;
    BYTE ret =DSIM_WrData(pInfor->m_pDsiProtocol, DCSRdNoPara,GET_BLUE_CHANNEL,0);

    if (ret)
    {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, &header))
        {
            if (DSIM_GetRxHeaderType(&header) == DcsShort1B)
            {
                return header._inter.data.data0;
            }
        }
    }
    return 0;
}

//////////
// Function Name : DCS_GetBlueChannel
// Function Description :
//   This function get blue channel.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetDisanosticResult(DCS_Infor* pInfor, BYTE* pResult)
{
    BYTE ret = DSIM_WrData(pInfor->m_pDsiProtocol, DCSRdNoPara,GET_DIAGNOSTIC_RESULT,0);
    DSIM_ShortPktHeader header;
    if (ret)
    {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol,&header))
        {
            if (DSIM_GetRxHeaderType(&header) == DcsShort1B)
            {
                pInfor->m_data.diagnosticResult.bGot = TRUE;
                pInfor->m_data.diagnosticResult.value = header._inter.data.data0;
                *((BYTE*)pResult) = (BYTE)(header._inter.data.data0);
            }
        }
    }
    return ret;
}


//////////
// Function Name : GetDisplayMode
// Function Description :
//   This function get Display Mode.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetDisplayMode(DCS_Infor* pInfor, BYTE* pMode)
{
    BYTE ret = DSIM_WrData(pInfor->m_pDsiProtocol,DCSRdNoPara,GET_DISPLAY_MODE,0);
    DSIM_ShortPktHeader header;
    if (ret) {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, &header)) {
            if (DSIM_GetRxHeaderType(&header) == DcsShort1B) {
                pInfor->m_data.displayMode.bGot = TRUE;
                pInfor->m_data.displayMode.value = header._inter.data.data0;
                *pMode = (BYTE)(header._inter.data.data0);
            }
        }
    }
    return ret;
}

//////////
// Function Name : GetGreenChannel
// Function Description :
//   This function get Display Mode.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetGreenChannel(DCS_Infor* pInfor)
{
    BYTE ret = DSIM_WrData(pInfor->m_pDsiProtocol,DCSRdNoPara,GET_GREEN_CHANNEL,0);
    DSIM_ShortPktHeader header;
    if (ret) {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, &header)) {
            if (DSIM_GetRxHeaderType(&header) == DcsShort1B) {
                return header._inter.data.data0;
            }
        }
    }
    return 0;
}

//////////
// Function Name : GetGreenChannel
// Function Description :
//   This function get Display Mode.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetPixelFormat(DCS_Infor* pInfor, DSIM_PixerFormat *pFmt)
{
    BYTE ret = DSIM_WrData(pInfor->m_pDsiProtocol,DCSRdNoPara,GET_PIXEL_FORMAT,0);
    DSIM_ShortPktHeader* header = &(pInfor->m_oHeader);
    if (ret) {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, header))
        {
            if (DSIM_GetRxHeaderType(header) == DcsShort1B)
            {
                *pFmt = (DSIM_PixerFormat)(header->_inter.data.data0);
            }
        }
    }
    return ret;
}

//////////
// Function Name : GetGreenChannel
// Function Description :
//   This function get Display Mode.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetPowerMode(DCS_Infor* pInfor, BYTE* pMode)
{
    BYTE ret = DSIM_WrData(pInfor->m_pDsiProtocol,DCSRdNoPara,GET_POWER_MODE,0);
    DSIM_ShortPktHeader header;
    if (ret) {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, &header)) {
            if (DSIM_GetRxHeaderType(&header) == DcsShort1B) {
                pInfor->m_data.powerMode.bGot = TRUE;
                pInfor->m_data.powerMode.value = header._inter.data.data0;
                *((BYTE*)pMode) = (BYTE)(header._inter.data.data0);
            }
        }
    }
    return ret;
}

//////////
// Function Name : DCS_GetRedChannel
// Function Description :
//   This function get Display Mode.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetRedChannel(DCS_Infor* pInfor)
{
    BYTE ret = DSIM_WrData(pInfor->m_pDsiProtocol,DCSRdNoPara,GET_RED_CHANNEL,0);
    DSIM_ShortPktHeader header;
    if (ret) {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, &header)) {
            if (DSIM_GetRxHeaderType(&header) == DcsShort1B) {
                return header._inter.data.data0;
            }
        }
    }
    return 0;
}

//////////
// Function Name : DCS_GetScanLine
// Function Description :
//   This function get Scan Line.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetScanLine(DCS_Infor* pInfor, DWORD* line)
{
    BYTE ret = DSIM_WrData(pInfor->m_pDsiProtocol,DCSRdNoPara,GET_SCANLINE,0);
    DSIM_ShortPktHeader header;
    if (ret) {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, &header)) {
            if (DSIM_GetRxHeaderType(&header) == DcsShort2B) {
                *line = (*((DWORD*)&header) & 0xff00 >> 8);
            }
        }
    }
    return ret;
}

//////////
// Function Name : DCS_GetScanLine
// Function Description :
//   This function get Scan Line.
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_GetSignalMode(DCS_Infor* pInfor, BYTE* pSig)
{
    BYTE ret = DSIM_WrData(pInfor->m_pDsiProtocol,DCSRdNoPara,GET_SIGNAL_MODE,0);
    DSIM_ShortPktHeader header;
    if (ret) {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, &header)) {
            if (DSIM_GetRxHeaderType(&header) == DcsShort1B) {
                pInfor->m_data.signalMode.bGot = TRUE;
                pInfor->m_data.signalMode.value = header._inter.data.data0;
                *pSig = (BYTE)header._inter.data.data0;
            }
        }
    }
    return ret;
}

//////////
// Function Name : DCS_Nop
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_Nop(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,NOP,0);
}

/*---------------------------------- wrappers of ------------------------*/
// Function Name : DCS_ReadDDBStart
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_ReadDDBStart(DCS_Infor* pInfor, BYTE* pBuf,DWORD bufSize,DWORD* pnRead)
{
    return DCS_ReadDCSRegister(pInfor, READ_DDB_START,pBuf,bufSize,pnRead);
}

// Function Name : DCS_ReadDDBContinue
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_ReadDDBContinue(DCS_Infor* pInfor, BYTE* pBuf,DWORD bufSize,DWORD* pnRead)
{
    return DCS_ReadDCSRegister(pInfor, READ_DDB_CONTINUE,pBuf,bufSize,pnRead);
}

// Function Name : DCS_ReadMemoryStart
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_ReadMemoryStart(DCS_Infor* pInfor, BYTE* pBuf,DWORD bufSize,DWORD* pnRead)
{
    return DCS_ReadDCSRegister(pInfor, READ_MEMORY_START,pBuf,bufSize,pnRead);
}

// Function Name : DCS_ReadMemoryContinue
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_ReadMemoryContinue(DCS_Infor* pInfor, BYTE* pBuf,DWORD bufSize,DWORD* pnRead)
{
    return DCS_ReadDCSRegister(pInfor, READ_MEMORY_CONTINUE,pBuf,bufSize,pnRead);
}

// Function Name : DCS_ReadDCSRegister
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_ReadDCSRegister(DCS_Infor* pInfor, BYTE cmd,BYTE *pBuf,DWORD nBufsize,DWORD* pRead)
{
    BYTE ret = DSIM_WrData(pInfor->m_pDsiProtocol,DCSRdNoPara,cmd,0);
    DSIM_ShortPktHeader header;
    if (ret)
    {
        /* check rx */
        if (DSIM_PopRxHeader(pInfor->m_pDsiProtocol, &header))
        {
            DSIM_Response eResponse = DSIM_GetRxHeaderType(&header);
            if ( eResponse == DcsShort1B || eResponse == GenShort1B)
            {
                memcpy(pBuf,(void*)&(header._inter.data.data0),1);
                if (pRead)
                    *pRead=1;
            }
            if (eResponse == DcsShort2B || eResponse == GenShort2B)
            {
                memcpy(pBuf,(void*)&(header._inter.data.data0),2);
                if (pRead)
                    *pRead=2;
            }
            if (eResponse == DcsLong || eResponse == GenLong)
            {
                DWORD toReadActual = (*((DWORD *)&header) & 0xff00) >> 8;
                if (toReadActual > nBufsize)
                {
                    /* TODO : warn user */
                    toReadActual = nBufsize;
                }
                if (pRead)
                {
                    *pRead = DSIM_PopRxPayload(&header,pBuf,toReadActual);
                    if (*pRead == toReadActual)
                        return TRUE;
                }
            }
        }
    }
    return FALSE;
}

/*---------------------------------- wrappers of ------------------------*/

// Function Name : DCS_SetAddressMode
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetAddressMode(DCS_Infor* pInfor, BYTE mode)
{
    SIMPLE_ARG1(SET_ADDRESS_MODE, mode);
}

// Function Name : DCS_SetPageAddress
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetPageAddress(DCS_Infor* pInfor, WORD startPage,WORD endPage)
{
    BYTE dataToSend[5];
    dataToSend[0] =    SET_PAGE_ADDRESS;
    dataToSend[1] =    LO_BYTE(startPage);
    dataToSend[2] =    HI_BYTE(startPage);
    dataToSend[3] =    LO_BYTE(endPage);
    dataToSend[4] =    LO_BYTE(endPage);

    if (startPage > endPage)
        return FALSE;

    SIMPLE_OP_LONG(5);
}

// Function Name : DCS_SetColumnAddress
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetColumnAddress(DCS_Infor* pInfor, WORD sc,WORD ec)
{

    BYTE dataToSend[5];
    dataToSend[0] =    SET_PAGE_ADDRESS;
    dataToSend[1] =    LO_BYTE(sc);
    dataToSend[2] =    HI_BYTE(sc);
    dataToSend[3] =    LO_BYTE(ec);
    dataToSend[4] =    LO_BYTE(ec);
    if (sc > ec) {
        return FALSE;
    }
    SIMPLE_OP_LONG(5);
}

// Function Name : DCS_SetDisplayOff
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetDisplayOff(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol, DCSWrNoPara,SET_DISPLAY_OFF,0);
}


// Function Name : DCS_SetDisplayOn
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetDisplayOn(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol,DCSWrNoPara,SET_DISPLAY_ON,0);
}


// Function Name : DCS_SetGammaCurve
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetGammaCurve(DCS_Infor* pInfor, GAMMA_CURVE_t curve)
{
    SIMPLE_ARG1(SET_GAMMA_CURVE,(BYTE)curve);
}

// Function Name : DCS_SetPartialArea
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetPartialArea(DCS_Infor* pInfor, WORD startRow,WORD endRow)
{

    /*if (startRow==0 || endRow == 0 ||
        startRow >= m_pDsiProtocol->GetDisplayHeight() ||
        endRow >= m_pDsiProtocol->GetDisplayHeight())
    {
        return FALSE;
    }*/

    BYTE dataToSend[5];
    dataToSend[0] = SET_PARTIAL_AREA;
    dataToSend[1] = LO_BYTE(startRow); dataToSend[2] = HI_BYTE(startRow);
    dataToSend[3] = LO_BYTE(endRow); dataToSend[4] = HI_BYTE(endRow);
    SIMPLE_OP_LONG(5);
}

// Function Name : DCS_SetPixelFormat
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetPixelFormat(DCS_Infor* pInfor, BYTE format)
{
    SIMPLE_ARG1(SET_PIXEL_FORMAT,format);
}


// Function Name : DCS_SetScrollArea
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetScrollArea(DCS_Infor* pInfor, WORD top_fixed_area_lines,WORD vertical_scrolling_area_lines,    WORD bottom_fixed_area_lines)
{
    /*if (top_fixed_area_lines + vertical_scrolling_area_lines + bottom_fixed_area_lines !=
        m_pDsiProtocol->GetDisplayHeight())
    {
        // the sum of parameter must equal the number of display device's horizontal lines
        return FALSE;
    }*/
    BYTE dataToSend[7] ;
    dataToSend[0] = SET_SCROLL_AREA;
    dataToSend[1] = LO_BYTE(top_fixed_area_lines);        dataToSend[2] = HI_BYTE(top_fixed_area_lines);
    dataToSend[3] = LO_BYTE(vertical_scrolling_area_lines);    dataToSend[4] = HI_BYTE(vertical_scrolling_area_lines);
    dataToSend[5] = LO_BYTE(bottom_fixed_area_lines);    dataToSend[6] = HI_BYTE(bottom_fixed_area_lines);
    SIMPLE_OP_LONG(7);
}

// Function Name : DCS_SetScrollStart
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetScrollStart(DCS_Infor* pInfor, WORD vertical_scroll_pointer)
{
    BYTE dataToSend[3];
    dataToSend[0] = SET_SCROLL_START;
    dataToSend[1] = LO_BYTE(vertical_scroll_pointer); dataToSend[2] =HI_BYTE(vertical_scroll_pointer);
    SIMPLE_OP_LONG(3);
}

// Function Name : DCS_SetTearOff
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetTearOff(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol,DCSWrNoPara ,SET_TEAR_OFF,0);
}

// Function Name : DCS_SetTearOn
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetTearOn(DCS_Infor* pInfor, BYTE bothBlanking)
{
    SIMPLE_ARG1(SET_TEAR_ON,(BYTE)bothBlanking);
}

// Function Name : DCS_SetTearScanline
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SetTearScanline(DCS_Infor* pInfor, WORD line)
{
    BYTE dataToSend[3];
    dataToSend[0] =SET_TEAR_SCANLINE,
    dataToSend[1] = LO_BYTE(line); dataToSend[2] =HI_BYTE(line);
    SIMPLE_OP_LONG(3);
}

// Function Name : DCS_SetTearScanline
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_SoftReset(DCS_Infor* pInfor)
{
    return DSIM_WrData(pInfor->m_pDsiProtocol,DCSWrNoPara,SOFT_RESET,0);
}

// Function Name : DCS_WriteLUT
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_WriteLUT(DCS_Infor* pInfor, BYTE* pBuf,DWORD size)
{
    return DCS_WriteLongPacketWithDCSCommand(pInfor, WRITE_LUT,pBuf,size);
}

// Function Name : DCS_WriteMemoryContinue
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_WriteMemoryContinue(DCS_Infor* pInfor, BYTE* pBuf,DWORD size)
{
    return DCS_WriteLongPacketWithDCSCommand(pInfor, WRITE_MEMORY_CONTINUE,pBuf,size);
}

// Function Name : DCS_WriteMemoryStart
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_WriteMemoryStart(DCS_Infor* pInfor, BYTE* pBuf,DWORD size)
{
    return DCS_WriteLongPacketWithDCSCommand(pInfor, WRITE_MEMORY_START,pBuf,size);
}

// Function Name : DCS_WriteMemoryStart
// Function Description :
//   This function is Display module to operate nothing
// Input :     DSIM_Infor* : Information structure of DCS Driver
// Output : BYTE (Bool) : TRUE/FALSE
// Version : v0.0
BYTE DCS_WriteLongPacketWithDCSCommand(DCS_Infor* pInfor, DCS_CmdSet cmd,BYTE* pBuf,DWORD size) //BYTE useHs,BYTE dummy
{
    BYTE ret;
    //BYTE* dataToSend = (BYTE *)malloc(size+5);
    BYTE dataToSend_mem[1024];
    BYTE* dataToSend = (BYTE *)dataToSend_mem;
    // DEADCODE
//    if (dataToSend==NULL) {
//        return FALSE;
//    }
    memset(dataToSend,0,size+1);
    dataToSend[0] = cmd;
    memcpy(dataToSend+1,pBuf,size);
    ret = DSIM_WrData(pInfor->m_pDsiProtocol, DCSLongWr, (DWORD)((BYTE*)dataToSend), (size+1));
    //free(dataToSend);
    return ret;
}




