//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    ldi.h

Abstract:       Function prototypes and enumrate value of LDI control library

Functions:


Notes:


--*/

#ifndef __LDI_H__
#define __LDI_H__

#if __cplusplus
extern "C"
{
#endif

typedef enum
{
    AT070TN92_RGB,                // 4.8" WVGA 800*480 in SMDKV210
    LDI_HT101HD1_RGB,                // 1376*768 in SMDKV210
    LDI_TL2796_RGB,                 // Portrait WVGA 480*800 in SMDKV210
    LDI_DUMMY,                    // MIPI LCD 320*480
    LDI_LTS222QV_RGB,               // RGB sireal I/F 240*320
    LDI_AUO27_RGB,               // Delta Structure RGB I/F 960*240
	LDI_VGA8060_RGB,
	LDI_VGA800_480_RGB,
	LDI_VGA1024_RGB,
	LDI_VGA1280_1024_RGB,
	LDI_VGA1440_900_RGB,	
	LDI_LTV350QV_RGB,		// added by terry for qimei4.3 inch 480*272	
    LDI_MODULE_TYPE_MAX
} LDI_LCD_MODULE_TYPE;

typedef enum
{
    LDI_SUCCESS,
    LDI_ERROR_NULL_PARAMETER,
    LDI_ERROR_ILLEGAL_PARAMETER,
    LDI_ERROR_NOT_INITIALIZED,
    LDI_ERROR_NOT_IMPLEMENTED,
    LDI_ERROR_XXX
} LDI_ERROR;

LDI_ERROR LDI_initialize_register_address(void *pSPIReg, void *pDispConReg, void *pGPIOReg);
LDI_ERROR LDI_DSI_initialize_register_address(void *pMIPIDSIReg, void *pDispConReg, void *pGPIOReg);
LDI_ERROR LDI_set_LCD_module_type(LDI_LCD_MODULE_TYPE ModuleType);
LDI_ERROR LDI_initialize_LCD_module(void);
LDI_ERROR LDI_deinitialize_LCD_module(void);
LDI_ERROR LDI_fill_output_device_information(void *pDevInfo);

static void LDI_LTE480WV_RGB_port_initialize(void);
static LDI_ERROR LDI_LTE480WV_RGB_power_on(void);
static LDI_ERROR LDI_LTE480WV_RGB_power_off(void);
static LDI_ERROR LDI_LTE480WV_RGB_initialize(void);

static void LDI_HT101HD1_RGB_port_initialize(void);
static LDI_ERROR LDI_HT101HD1_RGB_power_on(void);
static LDI_ERROR LDI_HT101HD1_RGB_power_off(void);
static LDI_ERROR LDI_HT101HD1_RGB_initialize(void);

static LDI_ERROR LDI_DUMMY_power_on(void);
static LDI_ERROR LDI_DUMMY_power_off(void);

static void LDI_TL2796_RGB_port_initialize(void);
static LDI_ERROR LDI_TL2796_RGB_power_on(void);
static LDI_ERROR LDI_TL2796_RGB_power_off(void);
static LDI_ERROR LDI_TL2796_RGB_initialize(void);
static LDI_ERROR Write_LDI_TL2796(UINT16 uiAddr, UINT16 uiData);

static void LDI_LTS222QV_port_initialize(void);
static LDI_ERROR LDI_LTS222QV_power_on(void);
static LDI_ERROR LDI_LTS222QV_power_off(void);
static LDI_ERROR LDI_LTS222QV_RGB_initialize(void);

static void LDI_AUO27_port_initialize(void);
static LDI_ERROR LDI_AUO27_power_on(void);
static LDI_ERROR LDI_AUO27_power_off(void);
static LDI_ERROR LDI_AUO27_RGB_initialize(void);

static void LDI_LTS222QV_write(unsigned int address, unsigned int data);
static void LDI_AUO27_write(unsigned int address, unsigned int data);
static void DelayLoop_1ms(int msec);
static void DelayLoop(int delay);

#if __cplusplus
}
#endif

#endif    // __LDI_H__
