#ifndef __IMAGE_ROTATOR_H__
#define __IMAGE_ROTATOR_H__

//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    image_rotator.h

Abstract:       Type definition and function prototypes

Functions:


Notes:


--*/

#if __cplusplus
extern "C"
{
#endif

typedef enum
{
    ROT_SUCCESS,
    ROT_ERROR_NULL_PARAMETER,
    ROT_ERROR_ILLEGAL_PARAMETER,
    ROT_ERROR_NOT_INITIALIZED,
    ROT_ERROR_NOT_IMPLEMENTED,
    ROT_ERROR_XXX
} ROT_ERROR;

typedef enum
{
    ROTATOR_IDLE = 0,
    ROTATOR_BUSY,
    ROTATOR_BUSY2
} ROTATOR_OP_STATUS;

typedef struct _tRotatorStatus
{
    unsigned int    uiCurLineNumber;
    BOOL        bIntPending;
    ROTATOR_OP_STATUS eOpStatus;
} tRotatorStatus;

ROT_ERROR Rotator_initialize_register_address(void *pRotatorReg);
ROT_ERROR Rotator_initialize(ROTATOR_IMAGE_FORMAT eFormat, ROTATOR_OPERATION_TYPE eOperation, unsigned int uiSrcWidth, unsigned int uiSrcHeight);
ROT_ERROR Rotator_set_source_buffer(unsigned int AddrRGBY, unsigned int AddrCb, unsigned int AddrCr);
ROT_ERROR Rotator_set_destination_buffer(unsigned int AddrRGBY, unsigned int AddrCb, unsigned int AddrCr);

void Rotator_start(void);
void Rotator_stop(void);

void Rotator_enable_interrupt(void);
void Rotator_disable_interrupt(void);
BOOL Rotator_clear_interrupt_pending(void);

static ROT_ERROR Rotator_get_status(tRotatorStatus *pStatus);


#if __cplusplus
}
#endif

#endif    // __IMAGE_ROTATOR_H__