#ifndef __DISPLAY_CON_MACRO_H__
#define __DISPLAY_CON_MACRO_H__

#if __cplusplus
extern "C"
{
#endif

////////////////////////////////////////
//
//    Display Controller SFR Bit Field Macro
//
////////////////////////////////////////

// VIDCON0
#define MIPI_DSI_EN         (1<<30) // RGBINFO.MIPIDSIen
#define MIPI_DSI_DIS        (0<<30) // RGBINFO.MIPIDSIen

#define PROGRESSIVE         (0<<29)
#define INTERLACE           (1<<29)

#define VIDOUT_RGBIF        (0<<26)
#define VIDOUT_ITU6xx       (1<<26)
#define VIDOUT_I80IF0       (2<<26)
#define VIDOUT_I80IF1       (3<<26)
#define VIDOUT_WB_RGBIF     (4<<26)
#define VIDOUT_WB_I80IF0    (6<<26)
#define VIDOUT_WB_I80IF1    (7<<26)
#define VIDOUT_WB_EN        (1<<28)
#define VIDOUT_MASK         (3<<26)

#define LDI1_16_MODE        (0<<23)
#define LDI1_16_2_MODE      (1<<23)
#define LDI1_9_9_MODE       (2<<23)
#define LDI1_16_8_MODE      (3<<23)
#define LDI1_18_MODE        (4<<23)
#define LDI1_8_8_MODE       (5<<23)

#define LDI0_16_MODE        (0<<20)
#define LDI0_16_2_MODE      (1<<20)
#define LDI0_9_9_MODE       (2<<20)
#define LDI0_16_8_MODE      (3<<20)
#define LDI0_18_MODE        (4<<20)
#define LDI0_8_8_MODE       (5<<20)

#define RGBSPSEL_PARALLEL   (0<<18)
#define RGBSPSEL_SERIAL     (1<<18)
//#define SET_RGBSPSEL(x)     (((x)&0x1)<<18)
#define SET_RGBSPSEL(x)     (((x)>2) ? (1<<18):(0<<18)) // 3 = DISP_18BIT_RGB666_S

#define PNRMODE_RGB_P       (0<<17)
#define PNRMODE_BGR_P       (1<<17)
#define PNRMODE_RGB_S       (2<<17)
#define PNRMODE_BGR_S       (3<<17)
#define PNRMODE_MASK        (3<<17)

#define CLKVALUP_ALWAYS     (0<<16)
#define CLKVALUP_ST_FRM     (1<<16)

#define CLKVAL_F(n)         (((n-1)&0xff)<<6)

#define VCLK_NORMAL         (0<<5)  // RGBINFO.VCLK_Gate
#define VCLK_FREERUN        (1<<5)  // RGBINFO.VCLK_Gate

#define CLKDIR_DIRECT       (0<<4)  // RGBINFO.VCLK_Direction
#define CLKDIR_DIVIDED      (1<<4)  // RGBINFO.VCLK_Direction

#define CLKSEL_F_HCLK       (0<<2)  // RGBINFO.VCLK_Source
#define CLKSEL_F_LCDCLK     (1<<2)  // RGBINFO.VCLK_Source
#define CLKSEL_F_EXT27M     (3<<2)
#define CLKSEL_F_MASK       (3<<2)

#define ENVID_DISABLE       (0<<1)
#define ENVID_ENABLE        (1<<1)
#define ENVID_F_DISABLE     (0<<0)
#define ENVID_F_ENABLE      (1<<0)

// VIDCON1
#define VCLK_HOLD   (0<<9)
#define VCLK_RUNNING   (1<<9)
#define VCLK_RUNNING_DISABLE_VDEN   (3<<9)
#define VCLK_HOLD_MASK   (3<<9)
#define IVCLK_FALL_EDGE     (0<<7)  // RGBINFO.VCLK_Polarity
#define IVCLK_RISE_EDGE     (1<<7)  // RGBINFO.VCLK_Polarity
#define IHSYNC_HIGH_ACTIVE  (0<<6)  // RGBINFO.HSYNC_Polarity
#define IHSYNC_LOW_ACTIVE   (1<<6)  // RGBINFO.HSYNC_Polarity
#define IVSYNC_HIGH_ACTIVE  (0<<5)  // RGBINFO.VSYNC_Polarity
#define IVSYNC_LOW_ACTIVE   (1<<5)  // RGBINFO.VSYNC_Polarity
#define IVDEN_HIGH_ACTIVE   (0<<4)  // RGBINFO.VDEN_Polarity
#define IVDEN_LOW_ACTIVE    (1<<4)  //RGBINFO.VDEN_Polarity

// VIDCON2
#define RGB_SKIP_DISABLE    (0<<27)     // RGBINFO.RGBSkipEn
#define RGB_SKIP_ENABLE        (1<<27) // RGBINFO.RGBSkipEn
#define RGB_SKIP_MASK        (1<<27) // RGBINFO.RGBSkipEn
//#define RGB_DUMMY_LAST        (0<<25)
//#define RGB_DUMMY_FIRST        (1<<25)
#define RGB_DUMMY_LAST        (1<<24)     // RGBINFO.RGBDummy
#define RGB_DUMMY_FIRST        (3<<24) // RGBINFO.RGBDummy
#define RGB_DUMMY_DISABLE    (0<<24)     // RGBINFO.RGBDummy
#define RGB_DUMMY_MASK        (3<<24) // RGBINFO.RGBDummy
//#define RGB_DUMMY_ENABLE    (1<<24)

#define EN601_DISABLE        (0<<23)
#define EN601_ENABLE        (1<<23)
#define EN656_DISABLE        (0<<22)
#define EN656_ENABLE        (1<<22)

#define RGB_ORDER_E_RGB        (0<<19) // RGBINFO.RGBEvenOrder
#define RGB_ORDER_E_GBR        (1<<19) // RGBINFO.RGBEvenOrder
#define RGB_ORDER_E_BRG        (2<<19) // RGBINFO.RGBEvenOrder
#define RGB_ORDER_E_BGR        (4<<19) // RGBINFO.RGBEvenOrder
#define RGB_ORDER_E_RBG        (5<<19) // RGBINFO.RGBEvenOrder
#define RGB_ORDER_E_GRB        (6<<19) // RGBINFO.RGBEvenOrder
#define RGB_ORDER_E_MASK       (7<<19) // RGBINFO.RGBEvenOrder

#define RGB_ORDER_O_RGB        (0<<16) // RGBINFO.RGBOddOrder
#define RGB_ORDER_O_GBR        (1<<16) // RGBINFO.RGBOddOrder
#define RGB_ORDER_O_BRG        (2<<16) // RGBINFO.RGBOddOrder
#define RGB_ORDER_O_BGR        (4<<16) // RGBINFO.RGBOddOrder
#define RGB_ORDER_O_RBG        (5<<16) // RGBINFO.RGBOddOrder
#define RGB_ORDER_O_GRB        (6<<16) // RGBINFO.RGBOddOrder
#define RGB_ORDER_O_MASK       (7<<16) // RGBINFO.RGBOddOrder

#define WRITEBACK_DISABLE    (0<<15)
#define WRITEBACK_ENABLE    (1<<15)
#define TVFORMATSEL0_HW        (0<<14)
#define TVFORMATSEL0_SW        (1<<14)
#define TVFORMATSEL1_RGB    (0<<12)
#define TVFORMATSEL1_YUV422    (1<<12)
#define TVFORMATSEL1_YUV444    (1<<13)
#define ORGYCBCR_YCBCR        (0<<8)
#define ORGYCBCR_CBCRY        (1<<8)
#define YUVORD_CB_CR        (0<<7)
#define YUVORD_CR_CB        (1<<7)

#define TV_FRAM_SKIP(n)        (((n-1)&0x1F)<<0)        // n=1 ; 1:1 /  n=2 ; 1:2 /   n=3 ; 1:3 ...

// VIDCON3
#define VE_ONOFF_MASK           (1<<20)
#define VE_ENABLE               (1<<20)
#define VE_DISABLE              (0<<20)
#define COLORGAIN_ONOFF_MASK    (1<<18)
#define COLORGAIN_ENABLE        (1<<18)
#define COLORGAIN_DISABLE       (0<<18)
#define GAMMA_ONOFF_MASK        (1<<16)
#define GAMMA_ENABLE            (1<<16)
#define GAMMA_DISABLE           (0<<16)
#define HUE_CSC_F_RANGE_MASK    (1<<14)
#define HUE_CSC_F_NARROW        (1<<14)
#define HUE_CSC_F_WIDE          (0<<14)
#define HUE_CSC_F_EQ_MASK       (1<<13)
#define HUE_CSC_F_EQ709         (1<<13)
#define HUE_CSC_F_EQ601         (0<<13)
#define HUE_CSC_F_ONOFF_MASK    (1<<12)
#define HUE_CSC_F_ENABLE        (1<<12)
#define HUE_CSC_F_DISABLE       (0<<12)
#define HUE_CSC_B_RANGE_MASK    (1<<10)
#define HUE_CSC_B_NARROW        (1<<10)
#define HUE_CSC_B_WIDE          (0<<10)
#define HUE_CSC_B_EQ_MASK       (1<<9)
#define HUE_CSC_B_EQ709         (1<<9)
#define HUE_CSC_B_EQ601         (0<<9)
#define HUE_CSC_B_ONOFF_MASK    (1<<8)
#define HUE_CSC_B_ENABLE        (1<<8)
#define HUE_CSC_B_DISABLE       (0<<8)
#define HUE_ONOFF_MASK          (1<<7)
#define HUE_ENABLE              (1<<7)
#define HUE_DISABLE             (0<<7)
//#define PIXEL_COMP_DIR_MASK     (1<<1)
//#define PIXEL_COMP_NEGATIVE     (1<<1)
//#define PIXEL_COMP_POSITIVE     (0<<1)
//#define PIXEL_COMP_ONOFF_MASK   (1<<0)
//#define PIXEL_COMP_ENABLE       (1<<0)
#define PIXEL_COMP_NEGATIVE     (3<<0)  // RGBINFO.PixelCompensation
#define PIXEL_COMP_POSITIVE     (1<<0)  // RGBINFO.PixelCompensation
#define PIXEL_COMP_DISABLE      (0<<0)  // RGBINFO.PixelCompensation

// VIDTCON0
#define VBPDE(n)            (((n-1)&0xff)<<24)
#define VBPD(n)             (((n-1)&0xff)<<16)
#define VFPD(n)             (((n-1)&0xff)<<8)
#define VSPW(n)             (((n-1)&0xff)<<0)

// VIDTCON1
#define VFPDE(n)            (((n-1)&0xff)<<24)
#define HBPD(n)             (((n-1)&0xff)<<16)
#define HFPD(n)             (((n-1)&0xff)<<8)
#define HSPW(n)             (((n-1)&0xff)<<0)

// VIDTCON2
#define LINEVAL(n)          (((n-1)&0x7ff)<<11)
#define HOZVAL(n)           (((n-1)&0x7ff)<<0)

// VIDTCON3

// WINCON0
#define CSC_WIDE_RANGE      (0<<26)
#define CSC_NARROW_RANGE    (3<<26)
// LOCALSEL is only in WINCON1
#define LOCALSEL_CAMIF1     (0<<23)
#define LOCALSEL_VP         (1<<23)

#define LOCAL_PATH_DISABLE  (0<<22)
#define LOCAL_PATH_ENABLE   (1<<22)

#define BUFSEL_BUF0         ((0<<30)|(0<<20))   // (BUFSEL_H | BUFSEL_L)
#define BUFSEL_BUF1         ((0<<30)|(1<<20))
#define BUFSEL_BUF2         ((1<<30)|(0<<20))

#define BUFAUTO_DISABLE     (0<<19)
#define BUFAUTO_ENABLE      (1<<19)

#define BITSWP_DISABLE      (0<<18)
#define BITSWP_ENABLE       (1<<18)
#define BYTSWP_DISABLE      (0<<17)
#define BYTSWP_ENABLE       (1<<17)
#define HAWSWP_DISABLE      (0<<16)
#define HAWSWP_ENABLE       (1<<16)
#define WSWP_DISABLE        (0<<15)
#define WSWP_ENABLE         (1<<15)

#define BUF_MODE_DOUBLE     (0<<14)
#define BUF_MODE_TRIPPLE    (1<<14)

#define LOCAL_IN_RGB888     (0<<13)
#define LOCAL_IN_YUV444     (1<<13)

#define BURSTLEN_16WORD     (0<<9)
#define BURSTLEN_8WORD      (1<<9)
#define BURSTLEN_4WORD      (2<<9)
#define BURSTLEN_MASK       (3<<9)

#define BLEND_PER_PLANE     (0<<6)
#define BLEND_PER_PIXEL     (1<<6)
#define BLEND_MULTIPLIED    (3<<6)

#define BPPMODE_F_1BPP          (0<<2)
#define BPPMODE_F_2BPP          (1<<2)
#define BPPMODE_F_4BPP          (2<<2)
#define BPPMODE_F_8BPP_PAL      (3<<2)
#define BPPMODE_F_8BPP_NOPAL    (4<<2)
#define BPPMODE_F_16BPP_565     (5<<2)
#define BPPMODE_F_16BPP_A555    (6<<2)
#define BPPMODE_F_16BPP_I555    (7<<2)
#define BPPMODE_F_18BPP_666     (8<<2)
#define BPPMODE_F_18BPP_A665    (9<<2)
#define BPPMODE_F_19BPP_A666    (0xa<<2)
#define BPPMODE_F_24BPP_888     (0xb<<2)
#define BPPMODE_F_24BPP_A887    (0xc<<2)
#define BPPMODE_F_25BPP_A888    (0xd<<2)
#define BPPMODE_F_32BPP_A8888   (0xd<<2)
#define BPPMODE_F_13BPP_A444    (0xe<<2)
#define BPPMODE_F_16BPP_A4444   (0xe<<2)
#define BPPMODE_F_MASK          (0xf<<2)
#define BPPMODE_F(n)            (((n)&0xf)<<2)

#define ALPHASEL_ALPHA0     (0<<1)    // Per Plane
#define ALPHASEL_ALPHA1     (1<<1)
#define ALPHASEL_AEN        (0<<1)    // Per Pixel
#define ALPHASEL_DATA       (1<<1)

#define ENWIN_F_DISABLE     (0<<0)
#define ENWIN_F_ENABLE      (1<<0)

// VIDOSDxA
#define OSD_LEFTTOPX_F(n)   (((n)&0x7ff)<<11)
#define OSD_LEFTTOPY_F(n)   ((n)&0x7ff)

// VIDOSDxB
#define OSD_RIGHTBOTX_F(n)  (((n)&0x7ff)<<11)
#define OSD_RIGHTBOTY_F(n)  ((n)&0x7ff)

// VIDOSDxC
#define ALPHA0_R_H(n)       ((((n)&0xf0)>>4)<<20)
#define ALPHA0_G_H(n)       ((((n)&0xf0)>>4)<<16)
#define ALPHA0_B_H(n)       ((((n)&0xf0)>>4)<<12)
#define ALPHA1_R_H(n)       ((((n)&0xf0)>>4)<<8)
#define ALPHA1_G_H(n)       ((((n)&0xf0)>>4)<<4)
#define ALPHA1_B_H(n)       (((n)&0xf0)>>4)

#define ALPHA0_R_4BIT(n)    (((n)&0xf)<<20)
#define ALPHA0_G_4BIT(n)    (((n)&0xf)<<16)
#define ALPHA0_B_4BIT(n)    (((n)&0xf)<<12)
#define ALPHA1_R_4BIT(n)    (((n)&0xf)<<8)
#define ALPHA1_G_4BIT(n)    (((n)&0xf)<<4)
#define ALPHA1_B_4BIT(n)    ((n)&0xf)

// VIDW0ALPHA0, VIDW0ALPHA1 has
#define VIDWxALPHAx_R(n)    (((n)&0xff0000)<<16)
#define VIDWxALPHAx_G(n)    (((n)&0x00ff00)<<8)
#define VIDWxALPHAx_B(n)    ((n)&0x0000ff)


// VIDWxALPHA0, VIDWxALPHA1  (1~4)
#define ALPHA0_R_L(n)       (((n)&0xf)<<16)
#define ALPHA0_G_L(n)       (((n)&0xf)<<8)
#define ALPHA0_B_L(n)       ((n)&0xf)
#define ALPHA1_R_L(n)       (((n)&0xf)<<16)
#define ALPHA1_G_L(n)       (((n)&0xf)<<8)
#define ALPHA1_B_L(n)       ((n)&0xf)

// BLENDEQx (1~4)
// foreground means higher window, background is lower window
// Window0 is lower than window1, so Window0 is background, window1 is foreground
#define BLDEQ_ZERO                      (0x0)   // 0
#define BLDEQ_MAX                       (0x1)   // 1
#define BLDEQ_ALHPA_A                   (0x2)   // foregorund Alpha
#define BLDEQ_INV_ALPHA_A               (0x3)   // 1- foreground alpha
#define BLDEQ_ALPHA_B                   (0x4)   // background alpha
#define BLDEQ_INV_ALPHA_B               (0x5)   // 1 - background alpha
#define BLDEQ_A                         (0xA)   // Foreground color data
#define BLDEQ_INV_A                     (0xB)   // 1 - foreground color data
#define BLDEQ_B                         (0xC)   // Background color data
#define BLDEQ_INV_B                     (0xD)   // 1- background color data

#define Q_FUNC(n)           (((n)&0xf)<<18)
#define P_FUNC(n)           (((n)&0xf)<<12)
#define B_FUNC(n)           (((n)&0xf)<<6)
#define A_FUNC(n)           ((n)&0xf)

// BLENDCON
#define USE_BLEND_NEW           (1)
#define USE_BLEND_OLD           (0)

// VIDOSD0C, VIDOSDxD
#define OSD_SIZE(n)         ((n)&0xffffff)

// VIDW0xADD0
#define VBANK_F(n)          (((n)&0xff)<<24)
#define VBASEU_F(n)         ((n)&0xffffff)

// VIDW0xADD1
#define VBASEL_F(n)         ((n)&0xffffff)

// VIDW0xADD2
#define OFFSIZE_F(n)        (((n)&0x1fff)<<13)
#define PAGEWIDTH_F(n)      ((n)&0x1fff)

// VIDINTCON0
#define INTVP_DISABLE       (0<<26)
#define INTVP_ENABLE        (1<<26)

#define FIFOINTERVAL(n)     (((n)&3f)<<20)

#define SYSMAINCON_DISABLE  (0<<19)
#define SYSMAINCON_ENABLE   (1<<19)
#define SYSSUBCON_DISABLE   (0<<18)
#define SYSSUBCON_ENABLE    (1<<18)
#define SYSIFDONE_DISABLE   (0<<17)
#define SYSIFDONE_ENABLE    (1<<17)

#define FRAMESEL0_BACK      (0<<15)
#define FRAMESEL0_VSYNC     (1<<15)
#define FRAMESEL0_ACTIVE    (2<<15)
#define FRAMESEL0_FRONT     (3<<15)

#define FRAMESEL1_NONE      (0<<13)
#define FRAMESEL1_BACK      (1<<13)
#define FRAMESEL1_VSYNC     (2<<13)
#define FRAMESEL1_FRONT     (3<<13)

#define INTFRMEN_DISABLE    (0<<12)
#define INTFRMEN_ENABLE     (1<<12)
#define FRAMEINT_MASK       (0x1f<<12)

#define FIFOSEL_WIN4        (1<<11)
#define FIFOSEL_WIN3        (1<<10)
#define FIFOSEL_WIN2        (1<<9)
#define FIFOSEL_WIN1        (1<<6)
#define FIFOSEL_WIN0        (1<<5)
#define FIFOSEL_ALL         (FIFOSEL_WIN0 | FIFOSEL_WIN1 | FIFOSEL_WIN2 | FIFOSEL_WIN3 | FIFOSEL_WIN4)

#define FIFOLEVEL_25        (0<<2)
#define FIFOLEVEL_50        (1<<2)
#define FIFOLEVEL_75        (2<<2)
#define FIFOLEVEL_EMPTY     (3<<2)
#define FIFOLEVEL_FULL      (4<<2)

#define INTFIFOEN_DISABLE   (0<<1)
#define INTFIFOEN_ENABLE    (1<<1)
#define FIFOINT_MASK        (0x7ff<<1)

#define INTEN_DISABLE       (0<<0)
#define INTEN_ENABLE        (1<<0)

// VIDINTCON1
#define INTVP_PEND          (1<<5)
#define INTSYSIF_PEND       (1<<2)
#define INTFRM_PEND         (1<<1)
#define INTFIFO_PEND        (1<<0)
#define INTPEND_MASK        (0x3f)

// WxKEYCON0
#define KEYBLEN_DISABLE     (0<<26)
#define KEYBLEN_ENABLE      (1<<26)
#define KEYEN_F_DISABLE     (0<<25)
#define KEYEN_F_ENABLE      (1<<25)
#define DIRCON_FG_MATCH_BG_DISPLAY (0<<24)
#define DIRCON_BG_MATCH_FG_DISPLAY (1<<24)
#define COMPKEY(n)          ((n)&0xffffff)

// WxKEYCON1
#define COLVAL(n)           ((n)&0xffffff)

// DITHMODE
#define RDITHPOS_8BIT       (0<<5)
#define RDITHPOS_6BIT       (1<<5)
#define RDITHPOS_5BIT       (2<<5)
#define GDITHPOS_8BIT       (0<<3)
#define GDITHPOS_6BIT       (1<<3)
#define GDITHPOS_5BIT       (2<<3)
#define BDITHPOS_8BIT       (0<<1)
#define BDITHPOS_6BIT       (1<<1)
#define BDITHPOS_5BIT       (2<<1)
#define RGB_DITHPOS_MASK    (0x3f<<1)
#define DITHEN_F_DISABLE    (0<<0)
#define DITHEN_F_ENABLE     (1<<0)

//COLORGAINCON
#define COLORGAIN_R_MASK    (0x3FF<<20)
#define COLORGAIN_R_BITPOS  20
#define COLORGAIN_G_MASK    (0x3FF<<10)
#define COLORGAIN_G_BITPOS  10
#define COLORGAIN_B_MASK    (0x3FF)
#define COLORGAIN_B_BITPOS  0

// VESFRCON0
#define ALPS_LOW_LUX    (0<<2)
#define ALPS_HIGH_LUX   (1<<2)
#define ALPS_MASK_LUX_LOW_HIGH  (1<<2)
#define ALPS_SW_RESET   (1<<1)

// VESFRCON1
#define ALPS_SET_VSIZE_F(x) (((x)&0x7ff)<<21)
#define ALPS_SET_HSIZE_F(x) (((x)&0x7ff)<<10)

// VESFRCON2
#define ALPS_ODV1_720_288   (0x14<<12)
#define ALPS_ODV1_720_240   (0x18<<12)
#define ALPS_ODV1_640_240   (0x1b<<12)
#define ALPS_ODV1_640_288   (0x5b<<12)
#define ALPS_ODV2_640_288   (0x00<<4)
#define ALPS_ODV2_720_240   (0x2d<<4)
#define ALPS_ODV2_720_288   (0x2e<<4)
#define ALPS_ODV2_640_240   (0x2e<<4)
#define ALPS_ODV_720_288    (0x00<<0)
#define ALPS_ODV_720_240    (0x00<<0)
#define ALPS_ODV_640_240    (0x00<<0)
#define ALPS_ODV_640_288    (0x10<<0)
#define ALPS_ODV_FREE_SIZE  (0x11<<0)

//HUECOEFFxx
#define CBGx_P_MASK         (0x3FF<<16)
#define CBGx_P_BITPOS       16
#define CBGx_N_MASK         (0x3FF)
#define CBGx_N_BITPOS       0
#define OFFSET_IN_MASK      (0x1FF<<16)
#define OFFSET_IN_BITPOS    16
#define OFFSET_OUT_MASK     (0x1FF)
#define OFFSET_OUT_BITPOS   0

// WINxMAP
#define MAPCOLEN_F_DISABLE    (0<<24)
#define MAPCOLEN_F_ENABLE    (1<<24)
#define MAPCOLOR(n)            ((n)&0xffffff)

// WPALCON
#define PALUPDATE_NORMAL    (0<<9)
#define PALUPDATE_ENABLE    (1<<9)

#define W4PAL_16BIT_565    (0<<8)
#define W4PAL_16BIT_A555    (1<<8)

#define W3PAL_16BIT_565    (0<<7)
#define W3PAL_16BIT_A555    (1<<7)

#define W2PAL_16BIT_565    (0<<6)
#define W2PAL_16BIT_A555    (1<<6)

#define W1PAL_25BIT_A888    (0<<3)
#define W1PAL_24BIT_888    (1<<3)
#define W1PAL_19BIT_A666    (2<<3)
#define W1PAL_18BIT_A665    (3<<3)
#define W1PAL_18BIT_666    (4<<3)
#define W1PAL_16BIT_A555    (5<<3)
#define W1PAL_16BIT_565    (6<<3)
#define W1PAL_MASK            (0x7<<3)

#define W0PAL_25BIT_A888    (0<<0)
#define W0PAL_24BIT_888    (1<<0)
#define W0PAL_19BIT_A666    (2<<0)
#define W0PAL_18BIT_A665    (3<<0)
#define W0PAL_18BIT_666    (4<<0)
#define W0PAL_16BIT_A555    (5<<0)
#define W0PAL_16BIT_565    (6<<0)
#define W0PAL_MASK            (0x7<<0)

//TRIGCON
#define W4_BUF_SW_TRG           (1<<26)
#define W4BUF_TRGMODE_EN        (1<<25)
#define W4BUF_TRGMODE_DIS       (0<<25)
#define W3_BUF_SW_TRG           (1<<21)
#define W3BUF_TRGMODE_EN        (1<<20)
#define W3BUF_TRGMODE_DIS       (0<<20)
#define W2_BUF_SW_TRG           (1<<16)
#define W2BUF_TRGMODE_EN        (1<<15)
#define W2BUF_TRGMODE_DIS       (0<<15)
#define W1_BUF_SW_TRG           (1<<11)
#define W1BUF_TRGMODE_EN        (1<<10)
#define W1BUF_TRGMODE_DIS       (0<<10)
#define W0_BUF_SW_TRG           (1<<6)
#define W0BUF_TRGMODE_EN        (1<<5)
#define W0BUF_TRGMODE_DIS       (0<<5)
#define FRAME_DONE_REQUEST      (1<<2)
#define I80_START_TRG           (1<<1)
#define I80_SW_TRGMODE_EN       (1<<0)
#define I80_SW_TRGMODE_DIS      (0<<0)

#define SW_TRG_CMD      (1)
#define TRGMODE_EN      (1)
#define TRGMODE_DIS     (0)
#define FRM_DONE_REQ    (1)

// ITUIFCON0
#define NO_DELAYED_VSYNC        (0<<24)
#define DELAYED_VSYNC           (1<<24)
#define DELAY_VSYNC_CLK(x)      (((x)&0xff)<<16)
#define I656FIELD_NORMAL        (0<<9)
#define I656FIELD_INVERTED      (1<<9)
#define I656CLK_NORMAL          (0<<8)
#define I656CLK_INVERTED        (1<<8)
#define I601HREF_NORMAL         (0<<6)
#define I601HREF_INVERTED       (1<<6)
#define I601VSYNC_NORMAL        (0<<5)
#define I601VSYNC_INVERTED      (1<<5)
#define I601HSYNC_NORMAL        (0<<4)
#define I601HSYNC_INVERTED      (1<<4)
#define I601FIELD_NORMAL        (0<<3)
#define I601FIELD_INVERTED      (1<<3)
#define I601CLK_NORMAL          (0<<2)
#define I601CLK_INVERTED        (1<<2)

#define EQUAL_VSYNC     (0)
#define DELAY_VSYNC     (1)
#define NORMAL_POL      (0)
#define INVERT_POL      (1)

// I80IFCONAx
#define SET_LCD_CS_SETUP(x)     (((x)&0xf)<<16)
#define SET_LCD_WRS_SETUP(x)    (((x)&0xf)<<16)
#define SET_LCD_WR_ACT(x)       (((x)&0xf)<<16)
#define SET_LCD_WR_HOLD(x)      (((x)&0xf)<<16)
#define RS_ACTIVE_LOW           (0<<2)
#define RS_ACTIVE_HIGH          (1<<2)
#define I80_IF_EN               (1<<0)
#define I80_IF_DIS              (0<<0)

#define ACTIVE_LOW              (0)
#define ACTIVE_HIGH             (1)
#define I80_EN                  (1)
#define I80_DIS                 (0)

// I80IFCONBx
#define NORMAL_CMD_START        (1<<9)
#define SET_FRAME_SKIP(x)       (((x)&0x3)<<5)
#define SET_AUTP_CMD_RATE(x)    ((((x)/2)&0xf)<<0)

// WxRTQOSCON
#define SET_QOS_FIFOLEVEL(x)    (((x)%0xff)<<4)
#define QOS_GATE_EN             (0<<1)
#define QOS_GATE_DIS            (1<<1)

// SHADOWCON
#define W4_SHADOW_PROTECT   (1<<14)
#define W3_SHADOW_PROTECT   (1<<13)
#define W2_SHADOW_PROTECT   (1<<12)
#define W1_SHADOW_PROTECT   (1<<11)
#define W0_SHADOW_PROTECT   (1<<10)
#define W4_SHADOW_UNPROTECT(R)  ((R)&(~(1<<14)))
#define W3_SHADOW_UNPROTECT(R)  ((R)&(~(1<<13)))
#define W2_SHADOW_UNPROTECT(R)  ((R)&(~(1<<12)))
#define W1_SHADOW_UNPROTECT(R)  ((R)&(~(1<<11)))
#define W0_SHADOW_UNPROTECT(R)  ((R)&(~(1<<10)))

// DUALCON
#define DUAL_VDEN_EN        (1<<16)
#define DUAL_VDEN_DIS       (0<<16)
#define DUAL_MAINCOUNT(n)   (((n)&0xFFF)<<17)
#define DUAL_SUBCOUNT(n)    (((n)&0xFFF)<<4)
#define DUAL_LINESPLIT      (0<<2)
#define DUAL_FRAMESPLIT     (1<<2)
#define SINGLE_BYPASS       (0<<0)
#define DUAL_BYPASS         (1<<0)
#define DUAL_MIE            (2<<0)
#define DUAL_MDNIE          (3<<0)
#define DUAL_MASK          (3<<0)

// CMU CLK
#define LCD_OUTPUT_MIE (0<<0)
#define LCD_OUTPUT_MDNIE (1<<0)
#define LCD_OUTPUT_BYPASS (2<<0)
#define LCD_OUTPUT_MASK (3<<0)

typedef struct _tDispAlphaBlendingConfig
{
    unsigned int BlendingMethod;
    union
    {
        struct
        {
            unsigned int AlphaSelect;
            unsigned int Alpha0_Red;
            unsigned int Alpha0_Green;
            unsigned int Alpha0_Blue;
            unsigned int Alpha1_Red;
            unsigned int Alpha1_Green;
            unsigned int Alpha1_Blue;
        };
        struct
        {
            unsigned int ColorKeyValue;
            unsigned int CompareKeyValue;
            unsigned int Direction;
        };
    };
} tDispAlphaBlendingConfig;

typedef struct _tDispWindow0Config
{
    DISP_BPP_MODE BPP_Mode;
    unsigned int LocalPathEnable;
    unsigned int LocaPathSourceFormat;
    unsigned int BufferSelect;
    unsigned int BufferAutoControl;
    unsigned int BitSwapping;
    unsigned int ByteSwapping;
    unsigned int HalfWordSwapping;
    unsigned int WordSwapping;
    unsigned int BurstLength;
    unsigned int uiWidth;
    unsigned int uiHeight;
    unsigned int uiOffsetX;
    unsigned int uiOffsetY;
    unsigned int uiPageWidth;
} tDispWindow0Config;

typedef struct _tDispWindow12Config
{
    DISP_BPP_MODE BPP_Mode;
    unsigned int LocalPathSelect;
    unsigned int LocalPathEnable;
    unsigned int LocaPathSourceFormat;
    unsigned int BufferSelect;
    unsigned int BufferAutoControl;
    unsigned int BitSwapping;
    unsigned int ByteSwapping;
    unsigned int HalfWordSwapping;
    unsigned int WordSwapping;
    unsigned int BurstLength;
    unsigned int uiWidth;
    unsigned int uiHeight;
    unsigned int uiOffsetX;
    unsigned int uiOffsetY;
    unsigned int uiPageWidth;
    tDispAlphaBlendingConfig BlendConfig;
} tDispWindow12Config;

typedef struct _tDispWindow34Config
{
    DISP_BPP_MODE BPP_Mode;
    unsigned int BufferSelect;
    unsigned int BufferAutoControl;
    unsigned int BitSwapping;
    unsigned int ByteSwapping;
    unsigned int HalfWordSwapping;
    unsigned int WordSwapping;
    unsigned int BurstLength;
    unsigned int uiWidth;
    unsigned int uiHeight;
    unsigned int uiOffsetX;
    unsigned int uiOffsetY;
    unsigned int uiPageWidth;
    tDispAlphaBlendingConfig BlendConfig;
} tDispWindow34Config;

#if __cplusplus
}
#endif

#endif    // __DISPLAY_CON_MACRO_H__
