#ifndef __DISPLAY_CON_H__
#define __DISPLAY_CON_H__

#if __cplusplus
extern "C"
{
#endif

#define MINIMUM_VCLK_FOR_TV    6000000
#define DISP_GAMMA_VALUE_NUM    65

#define MPLL_USE (TRUE)
#define MPLL_DIV_VALUE 5  //4-->5   modified by terry 



typedef enum
{
    DISP_VIDOUT_RGBIF,
    DISP_VIDOUT_ITU6xx,
    DISP_VIDOUT_I80IF_LDI0,
    DISP_VIDOUT_I80IF_LDI1,
    DISP_VIDOUT_MODE_NUM
} DISP_VIDOUT_MODE;

typedef enum
{
    DISP_16BIT_RGB565_P = 0,
    DISP_18BIT_RGB666_P,
    DISP_24BIT_RGB888_P,
    DISP_18BIT_RGB666_S,
    DISP_24BIT_RGB888_S
} DISP_RGBIFOUT_MODE;

typedef enum
{
    DISP_ENVID_OFF,
    DISP_ENVID_ON,
    DISP_ENVID_DIRECT_OFF
} DISP_ENVID_ONOFF;

typedef enum
{
    DISP_WINDOW_OFF,
    DISP_WINDOW_ON
} DISP_WINDOW_ONOFF;

typedef enum
{
    DISP_LOCALPATH_OFF,
    DISP_LOCALPATH_ON
} DISP_LOCALPATH_ONOFF;

typedef enum
{
    DISP_FRMINT_BACKPORCH = 0,
    DISP_FRMINT_VSYNC,
    DISP_FRMINT_ACTIVE,
    DISP_FRMINT_FRONTPORCH
} DISP_FRAME_INTERRUPT;

typedef enum
{
    DISP_FIFO_WIN0 = 1<<5,
    DISP_FIFO_WIN1 = 1<<6,
    DISP_FIFO_WIN2 = 1<<9,
    DISP_FIFO_WIN3 = 1<<10,
    DISP_FIFO_WIN4 = 1<<11
} DISP_FIFO_INTERRUPT_WINDOW;

typedef enum
{
    DISP_FIFO_0_25 = 0,
    DISP_FIFO_0_50,
    DISP_FIFO_0_75,
    DISP_FIFO_EMPTY,
    DISP_FIFO_FULL
} DISP_FIFO_INTERRUPT_LEVEL;

typedef enum
{
    DISP_INT_NONE = 0,
    DISP_INT_FRAME = 1<<0,
    DISP_INT_FIFO = 1<<1,
    DISP_INT_I80 = 1<<2
} DISP_INTERRUPT;

typedef enum
{
    DISP_OUTPUT_SINGLE_BYPASS,
    DISP_OUTPUT_DUAL_BYPASS,
    DISP_OUTPUT_MIE,
    DISP_OUTPUT_MODE_NUM
} DISP_VIDOUT_PATH;

typedef enum
{
    DISP_SUCCESS,
    DISP_ERROR_NULL_PARAMETER,
    DISP_ERROR_ILLEGAL_PARAMETER,
    DISP_ERROR_NOT_INITIALIZED,
    DISP_ERROR_NOT_IMPLEMENTED,
    DISP_ERROR_XXX
} DISP_ERROR;


DISP_ERROR Disp_initialize_register_address(void *pDispConReg, void *pGPIOReg,
                        void *pCMUCLKReg, void *pBSPArgs, void *pCMUMISCReg);
DISP_ERROR Disp_set_output_device_information(void *pInfo);
//void* Disp_get_output_device_information_buffer(void);
DISP_ERROR Disp_initialize_output_interface(DISP_VIDOUT_MODE VidoutMode);
DISP_ERROR Disp_set_window_mode(DISP_WINDOW_MODE Mode, DISP_BPP_MODE BPPMode, unsigned int uiWidth, unsigned int uiHeight, unsigned int uiOffsetX, unsigned int uiOffsetY);
DISP_ERROR Disp_set_window_position(DISP_WINDOW Win, unsigned int uiOffsetX, unsigned int uiOffsetY);
DISP_ERROR Disp_set_framebuffer(DISP_WINDOW Win, unsigned int uiFrameBufferAddress);
DISP_ERROR Disp_envid_onoff(DISP_ENVID_ONOFF EnvidOnOff);
BOOL Disp_get_envid_status(void);
BOOL Disp_wait_until_envid_off(unsigned int uiMaxWaitCount);
DISP_ERROR Disp_window_onfoff(DISP_WINDOW Win, DISP_WINDOW_ONOFF WinOnOff);
DISP_ERROR Disp_local_path_off(DISP_WINDOW Win);
DISP_WINDOW_ONOFF Disp_get_window_status(DISP_WINDOW Win);

DISP_ERROR Disp_set_window_color_map(DISP_WINDOW Win, BOOL bOnOff, unsigned int uiColorValue);
DISP_ERROR Disp_set_color_key(DISP_WINDOW Win, BOOL bOnOff, BOOL bBlend, DISP_COLOR_KEY_DIRECTION Direction, unsigned int uiColorKey, unsigned int uiComparekey, unsigned int uiKeyAlpha);
DISP_ERROR Disp_set_alpha_blending(DISP_WINDOW Win, DISP_ALPHA_BLEND_METHOD Method, unsigned int uiAlphaSet0, unsigned int uiAlphaSet1);
// TBD
DISP_ERROR Disp_set_alpha_blending_ex(DISP_WINDOW Win, DISP_ALPHA_BLEND_METHOD Method,
                                            DISP_BLEND_EQ A_BlendEq,
                                            DISP_BLEND_EQ B_BlendEq,
                                            DISP_BLEND_EQ P_BlendEq,
                                            DISP_BLEND_EQ Q_BlendEq,
                                            unsigned int uiAlphaSet0, unsigned int uiAlphaSet1);
DISP_ERROR Disp_set_gamma(BOOL bEnable, PBYTE pbGammaLUT);
DISP_ERROR Disp_set_colorgain(BOOL bEnable, WORD wRGain, WORD wGGain, WORD wBGain);
DISP_ERROR Disp_set_hue(BOOL bEnable, DISP_HUE_CONTROL hueControl);
DISP_ERROR Disp_set_dithering(BOOL bEnable, DISP_DITHER_MODE Mode);
DISP_ERROR Disp_set_alps(BOOL bEnable, DISP_LUX_CONTROL luxControl,
                        unsigned int uiSizeH, unsigned int uiSizeV,
                        unsigned int uiValueSize,
                        unsigned char* pLow_R_LUT,
                        unsigned char* pLow_G_LUT,
                        unsigned char* pLow_B_LUT,
                        unsigned char* pHigh_R_LUT,
                        unsigned char* pHigh_G_LUT,
                        unsigned char* pHigh_B_LUT);


DISP_ERROR Disp_set_frame_interrupt(DISP_FRAME_INTERRUPT FrameInt);
DISP_ERROR Disp_enable_frame_interrupt(void);
DISP_ERROR Disp_disable_frame_interrupt(void);

DISP_ERROR Disp_set_fifo_interrupt(DISP_WINDOW Win, DISP_FIFO_INTERRUPT_LEVEL Level);
DISP_ERROR Disp_enable_fifo_interrupt(void);
DISP_ERROR Disp_disable_fifo_interrupt(void);

DISP_INTERRUPT Disp_clear_interrupt_pending(void);

unsigned int Disp_get_line_count(void);
DISP_VERTICAL_STATUS Disp_get_vertical_status(void);
DISP_HORIZONTAL_STATUS Disp_get_horizontal_status(void);

DISP_WINDOW Disp_get_win_num_from_win_mode(DISP_WINDOW_MODE Mode);

DISP_ERROR Disp_enable_WB_interface(unsigned int uiSkipFrm);
DISP_ERROR Disp_disable_WB_interface(DISP_VIDOUT_PATH eVideoOutPath);

DISP_ERROR Disp_set_window_qos(DISP_WINDOW Win,
                                BOOL bGateEn,
                                unsigned char ucFifoLevel);

DISP_ERROR Disp_set_output_path(DISP_VIDOUT_PATH eVideoOutPath);

#if __cplusplus
}
#endif

#endif    // __DISPLAY_CON_H__
