#ifndef __MIE_CON_H__
#define __MIE_CON_H__

#if __cplusplus
extern "C"
{
#endif

// MIE error codes
typedef enum
{
    MIE_SUCCESS,
    MIE_ERROR_NULL_PARAMETER,
    MIE_ERROR_ILLEGAL_PARAMETER,
    MIE_ERROR_NOT_INITIALIZED,
    MIE_ERROR_NOT_IMPLEMENTED,
    MIE_ERROR_XXX
} MIE_ERROR;

// Enable/Disable
typedef enum
{
    MIE_DISABLE,
    MIE_ENABLE
} MIE_CONTROL;

// Transition control values by frames
typedef enum
{
    MIE_1_FRAME_TRANSITION,
    MIE_2_FRAMES_TRANSITION,
    MIE_4_FRAMES_TRANSITION,
    MIE_8_FRAMES_TRANSITION,
    MIE_16_FRAMES_TRANSITION,
    MIE_24_FRAMES_TRANSITION,
    MIE_32_FRAMES_TRANSITION,
    MIE_40_FRAMES_TRANSITION,
    MIE_48_FRAMES_TRANSITION,
    MIE_56_FRAMES_TRANSITION,
    MIE_64_FRAMES_TRANSITION,
    MIE_65_FRAMES_TRANSITION,
    MIE_72_FRAMES_TRANSITION,
    MIE_96_FRAMES_TRANSITION,
    MIE_128_FRAMES_TRANSITION
} MIE_FRAME_TRANSITION;

// MIE modes
typedef enum
{
    MIE_MODE_OFF,
    MIE_MODE_UI,
    MIE_MODE_STILL,
    MIE_MODE_MOVING
} MIE_MODE;

// RGB order of input pixels
typedef enum
{
    ORDER_RGB,
    ORDER_BGR
} MIE_INPUT_PIXEL_ORDER;

// PWM modes
typedef enum
{
    MIE_PWM_OFF,
    MIE_PWM_MANUAL,
    MIE_PWM_MIE,
    MIE_PWM_MANUAL_MIE
} MIE_PWM_MODE;

// PWM dimming steps
typedef enum
{
    MIE_STEP_32,
    MIE_STEP_64,
    MIE_STEP_128,
    MIE_STEP_256
} MIE_PWM_DIMMING_STEP;

// Mode control
typedef struct
{
    MIE_MODE eMode;
    MIE_CONTROL bDimming;
    MIE_FRAME_TRANSITION eCAT;
    MIE_FRAME_TRANSITION eCST;
} MIE_MODE_CONTROL;

// PWM control
typedef struct
{
    MIE_CONTROL bBLUControl;
    MIE_PWM_MODE ePWMMode;
    MIE_PWM_DIMMING_STEP ePWMDimmingStep;
    UINT8 uiManBr;
    MIE_CONTROL bManBrDimming;
    MIE_FRAME_TRANSITION eManBrDimmingControl;
} MIE_PWM_CONTROL;

// Enhancement control
typedef struct
{
    UINT8 uiIERC;
    UINT8 uiBRRC;
    UINT8 uiSERC;
    MIE_INPUT_PIXEL_ORDER eOrder;
} MIE_ENHANCEMENT_CONTROL;

// MIE functions
MIE_ERROR MIE_initialize_register_address(void *pMIEReg, void *pGPIOReg);
MIE_ERROR MIE_set_output_device_information_ex(void *pInfo);
MIE_ERROR MIE_initialize_RGBIF_ex(void);
MIE_ERROR MIE_set_mode(MIE_MODE_CONTROL modeControl);
MIE_ERROR MIE_set_pwm_control(MIE_PWM_CONTROL pwmControl);
MIE_ERROR MIE_set_enhancement(MIE_ENHANCEMENT_CONTROL enhControl);

#if __cplusplus
}
#endif

#endif    // __MIE_CON_H__
