//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
// Copyright (c) Samsung Electronics. Co. LTD. All rights reserved.

/*++

THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:

    priv_context.h

Abstract:

    The definition of HW context

Functions:


Notes:

--*/

#ifndef __DISP_PRIVATE_CONTEXT_H__
#define __DISP_PRIVATE_CONTEXT_H__

typedef enum
{
    VB_FRONTPORCH =0,
    VB_VSYNC,
    VB_BACKPORCH
} VB_STATUS;

typedef struct _OverlayContext
{
    SMDKSurf *pSurface;        // Current Overlay Surface
    SMDKSurf *pPrevSurface;    // Previous Flipped Overlay Surface

    DWORD       dwWinMode;
    DWORD       dwBPPMode;
    DWORD       dwPostSrcType;
    BOOL        bPostAttached;
    BOOL        bLocalPath;

    unsigned int    uiSrcWidth;
    unsigned int    uiSrcHeight;
    unsigned int    uiSrcOffsetX;
    unsigned int    uiSrcOffsetY;
    unsigned int    uiDstWidth;
    unsigned int    uiDstHeight;
    unsigned int    uiDstOffsetX;
    unsigned int    uiDstOffsetY;
    BOOL        bEnabled;        // TRUE menas FIMD window for Overlay is enabled
    BOOL        bShow;            // TRUE menas Overlay set to SHOW in HalUpdateOverlay()

    // Blending Information
    BOOL        bBlendOn;
    BOOL        bColorKey;        // TRUE measn Color Key, FALSE means Alpha Blending
    BOOL        bColorKeyWithAlpha; // TRUE measn Color Key with Alpha Blending

    // Color Key Information
    BOOL        bSrcCKey;        // TRUE measn SrcCKey, FALSE means DestCKey
    unsigned int    CompareKey;    // Compare Key (Mask)
    unsigned int    ColorKey;        // Color Key (Value)

    // Alpha Blending Information
    BOOL        bUsePixelBlend;    // TRUE means PerPixel Blending, FALSE means PerPlane Blending
    BOOL        bSrcAlpha;        // TRUE means Source Alpha Blending, FALSE means Destination Alpha Blending
    unsigned int    Alpha;            // Alpha Value
} OverlayContext;

// This definition is used for G2D_ACCEL DrvEscape to control 2DHW Acceleration grade
typedef struct _G2D_ACCEL_CONTROL_ARGS{
    unsigned int BltLimitSize;
    unsigned int AllocBoundSize;
    unsigned int AccelLevel;
    unsigned int UseSWAccel;
    unsigned int SetBltLimitSize;
    unsigned int SetAllocBound;
    unsigned int UsePACSurf;
    unsigned int UseCloneBuffer;
    unsigned int UseHWAccel;
    unsigned int UseForceSetPallete;
    unsigned int UseCachedVideoMemory;
    unsigned int UseCacheFlushForVideoMemory;
} G2D_ACCEL_CONTROL_ARGS;

#ifndef DRVESC_GET_FB_PHY_ADDR
#define DRVESC_GET_FB_PHY_ADDR        (0x00020100)
#endif

#ifndef DRVESC_G2D_ACCEL_SET
#define DRVESC_G2D_ACCEL_SET      (0x00020200)
#endif
#ifndef DRVESC_G2D_ACCEL_GET
#define DRVESC_G2D_ACCEL_GET        (0x00020101)
#endif

#ifndef GETRAWFRAMEBUFFER
#define GETRAWFRAMEBUFFER       (0x00020001)
#define RAW_FORMAT_565          (1)
#define RAW_FORMAT_555          (2)
#define RAW_FORMAT_OTHER        (3)
typedef struct _RawFrameBufferInfo
{
    WORD    wFormat;
    WORD    wBPP;
    VOID    *pFramePointer;
    int        cxStride;
    int        cyStride;
    int        cxPixels;
    int        cyPixels;
} RawFrameBufferInfo;
#endif

#define PALETTE_MEMORY_SIZE             (0x400)
#define WIN0_PALETTE_MEMORY_PA_START    (BASE_REG_PA_LCDC+PALETTE_MEMORY_SIZE)
#define WIN1_PALETTE_MEMORY_PA_START    (WIN0_PALETTE_MEMORY_PA_START+PALETTE_MEMORY_SIZE)
#define WIN2_PALETTE_MEMORY_PA_START    (WIN1_PALETTE_MEMORY_PA_START+PALETTE_MEMORY_SIZE)
#define WIN3_PALETTE_MEMORY_PA_START    (WIN2_PALETTE_MEMORY_PA_START+PALETTE_MEMORY_SIZE)
#define WIN4_PALETTE_MEMORY_PA_START    (WIN3_PALETTE_MEMORY_PA_START+PALETTE_MEMORY_SIZE)

#endif __DISP_PRIVATE_CONTEXT_H__