/*
 * Project Name Codec Memory Management DRIVER IN WINCE
 * Copyright  2007 Samsung Electronics Co, Ltd. All Rights Reserved. 
 *
 * This software is the confidential and proprietary information
 * of Samsung Electronics  ("Confidential Information").   
 * you shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Samsung Electronics 
 *
 * This file implements JPEG driver.
 *
 * @name  Codec Memory Management DRIVER MODULE Module (CMMDriver.c)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 23-04-08
 */
 
#include <windows.h>
#include <pmplatform.h>
//#define DEBUG    1

static HANDLE    hMutex;

/*----------------------------------------------------------------------------
*Function: CreateCMMmutex
*Implementation Notes: Create Mutex handle 
-----------------------------------------------------------------------------*/
HANDLE CreateCMMmutex(void)
{

    hMutex = CreateMutex( NULL,                       // default security attributes
                          FALSE,                      // initially not owned
                          NULL);                      // unnamed mutex
    
    return hMutex;
}

/*----------------------------------------------------------------------------
*Function: LockCMMMutex
*Implementation Notes: lock mutex 
-----------------------------------------------------------------------------*/
DWORD LockCMMMutex(void)
{
    DWORD                Status;
        

    Status = WaitForSingleObject(hMutex, INFINITE);
    if(Status == WAIT_OBJECT_0) 
    {
        Status = TRUE;
    } 
    else 
    {
        Status = GetLastError();
        RETAILMSG(1,(TEXT("DD::MUTEX LOCK ERROR : %d\r\n"),Status));
        Status = FALSE;
    }
    
      
    return Status;
}

/*----------------------------------------------------------------------------
*Function: UnlockCMMMutex
*Implementation Notes: unlock mutex
-----------------------------------------------------------------------------*/
DWORD UnlockCMMMutex(void)
{
    DWORD                Status;
   
    Status = ReleaseMutex(hMutex);
    if(Status != TRUE) 
    {
        Status = GetLastError();
        RETAILMSG(1,(TEXT("DD::MUTEX UNLOCK ERROR : %d\r\n"),Status));
        
    }
          
    return Status;
}

/*----------------------------------------------------------------------------
*Function: DeleteCMMMutex
*Implementation Notes: delete mutex handle 
-----------------------------------------------------------------------------*/
void DeleteCMMMutex(void)
{
    if (hMutex == NULL)
        return;

    CloseHandle(hMutex);
}



/*----------------------------------------------------------------------------
*Function: printD

*Parameters:         fmt        :
*Implementation Notes: Debug print
-----------------------------------------------------------------------------*/
void printD(char* fmt, ...) 
{
#ifdef DEBUG
    char str[512];

    vsprintf(str, fmt, (char *)(&fmt+1));
    printf(str);

#endif
}

