#ifndef _CEC_REG_H_
#define _CEC_REG_H_

#if __cplusplus
extern "C"
{
#endif

//TODO: move to PLATFORM\SMDKV210\SRC\INC\base_regs.h
#define BASE_REG_PA_CEC 0xE1B00000

typedef struct {
    DWORD STATUS_0;        // 0x0000
    DWORD STATUS_1;        // 0x0004
    DWORD STATUS_2;        // 0x0008
    DWORD STATUS_3;        // 0x000C
    DWORD IRQ_MASK;        // 0x0010
    DWORD IRQ_CLEAR;       // 0x0014
    DWORD RESERVED0[2];    // 0x0018, 0x001C
    DWORD LOGIC_ADDR;      // 0x0020
    DWORD RESERVED1[3];    // 0x0024...0x002C
    DWORD DIVISOR_0;       // 0x0030
    DWORD DIVISOR_1;       // 0x0034
    DWORD DIVISOR_2;       // 0x0038
    DWORD DIVISOR_3;       // 0x003C
    DWORD TX_CTRL;         // 0x0040
    DWORD TX_BYTES;        // 0x0044
    DWORD RESERVED2[6];    // 0x0048...0x005C
    DWORD TX_STAT0;        // 0x0060
    DWORD TX_STAT1;        // 0x0064
    DWORD RESERVED3[6];    // 0x0068...0x007C
    DWORD TX_BUFF[16];     // 0x0080...0x00BC
    DWORD RX_CTRL;         // 0x00C0
    DWORD RESERVED4[7];    // 0x00C4...0x00DC
    DWORD RX_STAT0;        // 0x00E0
    DWORD RX_STAT1;        // 0x00E4
    DWORD RESERVED5[6];    // 0x00E8...0x00FC
    DWORD RX_BUFF[16];     // 0x0100...0x013C
    DWORD RESERVED6[16];   // 0x0140...0x017C
    DWORD RX_FILTER_CTRL;  // 0x0180
    DWORD RX_FILTER_TH;    // 0x0184
} CEC_REGS, *PCEC_REG;

#define CEC_STATUS_TX_RUNNING       (1<<0)
#define CEC_STATUS_TX_TRANSFERRING  (1<<1)
#define CEC_STATUS_TX_DONE          (1<<2)
#define CEC_STATUS_TX_ERROR         (1<<3)
#define CEC_STATUS_TX_BYTES         (0xFF<<8)
#define CEC_STATUS_RX_RUNNING       (1<<16)
#define CEC_STATUS_RX_RECEIVING     (1<<17)
#define CEC_STATUS_RX_DONE          (1<<18)
#define CEC_STATUS_RX_ERROR         (1<<19)
#define CEC_STATUS_RX_BCAST         (1<<20)
#define CEC_STATUS_RX_BYTES         (0xFF<<24)

#define CEC_IRQ_TX_DONE             (1<<0)
#define CEC_IRQ_TX_ERROR            (1<<1)
#define CEC_IRQ_RX_DONE             (1<<4)
#define CEC_IRQ_RX_ERROR            (1<<5)

#define CEC_TX_CTRL_START           (1<<0)
#define CEC_TX_CTRL_BCAST           (1<<1)
#define CEC_TX_CTRL_RETRY           (0x04<<4)
#define CEC_TX_CTRL_RESET           (1<<7)

#define CEC_RX_CTRL_ENABLE          (1<<0)
#define CEC_RX_CTRL_RESET           (1<<7)

/** CEC Rx buffer size */
#define CEC_RX_BUFF_SIZE     16
/** CEC Tx buffer size */
#define CEC_TX_BUFF_SIZE     16

// magic number?
#define CEC_FILTER_THRESHOLD        0x15


#if __cplusplus
}
#endif

#endif // _CEC_REG_H_
