#include <precomp.h>

PostPowerContext PowerManageCtxt[COUNT_CAMERA_IP];
extern CAMIFPostIF oPostIF[COUNT_CAMERA_IP];


void CAM_initialize_post_power_context(DWORD uCamID)
{
    DBGMSG(CIF_FUNC && CIF_USR4, (_T("[CAM] %s()[uCamID=%d]\r\n"),_T(__FUNCTION__),uCamID ));

    BOOL bRet = TRUE;

    memset(&PowerManageCtxt[uCamID], 0x0, sizeof(PostPowerContext));

    PowerManageCtxt[uCamID].bPowerOn = TRUE;    // Initially Power On

    // Invalidate All Stored Values
    PowerManageCtxt[uCamID].bPostStart = FALSE;
}

void CAM_deinitialize_post_power_context(DWORD uCamID)
{
    // Currently, Power Context is static global variable
    // So, we don't need to any deinit procedure
    DBGMSG(CIF_FUNC && CIF_USR4, (_T("[CAM] %s()\r\n"), _T(__FUNCTION__)));
    return;
}

// This function will be called on Wakup Time.
void CAM_post_power_on(DWORD uCamID)
{
    DBGMSG(CIF_FUNC && CIF_USR4, (_T("[CAM] ++%s()[uCamID = %d]\r\n"), _T(__FUNCTION__),uCamID));

    if (PowerManageCtxt[uCamID].bPowerOn)
    {
        DBGMSG(CIF_FUNC && CIF_USR4, (_T("[CAM:INF] %s() : Video Engine is Already Power On\r\n"), _T(__FUNCTION__)));
        goto CleanUp;
    }

    //---------------------------
    // Post Processor Reconfiguration
    //---------------------------

    if (PowerManageCtxt[uCamID].bPostStart)
    {
//Post Queue Thread Start

//        if(!oPostIF[uCamID].m_pWorkingCtxt->bPostProcessDone)
//            oPostIF[uCamID].Post_Start( oPostIF[uCamID].m_pWorkingCtxt );

        if(oPostIF[uCamID].m_pWorkingCtxt->tPostParam.dwDstType == POST_DST_FIFO_RGB888 ||
            oPostIF[uCamID].m_pWorkingCtxt->tPostParam.dwDstType == POST_DST_FIFO_YUV444) // Local Path
        {
            DBGMSG(CIF_FUNC && CIF_USR4, (_T("[CAM] --%s() Local Path doesn't be supported!!\r\n"), _T(__FUNCTION__)));
        }
        else
        {
            if(oPostIF[uCamID].m_pWorkingCtxt->tPostParam.dwSrcType == POST_SRC_FIFO_YUV444) // WriteBack
        {
                oPostIF[uCamID].Post_Start(oPostIF[uCamID].m_pWorkingCtxt);
        }
            else // Mem to Mem mode
        {
                oPostIF[uCamID].ThreadStart();
            }
        }

    }

    //-------------------
    // Update Power State
    //-------------------
    PowerManageCtxt[uCamID].bPowerOn = TRUE;

CleanUp:

    DBGMSG(CIF_FUNC && CIF_USR4, (_T("[CAM] --%s()\r\n"), _T(__FUNCTION__)));

}

void CAM_post_power_off(DWORD uCamID)
{
    DBGMSG(CIF_FUNC && CIF_USR4, (_T("[CAM] ++%s()\r\n"), _T(__FUNCTION__)));

    if (!PowerManageCtxt[uCamID].bPowerOn)
    {
        DBGMSG(CIF_FUNC && CIF_USR4,(_T("[CAM:INF] %s() : Video Engine is Already Power Off\r\n"), _T(__FUNCTION__)));
        goto CleanUp;
    }

    //-----------------------
    // Disable Video Engine HW
    //-----------------------

    if (PowerManageCtxt[uCamID].bPostStart)
    {
        // Disable All Interrupt
        oPostIF[uCamID].DisableInterrupt();

        // Clear All Interrupt Pending
        oPostIF[uCamID].ClearInterruptPending();

        // Disable Post Processor Operation
        if (PowerManageCtxt[uCamID].bPostStart)
        {

            oPostIF[uCamID].SetAutoload(FALSE);
            oPostIF[uCamID].ProcessingStop();
        }

        if(oPostIF[uCamID].m_pWorkingCtxt->tPostParam.dwDstType == POST_DST_FIFO_RGB888 ||
            oPostIF[uCamID].m_pWorkingCtxt->tPostParam.dwDstType == POST_DST_FIFO_YUV444) // Local Path
        {
            DBGMSG(CIF_FUNC && CIF_USR4, (_T("[CAM] --%s() Local Path doesn't be supported!!\r\n"), _T(__FUNCTION__)));
        }
        else
        {
            if(oPostIF[uCamID].m_pWorkingCtxt->tPostParam.dwSrcType != POST_SRC_FIFO_YUV444) // Mem to Mem mode
            {
//Post Queue Thread Stop
                oPostIF[uCamID].ThreadStop();
            }
        }
    }

    //----------------------
    // Clear Command Context
    //----------------------

    //-------------------
    // Update Power State
    //-------------------
    PowerManageCtxt[uCamID].bPowerOn = FALSE;

CleanUp:

    DBGMSG(CIF_FUNC && CIF_USR4, (_T("[CAM] --%s()\r\n"), _T(__FUNCTION__)));
}
