#include <precomp.h>

////static CAMPostContext PostManager[COUNT_CAMERA_IP];
static PostContextManager PostCtxtMan[COUNT_CAMERA_IP][MAX_Q_NUMBER];
extern PostPowerContext PowerManageCtxt[COUNT_CAMERA_IP];
CAMIFPostIF oPostIF[COUNT_CAMERA_IP];

static DWORD CAM_wait_post_cmd_done(UINT32 uCamID)
{
    return WaitForSingleObject(oPostIF[uCamID].m_PostIntDoneEvent, CAM_POST_CMD_TIMEOUT);
}

void CAM_initialize_context(UINT32 uCamID, CameraHal *pCameraHal)
{
    DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM:POST] ++%s()\r\n"), _T(__FUNCTION__)));

    // Clear Context
////    memset(&PostManager[uCamID], 0x0, sizeof(CAMPostContext));
    memset(&PostCtxtMan[uCamID], 0x0, sizeof(PostContextManager)*MAX_Q_NUMBER);

    // Post Processor Command Context
    InitializeCriticalSection(&PowerManageCtxt[uCamID].csLockShadow);

////    PostManager[uCamID].dwProcessCnt = 0;
    // Command Event

    oPostIF[uCamID].m_uCamID = uCamID;
    oPostIF[uCamID].pCameraIF = pCameraHal;

    oPostIF[uCamID].pCameraIF->SetPostEvent(oPostIF[uCamID].m_PostIntDoneEvent);

    PowerManageCtxt[uCamID].bPostStart = FALSE;

    DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM:POST] --%s()\r\n"), _T(__FUNCTION__)));
}


void CAM_deinitialize_context(UINT32 uCamID)
{
    DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM:POST] ++%s()\r\n"), _T(__FUNCTION__)));

    // Post Processor Command Context
    DeleteCriticalSection(&PowerManageCtxt[uCamID].csLockShadow);

//    delete oPostIF[uCamID].pCAMIF;

    DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM:POST] --%s()\r\n"), _T(__FUNCTION__)));
}

BOOL CAM_Post_API_Proc(
    PHW_OPEN_INFO pOpenHead,
    DWORD dwCode,
    PBYTE pBufIn,
    DWORD dwLenIn,
    PBYTE pBufOut,
    DWORD dwLenOut,
    PDWORD pdwActualOut
    )
{
    BOOL bRet = TRUE;
    PHW_INDEP_INFO  pCAMHead = pOpenHead->pCamHead;
    PCTX_CAMERA  pCtxCamera = pCAMHead->pCtxCamera;
    UINT32 uCamID = pCtxCamera->uCamID;
    PostProcContext *PostCtxt = &pOpenHead->PostCtxt;
    PostProcContext *TempCtxt = NULL;
    int cnt = 0;
    BOOL bIsStop = FALSE;
    DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] ++%s()\n\r"), _T(__FUNCTION__)));
#ifdef USE_FIMC_LOCALPATH
    if(pCtxCamera->pOccupantCam != pOpenHead)
    {
         ERRMSG((TEXT("[CAM] %s(): dwCode:0x%08x, No access, OpenContext 0x%08x already has resource CAM%d\n"), _T(__FUNCTION__), dwCode, (DWORD)pCtxCamera->pOccupantCam, pCtxCamera->uCamID));
         return FALSE;
    }
#endif
    //--------------------------------
    // Processing IOCTL for post Processor
    //--------------------------------
    switch(dwCode)
    {
        case CAM_POST_SET_PROCESSING_PARAM:
        {
            CAMARG_POST_PARAMETER *pArg;

            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] %s() : CAM_POST_SET_PROCESSING_PARAM\n\r"), _T(__FUNCTION__)));

            if(!pBufIn)
            {
                ERRMSG((TEXT("Invalid Buffer : pBufIn:0x%x\n"), pBufIn));
                bRet = FALSE;
                break;
            }

            pArg = (CAMARG_POST_PARAMETER *)pBufIn;

            // Backup for PM
            //memcpy(&PowerManageCtxt[uCamID].tPostParam, pArg, sizeof(CAMARG_POST_PARAMETER));
            memcpy(&PostCtxt->tPostParam, pArg, sizeof(CAMARG_POST_PARAMETER));

            PostCtxt->bPostParam = TRUE;
            break;
        }

        case CAM_POST_SET_SOURCE_BUFFER:
        {
            CAMARG_POST_BUFFER *pArg;

            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_SET_SOURCE_BUFFER\n\r")));

            if(!pBufIn || dwLenIn < sizeof(CAMARG_POST_BUFFER))
            {
                ERRMSG((TEXT("Invalid Buffer : pBufIn:0x%x\n"), pBufIn));
                bRet = FALSE;
                break;
            }

            pArg = (CAMARG_POST_BUFFER *)pBufIn;

            // Backup for PM
            memcpy(&PostCtxt->tPostSrcBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            PostCtxt->bPostSrcBuffer = TRUE;

            break;
        }
        // This IOCTL is sensitive for timing, so do not use DebugMessage to see the parameter
        case CAM_POST_SET_NEXT_SOURCE_BUFFER:
        {
            CAMARG_POST_BUFFER *pArg;

            DBGMSG(POST_FUNC && POST_USR1,  (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_SET_NEXT_SOURCE_BUFFER\n\r")));
            if(!pBufIn || dwLenIn < sizeof(CAMARG_POST_BUFFER))
            {
                ERRMSG((TEXT("Invalid Buffer : pBufIn:0x%x\n"), pBufIn));
                bRet = FALSE;
                break;
            }
            pArg = (CAMARG_POST_BUFFER *)pBufIn;

            if (PowerManageCtxt[uCamID].bPowerOn && PowerManageCtxt[uCamID].bPostStart)
            {
                // Camera Register has shadow Register, This value will autofetched when DMA end.
                EnterCriticalSection(&PowerManageCtxt[uCamID].csLockShadow);
                if(oPostIF[uCamID].SetNextSourceBuffer(pArg->dwBufferRGBY, \
                            pArg->dwBufferCb, pArg->dwBufferCr) != POST_SUCCESS)
                {
                    ERRMSG( (_T("[CAM:ERR] CAM_Post_API_Proc() : CAM_POST_SET_NEXT_SOURCE_BUFFER : SetNextSourceBuffer error! = %d\n\r")));
                    bRet = FALSE;
                    break;
                }
                LeaveCriticalSection(&PowerManageCtxt[uCamID].csLockShadow);
            }

            // Backup for PM
            memcpy(&PostCtxt[uCamID].tPostSrcBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            PostCtxt[uCamID].bPostSrcBuffer = TRUE;

            break;
        }

        case CAM_POST_SET_DESTINATION_BUFFER:
        {
            CAMARG_POST_BUFFER *pArg;

            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_BUFFER\n\r")));
            if(!pBufIn || dwLenIn < sizeof(CAMARG_POST_BUFFER))
            {
                ERRMSG((TEXT("Invalid Buffer : pBufIn:0x%x\n"), pBufIn));
                bRet = FALSE;
                break;
            }
            pArg = (CAMARG_POST_BUFFER *)pBufIn;

            // Backup for PM
            //memcpy(&PowerManageCtxt[uCamID].tPostDstBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            memcpy(&PostCtxt->tPostDst1stBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            memcpy(&PostCtxt->tPostDst2ndBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            memcpy(&PostCtxt->tPostDst3rdBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            memcpy(&PostCtxt->tPostDst4thBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            PostCtxt->bPostDstBuffer = TRUE;
            DBGMSG(POST_FUNC && POST_USR1, (_T("--[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_BUFFER\n\r")));

            break;
        }

        case CAM_POST_SET_DESTINATION_1ST_BUFFER:
        {
            CAMARG_POST_BUFFER *pArg;

            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_1ST_BUFFER\n\r")));
            if(!pBufIn || dwLenIn < sizeof(CAMARG_POST_BUFFER))
            {
                ERRMSG((TEXT("Invalid Buffer : pBufIn:0x%x\n"), pBufIn));
                bRet = FALSE;
                break;
            }

            pArg = (CAMARG_POST_BUFFER *)pBufIn;

            // Backup for PM
            memcpy(&PostCtxt->tPostDst1stBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            PostCtxt->bPostDstBuffer = TRUE;
            DBGMSG(POST_FUNC && POST_USR1, (_T("--[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_1ST_BUFFER\n\r")));

            break;
        }

        case CAM_POST_SET_DESTINATION_2ND_BUFFER:
        {
            CAMARG_POST_BUFFER *pArg;

            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_2ND_BUFFER\n\r")));
            if(!pBufIn || dwLenIn < sizeof(CAMARG_POST_BUFFER))
            {
                ERRMSG((TEXT("Invalid Buffer : pBufIn:0x%x\n"), pBufIn));
                bRet = FALSE;
                break;
            }
            pArg = (CAMARG_POST_BUFFER *)pBufIn;

            // Backup for PM
            memcpy(&PostCtxt->tPostDst2ndBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            PostCtxt->bPostDstBuffer = TRUE;
            DBGMSG(POST_FUNC && POST_USR1, (_T("--[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_2ND_BUFFER\n\r")));

            break;
        }

        case CAM_POST_SET_DESTINATION_3RD_BUFFER:
        {
            CAMARG_POST_BUFFER *pArg;

            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_3RD_BUFFER\n\r")));
            if(!pBufIn || dwLenIn < sizeof(CAMARG_POST_BUFFER))
            {
                ERRMSG((TEXT("Invalid Buffer : pBufIn:0x%x\n"), pBufIn));
                bRet = FALSE;
                break;
            }
            pArg = (CAMARG_POST_BUFFER *)pBufIn;

            // Backup for PM
            memcpy(&PostCtxt->tPostDst3rdBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            PostCtxt->bPostDstBuffer = TRUE;
            DBGMSG(POST_FUNC && POST_USR1, (_T("--[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_3RD_BUFFER\n\r")));

            break;
        }

        case CAM_POST_SET_DESTINATION_4TH_BUFFER:
        {
            CAMARG_POST_BUFFER *pArg;

            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_4TH_BUFFER\n\r")));
            if(!pBufIn || dwLenIn < sizeof(CAMARG_POST_BUFFER))
            {
                ERRMSG((TEXT("Invalid Buffer : pBufIn:0x%x\n"), pBufIn));
                bRet = FALSE;
                break;
            }
            pArg = (CAMARG_POST_BUFFER *)pBufIn;

            // Backup for PM
            memcpy(&PostCtxt->tPostDst4thBuffer, pArg, sizeof(CAMARG_POST_BUFFER));
            PostCtxt->bPostDstBuffer = TRUE;
            DBGMSG(POST_FUNC && POST_USR1, (_T("--[CAM] CAM_Post_API_Proc() : CAM_POST_SET_DESTINATION_4TH_BUFFER\n\r")));

            break;
        }

        case CAM_POST_SET_PROCESSING_START:
        {
            DBGMSG(POST_FUNC && POST_USR1, (_T("\n\n1 [POST] CAM_Post_API_Proc() : CAM_POST_SET_PROCESSING_START\n\r")));

            if (PowerManageCtxt[uCamID].bPowerOn)
            {
                if(PostCtxt->tPostParam.dwDstType == POST_DST_FIFO_RGB888 ||
                    PostCtxt->tPostParam.dwDstType == POST_DST_FIFO_YUV444) // Local Path
                {
#ifndef USE_FIMC_LOCALPATH
                    DBGMSG(POST_FUNC && POST_USR1, (_T("[POST:ERR] CAM_Post_API_Proc() : CAM_POST_SET_PROCESSING_START(%d) : Local Path doesn't be supported! \n\r"),uCamID));
                    bRet = FALSE;
#else
                    oPostIF[uCamID].Post_Start(PostCtxt);
                    // Backup for PM
                    PowerManageCtxt[uCamID].bPostStart = TRUE;
                    PostCtxt->bPostStart = TRUE;
                    PostCtxtMan[uCamID][PostCtxt->dwContextNum].dwIsProcessing = TRUE;
#endif
               }
                else
                {
                    if(PostCtxt->tPostParam.dwSrcType == POST_SRC_FIFO_YUV444) // WriteBack
                    {
                        oPostIF[uCamID].Post_Start(PostCtxt);
                    }
                    else // Mem to Mem mode
                {
                        PostCtxt->bPostProcessDone = 0;

                        oPostIF[uCamID].m_PQ.Enqueue(PostCtxt);

                        DBGMSG(POST_FUNC && POST_USR4 ,(_T("[POST] ++%s() SetEvent Post Request Event \n\r"), _T(__FUNCTION__)));
                        SetEvent(oPostIF[uCamID].m_PostRequestEvent);
                }


            // Backup for PM
            PowerManageCtxt[uCamID].bPostStart = TRUE;
            PostCtxt->bPostStart = TRUE;
            PostCtxtMan[uCamID][PostCtxt->dwContextNum].dwIsProcessing = TRUE;

            }
            }

            break;
        }

        case CAM_POST_SET_PROCESSING_STOP:
        {
            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_SET_PROCESSING_STOP\n\r")));

            if (PowerManageCtxt[uCamID].bPowerOn)
            {
                if(PostCtxt->tPostParam.dwDstType == POST_DST_FIFO_RGB888 ||
                    PostCtxt->tPostParam.dwDstType == POST_DST_FIFO_YUV444) // Local Path
                {
#ifndef USE_FIMC_LOCALPATH
                    DBGMSG(POST_FUNC && POST_USR1, (_T("[POST:ERR] CAM_Post_API_Proc() : CAM_POST_SET_PROCESSING_STOP(%d) : Local Path doesn't be supported! \n\r"),uCamID));
                    bRet = FALSE;
#else
                    oPostIF[uCamID].SetAutoload(FALSE);

                    if (oPostIF[uCamID].GetProcessingState() == POST_BUSY)        // Post Processor Running
                    {
                        // Wait for Current Frame Finished
                        if (WAIT_TIMEOUT == CAM_wait_post_cmd_done(uCamID))
                        {
                            if (oPostIF[uCamID].GetProcessingState() == POST_IDLE)
                            {
                                // Time Out, But Post Processor Finished
                                DBGMSG(POST_FUNC && POST_USR1, (_T("[POST] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE : CAM_wait_post_cmd_done(%d) TimeOut, But Post Processor Finished\n\r"),uCamID));
                            }
                            else
                            {
                                DBGMSG(POST_FUNC && POST_USR1,(_T("[POST:INF] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE : CAM_wait_post_cmd_done(%d) TimeOut\n\r"),uCamID));
                                oPostIF[uCamID].ProcessingStop();
                            }
                        }
                    }
                    else
                {
                        oPostIF[uCamID].ProcessingStop();
                    }
                    PostCtxtMan[uCamID][PostCtxt->dwContextNum].dwIsProcessing = FALSE;
                    PowerManageCtxt[uCamID].bPostStart = FALSE;

                    PostCtxt->bPostStart = FALSE;
                    PostCtxt->bPostDstBuffer = FALSE;
                    PostCtxt->bPostSrcBuffer = FALSE;
                    PostCtxt->bPostParam = FALSE;
#endif
                }
                else
                {
                    if(PostCtxt->tPostParam.dwSrcType == POST_SRC_FIFO_YUV444) // WriteBack
                    {
                        oPostIF[uCamID].SetAutoload(FALSE);

                        if (oPostIF[uCamID].GetProcessingState() == POST_BUSY)        // Post Processor Running
                        {
                            // Wait for Current Frame Finished
                            if (WAIT_TIMEOUT == CAM_wait_post_cmd_done(uCamID))
                            {
                                if (oPostIF[uCamID].GetProcessingState() == POST_IDLE)
                                {
                                    // Time Out, But Post Processor Finished
                                    DBGMSG(POST_FUNC && POST_USR1, (_T("[POST] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE : CAM_wait_post_cmd_done(%d) TimeOut, But Post Processor Finished\n\r"),uCamID));
                                }
                                else
                                {
                                    DBGMSG(POST_FUNC && POST_USR1,(_T("[POST:INF] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE : CAM_wait_post_cmd_done(%d) TimeOut\n\r"),uCamID));
                                    oPostIF[uCamID].ProcessingStop();
                                }
                            }
                        }
                        else
                        {
                            oPostIF[uCamID].ProcessingStop();
                        }
                        PostCtxtMan[uCamID][PostCtxt->dwContextNum].dwIsProcessing = FALSE;
                        PowerManageCtxt[uCamID].bPostStart = FALSE;
                    }
                    else // Mem to Mem mode
                    {
                        if( 0 == PostCtxt->bPostProcessDone )
                        {
                            DBGMSG(POST_FUNC && POST_USR1, (_T("7 [POST] CAM_Post_API_Proc() : CAM_POST_SET_PROCESSING_STOP : WaitProcessDone(%d) Done handle = 0x%x\n\r"),uCamID, PostCtxt->hPostCmdDone));

                            ResetEvent(PostCtxt->hPostCmdDone);
                            if (WAIT_TIMEOUT == oPostIF[uCamID].WaitProcessDone(PostCtxt->hPostCmdDone))
                            {
                                DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM:INF] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE : WaitProcessDone(%d) TimeOut\n\r"),uCamID));
                                bRet = FALSE;
                            }
                        }

                        ResetEvent(PostCtxt->hPostCmdDone);

                        PostCtxtMan[uCamID][PostCtxt->dwContextNum].dwIsProcessing = FALSE;
                        bIsStop = TRUE;

                        // check what ctxt is working
                        for(cnt = 0 ; cnt <= pCAMHead->OpenCnt ; cnt++)
                        {
                            DBGMSG(1, (_T("[POST] bIsStop is checking opencnt = %d\n\r"),pCAMHead->OpenCnt));
                            if(PostCtxtMan[uCamID][cnt].dwIsProcessing == TRUE)
                                bIsStop = FALSE;
                        }

                        if(bIsStop)
                        {
                            DBGMSG(1, (_T("[POST] bIsStop is TRUE So REAL STOP FIMC IP \n\r")));
                            oPostIF[uCamID].SetAutoload(FALSE);
                            oPostIF[uCamID].ProcessingStop();

                            PowerManageCtxt[uCamID].bPostStart = FALSE;
                        }

                        DBGMSG(POST_FUNC && POST_USR1, (_T("7 [POST] CAM_Post_API_Proc() : CAM_POST_SET_PROCESSING_STOP : End \n\r")));
                }

                PostCtxt->bPostStart = FALSE;
                PostCtxt->bPostDstBuffer = FALSE;
                PostCtxt->bPostSrcBuffer = FALSE;
                PostCtxt->bPostParam = FALSE;

            }

            }


            break;
        }

        case CAM_POST_WAIT_PROCESSING_DONE:
        {
            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE\n\r")));

            if (PowerManageCtxt[uCamID].bPowerOn)
            {

                if(PostCtxt->tPostParam.dwDstType == POST_DST_FIFO_RGB888 ||
                    PostCtxt->tPostParam.dwDstType == POST_DST_FIFO_YUV444) // Local Path ( not supported )
                {
#ifndef USE_FIMC_LOCALPATH
                    DBGMSG(POST_FUNC && POST_USR1, (_T("[POST:ERR] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE(%d) : Local Path doesn't be supported! \n\r"),uCamID));
#else
                    DBGMSG(POST_FUNC && POST_USR1, (_T("[POST:ERR] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE(%d) : Local Path doesn't need this IOCTL! \n\r"),uCamID));
#endif
                    bRet = FALSE;
                }
                else
                        {
                    if(PostCtxt->tPostParam.dwSrcType == POST_SRC_FIFO_YUV444) // WriteBack
                            {
                            if (WAIT_TIMEOUT == CAM_wait_post_cmd_done(uCamID))
                            {
                                if (oPostIF[uCamID].GetProcessingState() == POST_IDLE)
                                {
                                    // Time Out, But Post Processor Finished
                                    DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE : CAM_wait_post_cmd_done(%d) TimeOut, But Post Processor Finished\n\r"),uCamID));
                                }
                                else
                                {
                                    DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM:INF] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE : CAM_wait_post_cmd_done(%d) TimeOut\n\r"),uCamID));
                                    bRet = FALSE;
                                }
                            }
                    }
                    else // Mem to Mem mode
                    {
                        if( 0 == PostCtxt->bPostProcessDone )
                        {
                            DBGMSG(POST_FUNC && POST_USR1, (_T("[POST] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE : CAM_wait_post_cmd_done(%d) Done handle = 0x%x\n\r"),uCamID, PostCtxt->hPostCmdDone));
                            ResetEvent(PostCtxt->hPostCmdDone);
                            if (WAIT_TIMEOUT == oPostIF[uCamID].WaitProcessDone(PostCtxt->hPostCmdDone))
                            {
                                DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM:INF] CAM_Post_API_Proc() : CAM_POST_WAIT_PROCESSING_DONE : CAM_wait_post_cmd_done(%d) TimeOut\n\r"),uCamID));
                                bRet = FALSE;
                            }
                        }
                    }
                }
            }
            break;
        }

        case CAM_POST_GET_PROCESSING_STATUS:
        {
            DWORD *pArg;

            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] CAM_Post_API_Proc() : CAM_POST_GET_PROCESSING_STATUS\n\r")));

            pArg = (DWORD *)pBufOut;

            if (PowerManageCtxt[uCamID].bPowerOn)
            {
                *pArg = oPostIF[uCamID].GetProcessingState();
            }
            else
            {
                *pArg = POST_IDLE;
            }

            *pdwActualOut = sizeof(DWORD);

            break;
        }
        case CAM_POST_RESUME:
        {
            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] %s() : CAM_POST_RESUME\n\r"), _T(__FUNCTION__)));

            CAM_post_power_on(uCamID);

            break;
        }
        case CAM_POST_SUSPEND:
        {
            DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] %s() : CAM_POST_SUSPEND\n\r"), _T(__FUNCTION__)));

            CAM_post_power_off(uCamID);

            break;

        }
        default:    // This is filtered above switch statement
            bRet = FALSE;
            break;
    }

    DBGMSG(POST_FUNC && POST_USR1, (_T("[CAM] --%s()\n\r"), _T(__FUNCTION__)));

    return bRet;
}
