//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    s5x532.h

Abstract:       OV2655 Camera module setting binary microcode sequence

Functions:


Notes:


--*/

//#ifndef _S5X532_H_
//#define _S5X532_H_

#define SIMPLE_MODULE_SETTING   (FALSE)
#define MODULE_COMMAND_SIZE     (2)

/* S/W defined features for tune */
#define REG_DELAY	0x0000	/* in ms */
#define REG_CMD		0xFFFF	/* Followed by command */
#define REG_ID		0x8899	/* Followed by command */


#if (SIMPLE_MODULE_SETTING)
//const
unsigned char OV2655_YCbCr8bit[][MODULE_COMMAND_SIZE] =
{
  {0xfc, 0x01},
    {0x03, 0x01}, // sw reset

    {0xfc, 0x01},
    {0x04, 0x01},

    {0xfc, 0x02},
    {0x52, 0x80}, // pll_m

    {0xfc, 0x02},
    {0x50, 0x54},

    {0xfc, 0x00},
    {0x02, 0x02},

    {0xfc, 0x01},
    {0x02, 0x05},

};

#else

unsigned char OV2655_YCbCr8bit[][MODULE_COMMAND_SIZE] =
{
	{0x12, 0x80},

//	{0x12, 0x0},
	{0xff,0x10},
	{0x11,0x80},
	{0x6a,0x3e},
	{0x3b,0x09},
//	{0x13,0x8f},
//	{0x01,0x80},
//	{0x02,0x80},
//	{0x00,0x00},
//	{0x00,0xff},
//	{0x10,0x00},
	{0x39,0x43},
	{0x38,0x12},
	{0x37,0x00},
	{0x35,0x91},
	{0x0e,0xa0},
	{0x1e,0x10},
	{0xA8,0x80},
	{0x12,0x40},
	{0x04,0x00},
	{0x0c,0x04},
	{0x0d,0x80},
//	{0x18,0xc6},
//	{0x17,0x26},
	{0x32,0xad},
//	{0x03,0x00},
//	{0x1a,0x3d},
//	{0x19,0x01},
	{0x3f,0xa6},
//	{0x14,0x2e},
	{0x15,0x10},
//	{0x41,0x02},
	{0x42,0x08},
	{0x1b,0x00},
	{0x16,0x06},
	{0x33,0xe2},
	{0x34,0xbf},
	{0x96,0x04},
//	{0x3a,0x00},
	{0x8e,0x00},
	{0x3c,0x77},
	{0x8B,0x06},
	{0x94,0x88},
	{0x95,0x88},
	{0x40,0xc1},
	{0x29,0x3f},
	{0x0f,0x42},
	{0x3d,0x92},
//	{0x69,0x40},
	{0x5C,0xb9},
	{0x5D,0x96},
	{0x5E,0x10},
	{0x59,0xc0},
	{0x5A,0xaf},
	{0x5B,0x55},
	{0x43,0xf0},
	{0x44,0x10},
	{0x45,0x68},
	{0x46,0x96},
	{0x47,0x60},
	{0x48,0x80},
	{0x5F,0xe0},
	{0x60,0x8c},
	{0x61,0x20},
	{0xa5,0xd9},
	{0xa4,0x74},
	{0x8d,0x02},
//	{0x8C,0x23},
	{0x3E,0x02},
	{0xa9,0xb8},
	{0xaa,0x92},
	{0xab,0x0a},
	{0x8f,0xdf},
	{0x90,0x00},
	{0x91,0x00},
	{0x9f,0x00},
	{0xa0,0x00},
//	{0x3A,0x01},
//	{0x24,0x70},
//	{0x25,0x64},
//	{0x26,0xc3},
	{0x2a,0x00},
	{0x2b,0x00},

//
//	{0x04,0x00},
//	{0x0C,0x00},
//	{0x0D,0x00},
// 	{0x11,0x80},
//	{0x12,0x40},
//	{0x37,0x81},
//	{0x38,0x93},
//	{0x39,0x50},
	{0x05,0x40},// 40
	{0x06,0x10},// 10
	{0x08,0x00},// 00
//	{0x10,0x80},
//	{0x8C,0x20},
//	{0x14,0x3a},
	{0x09, 0x01},// 02
	{0x13,0xef},
// vga
	{0x04,0x00},
	{0x0c,0x04},
	{0x0d,0x80},
	{0x11,0x83},
	{0x12,0x40},
	{0x37,0x00},
	{0x38,0x12},
	{0x39,0x43},
	{0x40,0xc1},
// exposure
	{0x04, 0x02},//[0-1]
	{0x10, 0x7c},//[2-9]
	{0xa1, 0x40},//[10-15]
	{0x24,0x70},
	{0x25,0x64},
	{0x26,0xc3},
//auto white blance
	{0x01,0x80},
	{0x02,0x80},
	{0x69,0x40},
//agc
	{0x00,0x04},
	{0x03,0x00},
	{0x14,0x2e},
	{0x18,0xc6},
	{0x17,0x26},
	{0x1a,0x3d},
	{0x19,0x01},
//Color Matrix Control
	{0x3d,0x92},
	{0x41,0x02},

	{0x4f,0x3a},
	{0x50,0x3d},
	{0x51,0x03},
	{0x52,0x12},
	{0x53,0x26},
	{0x54,0x38},
	{0x55,0x40},
	{0x56,0x40},
	{0x57,0x40},
	{0x58,0x0f},
// Sharpness Control
	{0x3e,0x02},
	{0x3f,0xa6},
	{0x8c,0x23},
//blc
	{0x3a,0x00},
	{0x67,0x80},
	{0x68,0x80},
	{0x3a,0x01},
//Banding Filter  VGA
//	{0x11,0x83},
	{0xa2,0x4b},
	{0xa3,0x3e},

//gamma
	{0x6c,0x40},
	{0x6d,0x30},
	{0x6e,0x4b},
	{0x6f,0x60},
	{0x70,0x70},
	{0x71,0x70},
	{0x72,0x70},
	{0x73,0x70},
	{0x74,0x60},
	{0x75,0x60},
	{0x76,0x50},
	{0x77,0x48},
	{0x78,0x3a},
	{0x79,0x2e},
	{0x7a,0x28},
	{0x7b,0x22},
	{0x7c,0x04},
	{0x7d,0x07},
	{0x7e,0x10},
	{0x7f,0x28},
	{0x80,0x36},
	{0x81,0x44},
	{0x82,0x52},
	{0x83,0x60},
	{0x84,0x6c},
	{0x85,0x78},
	{0x86,0x8c},
	{0x87,0x9e},
	{0x88,0xbb},
	{0x89,0xd2},
	{0x8a,0xe6},

};


/*
 * User tuned register setting values
 */
static unsigned short tvp5150_init_reg[][2] = {
	/*{0x00,0x00},
	{0x03,0x0d}, //output enable
//	{0x03,0x8f},
	{0x04,0xc0}, //PAL_NTSC_DETECT
	//	{0x04,0xff},
	{0x0d,0x40},*/

  {0x0a, 0xa0}, //color saturation control		//gavin 09-09-26 ɫͳֵ
  {0x0c, 0xBE},//contrast control						//gavin 09-09-26 öԱȶȳֵ
  {0x03, 0x0D},			
  {0x12, 0x00},
  {0x00, 0x00},		// CVBS-CH1			
  {0x28, 0x00},				
  {0x0F, 0x0A},		// set pin 27 = GPCL for v02.03
  {0x03, 0x6F},		// GPCL HIGH FOR ANALOG SW to CVBS, YUV output enable
  {0x15, 0x05},		// 0x05: ADI RTC mode
  {0xC8, 0x80},		// BuffThresh			set to trigger int when 1 transaction is stored
	{0xCA, 0x8C},		// IntLineNo			enable odd field, set to line 12
	{0xCE, 0x01},		// VidStandard			set 601 sampling
	{0xCF, 0x00},		// Full field enable    disable
	{0xEE, 0xE7},		// Line21 (Field 1)- CC NTSC, was 0xE7/0xC7
	{0xEF, 0xE7},		// Line21 (Field 2)- CC NTSC, was 0xE7/0xC7 
	{0xCB, 0x4E},		// Set Pixel Alignment [7:0] to 4Eh
	{0xCC, 0x00},		// Set pixel Alignment [9:8] to 0
	{0xCD, 0x00},		// Disable Host access VBI FIFO: FIFO outputs to 656 port
	{0xC9, 0x00},		// Reset FIFO


};

//#ifndef OV2655_1600_12000// OV2655 800*600
/*
 * User tuned register setting values
 */
static unsigned short ov2655_init_reg_800600[][2] = {
	{0x3012, 0x80},

	{0x0000, 0x0a}, //10ms

	{0x308c,0x80},
	{0x308d,0x0e},
	{0x360b,0x00},
	{0x30b0,0xff},
	{0x30b1,0xff},
	{0x30b2,0x04},

	{0x300e,0x34},
	{0x300f,0xa6},
	{0x3010,0x81},
	{0x3082,0x01},
	{0x30f4,0x01},
	{0x3090,0x43}, //add 3.6
	{0x3091,0xc0},
	{0x30ac,0x42},

	{0x30d1,0x08},
	{0x30a8,0x55},
	{0x3015,0x02},
	{0x3093,0x00},
	{0x307e,0xe5},
	{0x3079,0x00},
	{0x30aa,0x42},
	{0x3017,0x40},
	{0x30f3,0x83},
	{0x306a,0x0c},
	{0x306d,0x00},
	{0x336a,0x3c},
	{0x3076,0x6a},
	{0x30d9,0x95},
	{0x3016,0x82},
	{0x3601,0x30},
	{0x304e,0x88},
	{0x30f1,0x82},

	{0x306f,0x14},
	{0x3012,0x10},  //resolution
	{0x3011,0x01},			//change 3.6  0x01->0x02

	{0x302a,0x02},
	{0x302b,0xe6},
	{0x3028,0x07},
	{0x3029,0x93},
	{0x3391,0x06},
	{0x3394,0x38},
	{0x3395,0x38},

	{0x3013,0xf7},
	{0x3018,0x80},
	{0x3019,0x70},
	{0x301a,0xd4},
	{0x301c,0x07},
	{0x301d,0x08},
	{0x3070,0x5d},
	{0x3072,0x4d},

	{0x30af,0x00},
	{0x3048,0x1f},
	{0x3049,0x4e},
	{0x304a,0x20},
	{0x304f,0x20},
	{0x304b,0x02},
	{0x304c,0x00},
	{0x304d,0x02},
	{0x304f,0x20},
	{0x30a3,0x10},
	{0x3014,0x84},
	{0x3071,0x00},
	{0x3073,0x00},
	{0x304d,0x42},
	{0x304a,0x40},
	{0x304f,0x40},
	{0x3095,0x07},
	{0x3096,0x16},
	{0x3097,0x1d},
	{0x3020,0x01},
	{0x3021,0x18},
	{0x3022,0x00},
	{0x3023,0x06},
	{0x3024,0x06},
	{0x3025,0x58},
	{0x3026,0x04},
	{0x3027,0xbc},
	{0x3088,0x03},
	{0x3089,0x20},
	{0x308a,0x02},
	{0x308b,0x58},
	{0x3316,0x64},
	{0x3317,0x25},
	{0x3318,0x80},
	{0x3319,0x08},
	{0x331a,0x64},
	{0x331b,0x4b},
	{0x331c,0x00},
	{0x331d,0x38},
	{0x3100,0x00},
	{0x3320,0xfa},
	{0x3321,0x11},
	{0x3322,0x92},
	{0x3323,0x01},
	{0x3324,0x97},
	{0x3325,0x02},
	{0x3326,0xff},
	{0x3327,0x0c},
	{0x3328,0x10},
	{0x3329,0x10},
	{0x332a,0x58},
	{0x332b,0x56},
	{0x332c,0xbe},
	{0x332d,0xe1},
	{0x332e,0x3a},
	{0x332f,0x36},
	{0x3330,0x4d},
	{0x3331,0x44},
	{0x3332,0xf8},
	{0x3333,0x0a},
	{0x3334,0xf0},
	{0x3335,0xf0},
	{0x3336,0xf0},
	{0x3337,0x40},
	{0x3338,0x40},
	{0x3339,0x40},
	{0x333a,0x00},
	{0x333b,0x00},
	{0x3380,0x28},
	{0x3381,0x48},
	{0x3382,0x10},
	{0x3383,0x22},
	{0x3384,0xc0},
	{0x3385,0xe2},
	{0x3386,0xe2},
	{0x3387,0xf2},
	{0x3388,0x10},
	{0x3389,0x98},
	{0x338a,0x00},
	{0x3340,0x04},
	{0x3341,0x07},
	{0x3342,0x19},
	{0x3343,0x34},
	{0x3344,0x4a},
	{0x3345,0x5a},
	{0x3346,0x67},
	{0x3347,0x71},
	{0x3348,0x7c},
	{0x3349,0x8c},
	{0x334a,0x9b},
	{0x334b,0xa9},
	{0x334c,0xc0},
	{0x334d,0xd5},
	{0x334e,0xe8},
	{0x334f,0x20},
	{0x3090,0x03},
	{0x307c,0x10},
	{0x3350,0x33},
	{0x3351,0x28},
	{0x3352,0x00},
	{0x3353,0x16},
	{0x3354,0x00},
	{0x3355,0x85},
	{0x3356,0x35},
	{0x3357,0x28},
	{0x3358,0x00},
	{0x3359,0x13},
	{0x335a,0x00},
	{0x335b,0x85},
	{0x335c,0x34},
	{0x335d,0x28},
	{0x335e,0x00},
	{0x335f,0x13},
	{0x3360,0x00},
	{0x3361,0x85},
	{0x3363,0x70},
	{0x3364,0x7f},
	{0x3365,0x00},
	{0x3366,0x00},
	{0x3362,0x90},
	{0x3301,0xff},
	{0x338B,0x11},
	{0x338c,0x10},
	{0x338d,0x40},
	{0x3370,0xd0},
	{0x3371,0x00},
	{0x3372,0x00},
	{0x3373,0x30},
	{0x3374,0x10},
	{0x3375,0x10},
	{0x3376,0x05},
	{0x3377,0x00},
	{0x3378,0x04},
	{0x3379,0x40},
	{0x3069,0x86},
	{0x3087,0x02},
	{0x3300,0xfc},
	{0x3302,0x11},
	{0x3400,0x02},    // format
	{0x3606,0x20},
	{0x3601,0x30},
	{0x30f3,0x83},
	{0x304e,0x88},
	{0x3015,0x02},
	{0x302d,0x00},
	{0x302e,0x00},
	{0x3306,0x00},
	{0x363b,0x01},
	{0x363c,0xf2},
	{0x3086,0x0f},
	{0x3086,0x00},
	{0x30a1,0x41},
	{0x30a3,0x80},
	{0x30a8,0x56},
	{0x30aa,0x72},
	{0x30af,0x10},
	{0x30b2,0x2f},
	{0x30d9,0x8c},
};
//#else  // ov2655 1600*1200
 
/*
 * User tuned register setting values
 */
 
static unsigned short ov2655_init_reg[][2] = {
	{0X3012,0X80},
	{0XFFFF,0X0A},
	{0X308C,0X80},
	{0X308D,0X0E},
	{0X360B,0X00},
	{0X30B0,0XFF},
	{0X30B1,0XFF},
	{0X30B2,0X2C},
	{0X300E,0X34},
	{0X300F,0XA6},
	{0X3010,0X81},
	{0X3082,0X01},
	{0X30F4,0X01},
	{0X3090,0X33},
	{0X3091,0XC0},
	{0X30AC,0X42},
	{0X30D1,0X08},
	{0X30A8,0X54},
	{0X3015,0X02},
	{0X3093,0X00},
	{0X307E,0XE5},
	{0X3079,0X00},
	{0X30AA,0X42},
	{0X3017,0X40},
	{0X30F3,0X83},
	{0X306A,0X0C},
	{0X306D,0X00},
	{0X336A,0X3C},
	{0X3076,0X6A},
	{0X30D9,0X95},
	{0X3016,0X82},
	{0X3601,0X30},
	{0X304E,0X88},
	{0X30F1,0X82},
	{0X30AB,0X00},
	{0X30AD,0X0A},
	{0X3011,0X01},
	{0X3013,0XF7},
	{0X3018,0X88},
	{0X3019,0X78},
	{0X301A,0XD4},
	{0X301C,0X13},
	{0X301D,0X17},
	{0X3070,0X3E},
	{0X3072,0X34},
	{0X30AF,0X00},
	{0X3048,0X1F},
	{0X3049,0X4E},
	{0X304A,0X20},
	{0X304F,0X20},
	{0X304B,0X02},
	{0X304C,0X00},
	{0X304D,0X02},
	{0X304F,0X20},
	{0X30A3,0X10},
	{0X3013,0XF7},
	{0X3014,0X44},
	{0X3071,0X00},
	{0X3070,0X3E},
	{0X3073,0X00},
	{0X3072,0X34},
	{0X301C,0X12},
	{0X301D,0X16},
	{0X304D,0X42},
	{0X304A,0X40},
	{0X304F,0X40},
	{0X3095,0X07},
	{0X3096,0X16},
	{0X3097,0X1D},
	{0X3020,0X01},
	{0X3021,0X18},
	{0X3022,0X00},
	{0X3023,0X0A},
	{0X3024,0X06},
	{0X3025,0X58},
	{0X3026,0X04},
	{0X3027,0XBC},
	{0X3088,0X06},
	{0X3089,0X40},
	{0X308A,0X04},
	{0X308B,0XB0},
	{0X3316,0X64},
	{0X3317,0X4B},
	{0X3318,0X00},
	{0X331A,0X64},
	{0X331B,0X4B},
	{0X331C,0X00},
	{0X3100,0X00},
	{0X3320,0XFA},
	{0X3321,0X11},
	{0X3322,0X92},
	{0X3323,0X01},
	{0X3324,0X97},
	{0X3325,0X02},
	{0X3326,0XFF},
	{0X3327,0X0C},
	{0X3328,0X10},
	{0X3329,0X13},
	{0X332A,0X58},
	{0X332B,0X50},
	{0X332C,0XBE},
	{0X332D,0XCE},
	{0X332E,0X3A},
	{0X332F,0X36},
	{0X3330,0X4D},
	{0X3331,0X44},
	{0X3332,0XF0},
	{0X3333,0X0A},
	{0X3334,0XF0},
	{0X3335,0XF0},
	{0X3336,0XF0},
	{0X3337,0X40},
	{0X3338,0X40},
	{0X3339,0X40},
	{0X333A,0X00},
	{0X333B,0X00},
	{0X3380,0X28},
	{0X3381,0X48},
	{0X3382,0X10},
	{0X3383,0X24},
	{0X3384,0XC9},
	{0X3385,0XED},
	{0X3386,0XB4},
	{0X3387,0XC7},
	{0X3388,0X13},
	{0X3389,0X98},
	{0X338A,0X00},
	{0X3390,0X41},
	
};

//#endif

#endif

//#endif // _S5X532_H_
