//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
// This code is generated initially by dklee(dokyou.lee@samsung.com)

/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    s5k6aafx_module.h

Abstract:       S5K6AAFX Camera module header

Functions:


Notes:


--*/


#ifndef __S5K6AAFX_MODULE_H__
#define __S5K6AAFX_MODULE_H__

//========================================================
//  S5K6AAFX Micron module definition

#include <bsp.h>
#include "module.h"
#include "camera_typedef.h"

#define CAM_S5K6AAFX_DEVICE_ID         0x78  // 8bit slave address for WRITE
#define CAM_S5K6AAFX_I2C_CLOCK         100
  
/*========Register map for S5K6AA(Don't modify)===========*/
#define	S5K6AA_REG_TC_GP_EnablePreview				0x01F0
#define	S5K6AA_REG_TC_GP_EnablePreviewChanged		0x01F2
#define	S5K6AA_REG_TC_GP_SleepMode					0x022E
#define	S5K6AA_REG_TC_GP_SleepModeChanged			0x0230
#define	S5K6AA_setot_usForceClocksSettings				0x0AEA
#define	S5K6AA_setot_usConfigClocksSettings				0x0AEC	
/*================================================*/

//========================================================
//  S5K6AAFX default mode
#define S5K6AAFX_MODULE_ITUXXX         CAM_ITU601
#define S5K6AAFX_MODULE_INTERLACE      0
#define S5K6AAFX_MODULE_MIPI           (TRUE)
#define S5K6AAFX_MODULE_LANE           (DATA_LANE_1)
#define S5K6AAFX_MODULE_JPEG           (0)
#define S5K6AAFX_MODULE_YUVORDER       CAM_ORDER_CRYCBY
#define S5K6AAFX_MODULE_HSIZE          640
#define S5K6AAFX_MODULE_VSIZE          480
#define S5K6AAFX_MODULE_HOFFSET        0
#define S5K6AAFX_MODULE_VOFFSET        0
#define S5K6AAFX_MODULE_UVOFFSET       CAM_UVOFFSET_0
#define S5K6AAFX_MODULE_CLOCK          24000000
#define S5K6AAFX_MODULE_CODEC          CAM_FORMAT_YCBYCR422_1PLANE
#define S5K6AAFX_MODULE_HIGHRST        0        // This is affected by Electic circuit for reset or power control PIN, BB37->0, SMDK->1
#define S5K6AAFX_MODULE_INVPCLK        0
#define S5K6AAFX_MODULE_INVVSYNC       0
#define S5K6AAFX_MODULE_INVHREF        0
#define S5K6AAFX_MODULE_HSSETTLE       6


class S5K6AAFX : public CamModule
{
public:
    S5K6AAFX();    
    S5K6AAFX(ICamComm *CommIF);
    ~S5K6AAFX();    
    MODULE_STATUS Init();
    MODULE_STATUS Deinit();
    MODULE_STATUS InitSensor();
    MODULE_STATUS Power(BOOL bOnOff);
    MODULE_STATUS Standby(BOOL bActive);
    MODULE_STATUS Reset(BOOL bActive);

    MODULE_STATUS GetSupportFormat(MODULE_DESCRIPTOR *outModuleDesc);

    MODULE_STATUS SetFormatSize(CAMIF_IMG_SIZE Size);
    MODULE_STATUS SensorPrepare();
    MODULE_STATUS SensorStart();
};

#endif //__S5K6AAFX_MODULE_H__
