#ifndef __S5PV210_POST_PROC_H__
#define __S5PV210_POST_PROC_H__

//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    postif_proc.h

Abstract:       Private Type definition and function prototypes for camera driver POST API

Functions:


Notes:


--*/
#include <camera_hal.h>
//#include <camif.h>

#if __cplusplus
extern "C"
{
#endif

#define CAM_POST_CMD_TIMEOUT            (100)    //(35)    // Optimal Period of Vsync is 16.7ms (60Hz)
// Max Q number
#define MAX_Q_NUMBER    10

typedef enum
{
    POST_SRC_ADDRESS,
    POST_NEXT_SRC_ADDRESS,
    POST_DST_ADDRESS,
    POST_NEXT_DST_ADDRESS,
    POST_DST_1ST_ADDRESS,
    POST_DST_2ND_ADDRESS,
    POST_DST_3RD_ADDRESS,
    POST_DST_4TH_ADDRESS
} POST_DMA_ADDRESS;

typedef enum
{
    POST_SUCCESS,
    POST_ERROR_NULL_PARAMETER,
    POST_ERROR_ILLEGAL_PARAMETER,
    POST_ERROR_NOT_INITIALIZED,
    POST_ERROR_NOT_IMPLEMENTED,
    POST_ERROR_PRESCALER_OUT_OF_SCALE_RANGE,
    POST_ERROR_XXX
} POST_ERROR;

typedef struct _PostContextManager
{
    BOOL  dwIsProcessing;

} PostContextManager, *pPostContextManager;

typedef struct _tPostConfig
{
    POST_OP_MODE Mode;
    POST_SCAN_MODE Scan;
    DWORD dwRotFlipMode;
    POST_SRC_TYPE SrcType;
    unsigned int SrcBaseWidth;
    unsigned int SrcBaseHeight;
    unsigned int SrcWidth;
    unsigned int SrcHeight;
    unsigned int SrcOffsetX;
    unsigned int SrcOffsetY;
    POST_DST_TYPE DstType;
    unsigned int DstBaseWidth;
    unsigned int DstBaseHeight;
    unsigned int DstWidth;
    unsigned int DstHeight;
    unsigned int DstOffsetX;
    unsigned int DstOffsetY;
    BOOL bIntEnable;
} tPostConfig;

// This structure will hold the setting parameters and status.
// These values will be used for resetting the Camera IP registers on wakeup time.
typedef struct _PostProcContext
{
    // Power State
    BOOL bPowerOn;
    DWORD   dwContextNum;
    HANDLE hPostCmdDone;        // Post Processor Cmd Event

    // Critical Section for IOCTL Proc
    CRITICAL_SECTION    csLockShadow;

    // CAM_POST_SET_PROCESSING_PARAM
    BOOL bPostParam;
    CAMARG_POST_PARAMETER     tPostParam;

    // CAM_POST_SET_SOURCE_BUFFER/CAM_POST_SET_NEXT_SOURCE_BUFFER
    BOOL bPostSrcBuffer;
    CAMARG_POST_BUFFER    tPostSrcBuffer;

    // CAM_POST_SET_DESTINATION_BUFFER
    BOOL bPostDstBuffer;
    //CAMARG_POST_BUFFER tPostDstBuffer;
    CAMARG_POST_BUFFER tPostDst1stBuffer;
    CAMARG_POST_BUFFER tPostDst2ndBuffer;
    CAMARG_POST_BUFFER tPostDst3rdBuffer;
    CAMARG_POST_BUFFER tPostDst4thBuffer;

    // CAM_POST_SET_PROCESSING_START/STOP
    BOOL bPostStart;            // Need to Trigger
    BOOL bPostProcessDone;
    BOOL bPostInQueue;
} PostProcContext, *pPostProcContext;

typedef struct _PostPowerContext
{
    // Power State
    BOOL bPowerOn;

    // Critical Section for IOCTL Proc
    CRITICAL_SECTION    csLockShadow;

    // CAM_POST_SET_PROCESSING_START/STOP
    BOOL bPostStart;            // Need to Trigger

} PostPowerContext, *pPostPowerContext;


#if __cplusplus
}
#endif

class IPost
{
public:
    virtual POST_ERROR Initialize(POST_OP_MODE Mode, POST_SCAN_MODE Scan, unsigned int RotFlip,
                        POST_SRC_TYPE SrcType, unsigned int SrcBaseWidth, unsigned int SrcBaseHeight,
                        unsigned int SrcWidth, unsigned int SrcHeight, unsigned int SrcOffsetX, unsigned int SrcOffsetY,
                        POST_DST_TYPE DstType, unsigned int DstBaseWidth, unsigned int DstBaseHeight,
                        unsigned int DstWidth, unsigned int DstHeight, unsigned int DstOffsetX, unsigned int DstOffsetY) = 0;
    virtual POST_ERROR SetSourceBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr) = 0;
    virtual POST_ERROR SetNextSourceBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr) = 0;
    virtual POST_ERROR SetDestinationBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr) = 0;
    virtual POST_ERROR SetNextDestinationBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr) = 0;
    virtual POST_ERROR SetRotationAndFlip(unsigned int RotFlip) = 0;

    virtual void ProcessingStart(void) = 0;
    virtual void ProcessingStop(void) = 0;
    virtual void SetAutoload(BOOL bEnable) = 0;
    virtual POST_STATE GetProcessingState(void) = 0;

    virtual void EnableInterrupt(void) = 0;
    virtual void DisableInterrupt(void) = 0;
    virtual BOOL ClearInterruptPending(void) = 0;
    virtual POST_SRC_TYPE GetCurrentSrcType(void) = 0;

};

#include "post_queue.h"
class PostQueue;

class CAMIFPostIF : public IPost, public CMiniThread
{
public:
    CAMIFPostIF();
    POST_ERROR Initialize(POST_OP_MODE Mode, POST_SCAN_MODE Scan, unsigned int RotFlip,
                        POST_SRC_TYPE SrcType, unsigned int SrcBaseWidth, unsigned int SrcBaseHeight,
                        unsigned int SrcWidth, unsigned int SrcHeight, unsigned int SrcOffsetX, unsigned int SrcOffsetY,
                        POST_DST_TYPE DstType, unsigned int DstBaseWidth, unsigned int DstBaseHeight,
                        unsigned int DstWidth, unsigned int DstHeight, unsigned int DstOffsetX, unsigned int DstOffsetY);
    POST_ERROR SetPostEvent(HANDLE hEvent);

    POST_ERROR SetSourceBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr);
    POST_ERROR SetNextSourceBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr);
    POST_ERROR SetDestinationBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr);
    POST_ERROR SetNextDestinationBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr);
    POST_ERROR Set1stDestinationBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr);
    POST_ERROR Set2ndDestinationBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr);
    POST_ERROR Set3rdDestinationBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr);
    POST_ERROR Set4thDestinationBuffer(unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr);
    POST_ERROR SetRotationAndFlip(unsigned int RotFlip);
    void SetDmaMode(CAM_DMA_MODE InputDMA, CAM_DMA_MODE OutputDMA);

    void ProcessingStart(void);
    void ProcessingStop(void);
    void SetAutoload(BOOL bEnable);
    POST_STATE GetProcessingState(void);

    void EnableInterrupt(void);
    void DisableInterrupt(void);
    BOOL ClearInterruptPending(void);
    POST_SRC_TYPE GetCurrentSrcType(void) { return m_PostConfig.SrcType; }
    CameraHal   *pCameraIF;
//    CAMIF       *pCAMIF;
    UINT32      m_uCamID;
    DWORD       m_isThreadWorking;
    PostQueue   m_PQ;
    PostProcContext *m_pWorkingCtxt;
    HANDLE      m_PostIntDoneEvent;
    HANDLE      m_PostRequestEvent;

    DWORD WaitProcessDone(HANDLE hEvent);
    BOOL Post_Start(PostProcContext *PCtxt);

private:

    virtual DWORD ThreadRun();   // Q Thread
    POST_ERROR SetMode(POST_OP_MODE Mode, POST_SCAN_MODE Scan, POST_SRC_TYPE SrcType, POST_DST_TYPE DstType);
    void SetSourceSize(unsigned int BaseWidth, unsigned int BaseHeight, unsigned int Width, unsigned int Height, unsigned int OffsetX, unsigned int OffsetY);
    void SetDestinationSize(unsigned int BaseWidth, unsigned int BaseHeight, unsigned int Width, unsigned int Height, unsigned int OffsetX, unsigned int OffsetY);
//    POST_ERROR GetPrescalerShiftvalue(unsigned int *MainShift, unsigned int SrcValue, unsigned int DstValue );
    POST_ERROR UpdateCondition(void);
    POST_ERROR SetDmaAddress(POST_DMA_ADDRESS DMA, unsigned int AddrY, unsigned int AddrCb, unsigned int AddrCr);

    tPostConfig m_PostConfig;

};


#endif    // __S5PV210_POST_PROC_H__
