
#ifndef __IPC_H__
#define __IPC_H__

#include <ipc_reg.h>
#include "ipc_table.h"


typedef enum{
	OFF,
	ON
}IPC_eONOFF;

typedef enum{

	DISABLED,		
	ENABLED
	
}IPC_eON;

typedef enum{
	
	IPC_TOP_FIELD,
	IPC_BOTTOM_FIELD
	
}IPC_eFIELD_ID;

typedef enum{
	
	INTERNAL,
	CAM_FIELD_SIG
	
}IPC_eFIELD_ID_SEL;

typedef enum{
	
	BYUSER,
	AUTO
	
}IPC_eFIELD_ID_TOGL;

typedef enum{
	
	IPC_HDS, // Horizontal Double scaling
	IPC_2D // 2D IPC
	
}_2D_eIPC;

typedef enum{
	
	_1PIX_PER_1CYCLE,
	_1PIX_PER_2CYCLE,
	_1PIX_PER_3CYCLE,
	_1PIX_PER_4CYCLE
	
}IPC_ePEL_RATE_CTRL;

typedef enum IPC_SHARPNESS {
	NO_EFFECT, MIN_EDGE, MODERATE_EDGE, MAX_EDGE
}IPC_eSHARPNESS;

typedef enum IPC_PP_LINEEQ_VAL {
	
	IPC_PP_LINEEQ_0 = 0,
	IPC_PP_LINEEQ_1,
	IPC_PP_LINEEQ_2,
	IPC_PP_LINEEQ_3,
	IPC_PP_LINEEQ_4,
	IPC_PP_LINEEQ_5,
	IPC_PP_LINEEQ_6,
	IPC_PP_LINEEQ_7,
	IPC_PP_LINEEQ_ALL
	
}IPC_ePP_LINEEQ_VAL;

typedef enum IPC_FILTER_H_PP {
	/* Don't change the order and the value */
	IPC_PP_H_NORMAL = 0,
	IPC_PP_H_8_9,		/* 720 to 640 */
	IPC_PP_H_1_2,
	IPC_PP_H_1_3,
	IPC_PP_H_1_4
}IPC_eFILTER_H_PP;

typedef enum IPC_FILTER_V_PP {
	/* Don't change the order and the value */
	IPC_PP_V_NORMAL = 0,
	IPC_PP_V_5_6,		/* PAL to NTSC */
	IPC_PP_V_3_4,
	IPC_PP_V_1_2,
	IPC_PP_V_1_3,
	IPC_PP_V_1_4
}IPC_eFILTER_V_PP;

typedef enum IPC_SRC_X_POS_FRACTION_STEP
{
	STEP0 = 0, // 0/16 = 0
	STEP1, // 1/16 = 0.0625
	STEP2, // 2/16 = 0.125
	STEP3, // 3/16 = 0.1875
	STEP4, // 4/16 = 0.25
	STEP5, // 5/16 = 0.3125
	STEP6, // 6/16 = 0.375
	STEP7, // 7/16 = 0.4375
	STEP8, // 8/16 = 0.5
	STEP9, // 9/16 = 0.5625
	STEP10, // 10/16 = 0.625
	STEP11, // 11/16 = 0.6875
	STEP12, // 12/16 = 0.75
	STEP13, // 13/16 = 0.8125
	STEP14, // 14/16 = 0.875
	STEP15 // 15/16 = 0.9375
}IPC_eSRC_X_POS_FRACTION_STEP;

typedef enum
{	
	PROGRESSIVE_IPC,
	INTERLACED_IPC
} SCAN_MODE_IPC;


////////////////////////////////////////////////
// Source Image Processing Infomation
////////////////////////////////////////////////
typedef struct IPC_xSource
{
//	IMG_FMT 	eSrcBpp;
	DWORD 		uSrcStAddr;
	DWORD 		uImgHsz;
	DWORD 		uImgVsz;
	DWORD 		uSrcXPos;
	DWORD 		uSrcYPos;
	DWORD 		uSrcHsz;
	DWORD 		uSrcVsz; 
	DWORD 		uSrcNumOfFrm;	
	DWORD 		uLastFrmBufIdx;	
	IPC_eSRC_X_POS_FRACTION_STEP eStep;	
}oIPC_Source;

//extern oVP_Source oIPC_SrcInf;

////////////////////////////////////////////////
// Destination Image Processing Infomation
////////////////////////////////////////////////	
typedef struct IPC_xDestination
{
	SCAN_MODE_IPC 	    eScanMode;
	DWORD 			uOrgDstHsz;
	DWORD 			uOrgDstVsz;	
	DWORD 			uDstXPos;
	DWORD 			uDstYPos;
	DWORD 			uDstHsz;
	DWORD 			uDstVsz; 
//	IMG_RESOLUTION 	eImgSz;
}oIPC_Destination;

//extern oVP_Destination oVP_DstInf;

////////////////////////////////////////////////
// Variable Structure(Control, Source, Destination, Enhancing)
////////////////////////////////////////////////
typedef struct IPC_xControlVariable
{
	_2D_eIPC uModeVal;
	DWORD uLineEqVal;
	DWORD uScanConversionIdx;
}oIPC_ControlVariable;

typedef struct IPC_xEnhancingVariable
{
	DWORD 				aContrast[8];
	DWORD				aBrightness[8];
	DWORD				uSaturation;
	IPC_eSHARPNESS	    eSharpness;
	DWORD				uThHnoise;
	DWORD				uBrightOffset;
}oIPC_EnhancingVariable;

typedef enum
{
	REG_READ=0x1, 
	REG_WRITE=0x2
}REG_TYPE;

typedef struct
{
	BYTE name[32];
	DWORD offset;
	REG_TYPE type;
	DWORD readableBits;
	DWORD writebleBits;
	DWORD resetValue;
	DWORD resetValueMask; // if((register real value)&(resetValueMask) == resetValue){the reset value is OK}
	DWORD tmp; //this is temp.
}REGISTER;

// IPC_SRESET
#define IPC_SOFT_RESET (1<<0)

class IPC
{
public:     
    oIPC_Source 		    oIpc_SrcInf;
    oIPC_Destination 	    oIpc_DstInf;
    oIPC_ControlVariable    oIpc_ConVar;  
    oIPC_EnhancingVariable  oIpc_EnhVar;

    IPC();              // This will map physical address to virtual address
    ~IPC();
    void InitIp(DWORD InHSz, DWORD InVSz, _2D_eIPC Ipc2d);
    void SetPostProcessingOnOff(DWORD dwOnOff);
    void EnableIP(DWORD dwOnOff);

protected:
	HANDLE m_hPwrControl;
    void Init(oIPC_Source oIpc_Src, oIPC_Destination oIpc_Dst, oIPC_ControlVariable oIpc_ConVar);
    void SWReset(void);
    void SetModeAndImgSize(oIPC_Source oIpc_Src, oIPC_Destination oIpc_Dst, oIPC_ControlVariable oIpc_ConVar); 
    void FILED_ID_Control(IPC_eFIELD_ID id);
    void FILED_ID_Mode(IPC_eFIELD_ID_SEL sel,IPC_eFIELD_ID_TOGL toggle);
    void IPC2D_ENABLE(_2D_eIPC dwOnOff);
    void InitEnhancingParameter(void);    
    void SetContrast(DWORD *uContrast);
    void SetBrightness(DWORD *uBrightness);
    void SetBrightOffset(DWORD uOffset);
    void SetSaturation(DWORD uSaturation);
    void SetSharpness(IPC_eSHARPNESS eSharpness, DWORD uThreshold);
    void SetFilter(void);
    void SetPolyPhaseFilterSet(IPC_eFILTER_H_PP eHFilter, IPC_eFILTER_V_PP eVFilter);
    void SetPolyPhaseFilter(volatile DWORD *uFilterReg, const BYTE* sFilterCoef, WORD usTapSz);

    volatile IPC_REG *m_pIPC_Reg;
    volatile CMU_CLK_REG *m_pCMUCLKReg;
	
};

#endif //__IPC_H__
