#ifndef __CAMERA_TYPEDEF_H
#define __CAMERA_TYPEDEF_H

/// Macros
// Used in Module Implementation
#define CAM_UVOFFSET_0          (0)
#define CAM_UVOFFSET_128        (1)

#define MAX_CAMERA_IP_HW        (3)
#define MAX_PINGPONG_NUM        4
#define VIDEO_PINGPONG_NUM      4
#define STILL_PINGPONG_NUM      1   // DO NOT change this value.

#define DEFAULT_CAPTURE_WIDTH   2048//640
#define DEFAULT_CAPTURE_HEIGHT  1536//480

#define CAPTURE_MAX_WIDTH       2048//1920
#define CAPTURE_MAX_HEIGHT      1536//1280
#define CAPTURE_BPP             2
#define CAPTURE_FRAME_SIZE      (CAPTURE_MAX_WIDTH*CAPTURE_MAX_HEIGHT*CAPTURE_BPP)

#define DEFAULT_STILL_WIDTH     640
#define DEFAULT_STILL_HEIGHT    480

#define STILL_MAX_WIDTH         DEFAULT_STILL_WIDTH
#define STILL_MAX_HEIGHT        DEFAULT_STILL_WIDTH
#if     0   // 8MPixel
#define STILL_MAX_WIDTH         3264
#define STILL_MAX_HEIGHT        2448
#endif
#define STILL_BPP               2
#define STILL_FRAME_SIZE        (STILL_MAX_WIDTH*STILL_MAX_HEIGHT*STILL_BPP)

#define DEFAULT_PREVIEW_WIDTH   2048//800     //< Normally this will be same to screen without scaling// modify by jerry
#define DEFAULT_PREVIEW_HEIGHT  1536//480

#define PREVIEW_MAX_WIDTH       DEFAULT_PREVIEW_WIDTH
#define PREVIEW_MAX_HEIGHT      DEFAULT_PREVIEW_HEIGHT
#define PREVIEW_BPP             2
#define PREVIEW_FRAME_SIZE      (PREVIEW_MAX_WIDTH*PREVIEW_MAX_HEIGHT*PREVIEW_BPP)


#define CAPTURE_BUFFER_SIZE     ((ULONG)CAPTURE_FRAME_SIZE*VIDEO_PINGPONG_NUM)
#define STILL_BUFFER_SIZE       ((ULONG)STILL_FRAME_SIZE*STILL_PINGPONG_NUM)
#define PREVIEW_BUFFER_SIZE     ((ULONG)PREVIEW_FRAME_SIZE*VIDEO_PINGPONG_NUM)

//////////////////////////////////////////////////
//
// Predefined Aspect of image
//
//////////////////////////////////////////////////
#define CAMERA_QCIF_WIDTH           (176)
#define CAMERA_QCIF_HEIGHT          (144)

#define CAMERA_CIF_WIDTH            (352)
#define CAMERA_CIF_HEIGHT           (288)

#define CAMERA_QQVGA_WIDTH          (160)
#define CAMERA_QQVGA_HEIGHT         (120)

#define CAMERA_QVGA_WIDTH           (320)
#define CAMERA_QVGA_HEIGHT          (240)

#define CAMERA_VGA_WIDTH            (640)
#define CAMERA_VGA_HEIGHT           (480)

#define CAMERA_SVGA_WIDTH           (800)
#define CAMERA_SVGA_HEIGHT          (600)

#define CAMERA_WVGA_WIDTH            (800)
#define CAMERA_WVGA_HEIGHT           (480)

#define CAMERA_SXGA_WIDTH           (1280)
#define CAMERA_SXGA_HEIGHT          (1024)

#define CAMERA_UXGA_WIDTH           (1600)
#define CAMERA_UXGA_HEIGHT          (1200)

#define CAMERA_QXGA_WIDTH           (2048)
#define CAMERA_QXGA_HEIGHT          (1536)

#define CAMERA_WSVGA_WIDTH          (854)
#define CAMERA_WSVGA_HEIGHT         (480)

#define CAMERA_HD720_WIDTH          (1280)
#define CAMERA_HD720_HEIGHT         (720)

#define CAMERA_HD1080_WIDTH         (1920)
#define CAMERA_HD1080_HEIGHT        (1080)

//////////////////////////////////////////////////
//
// Camera interface Controller SFR Bit Field Macro
//
//////////////////////////////////////////////////
// CAMIF_REG
// CIGCTRL : Global Control
#define IRQ_EDGE            (0<<BP_CAM_IRQ_LEVEL)
#define IRQ_LEVEL           (1<<BP_CAM_IRQ_LEVEL)
#define INPUT_CAMIF         (0<<BP_CAM_SEL_WB_CAMIF)
#define INPUT_WB            (1<<BP_CAM_SEL_WB_CAMIF)
#define SCAN_PROGRESSIVE    (0<<BP_INTERLACE)
#define SCAN_INTERLACE      (1<<BP_INTERLACE)

// CIREAL_ISIZE
#define AUTOLOAD_DISABLE        (0<<BP_AUTOLOADENABLE)
#define AUTOLOAD_ENABLE         (1<<BP_AUTOLOADENABLE)
#define ADDR_CHANGE_ENABLE      (0<<BP_ADDR_CH_DIS)
#define ADDR_CHANGE_DISABLE     (1<<BP_ADDR_CH_DIS)
#define LOCK_ADDR_FETCH(reg)    (reg##->CIREAL_ISIZE = (reg##->CIREAL_ISIZE & ~(BM_ADDR_CH_DIS)) | ADDR_CHANGE_DISABLE)
#define UNLOCK_ADDR_FETCH(reg)  (reg##->CIREAL_ISIZE = (reg##->CIREAL_ISIZE & ~(BM_ADDR_CH_DIS)) | ADDR_CHANGE_ENABLE)
#define INDMA_REAL_HEIGHT(n)    (((n) & BW_REAL_HEIGHT)<<BP_REAL_HEIGHT)
#define INDMA_REAL_WIDTH(n)     (((n) & BW_REAL_WIDTH)<<BP_REAL_WIDTH)

// CISCCTRL : Scaler Control
#define SCALER_STOP             (0<<BP_SCALERSTART)
#define SCALER_START            (1<<BP_SCALERSTART)
#define SCALE_DOWN_H            (0<<BP_SCALEUP_H)
#define SCALE_UP_H              (1<<BP_SCALEUP_H)
#define SCALE_DOWN_V            (0<<BP_SCALEUP_V)
#define SCALE_UP_V              (1<<BP_SCALEUP_V)
#define CSC_R2Y_NARROW          (0<<BP_CSCR2Y)
#define CSC_R2Y_WIDE            (1<<BP_CSCR2Y)
#define CSC_Y2R_NARROW          (0<<BP_CSCY2R)
#define CSC_Y2R_WIDE            (1<<BP_CSCY2R)
//#define PROGRESSIVE             (0<<BP_INTERLACE)
//#define INTERLACE               (1<<BP_INTERLACE)
#define MAINSCALE_H_RATIO(n)    (((n) & BW_MAINHORRATIO)<<BP_MAINHORRATIO)         // MainScale Horizontal Ratio
#define MAINSCALE_V_RATIO(n)    (((n) & BW_MAINVERRATIO)<<BP_MAINVERRATIO)         // MainScale Vertical Ratio
#define FIFO_OUT_DISABLE        (0<<BP_LCDPATHEN)
#define FIFO_OUT_ENABLE         (1<<BP_LCDPATHEN)       // If OutFormat = RGB -> RGB888, otherwise YUV444

// For Input DMA of Scaler
#define SRCRGB_RGB565        (0x0<<BP_INRGB_FMT)
#define SRCRGB_RGB666        (0x1<<BP_INRGB_FMT)
#define SRCRGB_RGB888        (0x2<<BP_INRGB_FMT)
// For Out DMA of Scaler
#define OUTRGB_RGB565        (0x0<<BP_OUTRGB_FMT)
#define OUTRGB_RGB666        (0x1<<BP_OUTRGB_FMT)
#define OUTRGB_RGB888        (0x2<<BP_OUTRGB_FMT)

// CIMSCTRL : Input DMA Setting
#define INPUTDMA_STOP       (0<<BP_ENVID_M)
#define INPUTDMA_START      (1<<BP_ENVID_M)

#define INDMA_DMAPATH       (0x1<<BP_SEL_DMA_CAM)
#define INDMA_FIFOPATH      (0x0<<BP_SEL_DMA_CAM)

#define INDMA_SRCYUV420_23PLANE  (0x0<<BP_INFORMAT_M)
#define INDMA_SRCYUV422_23PLANE  (0x1<<BP_INFORMAT_M)
#define INDMA_SRCYUV422_1PLANE   (0x2<<BP_INFORMAT_M)
#define INDMA_SRCRGB             (0x3<<BP_INFORMAT_M)

#define INDMA_SRCYUV_2PLANE     (0x1<<BP_C_INT_IN)
#define INDMA_SRCYUV_3PLANE     (0x0<<BP_C_INT_IN)

// CRCB_LITTLE = MSB Cr3Cb3Cr2Cb2Cr1Cb1Cr0Cb0 LSB
// CBCR_LITTLE = MSB Cb3Cr3Cb2Cr2Cb1Cr1Cb0Cr0 LSB
// CRCB_BIG    = MSB Cr0Cb0Cr1Cb1Cr2Cb2Cr3Cb3 LSB
// CBCR_BIG    = MSB Cb0Cr0Cb1Cr1Cb2Cr2Cb3Cr3 LSB
#define INDMA_SRCYUV_2PLANE_CRCB_LITTLE (0x0<<BP_ORDER2P_IN)
#define INDMA_SRCYUV_2PLANE_CBCR_LITTLE (0x1<<BP_ORDER2P_IN)
#define INDMA_SRCYUV_2PLANE_CRCB_BIG    (0x2<<BP_ORDER2P_IN)
#define INDMA_SRCYUV_2PLANE_CBCR_BIG    (0x3<<BP_ORDER2P_IN)

// This is Little Endian Style
// YCBYCR = MSB Y3Cb1Y2Cr1Y1Cb0Y0Cr0 LSB
// CBYCRY = MSB Cb1Y3Cr1Y2Cb0Y1Cr0Y0 LSB
// YCRYCB = MSB Y3Cr1Y2Cb1Y1Cr0Y0Cb0 LSB
// CRYCBY = MSB Cr1Y3Cb1Y2Cr0Y1Cb0Y0 LSB
#define INDMA_SRCYUV422_1PLANE_YCBYCR    ((0x0<<BP_ORDER422_M)|INDMA_SRCYUV422_1PLANE)
#define INDMA_SRCYUV422_1PLANE_CBYCRY    ((0x1<<BP_ORDER422_M)|INDMA_SRCYUV422_1PLANE)
#define INDMA_SRCYUV422_1PLANE_YCRYCB    ((0x2<<BP_ORDER422_M)|INDMA_SRCYUV422_1PLANE)
#define INDMA_SRCYUV422_1PLANE_CRYCBY    ((0x3<<BP_ORDER422_M)|INDMA_SRCYUV422_1PLANE)

#define INDMA_SRCYUV422_23PLANE_YCBYCR    ((0x0<<BP_ORDER422_M)|INDMA_SRCYUV422_23PLANE)
#define INDMA_SRCYUV422_23PLANE_CBYCRY    ((0x1<<BP_ORDER422_M)|INDMA_SRCYUV422_23PLANE)
#define INDMA_SRCYUV422_23PLANE_YCRYCB    ((0x2<<BP_ORDER422_M)|INDMA_SRCYUV422_23PLANE)
#define INDMA_SRCYUV422_23PLANE_CRYCBY    ((0x3<<BP_ORDER422_M)|INDMA_SRCYUV422_23PLANE)


// CITRGFMT : Scaler and CSC Target Format Setting
#define INROT_BYPASS                    (0x0<<BP_INROT90)
#define INROT_90_DEGREE                 (0x1<<BP_INROT90)
#define OUTFMT_YUV420_23PLANE           (0x0<<BP_OUTFORMAT)
#define OUTFMT_YUV422_23PLANE           (0x1<<BP_OUTFORMAT)
#define OUTFMT_YUV422_1PLANE            (0x2<<BP_OUTFORMAT)
#define OUTFMT_RGB                      (0x3<<BP_OUTFORMAT)

#define OUTFLIP_NONE                    (0x0<<BP_OUTFLIPMD)
#define OUTFLIP_X                       (0x1<<BP_OUTFLIPMD)
#define OUTFLIP_Y                       (0x2<<BP_OUTFLIPMD)
#define OUTFLIP_XY                      (0x3<<BP_OUTFLIPMD)
#define OUTROT_BYPASS                   (0x0<<BP_OUTROT90)
#define OUTROT_90_DEGREE                (0x1<<BP_OUTROT90)

#define OUTROT_90                       (OUTFLIP_NONE | OUTROT_90_DEGREE)
#define OUTROT_180                      (OUTFLIP_XY | OUTROT_BYPASS)
#define OUTROT_270                      (OUTFLIP_XY | OUTROT_90_DEGREE)

#define TRG_HEIGHT(n)                   (((n) & BW_TARGETVSIZE)<<BP_TARGETVSIZE)
#define TRG_WIDTH(n)                    (((n) & BW_TARGETHSIZE)<<BP_TARGETHSIZE)

// CIOCTRL : Output DMA setting
#define OUTDMA_USE_WEAVEOUT                (1<<BP_WEAVE_OUT)
#define OUTDMA_NOTUSE_WEAVEOUT             (0<<BP_WEAVE_OUT)

#define OUTDMA_YUV_2PLANE_CBCR_LITTLE   (0<<BP_ORDER2P_OUT)
#define OUTDMA_YUV_2PLANE_CRCB_LITTLE   (1<<BP_ORDER2P_OUT)
#define OUTDMA_YUV_2PLANE_CRCB_BIG      (2<<BP_ORDER2P_OUT)
#define OUTDMA_YUV_2PLANE_CBCR_BIG      (3<<BP_ORDER2P_OUT)

#define OUTDMA_YUV_2PLANE               (0x1<<BP_C_INT_OUT)
#define OUTDMA_YUV_3PLANE               (0x0<<BP_C_INT_OUT)

#define OUTDMA_YUV422_1PLANE_YCBYCR     (0<<BP_ORDER422_OUT)
#define OUTDMA_YUV422_1PLANE_CBYCRY     (1<<BP_ORDER422_OUT)
#define OUTDMA_YUV422_1PLANE_YCRYCB     (2<<BP_ORDER422_OUT)
#define OUTDMA_YUV422_1PLANE_CRYCBY     (3<<BP_ORDER422_OUT)

// CISCPRERATIO : PreScale_Ratio
#define PRESCALE_V_RATIO(n)         (((n) & BW_PREVERRATIO)<<BP_PREVERRATIO)
#define PRESCALE_H_RATIO(n)         (((n) & BW_PREHORRATIO)<<BP_PREHORRATIO)
// CISCPRERATIO : PreScale_SHFactor
#define PRESCALE_SHFACTOR(n)        (((n) & BW_SHFACTOR)<<BP_SHFACTOR)

// CISCPREDST : PreScaled Destination Image Size
#define PRESCALE_HEIGHT(n)          (((n) & BW_PREDSTHEIGHT)<<BP_PREDSTHEIGHT)
#define PRESCALE_WIDTH(n)           (((n) & BW_PREDSTWIDTH)<<BP_PREDSTWIDTH)

// ORGISIZE : Source Image Original Size
#define SRC_HEIGHT(n)               (((n) & BW_ORG_IN_V)<<BP_ORG_IN_V)
#define SRC_WIDTH(n)                (((n) & BW_ORG_IN_H)<<BP_ORG_IN_H)
// ORGOSIZE : Output Image Original Size
#define DST_HEIGHT(n)               (((n) & BW_ORG_OUT_V)<<BP_ORG_OUT_V)
#define DST_WIDTH(n)                (((n) & BW_ORG_OUT_H)<<BP_ORG_OUT_H)

// CIIMGCPT
#define GLOBAL_CPT_DISABLE      (0<<BP_IMGCPTEN)
#define GLOBAL_CPT_ENABLE       (1<<BP_IMGCPTEN)
#define SCALER_DISABLE          (0<<BP_IMGCPTEN_SC)
#define SCALER_ENABLE           (1<<BP_IMGCPTEN_SC)
#define CPT_FREN_DISABLE        (0<<BP_CPT_FREN)
#define CPT_FREN_ENABLE         (1<<BP_CPT_FREN)

// CIWDOFST
#define OFFSET_DISABLE          (0<<BP_WINOFSEN)
#define OFFSET_ENABLE           (1<<BP_WINOFSEN)

// Mode
#define POSTINT_ENABLE        (1<<7)
#define POSTINT_PEND        (1<<6)

// OffSetx
#define OFFSET(n)                ((n)&0xffffff)

// MODE_2
#define CHANGE_SEL_FIELD        (0<<3)
#define CHANGE_SEL_FRAME        (1<<3)
#define SW_TRG_MODE            (0<<0)

//Offset
#define CIIYOFF(n,k)            ((((n)&BW_IYOFF_V)<<BP_IYOFF_V)|(((k)&BW_IYOFF_H)<<BP_IYOFF_H))
#define CIICBOFF(n,k)           ((((n)&BW_ICBOFF_V)<<BP_ICBOFF_V)|(((k)&BW_ICBOFF_H)<<BP_ICBOFF_H))
#define CIICROFF(n,k)           ((((n)&BW_ICROFF_V)<<BP_ICROFF_V)|(((k)&BW_ICROFF_H)<<BP_ICROFF_H))

#define CIOYOFF(n,k)            ((((n)&BW_OYOFF_V)<<BP_OYOFF_V)|(((k)&BW_OYOFF_H)<<BP_OYOFF_H))
#define CIOCBOFF(n,k)           ((((n)&BW_OCBOFF_V)<<BP_OCBOFF_V)|(((k)&BW_OCBOFF_H)<<BP_OCBOFF_H))
#define CIOCROFF(n,k)           ((((n)&BW_OCROFF_V)<<BP_OCROFF_V)|(((k)&BW_OCROFF_H)<<BP_OCROFF_H))


#define IMG_TYPE_YV12(DX, DY, ORDER) \
    { \
        DX,                     \
        DY,                     \
        CAM_FORMAT_YCBCR420_3PLANE,      \
        CAM_ORDER_NONE,         \
    }
#define IMG_TYPE_YUV420_3PLANE(DX,DY, ORDER)  IMG_TYPE_YV12(DX,DY,ORDER)

#define IMG_TYPE_NV12(DX, DY, ORDER) \
    { \
        DX,                     \
        DY,                     \
        CAM_FORMAT_YCBCR420_2PLANE,      \
        CAM_ORDER_NONE,         \
    }
#define IMG_TYPE_YUV420_2PLANE(DX,DY, ORDER)  IMG_TYPE_NV12(DX,DY,ORDER)

#define IMG_TYPE_YUV422(DX, DY, ORDER) \
    { \
        DX,                     \
        DY,                     \
        CAM_FORMAT_YCBYCR422_1PLANE,      \
        ORDER,                  \
    }

#define IMG_TYPE_RGB16(DX, DY, ORDER) \
    { \
        DX,                     \
        DY,                     \
        CAM_FORMAT_RGB16,       \
        CAM_ORDER_NONE,         \
    }

#define IMG_TYPE_RGB24(DX, DY, ORDER) \
    { \
        DX,                     \
        DY,                     \
        CAM_FORMAT_RGB24,       \
        CAM_ORDER_NONE,         \
    }

/// Enumerations

/// From Here: This is merged from firmware code, camif class
// this is used for ModuleDesc
typedef enum
{
    IMAGE_SIZE_QCIF  = 0,  // 176x144
    IMAGE_SIZE_SQCIF = 1,  // 176x176
    IMAGE_SIZE_QVGA  = 2,  // 320x240
    IMAGE_SIZE_CIF   = 3,  // 352x288
    IMAGE_SIZE_WQVGA = 4,  // 400x240
    IMAGE_SIZE_VGA   = 5,  // 640x480
    IMAGE_SIZE_D1    = 6,  // 720x480
    IMAGE_SIZE_WVGA  = 7,  // 800x480

    IMAGE_SIZE_SVGA  = 8,  // 800x600
    IMAGE_SIZE_720P  = 9,  // 1280x720
    IMAGE_SIZE_1280A = 10, // 1280x960
    IMAGE_SIZE_UXGA  = 11, // 1600x1200(2M)
    IMAGE_SIZE_QXGA  = 12, // 2048x1536(3M)
    IMAGE_SIZE_WQXGA = 13, // 2560x1536(4M)
    IMAGE_SIZE_QSXGA = 14, // 2560x1920(5M)
    IMAGE_SIZE_6MEGA = 15, // 3264x1960(6M)

    IMAGE_SIZE_8MEGA = 16, // 3264x2448(8M)
    IMAGE_SIZE_MAX   = 17,
} CAMIF_IMG_SIZE;

// this is used for CAMIF(PostProc)
typedef enum
{
    QCIF    = 0,
    CIF     = 1,
    QQVGA   = 2,
    QVGA    = 3,
    VGA     = 4,
    SVGA    = 5,
    SXGA    = 6,
    UXGA    = 7,
    QXGA    = 8,
    WVGA    = 9,
    HD720   = 10,
    HD1080  = 11,
    SUB_SAMPLING2 = 12, /*800x600*/
    SUB_SAMPLING4 = 13, /*400x300*/
    SD480   = 14,
    SD576   = 15,
    WWSD480 = 16,
    WWSD576 = 17
} IMG_SIZE;
/*    CIF      = 352x288
    WVGA     = 800x480
    SVGA     = 800x600
    SXGA     = 1280x1024
    UXGA     = 1600x1200
    QXGA     = 2048x1536
    SD480    = 720x480
    SD576    = 720x576
    WWSD480  = 1440x480
    WWSD576  = 1440x576
    HD720    = 1280x720
    HD1080   = 1920x1080
*/

enum IMG_TYPE // I : Interlaced, IW : Interlaced Weave, None : Progressive
{
    PAL1, PAL2, PAL4, PAL8,
    RGB8, ARGB8, RGB16, ARGB16, RGB24, ARGB24, ARGB32_8888,
    RGB16_I, RGB16_IW, RGB24_I, RGB24_IW,
    BayerRGB8, BayerRGB10, BayerRGB12,
    CRYCBY, CBYCRY, YCRYCB, YCBYCR, // Y/Cb/Cr interleave (1 plane)
    NV12, NV16, NV24, // Y/C non-interleave, Cb/Cr interleave (2 plane)
    NV12_I, NV12_IW, // Y/C non-interleave, Cb/Cr interleave (2 plane)
    TILE_NV12, TILE_NV12_IW, // Y/C non-interleave, Cb/Cr interleave (2 plane), 64 bytes x 32 lines
    YC420, YC422, YC444, // Y/Cb/Cr non-interleave (3 plane)
    USER_DEFINED_TYPE1, USER_DEFINED_TYPE2, USER_DEFINED_TYPE3, USER_DEFINED_TYPE4
};

enum IMG_IF_TYPE
{
    RGB_IF, YC444_IF, YC422_IF, YC420_IF
};

enum SCAN_MODE
{
    INTERLACE = (1<<BP_INTERLACE),
    PROGRESSIVE = (0<<BP_INTERLACE)
};

enum CIS_MODEL
{
    OV7620, S5X433, AU70H, S5X3A1, S5K3AAE, S5K4AAF, OV3640F, OV2655F,  S5K4CAGX, ADV7180
};

/// To Here

typedef enum _CAMIF_USE {
    USE_FOR_NONE = 0,
    USE_FOR_CAMERA,
    USE_FOR_POST
} CAMIF_USE;

typedef enum _CAMIF_OPERATION_MODE{
    ABNORMAL_MODE = 0x0,
    VIDEO_CAPTURE = 0x1,
    STILL_CAPTURE = 0x2,
    PREVIEW_CAPTURE = 0x4,
    POST_PROCESSOR = 0x8
} CAMIF_OPERATION_MODE;

typedef enum _CAMIF_INPUTPORT{
    CAM_A_PORT = 0,
    CAM_B_PORT,
    CAM_C_MIPI_PORT,
    CAM_DMA_PORT,
    CAM_PORT_NONE
} CAMIF_INPUTPORT;

typedef enum _ADDRESS_MODE {
    MODE_MEM_COPY = 1,
    MODE_DIRECT,
    MODE_LOCAL_PATH
} ADDRESS_MODE;

typedef enum _CAMIF_ITU_FORMAT{
    CAM_ITU656 = 0,
    CAM_ITU601 = 1
} CAMIF_ITU_FORMAT;

enum CAMERA_POST_ERROR {
   ERROR_CAMIF_SUCCESS = 0,
   ERROR_CAMIF_NOTENOUGHMEMORY = 0xE001,
   ERROR_CAMIF_INVALIDADDRESS = 0xE002,
   ERROR_CAMIF_INVALIDIMAGETYPE = 0xE003,
   ERROR_CAMIF_MODULEERR = 0xE004,
   ERROR_CAMIF_ALREADYUSED = 0xE005,
   ERROR_CAMIF_ALREADYRUNNING = 0xE006,
   ERROR_CAMIF_NOTSUPPORTED = 0xE007,
   ERROR_CAMIF_NOTDEFINED = 0xE999
};

enum YCBCR_ORDER{
    CAM_ORDER_YCBYCR = 0,
    CAM_ORDER_YCRYCB,
    CAM_ORDER_CBYCRY,
    CAM_ORDER_CRYCBY,
    CAM_ORDER_NONE
};

typedef enum _CAM_IMG_FORMAT{
    CAM_FORMAT_YCBCR420_3PLANE = 0x0,
    CAM_FORMAT_YV12 = 0x0,
    CAM_FORMAT_YCBYCR422_3PLANE = 0x1,

    CAM_FORMAT_YCBYCR422_1PLANE = 0x2,
    CAM_FORMAT_CBYCRY422_1PLANE = 0x3,
    CAM_FORMAT_YCRYCB422_1PLANE = 0x4,
    CAM_FORMAT_CRYCBY422_1PLANE = 0x5,

    CAM_FORMAT_RGB16 = 0x6,
    CAM_FORMAT_RGB24 = 0x7,
    CAM_FORMAT_YCBCR444 = 0x8,
    CAM_FORMAT_YCBCR420_2PLANE = 0x9,
    CAM_FORMAT_NV12 = 0xa,
    CAM_FORMAT_IJPG = 0xb,
    CAM_FORMAT_RAW8 = 0xc,
    CAM_FORMAT_RAW10 = 0xd,
    CAM_FORMAT_RAW12 = 0xe,
    CAM_FORMAT_YCBYCR422_2PLANE = 0xf,
    CAM_FORMAT_NV12_WEAVE = 0x10,
    CAM_FORMAT_RGB18 = 0x11,
    CAM_FORMAT_NONE = 0xff
} CAM_IMG_FORMAT;

enum CAM_IMG_PLANE{
    CAM_1PLANE = 0,
    CAM_2PLANE = 1,
    CAM_3PLANE = 2
};

typedef enum _CAM_DMA_DIRECTION {
    CAM_DMA_INPUT = 0,
    CAM_DMA_OUTPUT = 1
} CAM_DMA_DIRECTION;

typedef enum _CAM_IMAGE_EFFECT {
    EFFECT_BYPASS = 0,
    EFFECT_ARBITRARY = 1,
    EFFECT_NEGATIVE = 2,
    EFFECT_ARTFREEZE = 3,
    EFFECT_EMBOSSING = 4,
    EFFECT_SILHOUETTE = 5
} CAM_IMAGE_EFFECT;


typedef enum _CAM_DMA_MODE {
    CAM_DMA_LINEAR = 0,
    CAM_DMA_CONFIGURABLE = 1,
    CAM_DMA_16BY16 = 2,
    CAM_DMA_64BY32 = 3,
} CAM_DMA_MODE;

typedef enum _CAM_DMA_HSIZE {
    CAM_DMA_64BYTES = 0,
    CAM_DMA_128BYTES = 1,
    CAM_DMA_256BYTES = 2,
    CAM_DMA_512BYTES = 3,
    CAM_DMA_1024BYTES = 4,
    CAM_DMA_2048BYTES = 5,
    CAM_DMA_4096BYTES = 6
} CAM_DMA_HSIZE;

typedef enum _CAM_DMA_VSIZE {
    CAM_DMA_1LINE = 0,
    CAM_DMA_2LINES = 1,
    CAM_DMA_4LINES = 2,
    CAM_DMA_8LINES = 3,
    CAM_DMA_16LINES = 4,
    CAM_DMA_32LINES = 5
} CAM_DMA_VSIZE;

typedef enum
{
    UNKNOWN_MODULE = 0,
    SYSLSI_OV2655,
    SYSLSI_OV3640,
    SYSLSI_S5K4EAGX,
    SYSLSI_S5K6AAFX,
    NEC_CE131,
    SAMSUNG_S5KA3DFX,
    MODULE_ID_MAX,
} MODULE_SENSOR;
typedef void (*PFNCAMHANDLEFRAME)( DWORD dwContext );

// structures
typedef struct {
    CAMIF_INPUTPORT  CamPort;
    MODULE_SENSOR  ModuleName;
} CAMERA_MODULE_DESC;


// Structure Definitions
typedef struct
{
        DWORD VirtAddr;
        int   size;             // size of the buffer
        int   BufferID;         // a buffer ID used to identify this buffer to the driver
        union{
            DWORD *pY;
            DWORD *pRGB;
        };
        DWORD *pCb;
        DWORD *pCr;
//        DWORD *pBuf;            // Address of the DMA buffer returned from a call to malloc().
} CAMERA_DMA_BUFFER_INFO, *P_CAMERA_DMA_BUFFER_INFO;

// structures
typedef struct {
    UINT32  Width;
    UINT32  Height;
    CAM_IMG_FORMAT Format;
    union {
        int     Size;
        CAMIF_OPERATION_MODE     Type;
    };
    int     FrameSize;
    int     vBufAddr[4];
} BUFFER_DESC;

typedef struct _CAMIF_OFFSET {
    UINT32 HorOffset;     // Horizontal size
    UINT32 HorOffset2;     // Horizontal size
    UINT32 VerOffset;        // Vertical size
    UINT32 VerOffset2;        // Vertical size
} CAMIF_OFFSET, *PCAMIF_OFFSET;

typedef struct _CAMIF_CONTEXT {
    CAMIF_USE usefor;
    CAMIF_OFFSET offset;
    UINT32 SourceFormat;     // source format
    UINT32 SourceOrder422;     // 4:2:2 order
    UINT32 SourceHSize;     // Horizontal size
    UINT32 SourceVSize;        // Vertical size
} CAMIF_CONTEXT, *PCAMIF_CONTEXT;

typedef struct _BUFFER_ADDRESS {
    DWORD           physicalAddr;
    DWORD           virtualAddr;
} BUFFER_ADDRESS;

typedef struct _IMG_TYPE_ITEM {
    unsigned int width;
    unsigned int height;
    CAM_IMG_FORMAT outputFormat;
    unsigned int outputOrder;
    unsigned int outputPlane;
} IMG_TYPE_ITEM;

typedef struct _CAM_START_ARGS {
    ADDRESS_MODE    mode;
} CAM_START_ARGS, *PCAM_START_ARGS;

typedef struct _CAM_STILLCUT_ARGS {
    ADDRESS_MODE    mode;
    PVOID           buffer;
    BUFFER_ADDRESS  directBuffer;
} CAM_STILLCUT_ARGS, *PCAM_STILLCUT_ARGS;

typedef struct _CAM_IMGTYPE_ARGS {
    IMG_TYPE_ITEM   imgtype;
} CAM_IMGTYPE_ARGS, *PCAM_IMGTYPE_ARGS;

    // Signals the application that the video or still image frame is available
typedef struct _CAM_CALLBACK_ARGS {
    // Pointer to camera driver instance which we will send back with callback functions
    DWORD dwCameraDriverContext;
    // This callback function is used to signal the application that the video frame is now available.
    PFNCAMHANDLEFRAME pfnCameraHandleVideoFrame;
    // This callback function is used to signal the application that the still image is now available.
    PFNCAMHANDLEFRAME pfnCameraHandleStillFrame;
    // This callback function is used to signal the application that the Preview image is now available.
    PFNCAMHANDLEFRAME pfnCameraHandlePreviewFrame;
} CAM_CALLBACK_ARGS, *PCAM_CALLBACK_ARGS;

typedef struct _CAM_DMA_PARAMETER_ARGS {
    BOOL bInOutType;    // For Input DMA or Output DMA, 0:Input, 1:Output
    CAM_DMA_MODE dwMode;       // DMA address access style, 0:Linear, 1:Confugrable Tile, 2:16x16 tile,
    CAM_DMA_HSIZE dwTileHSize;
    CAM_DMA_VSIZE dwTileVSize;
} CAM_DMA_PARAMETER_ARGS, *PCAM_DMA_PARAMETER_ARGS;

/*
typedef enum
{
    POST_IDLE = 0,
    POST_BUSY
} POST_STATE;
  */

#endif
