//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    pdd_intf.cpp

Abstract:       High level camera control PDD part interface implementation

Functions:


Notes:


--*/

#include <bsp.h>
#include <pm.h>

#include "Cs.h"
#include "Csmedia.h"

#include "CameraPDDProps.h"
#include "dstruct.h"
#include "dbgsettings.h"

#include "camera_hal.h"
#include <camera.h>
#include "CameraDriver.h"
#include "PinDriver.h"

#include "CameraPDD.h"
#include "camera_pdd.h"
#include "wchar.h"

#include <drvmsg.h>

#define MSG_ERROR        1
#define MSG_INOUT        0
#define MSG_ON           0

PVOID PDD_Init( PVOID MDDContext, PPDDFUNCTBL pPDDFuncTbl )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));

    DWORD dwRet = ERROR_SUCCESS;
    CCameraPdd *pDD = new CCameraPdd();
    if ( pDD == NULL )
    {
        return NULL;
    }
    dwRet = pDD->PDDInit( MDDContext, pPDDFuncTbl );
    if( ERROR_SUCCESS != dwRet )
    {
        return NULL;
    }
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD;

}

DWORD PDD_DeInit( LPVOID PDDContext )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD != NULL )
    {
        pDD->PDD_DeInit();
        delete pDD;
    }
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return ERROR_SUCCESS;
}

DWORD PDD_GetAdapterInfo( LPVOID PDDContext, PADAPTERINFO pAdapterInfo )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if( NULL == pDD )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->GetAdapterInfo( pAdapterInfo );
}

DWORD PDD_HandleVidProcAmpChanges( LPVOID PDDContext, DWORD dwPropId, LONG lFlags, LONG lValue)
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->HandleVidProcAmpChanges( dwPropId, lFlags, lValue );
}

DWORD PDD_HandleCamControlChanges( LPVOID PDDContext, DWORD dwPropId, LONG lFlags, LONG lValue )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->HandleCamControlChanges( dwPropId, lFlags, lValue );
}

DWORD PDD_HandleVideoControlCapsChanges( LPVOID PDDContext, LONG lModeType ,ULONG ulCaps )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->HandleVideoControlCapsChanges( lModeType, ulCaps );
}

DWORD PDD_SetPowerState( LPVOID PDDContext, CEDEVICE_POWER_STATE PowerState )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->SetPowerState( PowerState );
}


DWORD PDD_HandleAdapterCustomProperties( LPVOID PDDContext, PUCHAR pInBuf, DWORD  InBufLen, PUCHAR pOutBuf, DWORD  OutBufLen, PDWORD pdwBytesTransferred )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->HandleAdapterCustomProperties( pInBuf, InBufLen, pOutBuf, OutBufLen, pdwBytesTransferred );
}


DWORD PDD_InitSensorMode( LPVOID PDDContext, ULONG ulModeType, LPVOID ModeContext )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->InitSensorMode( ulModeType, ModeContext );
}

DWORD PDD_DeInitSensorMode( LPVOID PDDContext, ULONG ulModeType )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->DeInitSensorMode( ulModeType );
}

DWORD PDD_SetSensorState( LPVOID PDDContext, ULONG ulModeType, CSSTATE CsState )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->SetSensorState( ulModeType, CsState );
}

DWORD PDD_TakeStillPicture( LPVOID PDDContext, LPVOID pBurstModeInfo )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->TakeStillPicture( pBurstModeInfo );
}

DWORD PDD_GetSensorModeInfo( LPVOID PDDContext, ULONG ulModeType, PSENSORMODEINFO pSensorModeInfo )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->GetSensorModeInfo( ulModeType, pSensorModeInfo );
}

DWORD PDD_SetSensorModeFormat( LPVOID PDDContext, ULONG ulModeType, PCS_DATARANGE_VIDEO pCsDataRangeVideo )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->SetSensorModeFormat( ulModeType, pCsDataRangeVideo );
}

PVOID PDD_AllocateBuffer( LPVOID PDDContext, ULONG ulModeType )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return NULL;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->AllocateBuffer( ulModeType );
}

DWORD PDD_DeAllocateBuffer( LPVOID PDDContext, ULONG ulModeType, PVOID pBuffer )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->DeAllocateBuffer( ulModeType, pBuffer );
}

DWORD PDD_RegisterClientBuffer( LPVOID PDDContext, ULONG ulModeType, PVOID pBuffer )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->RegisterClientBuffer( ulModeType, pBuffer );
}

DWORD PDD_UnRegisterClientBuffer( LPVOID PDDContext, ULONG ulModeType, PVOID pBuffer )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->UnRegisterClientBuffer( ulModeType, pBuffer );
}

DWORD PDD_FillBuffer( LPVOID PDDContext, ULONG ulModeType, PUCHAR pImage )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->FillBuffer( ulModeType, pImage );
}

DWORD PDD_HandleModeCustomProperties( LPVOID PDDContext, ULONG ulModeType, PUCHAR pInBuf, DWORD  InBufLen, PUCHAR pOutBuf, DWORD  OutBufLen, PDWORD pdwBytesTransferred )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->HandleSensorModeCustomProperties( ulModeType, pInBuf, InBufLen, pOutBuf, OutBufLen, pdwBytesTransferred );
}


BOOL PDD_RequestCameraResources( LPVOID PDDContext )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->RequestCameraResources( );
}

BOOL PDD_ReleaseCameraResources( LPVOID PDDContext )
{
    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]++%s\n"), _T(__FUNCTION__)));
    CCameraPdd *pDD = (CCameraPdd *)PDDContext;
    if ( pDD == NULL )
    {
        return ERROR_INVALID_PARAMETER;
    }

    DBGMSG(CAMF_FUNC && CAMF_USR2,(TEXT("[CAMFILTER]--%s\n"), _T(__FUNCTION__)));
    return pDD->ReleaseCameraResources( );
}

