#include <windows.h>
#include <bsp.h>
#include <bsp_cfg.h>
#include "ac97_interface_macro.h"
#include "ac97_interface.h"

//#ifdef    REMOVE_BEFORE_RELEASE
#if 0
#define AC97_MSG(x)
#define AC97_INF(x)
#define AC97_ERR(x)    RETAILMSG(TRUE, x)
#else
//#define AC97_MSG(x)    RETAILMSG(TRUE, x)
#define AC97_MSG(x)
#define AC97_INF(x)    RETAILMSG(TRUE, x)
//#define AC97_INF(x)
#define AC97_ERR(x)    RETAILMSG(TRUE, x)
//#define AC97_ERR(x)
#endif

#define DELAY_LOOP_COUNT    (660000000/100000)
#define CONTROL_DELAY        (10)
#define CMD_DELAY            (3)

static volatile AC97_REG *g_pAC97Reg = NULL;
static volatile GPIO_REG *g_pGPIOReg = NULL;

AC97_ERROR AC97_initialize_register_address(void *pAC97Reg, void *pGPIOReg)
{
    AC97_ERROR error = AC97_SUCCESS;

    AC97_MSG((_T("[AC97]++AC97_initialize_register_address(0x%08x, 0x%08x)\n\r"), pAC97Reg, pGPIOReg));

    if (pAC97Reg == NULL || pGPIOReg == NULL)
    {
        AC97_ERR((_T("[AC97:ERR] AC97_initialize_register_address() : NULL pointer parameter\n\r")));
        error = AC97_ERROR_NULL_PARAMETER;
    }
    else
    {
        g_pAC97Reg = (AC97_REG *)pAC97Reg;
        g_pGPIOReg = (GPIO_REG *)pGPIOReg;
        AC97_INF((_T("[AC97:INF] g_pAC97Reg = 0x%08x\n\r"), g_pAC97Reg));
        AC97_INF((_T("[AC97:INF] g_pGPIOReg = 0x%08x\n\r"), g_pGPIOReg));
    }

    AC97_MSG((_T("[AC97]--AC97_initialize_register_address() : %d\n\r"), error));

    return error;
}

void AC97_initialize_ACLink(void)
{
    AC97_MSG((_T("[AC97] ++AC97_initialize_ACLink()\n\r")));

    AC97_port_initialize();

    // Codec Chip Need Cold - Cold- Warm Reset Sequence !!!

    // Cold Reset
    AC97_cold_reset();

    // Cold Reset Again
    AC97_cold_reset();

    // Warm Reset
    AC97_warm_reset();

    // Enable Codec Ready Interrupt
    //AC97_enable_codec_ready_interrupt();

    // AC-Link On
    AC97_set_ACLink_On();

    AC97_MSG((_T("[AC97] --AC97_initialize_ACLink()\n\r")));
}

void AC97_enable_ACLink_data_transfer(void)
{
    AC97_MSG((_T("[AC97] AC97_enable_ACLink_data_transfer()\n\r")));

    g_pAC97Reg->AC_GLBCTRL |= ACLINK_DATA_TRANSFER_ENABLE;
    DelayLoop(CONTROL_DELAY);
}

void AC97_disable_ACLink_data_transfer(void)
{
    AC97_MSG((_T("[AC97] AC97_disable_ACLink_data_transfer()\n\r")));

    g_pAC97Reg->AC_GLBCTRL &= ~ACLINK_DATA_TRANSFER_ENABLE;
    DelayLoop(CONTROL_DELAY);
}

BOOL AC97_wait_for_codec_ready(void)
{
    int iCnt = 0;

    AC97_MSG((_T("[AC97] AC97_wait_for_codec_ready()\n\r")));

    // Waiting for Codec Ready
    while(!(AC97_get_status()&CODEC_READY_INT_PEND))
    {
        if (iCnt > 100)
        {
            AC97_ERR((_T("[AC97:ERR] AC97_wait_for_codec_ready() : Codec can't be initialized\n\r")));
            return FALSE;
        }

        iCnt++;
        Sleep(10);
    }

    AC97_INF((_T("[AC97:INF] AC97_wait_for_codec_ready() : Status = 0x%08x\n\r"), AC97_get_status()));

    return TRUE;
}

AC97_ERROR AC97_set_pcmout_transfer_mode(AC97_CHANNEL_MODE eMode)
{
    AC97_ERROR error = AC97_SUCCESS;

    AC97_MSG((_T("[AC97] AC97_set_pcmout_transfer_mode(%d)\n\r"), eMode));

    switch(eMode)
    {
    case AC97_CH_OFF:
        g_pAC97Reg->AC_GLBCTRL &= ~PCMOUT_TRANSFER_MODE_MASK;
        break;
    case AC97_CH_PIO:
        g_pAC97Reg->AC_GLBCTRL = (g_pAC97Reg->AC_GLBCTRL & ~(PCMOUT_TRANSFER_MODE_MASK)) | PCMOUT_TRANSFER_PIO;
        break;
    case AC97_CH_DMA:
        g_pAC97Reg->AC_GLBCTRL = (g_pAC97Reg->AC_GLBCTRL & ~(PCMOUT_TRANSFER_MODE_MASK)) | PCMOUT_TRANSFER_DMA;
        break;
    default:
        AC97_ERR((_T("[AC97:ERR] AC97_set_pcmout_transfer_mode() : Unknown Mode [%d]\n\r"), eMode));
        error = AC97_ERROR_ILLEGAL_PARAMETER;
        g_pAC97Reg->AC_GLBCTRL &= ~PCMOUT_TRANSFER_MODE_MASK;
        break;
    }

    return error;
}

AC97_ERROR AC97_set_pcmin_transfer_mode(AC97_CHANNEL_MODE eMode)
{
    AC97_ERROR error = AC97_SUCCESS;

    AC97_MSG((_T("[AC97] AC97_set_pcmin_transfer_mode(%d)\n\r"), eMode));

    switch(eMode)
    {
    case AC97_CH_OFF:
        g_pAC97Reg->AC_GLBCTRL &= ~PCMIN_TRANSFER_MODE_MASK;
        break;
    case AC97_CH_PIO:
        g_pAC97Reg->AC_GLBCTRL = (g_pAC97Reg->AC_GLBCTRL & ~(PCMIN_TRANSFER_MODE_MASK)) | PCMIN_TRANSFER_PIO;
        break;
    case AC97_CH_DMA:
        g_pAC97Reg->AC_GLBCTRL = (g_pAC97Reg->AC_GLBCTRL & ~(PCMIN_TRANSFER_MODE_MASK)) | PCMIN_TRANSFER_DMA;
        break;
    default:
        AC97_ERR((_T("[AC97:ERR] AC97_set_pcmin_transfer_mode() : Unknown Mode [%d]\n\r"), eMode));
        error = AC97_ERROR_ILLEGAL_PARAMETER;
        g_pAC97Reg->AC_GLBCTRL &= ~PCMIN_TRANSFER_MODE_MASK;
        break;
    }

    return error;
}

AC97_ERROR AC97_set_micin_transfer_mode(AC97_CHANNEL_MODE eMode)
{
    AC97_ERROR error = AC97_SUCCESS;

    AC97_MSG((_T("[AC97] AC97_set_micin_transfer_mode(%d)\n\r"), eMode));

    switch(eMode)
    {
    case AC97_CH_OFF:
        g_pAC97Reg->AC_GLBCTRL &= ~MICIN_TRANSFER_MODE_MASK;
        break;
    case AC97_CH_PIO:
        g_pAC97Reg->AC_GLBCTRL = (g_pAC97Reg->AC_GLBCTRL & ~(MICIN_TRANSFER_MODE_MASK)) | MICIN_TRANSFER_PIO;
        break;
    case AC97_CH_DMA:
        g_pAC97Reg->AC_GLBCTRL = (g_pAC97Reg->AC_GLBCTRL & ~(MICIN_TRANSFER_MODE_MASK)) | MICIN_TRANSFER_DMA;
        break;
    default:
        AC97_ERR((_T("[AC97:ERR] AC97_set_micin_transfer_mode() : Unknown Mode [%d]\n\r"), eMode));
        error = AC97_ERROR_ILLEGAL_PARAMETER;
        g_pAC97Reg->AC_GLBCTRL &= ~MICIN_TRANSFER_MODE_MASK;
        break;
    }

    return error;
}

void AC97_write_codec(unsigned char ucReg, unsigned short usData)
{
    g_pAC97Reg->AC_CODEC_CMD = CMD_WRITE | CMD_ADDRESS(ucReg) | CMD_DATA(usData);
    DelayLoop(CMD_DELAY);

    g_pAC97Reg->AC_CODEC_CMD |= CMD_READ;    //To receive SLOTREQ bits when VRA is '1'
    DelayLoop(CMD_DELAY);
}

unsigned short AC97_read_codec(unsigned char ucReg)
{
    unsigned short usVal;

    // Read Dummy
    usVal = STATUS_DATA(g_pAC97Reg->AC_CODEC_STAT);
    DelayLoop(CMD_DELAY);

    g_pAC97Reg->AC_CODEC_CMD = CMD_READ | CMD_ADDRESS(ucReg) | CMD_DATA(0x0);
    DelayLoop(CMD_DELAY);

    // Read Value
    usVal = STATUS_DATA(g_pAC97Reg->AC_CODEC_STAT);
    DelayLoop(CMD_DELAY);

    g_pAC97Reg->AC_CODEC_CMD |= CMD_READ;    //To receive SLOTREQ bits when VRA is '1'
    DelayLoop(CMD_DELAY);

    return usVal;
}

void AC97_enable_all_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= ALL_INT_ENABLE_MASK;
}

void AC97_enable_codec_ready_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= CODEC_READY_INT_ENABLE;
}

void AC97_enable_pcmout_underrun_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= PCMOUT_UR_INT_ENABLE;
}

void AC97_enable_pcmin_overrun_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= PCMIN_OR_INT_ENABLE;
}

void AC97_enable_micin_overrun_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= MICIN_OR_INT_ENABLE;
}

void AC97_enable_pcmout_threshold_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= PCMOUT_THOLD_INT_ENABLE;
}

void AC97_enable_pcmin_threshold_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= PCMIN_THOLD_INT_ENABLE;
}

void AC97_enable_micin_threshold_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= MICIN_THOLD_INT_ENABLE;
}

void AC97_disable_all_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL &= ~ALL_INT_ENABLE_MASK;
}

void AC97_disable_codec_ready_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL &= ~CODEC_READY_INT_ENABLE;
}

void AC97_disable_pcmout_underrun_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL &= ~PCMOUT_UR_INT_ENABLE;
}

void AC97_disable_pcmin_overrun_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL &= ~PCMIN_OR_INT_ENABLE;
}

void AC97_disable_micin_overrun_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL &= ~MICIN_OR_INT_ENABLE;
}

void AC97_disable_pcmout_threshold_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL &= ~PCMOUT_THOLD_INT_ENABLE;
}

void AC97_disable_pcmin_threshold_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL &= ~PCMIN_THOLD_INT_ENABLE;
}

void AC97_disable_micin_threshold_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL &= ~MICIN_THOLD_INT_ENABLE;
}

void AC97_clear_all_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= ALL_INT_CLEAR_MASK;
}

void AC97_clear_codec_ready_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= CODEC_READY_INT_PEND;
}

void AC97_clear_pcmout_underrun_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= PCMOUT_UR_INT_PEND;
}

void AC97_clear_pcmin_overrun_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= PCMIN_OR_INT_PEND;
}

void AC97_clear_micin_overrun_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= MICIN_OR_INT_PEND;
}

void AC97_clear_pcmout_threshold_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= PCMOUT_THOLD_INT_PEND;
}

void AC97_clear_pcmin_threshold_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= PCMIN_THOLD_INT_PEND;
}

void AC97_clear_micin_threshold_interrupt(void)
{
    g_pAC97Reg->AC_GLBCTRL |= MICIN_THOLD_INT_PEND;
}

unsigned int AC97_get_pcmout_physical_buffer_address(void)
{
    return (unsigned int)(0xE2200018);
}

unsigned int AC97_get_pcmin_physical_buffer_address(void)
{
    return (unsigned int)(0xE2200018);
}

unsigned int AC97_get_micin_physical_buffer_address(void)
{
    return (unsigned int)(0xE220001C);
}

static void AC97_port_initialize(void)
{
    AC97_MSG((_T("[AC97] AC97_port_initialize()\n\r")));

    // AC97 BITCLK    : GPC[0]
    // AC97 RESETn    : GPC[1]
    // AC97 SYNC      : GPC[2]
    // AC97 SDI       : GPC[3]
    // AC97 SDO       : GPC[4]

    g_pGPIOReg->GPC0.GP_PUD &= ~(0x3ff);    // Pull-Up/Down Disable
    g_pGPIOReg->GPC0.GP_CON = 0x44444;        

}

static void AC97_cold_reset(void)
{
    AC97_MSG((_T("[AC97] AC97_cold_reset()\n\r")));

    g_pAC97Reg->AC_GLBCTRL |= COLD_RESET;
    DelayLoop(CONTROL_DELAY);
    g_pAC97Reg->AC_GLBCTRL &= ~COLD_RESET;
    DelayLoop(CONTROL_DELAY);
}

static void AC97_warm_reset(void)
{
    AC97_MSG((_T("[AC97] AC97_warm_reset()\n\r")));

    g_pAC97Reg->AC_GLBCTRL |= WARM_RESET;
    DelayLoop(CONTROL_DELAY);
    g_pAC97Reg->AC_GLBCTRL &= ~WARM_RESET;
    DelayLoop(CONTROL_DELAY);
}

static void AC97_set_ACLink_On(void)
{
    AC97_MSG((_T("[AC97] AC97_set_ACLink_On()\n\r")));

    g_pAC97Reg->AC_GLBCTRL |= ACLINK_ON;
    DelayLoop(CONTROL_DELAY);
}

static void AC97_set_ACLink_Off(void)
{
    AC97_MSG((_T("[AC97] AC97_set_ACLink_Off()\n\r")));

    g_pAC97Reg->AC_GLBCTRL &= ~ACLINK_ON;
    DelayLoop(CONTROL_DELAY);
}

static AC97_STATUS AC97_get_status(void)
{
    return g_pAC97Reg->AC_GLBSTAT;
}

static void DelayLoop(unsigned int count)
{
    volatile int i, j=0;

    for(;count > 0;count--)
        for(i=0;i < DELAY_LOOP_COUNT; i++) { j++; }
}

