/*-----------------------------------------------------------------------------
 * Copyright (c) Wolfson Microelectronics plc.  All rights reserved.
 *
 * This software as well as any related documentation is furnished under 
 * license and may only be used or copied in accordance with the terms of the 
 * license. The information in this file is furnished for informational use 
 * only, is subject to change without notice, and should not be construed as 
 * a commitment by Wolfson Microelectronics plc. Wolfson Microelectronics plc
 * assumes no responsibility or liability for any errors or inaccuracies that
 * may appear in this document or any software that may be provided in
 * association with this document. 
 *
 * Except as permitted by such license, no part of this document may be 
 * reproduced, stored in a retrieval system, or transmitted in any form or by 
 * any means without the express written consent of Wolfson Microelectronics plc. 
 *
 *---------------------------------------------------------------------------*/
#ifndef _WM8580_H_
#define _WM8580_H_


typedef enum
{
    WM8580_PLLA1                        = 0x00,
    WM8580_PLLA2                        = 0x01,
    WM8580_PLLA3                        = 0x02,
    WM8580_PLLA4                        = 0x03,
    WM8580_PLLB1                        = 0x04,
    WM8580_PLLB2                        = 0x05,
    WM8580_PLLB3                        = 0x06,
    WM8580_PLLB4                        = 0x07,
    WM8580_CLKSEL                       = 0x08,
    WM8580_PAIF1                        = 0x09,
    WM8580_PAIF2                        = 0x0A,
    WM8580_SAIF1                        = 0x0B,
    WM8580_PAIF3                        = 0x0C,
    WM8580_PAIF4                        = 0x0D,
    WM8580_SAIF2                        = 0x0E,
    WM8580_DAC_CONTROL1                 = 0x0F,
    WM8580_DAC_CONTROL2                 = 0x10,
    WM8580_DAC_CONTROL3                 = 0x11,
    WM8580_DAC_CONTROL4                 = 0x12,
    WM8580_DAC_CONTROL5                 = 0x13,
    WM8580_DIGITAL_ATTENUATION_DACL1    = 0x14,
    WM8580_DIGITAL_ATTENUATION_DACR1    = 0x15,
    WM8580_DIGITAL_ATTENUATION_DACL2    = 0x16,
    WM8580_DIGITAL_ATTENUATION_DACR2    = 0x17,
    WM8580_DIGITAL_ATTENUATION_DACL3    = 0x18,
    WM8580_DIGITAL_ATTENUATION_DACR3    = 0x19,
    WM8580_MASTER_DIGITAL_ATTENUATION   = 0x1C,
    WM8580_ADC_CONTROL1                 = 0x1D,
    WM8580_SPDTXCHAN0                   = 0x1E,
    WM8580_SPDTXCHAN1                   = 0x1F,
    WM8580_SPDTXCHAN2                   = 0x20,
    WM8580_SPDTXCHAN3                   = 0x21,
    WM8580_SPDTXCHAN4                   = 0x22,
    WM8580_SPDTXCHAN5                   = 0x23,
    WM8580_SPDMODE                      = 0x24,
    WM8580_INTMASK                      = 0x25,
    WM8580_GPO1                         = 0x26,
    WM8580_GPO2                         = 0x27,
    WM8580_GPO3                         = 0x28,
    WM8580_GPO4                         = 0x29,
    WM8580_GPO5                         = 0x2A,
    WM8580_INTSTAT                      = 0x2B,
    WM8580_SPDRXCHAN1                   = 0x2C,
    WM8580_SPDRXCHAN2                   = 0x2D,
    WM8580_SPDRXCHAN3                   = 0x2E,
    WM8580_SPDRXCHAN4                   = 0x2F,
    WM8580_SPDRXCHAN5                   = 0x30,
    WM8580_SPDSTAT                      = 0x31,
    WM8580_PWRDN1                       = 0x32,
    WM8580_PWRDN2                       = 0x33,
    WM8580_READBACK                     = 0x34,
    WM8580_RESET                        = 0x35,
}  WM8580_RegAddr;

/* Powerdown Register 1 (register 32h) */
#define WM8580_PWRDN1_PWDN_ALL_ACTIVE      0<<0
#define WM8580_PWRDN1_PWDN_ALL_MUTE        1<<0
#define WM8580_PWRDN1_ADCPD_ENABLE         0<<1
#define WM8580_PWRDN1_ADCPD_DISABLE        1<<1
#define WM8580_PWRDN1_DACPD_0_ENABLE       0<<2
#define WM8580_PWRDN1_DACPD_0_DISABLE      1<<2
#define WM8580_PWRDN1_DACPD_1_ENABLE       0<<3
#define WM8580_PWRDN1_DACPD_1_DISABLE      1<<3
#define WM8580_PWRDN1_DACPD_2_ENABLE       0<<4
#define WM8580_PWRDN1_DACPD_2_DISABLE      1<<4
#define WM8580_PWRDN1_DACPD_ALL_ENABLE     0<<6
#define WM8580_PWRDN1_DACPD_ALL_DISABLE    1<<6

#define WM8580_ALL_POWER_ON                0x000


// WM8580 Codec-chip Initialization Value 
/*
unsigned int WM8580_Codec_Init_Table[][2] =
{
#if ((AP == I2S0_MASTER) && (CODEC == I2S0_SLAVE))

{ WM8580_RESET, 0x000 },
{ 0x1A, 0x0FF },
{ 0x1B, 0x0FF },
{ WM8580_MASTER_DIGITAL_ATTENUATION, 0x1FF } ,
{ WM8580_PLLB4, (3<<7)|(0<<5)|(1<<2)|(2<<0) },
{ WM8580_CLKSEL, (1<<4)|(0<<2)|(0<<0) },
{ WM8580_PAIF1, (0<<6)|(0<<5)|(0<<3)|(2<<0) },
{ WM8580_PAIF2, (0<<5)|(0<<3)|(2<<0) },
{ WM8580_PWRDN1, 0x00 },
{ WM8580_PAIF3, (3<<7)|(0<<2)|(2<<0) },
{ WM8580_PAIF4, (1<<7)|(0<<2)|(2<<0) },


#endif


#if ((AP == I2S0_SLAVE) && (CODEC == I2S0_MASTER))
//AP XCLKOUT 24MHz give to XTI

{WM8580_RESET, 0x000},//53		//Reset WM8580
{WM8580_PWRDN1, 0x022},//50		//Power Down 1: ADC Disable, DACs Enable, Digital Interface Enable 

{WM8580_PWRDN2, 0x03d},//51		//Power Down 2 : pll enabled, osc disabled.
//11.2896MHz 
//PLL A K-Value : 21B089 -- 10 0001 1011 0000  1000 1001 
//									      -----------
//						          ----------		
//PLL A N-Value :	8
{WM8580_PLLA1, 0x089},// 0		//PLL A K-Value : 0 1000 1001 [8:0]
{WM8580_PLLA2, 0x0d8},// 1		//PLL A K-Value : 01 1011 000 [17:9]
{WM8580_PLLA3, 0x078},// 2		//PLL A N-Value : 7,  PLL A K-Value : 1000 [21:18]
{WM8580_PLLA4, 0x015},// 3		//PLL A [4:3] freq mode-10,  [2]:1 , [1] post scale-0, [0] prescale.-1

{WM8580_PLLB4, 0x1b0},//07		//clkout : [6:5] :01ouput pllaclk. [8:7] 11 oscclk
{WM8580_CLKSEL, 0x055},//08		//CLKSEL : All ADC, DAC & SPDIF CLk source are PLLACLK
{WM8580_PAIF1, ((1<<6) | (1<<5) | (1<<3) | (2)) },//09	//PAIF 1	Master Reciever	  [5] master, RFS, BFS
{WM8580_PAIF3, (3<<7)|( 0 << 2)|(2 << 0)},        //12		//PAIF 3	CODEC Pri SDI format
{WM8580_DAC_CONTROL2, 0x009},//16						//DAC Control 2			Left , Right DAC Souce 
{WM8580_MASTER_DIGITAL_ATTENUATION, (1<<8)|( 0xff)},//28  				//volume control
};
#endif
*/
//Temporary macro for Codec setting, this will be removed.
//And Codec Abstract layer will be added

//////////////////////////////////////////////////
//
//	Common(Codec chip, Audio IPs)
//
//////////////////////////////////////////////////
typedef enum
{
	RFS_256fs = 0,		//8, 16
	RFS_512fs = 1,		//8, 16
	RFS_384fs = 2,		//8,16,24bit
	RFS_768fs = 3, 		//8,16,24bit
	RFS_NA = 10,		//not applicable.
}I2S_RFSLength;		//RFS

typedef enum
{
	I2SFormat 				= 0,
	MSBJustified 				= 1,
	LSBJustified 				= 2,
	AFTER_PCMSYNC_HIGH 	= 3,
	DURING_PCMSYNC_HIGH 	= 4,
	ACLinkSlot34				= 5,
	ACLinkSlot6				= 6,
}SerialDataFormat;


typedef enum
{
	I2S_Master = 0,
	I2S_Slave = 1,
}I2SOPMode;


typedef enum 
{
	I2STX=0,
	 I2SRX=1,
	 I2STRX=2,
}I2SDIR;

typedef enum 
{
	RCLK_PCLK=0,
	 RCLK_I2SCLK=1,
}I2SRCLK;

typedef enum
{
	CDCLK_Out = 0,
	CDCLK_In = 1,
}I2S_CDCLKCON;

typedef enum
{
	BFS_32fs = 0,
	BFS_48fs = 1,
	BFS_16fs = 2,
	BFS_24fs = 3,
}I2S_BFSLength;

//////////////////////////////////////////////////
//
//	Codec chip
//
//////////////////////////////////////////////////
typedef enum
{
	PRIMARY_PORT 		= 0,
	SECONDARY_PORT 			= 1,
}CODECport;
//	SMDK_PCM 			= 1,
//	SMDK_AC97 			= 2,
	
typedef enum
{
	Master = 0,
	Slave = 1,
}OPMode;



//////////////////////////////////////////////////
//
//	Not defined
//
//////////////////////////////////////////////////

typedef enum
{
	LINEIN 	= 0,
	MICIN	= 1,
}AudioSource;

typedef enum
{
	Word16 	= 0,
	Word8	= 1,
	Word24	= 2,
	Word20	= 3,
}PCMWordLength;

typedef enum
{
	CodecSource_I2S = 0,
	CodecSource_OSC = 1
}CodecClkSource;
//-----------------------------------------------------

#endif // _WM8580_H_




