//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
#pragma once
//
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.
 
-*/

#define WAVFILE_HEADER_SZ 44

class WAV  
{
public:
	
	WAV(DWORD uWavFileAddr);
	WAV();
	~WAV();

	void InitInstance(DWORD uWavFileAddr);
	void GetPcmStAddr(DWORD & uPcmAddr);
	void GetPcmSize(DWORD& uPcmSize);
	void GetSampleRate(DWORD& uSampleRate);
	void GetPcmAttrib(DWORD& uPcmSize, DWORD& uChannels, DWORD &uSampleRate, DWORD& uBitsPerSample);
	void PutHeader(DWORD uWavFileAddr, 
		DWORD uPcmSize, DWORD uChannels, DWORD uSampleRate, DWORD uBitsPerSample);
	void PutHeader(DWORD uPcmSize, DWORD uChannels, DWORD uSampleRate, DWORD uBitsPerSample);
	void SeparateCh(DWORD uWavFileAddr, DWORD uChIdx, DWORD uSaveAddr, DWORD& uSaveSize);

	void ExtendPcm(DWORD uWavFileAddr, DWORD uLimitSize=-1);

protected:
	
	void ParseHeader(DWORD uWavFileAddr, 
		DWORD& uPcmSize, DWORD& uChannels, DWORD &uSampleRate, DWORD& uBitsPerSample);
		
	DWORD m_uPcmSize;
	DWORD m_uChannelType;
	DWORD m_uSampleRate;
	DWORD m_uBitsPerSample;
	DWORD m_uPcmStAddr;
	DWORD m_uWavFileAddr;
};

inline void WAV::GetPcmStAddr(DWORD & uPcmAddr)
{
	uPcmAddr = m_uPcmStAddr;
}

inline void WAV::InitInstance(DWORD uWavFileAddr)
{
	m_uWavFileAddr = uWavFileAddr; 
	ParseHeader(uWavFileAddr, m_uPcmSize, m_uChannelType, m_uSampleRate, m_uBitsPerSample);
}

inline void WAV::GetPcmSize(DWORD & uPcmSize)
{
	uPcmSize = m_uPcmSize;
}

inline void WAV::GetSampleRate(DWORD& uSampleRate)
{
	uSampleRate = m_uSampleRate;
}

inline void WAV::GetPcmAttrib(DWORD& uPcmSize, DWORD& uChannels, DWORD &uSampleRate, DWORD& uBitsPerSample)
{
	uPcmSize = m_uPcmSize;
	uChannels = m_uChannelType;
	uSampleRate = m_uSampleRate;
	uBitsPerSample = m_uBitsPerSample;
}

inline void WAV::PutHeader(DWORD uPcmSize, DWORD uChannels, DWORD uSampleRate, DWORD uBitsPerSample)
{
	PutHeader(m_uWavFileAddr, uPcmSize, uChannels, uSampleRate, uBitsPerSample);
}

