/*-----------------------------------------------------------------------------
 * Copyright (c) Wolfson Microelectronics plc.  All rights reserved.
 *
 * This software as well as any related documentation is furnished under 
 * license and may only be used or copied in accordance with the terms of the 
 * license. The information in this file is furnished for informational use 
 * only, is subject to change without notice, and should not be construed as 
 * a commitment by Wolfson Microelectronics plc. Wolfson Microelectronics plc
 * assumes no responsibility or liability for any errors or inaccuracies that
 * may appear in this document or any software that may be provided in
 * association with this document. 
 *
 * Except as permitted by such license, no part of this document may be 
 * reproduced, stored in a retrieval system, or transmitted in any form or by 
 * any means without the express written consent of Wolfson Microelectronics plc. 
 *
 *---------------------------------------------------------------------------*/
#ifndef _CH7026_H_
#define _CH7026_H_


#define CH7026_ID 				0x54
#define I2C_CH7026_ID            0xEC  // IIC ADDRESS
#define I2C_CH7026_SPEED         100



//CVBS NTSC_M OutPut
unsigned short CH7026_Init_CVBS[][2] = {
{ 0x02, 0x01 },
{ 0x02, 0x03 },
{ 0x03, 0x00 },
{ 0x04, 0x39 },
{ 0x0F, 0x23 },
{ 0x10, 0x20 },
{ 0x11, 0x22 },
{ 0x12, 0x40 },
{ 0x13, 0xDC },
{ 0x14, 0x0A },
{ 0x15, 0x11 },
{ 0x16, 0xE0 },
{ 0x17, 0x0F },
{ 0x19, 0x1E },
{ 0x1A, 0x07 },
{ 0x1C, 0x1E },
{ 0x22, 0xBD },
{ 0x36, 0xC8 },
{ 0x41, 0xA2 },
{ 0x4D, 0x04 },
{ 0x4E, 0x27 },
{ 0x4F, 0x62 },
{ 0x50, 0x76 },
{ 0x51, 0x51 },
{ 0x52, 0x12 },
{ 0x53, 0x1B },
{ 0x55, 0xE5 },
{ 0x5E, 0x80 },
{ 0x69, 0x64 },
{ 0x7D, 0x62 },
{ 0x04, 0x38 },
{ 0x06, 0x71 },

/*
NOTE: The following five repeated sentences are used here to wait memory initial complete, please don't remove...(you could refer to Appendix A of programming guide document (CH7025(26)B Programming Guide Rev2.03.pdf or later version) for detailed information about memory initialization! 
*/
{ 0x03, 0x00 },
{ 0x03, 0x00 },
{ 0x03, 0x00 },
{ 0x03, 0x00 },
{ 0x03, 0x00 },

{ 0x06, 0x70 },
{ 0x02, 0x02 },
{ 0x02, 0x03 },
{ 0x04, 0x00 },
};


//VGA 800*600
unsigned short CH7026_Init_VAG800600[][2] = {
{ 0x02, 0x01 },
{ 0x02, 0x03 },
{ 0x03, 0x00 },
{ 0x04, 0x39 },
{ 0x08, 0x08 },
{ 0x09, 0x80 },

{ 0x0D, 0x08 },
{ 0x0F, 0x23 },
{ 0x10, 0x20 },
{ 0x11, 0x22 },
{ 0x12, 0x40 },//{ 0x12, 0x40 },
{ 0x13, 0xe6 },//{ 0x13, 0xa6 },//{ 0x13, 0x26 },//increase add h size,or inc size
{ 0x14, 0x0A },
{ 0x15, 0x11 },
{ 0x16, 0xf0 },//{ 0x16, 0xE0 },//increase add v size,or inc size
{ 0x17, 0x0F },
{ 0x19, 0x12 },
{ 0x1A, 0x07 },
{ 0x1B, 0x23 },
{ 0x1C, 0x20 },
{ 0x1D, 0x20 },
{ 0x1F, 0x28 },
{ 0x20, 0x80 },
{ 0x21, 0x12 },
{ 0x22, 0x58 },
{ 0x23, 0x74 },
{ 0x25, 0x01 },
{ 0x26, 0x04 },
{ 0x37, 0x20 },
{ 0x39, 0x20 },
{ 0x3B, 0x20 },
{ 0x41, 0xA2 },
{ 0x4D, 0x03 },
{ 0x4E, 0x0F },
{ 0x4F, 0x8E },
{ 0x50, 0x92 },
{ 0x51, 0x51 },
{ 0x52, 0x12 },
{ 0x53, 0x13 },
{ 0x55, 0xE5 },
{ 0x5E, 0x80 },
{ 0x69, 0x64 },
{ 0x77, 0x03 },
{ 0x7D, 0x62 },
{ 0x04, 0x38 },
{ 0x06, 0x71 },
{ 0x36, 0x18 },//{ 0x36, 0x28 },//increase to move right,or move left
{ 0x34, 0x08 },//{ 0x36, 0x48 },//increase to move up,or move down

/*
NOTE: The following five repeated sentences are used here to wait memory initial complete, please don't remove...(you could refer to Appendix A of programming guide document (CH7025(26)B Programming Guide Rev2.03.pdf or later version) for detailed information about memory initialization! 
*/
{ 0x03, 0x00 },
{ 0x03, 0x00 },
{ 0x03, 0x00 },
{ 0x03, 0x00 },
{ 0x03, 0x00 },

{ 0x06, 0x70 },
{ 0x02, 0x02 },
{ 0x02, 0x03 },
{ 0x04, 0x00 },
//{0xffff, 0xfffe}
};

bool CH7026_Init(void);





#endif // _CH7026_H_




