//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
// -----------------------------------------------------------------------------
//
//      THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//      ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
//      THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//      PARTICULAR PURPOSE.
//
// -----------------------------------------------------------------------------

//
// iis_interface_macro.h

#ifndef _IIS_INTERFACE_MACRO_H_
#define _IIS_INTERFACE_MACRO_H_

#if __cplusplus
extern "C"
{
#endif


#define IIS_CH0_TXD_REG_PA  0xEEE30010 
#define IIS_CH0_RXD_REG_PA  0xEEE30014 
#define IIS_CH1_TXD_REG_PA  0XE2100010 
#define IIS_CH1_RXD_REG_PA  0XE2100014 
#define IIS_CH2_TXD_REG_PA  0XE2A00010 
#define IIS_CH2_RXD_REG_PA  0XE2A00014 



        /*---------------------------------------------------------*/
        // IISCON : IIS Interface Control Register
        /*---------------------------------------------------------*/
#define SW_RST_MASK                         (3 << 31)                                           
#define RESET_I2S_MODULE                    (0 << 31)
#define UNRESET_I2S_MODULE                 (1 << 31)
                                     
//  RESERVED                                  30:27                                  
                                     
#define FRXOFSTATUS_MASK                    (3 << 26)                                          
#define FRXOF_INT_DIDNT_OCCUR               (0 << 26)
#define FRXOF_INT_OCCURRED                  (1 << 26)
#define OCCURED_INT_OVR_RX                  (1 << 26)
                                   
#define FRXOFINTEN_MASK                     (3 << 25)                                          
#define RXFIFO_OVERFLOW_INT_DISABLE         (0 << 25)
#define RXFIFO_OVERFLOW_INT_ENABLE          (1 << 25)
                                    
#define FTXSUR_STATUS_MASK                  (3 << 24                                     
#define FTXSUR_INT_DIDNT_OCCUR              (0 << 24)
#define FTXSUR_INT_OCCURRED                 (1 << 24)
#define OCCURED_INT_UDR_TXS                 (1 << 24)
                                    
#define FTXSURINTEN_MASK                    (3 << 23)                                          
#define TXFIFO_S_UNDERRUN_INT_DISABLE       (0 << 23)
#define TXFIFO_S_UNDERRUN_INT_ENABLE        (1 << 23)
                                    
#define FTXSEMPT_MASK                       (3 << 22)                                          
#define TX_FIFO_S_NOT_EMPTY                 (0 << 22)
#define TX_FIFO_S_EMPTY                     (1 << 22)
                                    
#define FTXSFULL_MASK                       (3  << 21)                                      
#define TX_FIFO_S_NOT_FULL                  (0 << 21)
#define TX_FIFO_S_FULL                      (1 << 21)
                                    
#define TXSDMAPAUSE_MASK                    (3 << 20)                                          
#define NO_PAUSE_EXT_DMA_FOR_TX_FIFO_S      (0 << 20)
#define PAUSE_EXT_DMA_FOR_TX_FIFO_S         (1 << 20)

//  RESERVED                                   19                 
                                     
#define TXSDMACTIVE_MASK                    (3 << 18)                                          
#define TXSDMACTIVE_INACTIVE                (0 << 18)
#define TXSDMACTIVE_ACTIVE                  (1 << 18)
        
#define TX_FIFO_UNDERRUN_STATUS             (1 << 17)
#define OCCURED_INT_UDR_TXn                 (1 << 17)
#define TX_FIFO_UNDERRUN_INT_ENABLE         (1 << 16)
#define TX_FIFO_2_EMPTY_STATUS              (1 << 15)
#define TX_FIFO_1_EMPTY_STATUS              (1 << 14)
#define TX_FIFO_2_FULL_SATATUS              (1 << 13)
#define TX_FIFO_1_FULL_SATATUS              (1 << 12)

#define LEFT_RIGHT_INDICATION_STATUS        (1 << 11)
#define TX_FIFO_EMPTY_STATUS                (1 << 10)
#define RX_FIFO_EMPTY_STATUS                (1 <<  9)
#define TX_FIFO_FULL_STATUS                 (1 <<  8)
#define RX_FIFO_FULL_STATUS                 (1 <<  7)

#define IISCON_STATUS_MASK                  (0x1F << 7)

#define TX_DMA_NOPAUSE                      (0 <<  6)
#define TX_DMA_PAUSE                        (1 <<  6)
#define RX_DMA_NOPAUSE                      (0 <<  5)
#define RX_DMA_PAUSE                        (1 <<  5)

#define TX_CHANNEL_NOPAUSE                  (0 <<  4)
#define TX_CHANNEL_PAUSE                    (1 <<  4)

#define RX_CHANNEL_NOPAUSE                  (0 <<  3)
#define RX_CHANNEL_PAUSE                    (1 <<  3)

#define TX_DMA_INACTIVE                     (0 <<  2)
#define TX_DMA_ACTIVE                       (1 <<  2)

#define RX_DMA_INACTIVE                     (0 <<  1)
#define RX_DMA_ACTIVE                       (1 <<  1)

#define IIS_INACTIVE                        (0 <<  0)
#define IIS_ACTIVE                          (1 <<  0)

#define TX_MOD_MASK        (TX_DMA_PAUSE|TX_CHANNEL_PAUSE|TX_DMA_ACTIVE)
#define RX_MOD_MASK        (RX_DMA_PAUSE|RX_CHANNEL_PAUSE|RX_DMA_ACTIVE)

//#ifdef LPMODE
#define TXS_DMA_NOPAUSE                     (0 << 20)
#define TXS_DMA_PAUSE                       (1 << 20)

#define TXS_CHANNEL_NOPAUSE                 (0 << 19)
#define TXS_CHANNEL_PAUSE                   (1 << 19)

#define TXS_DMA_INACTIVE                    (0 << 18)
#define TXS_DMA_ACTIVE                      (1 << 18)

#define TXS_MOD_MASK        (TXS_DMA_PAUSE|TXS_CHANNEL_PAUSE|TXS_DMA_ACTIVE)
//#endif

        /*---------------------------------------------------------*/
        // IISMOD : IIS Interface Mode Register
        /*---------------------------------------------------------*/
//operation clock for i2s logic.                                   
#define OP_CLK_MASK             (3 << 30)                                                 
#define CODEC_CLOCK_OUT         (0 << 30)
#define CODEC_CLOCK_IN          (1 << 30)
#define BIT_CLOCK_OUT           (2 << 30)
#define AUDIO_BUS_CLOCK         (3 << 30)

//      RESERVED                [29]

//mux selection for secondary tx fifo_s   
#define OP_MUX_SEL_MASK         (3 << 28)                                                
#define TX_FIFO_S_APB_SFR      (0 << 28)
#define TX_FIFO_S_INTERNAL_DMA  (1 << 28)

//bit length control bit which decides transmission of                 
//8/16/24 bits per audio channel for secondary tx fifo_s               
#define BLC_S_MASK              (27 << 26)                                                  
#define BLC_S_BITS_PER_CHAN_16  (0 << 26)           
#define BLC_S_BITS_PER_CHAN_8   (1 << 26)        
#define BLC_S_BITS_PER_CHAN_24  (2 << 26)        
#define BLC_S_RESERVED          (3 << 26)                                            

//bit length control bit which decides transmission of                 
//8/16/24 bits per audio channel for primary tx fifox                  
#define BLC_P_MASK              (3 << 24)                                                  
#define BLC_P_BITS_PER_CHAN_16  (0 << 24)
#define BLC_P_BITS_PER_CHAN_8   (1 << 24)
#define BLC_P_BITS_PER_CHAN_24  (2 << 24)
#define BLC_P_RESERVED          (3 << 24)
                                                
//      RESERVED                                [23:22]        
#define IIS_CH2_DATA_DISCARD_MASK               (3 << 20)
#define IIS_CH2_DATA_NO_DISCARD                 (0 << 20)
#define IIS_CH2_DATA_RIGHT_HALFWORD_DISCARD     (1 << 20)
#define IIS_CH2_DATA_LEFT_HALFWORD_DISCARD      (2 << 20)

#define IIS_CH1_DATA_DISCARD_MASK               (3 << 18)
#define IIS_CH1_DATA_NO_DISCARD                 (0 << 18)
#define IIS_CH1_DATA_RIGHT_HALFWORD_DISCARD     (1 << 18)
#define IIS_CH1_DATA_LEFT_HALFWORD_DISCARD      (2 << 18)
//TBD need more information on this 
#define IIS_DATA_CHANNEL_MASK                   (3 << 16)
#define IIS_SD2_CHANNEL_ENABLE                  (1 << 17)
#define IIS_SD2_CHANNEL_DISABLE                 (0 << 17)
#define IIS_SD1_CHANNEL_ENABLE                  (1 << 16)
#define IIS_SD1_CHANNEL_DISABLE                 (0 << 16)

#define BIT_LENGTH_PER_CHANNEL_MASK             (3 << 13)
#define BIT_LENGTH_PER_CHANNEL_16BIT            (0 << 13)
#define BIT_LENGTH_PER_CHANNEL_8BIT             (1 << 13)
#define BIT_LENGTH_PER_CHANNEL_24BIT            (2 << 13)


#define CODEC_CLOCK_SOURCE_MASK                 (1 << 12)
#define CODEC_CLK_USE_INTERNAL_CLK              (0 << 12)
#define CODEC_CLK_USE_EXTERNAL_CLK              (1 << 12)


#define MASTER_MODE                             (0 << 11)
#define SLAVE_MODE                              (1 << 11)

#define IIS_CLK_MASTER_SLAVE_MASK               (3 << 10)
#define IIS_CLK_MASTER_PCLK_DIV_MODE            (0 << 10)
#define IIS_CLK_MASTER_IISCLK_BYPASS_MODE       (1 << 10)
#define IIS_CLK_SLAVE_MODE                      (2 << 10)

#define TRANSFER_MODE_MASK                      (3 << 8)
#define TRANSFER_MODE_TX_ONLY                   (0 << 8)
#define TRANSFER_MODE_RX_ONLY                   (1 << 8)
#define TRANSFER_MODE_BOTH                      (2 << 8)

#define LR_CH_POL_MASK                          (1 << 7)
#define LR_CH_POL_LOW_FOR_LEFT_HIGH_FOR_RIGHT   (0 << 7)
#define LR_CH_POL_HIGH_FOR_LEFT_LOW_FOR_RIGHT   (1 << 7)

#define SERIAL_DATA_FORMAT_MASK                 (3 << 5)
#define SERIAL_DATA_FORMAT_IIS                  (0 << 5)
#define SERIAL_DATA_FORMAT_MSB_JUSTIFIED        (1 << 5)
#define SERIAL_DATA_FORMAT_LSB_JUSTIFIED        (2 << 5)

#define IIS_CODEC_CLOCK_FREQUENCY_MASK          (3 << 3)
#define IIS_CODEC_CLOCK_FREQUENCY_256FS         (0 << 3)
#define IIS_CODEC_CLOCK_FREQUENCY_512FS         (1 << 3)
#define IIS_CODEC_CLOCK_FREQUENCY_384FS         (2 << 3)
#define IIS_CODEC_CLOCK_FREQUENCY_768FS         (3 << 3)

#define BIT_CLOCK_FREQUENCY_MASK                (3 << 1)
#define BIT_CLOCK_FREQUENCY_32FS                (0 << 1)
#define BIT_CLOCK_FREQUENCY_48FS                (1 << 1)
#define BIT_CLOCK_FREQUENCY_16FS                (2 << 1)
#define BIT_CLOCK_FREQUENCY_24FS                (3 << 1)

        /*---------------------------------------------------------*/
        // IISFIC : IIS Interface FIFO Control Register
        /*---------------------------------------------------------*/
#define TX_FIFO_2_DATA_COUNT_MASK               (0x1F << 24) // [28:24] 5 bits
#define TX_FIFO_2_DATA_COUNT_SHIFT              (24)

#define TX_FIFO_1_DATA_COUNT_MASK               (0x1F << 16) // [20:16] 5 bits
#define TX_FIFO_1_DATA_COUNT_SHIFT              (16)

#define TX_FIFO_FLUSH                           (1 << 15)
#define TX_FIFO_DATA_COUNT_MASK                 (0x1F << 8) // [12:8] 5 bits
#define TX_FIFO_DATA_COUNT_SHIFT                (8)
#define RX_FIFO_FLUSH                           (1 << 7)
#define RX_FIFO_DATA_COUNT_SHIFT                (0)
#define RX_FIFO_DATA_COUNT_MASK                 (0x1F << 0) // [4:0] 5 bits //TBD needs correction mismatch betwenn spec and hw details. Maybe 6 bits

        /*---------------------------------------------------------*/
        // IISPSR : IIS Interface Clock Divider Control Register
        /*---------------------------------------------------------*/
#define PRESCALER_A_ACTIVE                      (1 << 15)
#define PRESCALER_A_DIVISION_VALUE_SHIFT        (8)
#define PRESCALER_A_DIVISION_VALUE_MASK         (0x3F) // [13:8] 6 bits
#define PRESCALER_A_VALUE_0                     (0 << 8) 
#define PRESCALER_A_VALUE_1                     (1 << 8) 
#define PRESCALER_A_VALUE_2                     (2 << 8) 
#define PRESCALER_A_VALUE_3                     (3 << 8) 
#define PRESCALER_A_VALUE_4                     (4 << 8) 
#define PRESCALER_A_VALUE_5                     (5 << 8) 
#define PRESCALER_A_VALUE_6                     (6 << 8) 
#define PRESCALER_A_VALUE_7                     (7 << 8) 

        /*---------------------------------------------------------*/
        // IIS INTERFACE TXFIFO_S CONTROL REGISTER IISFICS
        /*---------------------------------------------------------*/
#define TX_S_FIFO_FLUSH                           (1 << 15)                 
#define TX_S_FIFO_DATA_COUNT_MASK                 (0x7F << 8) // [12:8] 5 bits
#define TX_S_FIFO_DATA_COUNT_SHIFT                (8)                 
                 

        /*---------------------------------------------------------*/
        // IIS AHB DMA CONTROL REGISTER (IISAHB                 
        /*---------------------------------------------------------*/
#define IIS_DMA_START_ADDR_RST                    (1 << 7)  
   
                 
        /*---------------------------------------------------------*/
        // IISTXD : IIS Interface Transmit Data Register
        /*---------------------------------------------------------*/
        /*---------------------------------------------------------*/
        // IISRXD : IIS Interface Receive Data Register
        /*---------------------------------------------------------*/



#if __cplusplus
}
#endif

#endif    // _IIS_INTERFACE_MACRO_H_
