#include <windows.h>
#include <bsp_cfg.h>
#include <register_map.h>
#include "iis_interface_macro.h"
#include "iis_interface.h"
#include <drvlib_wait.h>
#include <drvmsg.h>


//#define DELAY_LOOP_COUNT    (gSystemClock.ARM_CLK/100000)
#define CONTROL_DELAY        (10)
#define CMD_DELAY            (3)


static volatile GPIO_REG * g_pGPIOReg = NULL;
static volatile IIS_REG * g_pIISReg = NULL;


IIS_ERROR IIS_initialize_register_address(void *pIISReg, void *pGPIOReg)
{
    IIS_ERROR error = IIS_SUCCESS;

    //DEBUGMSG(ZONE_FUNCTION,(TEXT("[IIS]++IIS_initialize_register_address(0x%08x, 0x%08x)\n\r"), pIISReg, pGPIOReg));

    if (pIISReg == NULL || pGPIOReg == NULL)
    {
        ERRMSG((L"[IIS:ERR] IIS_initialize_register_address() : NULL pointer parameter\n\r"));
        error = IIS_ERROR_NULL_PARAMETER;
    }
    else
    {
        g_pIISReg = (IIS_REG *)pIISReg;
        g_pGPIOReg = (GPIO_REG *)pGPIOReg;
    }

    return error;
}

void IIS_initialize_interface(BOOL CodecMaster)
{
    DBGMSG(0,(TEXT("[IIS] ++IIS_initialize_interface() \n\r")));
    if (CodecMaster == TRUE)
    {
	    g_pIISReg->IISCON = (0 <<31);  // reset I2S
	    Sleep(10);

	    g_pIISReg->IISCON = (1<<31)| // UNRESET
	                        (1<<18)| // TX SDMA ACTIVE
	                        (1<<16); // PRIMARY TX FIFO UNDER_RUN ENABLE
	    
	    g_pIISReg->IISMOD = (3 <<30)| // Operation Clock 00:CodecClk 11:Audio Bus Clock
	                        (0 <<28)| // TX_S FIFO interface 0:APB 1:IDMA
	                        (0 <<26)| // 16bps TX_S FIFO SRC BLC
	                        (0 <<24)| // 16bps TX_n FIFO SRC BLC
	                        (0 <<16)| // channel = 2 so set to 0 , 2 = 5.1ch
	                        (0 <<13)| // 16bit final sound BLC MIX TX_S & TX_0
	                        (1 <<12)| // Codec clock 0:Internal 1:External
	                        (1 <<11)| // Codec is Slave, Controller is master
	                        (1 <<10)| // use EPLL
	                        (2 << 8)| // R / W simultaneous mode
	                        (0 << 7)| 
	                        (0 << 5)| // I2S Format
	                        (2 << 3)| // 384FS
	                        (0 << 1); // 32fs

		g_pIISReg->IISAHB = (1 << 7)|
	                        (1 << 3);

	    g_pIISReg->IISPSR = (1 <<15)|  // Pre-scaler enable a active
	                        (1 << 8);   // Pre-scaler a division value 1
	 
	    g_pIISReg->IISFIC  = (0x1 << 15); // TX Fifo Flush
	    g_pIISReg->IISFIC  = 0x0;         // TX Fifo NO flush
	    g_pIISReg->IISFICS = (0x1 << 15); // TX Fifo Flush
	    g_pIISReg->IISFICS = 0x0;         // TX Fifo NO flush
	    g_pIISReg->IISFIC  = (0x1 << 7);  // RX Fifo Flush
	    g_pIISReg->IISFIC  = 0x0;         // RX Fifo NO flush

//added by terry from xpad 2011001
		g_pIISReg->IISCON=0x8044CE01;
 		g_pIISReg->IISMOD = 0x10000600;
		g_pIISReg->IISPSR = 0x28;

#ifdef WAV_I2S0
		IIS_port_initialize(IIS_CH_0);     //      IIS_CH_1 --->IIS_CH_0            modified by terry  for easy210 I2S0 20120313
#else //ifdef WAV_I2S1
	    IIS_port_initialize(IIS_CH_1);         
#endif		
    }
    else if (CodecMaster == FALSE)	
    {
	#ifdef WAV_I2S0
	    g_pIISReg->IISCON = (0 <<31);  // reset I2S
	    Sleep(10);

	    g_pIISReg->IISCON = (1 <<31);  // un-reset I2S
							
	    g_pIISReg->IISMOD = (0 <<30)| // Operation Clock 00:CodecClk 11:PCLK
	                        (0 <<28)| // TX_S FIFO interface 0:APB 1:IDMA
	                        (0 <<26)| // 16bps TX_S FIFO SRC BLC
	                        (0 <<24)| // 16bps TX_n FIFO SRC BLC
	                        (0 <<16)| // channel = 2 so set to 0 , 2 = 5.1ch
	                        (0 <<13)| // 16bit final sound BLC MIX TX_S & TX_0
	                        (0 <<12)| // Codec clock 0:Internal 1:External
	                        (0 <<11)| // Codec is Slave, Controller is master  0:master 1:slave mode
	                        (1 <<10)| // use EPLL   0: using adio bus clock 1:using i2sclk
	                        (0 << 8)| // R / W simultaneous mode
	                        (0 << 7)| 
	                        (0 << 5)| // I2S Format
	                        (2 << 3)|// (2 << 3)| // 384FS ----> 256fs modified by terry 20111004 
	                        (0 << 1); // 32fs	
	                        
	    g_pIISReg->IISPSR = (1 <<15)|  // Pre-scaler enable a active
	                       (0<< 8);   // Pre-scaler a division value 3+1 = 4
	 
	    g_pIISReg->IISFIC  = 0x1 << 15;  // TX, Fifo Flush
	    g_pIISReg->IISFIC  = 0x0;         // TX, RX Fifo NO flush	    
	    g_pIISReg->IISFICS = 0x1 << 15;  // TX, RX Fifo Flush
	    g_pIISReg->IISFICS = 0x0;         // TX, RX Fifo NO flush
	    g_pIISReg->IISFIC  = 0x1 << 7;  // RX, Fifo Flush
	    g_pIISReg->IISFIC  = 0x0;         // Tx, RX Fifo NO flush	    
		
		IIS_port_initialize(IIS_CH_0);     //      IIS_CH_1 --->IIS_CH_0            modified by terry  for easy210 I2S0 20120313
		
#else // WAV_I2S1
		
		    g_pIISReg->IISCON = (0 <<31);  // reset I2S
	    Sleep(10);

	    g_pIISReg->IISCON = (1 <<31);  // un-reset I2S
							
	    g_pIISReg->IISMOD = (0 <<30)| // Operation Clock 00:CodecClk 11:PCLK
	                        (0 <<28)| // TX_S FIFO interface 0:APB 1:IDMA
	                        (0 <<26)| // 16bps TX_S FIFO SRC BLC
	                        (0 <<24)| // 16bps TX_n FIFO SRC BLC
	                        (0 <<16)| // channel = 2 so set to 0 , 2 = 5.1ch
	                        (0 <<13)| // 16bit final sound BLC MIX TX_S & TX_0
	                        (0 <<12)| // Codec clock 0:Internal 1:External
	                        (0 <<11)| // Codec is Slave, Controller is master  0:master 1:slave mode
	                        (1 <<10)| // use EPLL   0: using adio bus clock 1:using i2sclk
	                        (0 << 8)| // R / W simultaneous mode
	                        (0 << 7)| 
	                        (0 << 5)| // I2S Format
	                        (0 << 3)|// (2 << 3)| // 384FS ----> 256fs modified by terry 20111004 
	                        (0 << 1); // 32fs	
	                        
	    g_pIISReg->IISPSR = (1 <<15)|  // Pre-scaler enable a active
	                       (5<< 8);   // Pre-scaler a division value 3+1 = 4
	 
	    g_pIISReg->IISFIC  = 0x1 << 15;  // TX, Fifo Flush
	    g_pIISReg->IISFIC  = 0x0;         // TX, RX Fifo NO flush	    
	    g_pIISReg->IISFICS = 0x1 << 15;  // TX, RX Fifo Flush
	    g_pIISReg->IISFICS = 0x0;         // TX, RX Fifo NO flush
	    g_pIISReg->IISFIC  = 0x1 << 7;  // RX, Fifo Flush
	    g_pIISReg->IISFIC  = 0x0;         // Tx, RX Fifo NO flush	    
		IIS_port_initialize(IIS_CH_1);		
		
		
	#endif
    }

	//IIS_print_all();
    DBGMSG(0,(TEXT("[IIS] --IIS_initialize_interface()\n\r")));
}

VOID IIS_print_all(VOID)
{
    ERRMSG((L"[WAV] IISCON 0x%08X\r\n", g_pIISReg->IISCON));
    ERRMSG((L"[WAV] IISMOD 0x%08X\r\n", g_pIISReg->IISMOD));
    ERRMSG((L"[WAV] IISFIC 0x%08X\r\n", g_pIISReg->IISFIC));
    ERRMSG((L"[WAV] IISPSR 0x%08X\r\n", g_pIISReg->IISPSR));
    ERRMSG((L"[WAV] IISFICS 0x%08X\r\n", g_pIISReg->IISFICS));
    ERRMSG((L"[WAV] IISAHB 0x%08X\r\n", g_pIISReg->IISAHB));
    ERRMSG((L"[WAV] IISSTR0 0x%08X\r\n", g_pIISReg->IISSTR0));
    ERRMSG((L"[WAV] IISSIZE 0x%08X\r\n", g_pIISReg->IISSIZE));
    ERRMSG((L"[WAV] IISTRNCNT 0x%08X\r\n", g_pIISReg->IISTRNCNT));
    ERRMSG((L"[WAV] IISLVL0ADDR 0x%08X\r\n", g_pIISReg->IISLVL0ADDR));
    ERRMSG((L"[WAV] IISLVL1ADDR 0x%08X\r\n", g_pIISReg->IISLVL1ADDR));
    ERRMSG((L"[WAV] IISLVL2ADDR 0x%08X\r\n", g_pIISReg->IISLVL2ADDR));
    ERRMSG((L"[WAV] IISLVL3ADDR 0x%08X\r\n", g_pIISReg->IISLVL3ADDR));
    ERRMSG((L"[WAV] IISSTR1 0x%08X\r\n", g_pIISReg->IISSTR1));
}

unsigned int IIS_get_output_physical_buffer_address(IIS_CHANNEL mChannel)
{
    unsigned int m_physical_buffer_address = 0;

   DEBUGMSG(0,(TEXT("[IIS] IIS_get_output_physical_buffer_address() IIS Channel : %x \n\r"),mChnNum));
	
    if (mChannel == IIS_CH_0) 
    {	    
	    m_physical_buffer_address = (unsigned int)(0xEEE30010);
    }	    
    else if (mChannel == IIS_CH_1) 
    {	    	    
	    m_physical_buffer_address = (unsigned int)(0XE2100010);
    }
	else if (mChannel == IIS_CH_2) 
    {	    	    
	    m_physical_buffer_address = (unsigned int)(0XE2A00010);
    }
    
    return m_physical_buffer_address;
}

unsigned int IIS_get_input_physical_buffer_address(IIS_CHANNEL mChannel)
{
    unsigned int m_physical_buffer_address = 0;

    //DEBUGMSG(ZONE_FUNCTION,(TEXT("[IIS] IIS_get_input_physical_buffer_address() IIS Channel : %x \n\r"),mChnNum));

    if (mChannel == IIS_CH_0)
    {	    
	    m_physical_buffer_address = (unsigned int)(0xEEE30014);
    }	        
    else if (mChannel == IIS_CH_1)
    {	    
	    m_physical_buffer_address = (unsigned int)(0XE2100014);
    }	    
    else if (mChannel == IIS_CH_2)
    {	    
	    m_physical_buffer_address = (unsigned int)(0XE2A00014);
    }	    
    
    return m_physical_buffer_address;
}

PRIVATE void IIS_port_initialize(IIS_CHANNEL mChnNum)
{
    //DEBUGMSG(ZONE_FUNCTION,(TEXT("[IIS] IIS_port_initialize() IIS Channel : %x \n\r"),mChnNum));

    ASSERT( (mChnNum == IIS_CH_0) || (mChnNum == IIS_CH_1)  || (mChnNum == IIS_CH_2));

    if (mChnNum == IIS_CH_0)
    {
        //DEBUGMSG(ZONE_FUNCTION,(TEXT("I2S 0 Channel's GPIO Ports configuration...\n")));
        Set_PinFunction(g_pGPIOReg, GPI00_I2S_0_SCLK);   
        Set_PinFunction(g_pGPIOReg, GPI01_I2S_0_CDCLK);
        Set_PinFunction(g_pGPIOReg, GPI02_I2S_0_LRCK);
        Set_PinFunction(g_pGPIOReg, GPI03_I2S_0_SDI);
        Set_PinFunction(g_pGPIOReg, GPI04_I2S_0_SDO_0);

        Set_PinPullUD(g_pGPIOReg, GPI00_I2S_0_SCLK,  sgip_PULL_DISABLE);   
        Set_PinPullUD(g_pGPIOReg, GPI01_I2S_0_CDCLK, sgip_PULL_DISABLE);
        Set_PinPullUD(g_pGPIOReg, GPI02_I2S_0_LRCK,  sgip_PULL_DISABLE);
        Set_PinPullUD(g_pGPIOReg, GPI03_I2S_0_SDI,   sgip_PULL_DISABLE);
        Set_PinPullUD(g_pGPIOReg, GPI04_I2S_0_SDO_0, sgip_PULL_DISABLE);
    }
    else if (mChnNum == IIS_CH_1)
    {
        //DEBUGMSG(ZONE_FUNCTION,(TEXT("[IIS] I2S 1 Channel's GPIO Ports configuration...\n\r")));
        Set_PinFunction(g_pGPIOReg, GPC00_I2S_1_SCLK);   
        Set_PinFunction(g_pGPIOReg, GPC01_I2S_1_CDCLK);
        Set_PinFunction(g_pGPIOReg, GPC02_I2S_1_LRCK);
        Set_PinFunction(g_pGPIOReg, GPC03_I2S_1_SDI);
        Set_PinFunction(g_pGPIOReg, GPC04_I2S_1_SDO);

        Set_PinPullUD(g_pGPIOReg, GPC00_I2S_1_SCLK,  sgip_PULL_DISABLE);   
        Set_PinPullUD(g_pGPIOReg, GPC01_I2S_1_CDCLK, sgip_PULL_DISABLE);
        Set_PinPullUD(g_pGPIOReg, GPC02_I2S_1_LRCK,  sgip_PULL_DISABLE);
        Set_PinPullUD(g_pGPIOReg, GPC03_I2S_1_SDI,   sgip_PULL_DISABLE);
        Set_PinPullUD(g_pGPIOReg, GPC04_I2S_1_SDO,   sgip_PULL_DISABLE);
    }
    else if (mChnNum == IIS_CH_2)
    {
        //DEBUGMSG(ZONE_FUNCTION,(TEXT("[IIS] I2S 2 Channel's GPIO Ports configuration...\n\r")));
        Set_PinFunction(g_pGPIOReg, GPC10_I2S_2_SCLK);   
        Set_PinFunction(g_pGPIOReg, GPC11_I2S_2_CDCLK);
        Set_PinFunction(g_pGPIOReg, GPC12_I2S_2_LRCK);
        Set_PinFunction(g_pGPIOReg, GPC13_I2S_2_SDI);
        Set_PinFunction(g_pGPIOReg, GPC14_I2S_2_SDO);

        Set_PinPullUD(g_pGPIOReg, GPC10_I2S_2_SCLK,  sgip_PULL_DISABLE);   
        Set_PinPullUD(g_pGPIOReg, GPC11_I2S_2_CDCLK, sgip_PULL_DISABLE);
        Set_PinPullUD(g_pGPIOReg, GPC12_I2S_2_LRCK,  sgip_PULL_DISABLE);
        Set_PinPullUD(g_pGPIOReg, GPC13_I2S_2_SDI,   sgip_PULL_DISABLE);
        Set_PinPullUD(g_pGPIOReg, GPC14_I2S_2_SDO,   sgip_PULL_DISABLE);
    }
}


void IIS_set_tx_mode_control(IIS_TRANSFER_PAUSE_CONTROL mMode)
{
    DWORD uRegValue = 0;

    //DEBUGMSG(ZONE_FUNCTION,(TEXT("[IIS] IIS_set_tx_mode_control [%d]\r\n"), mMode));

    uRegValue = g_pIISReg->IISCON & ~(TX_MOD_MASK);

    switch(mMode)
    {
        case IIS_TRANSFER_NOPAUSE :
            uRegValue = uRegValue |(TX_DMA_NOPAUSE) | (TX_CHANNEL_NOPAUSE) | (TX_DMA_ACTIVE);
            break;
        case IIS_TRANSFER_PAUSE :
            uRegValue = uRegValue | (TX_DMA_PAUSE) | (TX_CHANNEL_PAUSE) | (TX_DMA_INACTIVE);
            break;
        default :
            break;
    }

    g_pIISReg->IISCON = uRegValue;
}

void IIS_set_rx_mode_control(IIS_TRANSFER_PAUSE_CONTROL mMode)
{
    DWORD uRegValue = 0;

    //DEBUGMSG(ZONE_FUNCTION,(TEXT("[IIS] IIS_set_rx_mode_control [%d]\r\n"), mMode));

    uRegValue = g_pIISReg->IISCON & ~(RX_MOD_MASK);

    switch(mMode)
    {
        case IIS_TRANSFER_NOPAUSE :
            uRegValue = uRegValue | (RX_DMA_NOPAUSE) | (RX_CHANNEL_NOPAUSE) | (RX_DMA_ACTIVE);
            break;
        case IIS_TRANSFER_PAUSE :
            uRegValue = uRegValue | (RX_DMA_PAUSE) | (RX_CHANNEL_PAUSE) | (RX_DMA_INACTIVE);
            break;
        default :
            break;
    }

    g_pIISReg->IISCON = uRegValue;
}



PRIVATE void IIS_set_active_on(void)
{
    DBGMSG(0,(TEXT("[IIS] IIS_set_active_on()................................\n\r")));

    if (g_pIISReg->IISCON & IIS_ACTIVE)
    {
        //DEBUGMSG(ZONE_FUNCTION,(TEXT("IIS is already active\r\n")));
    }
    else
    {	    
        g_pIISReg->IISCON |= IIS_ACTIVE;
    }
}

PRIVATE void IIS_set_active_off(void)
{
   DEBUGMSG(0,(TEXT("[IIS] IIS_set_active_off()\n\r")));

    g_pIISReg->IISCON &= ~IIS_ACTIVE;
}

PRIVATE void IIS_Set_Internal_DMA_Transfer_Size(DWORD dwSize)
{
    DWORD   dwTr;
 
  	dwTr = (dwSize/4);
    g_pIISReg->IISSIZE = (dwTr<<16)|0x1;
}

PRIVATE void IIS_Set_Internal_DMA_Source(UINT32 BufferPhyAddr0, UINT32 BufferPhyAddr1, DWORD BufferSize)
{
    g_pIISReg->IISSTR0 = BufferPhyAddr0;
    g_pIISReg->IISSTR1 = BufferPhyAddr1;

    IIS_Set_Internal_DMA_Transfer_Size(BufferSize);
}

PRIVATE void IIS_Start_Internal_DMA()
{
    //g_pIISReg->IISAHB = (1<<6)|(1<<5)|(1<<3)|(1<<1)|(1<<0);
    g_pIISReg->IISAHB = (0<<6)|(1<<5)|(1<<3)|(1<<1)|(1<<0);
}

PRIVATE void IIS_Stop_Internal_DMA()
{
    g_pIISReg->IISAHB = (0<<5)|(1<<1)|(0<<0);
}

PRIVATE void IIS_Get_Interrupt_Pending(IIS_INTR_SRC *eInt)
{
	DWORD uCon,uAhb;

	uAhb = g_pIISReg->IISAHB;
	if (uAhb&(1<<2))
	{
	    //DEBUGMSG(ZONE_INTR,(TEXT("IIS_INT_IDMA_DONE\r\n")));
		*eInt = IIS_INT_IDMA_DONE;
	}
	else if (uAhb&(1<<20))
	{
	    //DEBUGMSG(ZONE_INTR,(TEXT("LVL0\r\n")));
		*eInt = IIS_INT_LVL0;
	}
	else if (uAhb&(1<<21))
	{
	    //DEBUGMSG(ZONE_INTR,(TEXT("LVL1 0x%x\r\n"),(g_pIISReg->IISFICS & 0x7f00) >> 8));
	    *eInt = IIS_INT_LVL1;
	}
	else if (uAhb&(1<<22))
	{
	    //DEBUGMSG(ZONE_INTR,(TEXT("IIS_INT_LVL2\r\n")));
		*eInt = IIS_INT_LVL2;
	}
	else if (uAhb&(1<<23))
	{
	    //DEBUGMSG(ZONE_INTR,(TEXT("IIS_INT_LVL3\r\n")));
		*eInt = IIS_INT_LVL3;
	}
	else
	{
		uCon = g_pIISReg->IISCON;

		if (uCon&OCCURED_INT_UDR_TXn)
        {
    	    //DEBUGMSG(ZONE_INTR,(TEXT("IIS_INT_UDR_TXn\r\n")));
            *eInt = IIS_INT_UDR_TXn;
        }
		else if (uCon&OCCURED_INT_OVR_RX)
		{
    	    //DEBUGMSG(ZONE_INTR,(TEXT("IIS_INT_OVR_RX\r\n")));
			*eInt = IIS_INT_OVR_RX;
		}
		else if (uCon&OCCURED_INT_UDR_TXS)
		{
    	    //DEBUGMSG(ZONE_INTR,(TEXT("IIS_INT_UDR_TXS\r\n")));
			*eInt = IIS_INT_UDR_TXS;
		}
		else
		{
    	    //DEBUGMSG(ZONE_INTR,(TEXT("IIS_INT_NOINT\r\n")));
			*eInt = IIS_INT_NOINT;
		}
	}
	
}

// [Clear interrupt ]
PRIVATE void IIS_ClearIntPending(IIS_INTR_SRC eInt)
{
	//DWORD uOffset;
	switch(eInt)
	{
		case IIS_INT_LVL0:
                g_pIISReg->IISAHB |= (1<<16);
                break;
                
		case IIS_INT_LVL1:
                g_pIISReg->IISAHB |= (1<<17);
                break;          
                
		case IIS_INT_LVL2:
                g_pIISReg->IISAHB |= (1<<18);
                break;      
                
		case IIS_INT_LVL3:
                g_pIISReg->IISAHB |= (1<<19);
                break;            

		case IIS_INT_IDMA_DONE:
    	    g_pIISReg->IISAHB |= (1<<1);
			break;

		case IIS_INT_UDR_TXS:
			g_pIISReg->IISCON |= OCCURED_INT_UDR_TXS;
			break;

        case IIS_INT_UDR_TXn:
			g_pIISReg->IISCON |= OCCURED_INT_UDR_TXn;
			break;    

		default:
            RETAILMSG(1, (L"[WAV] UNRESOLVED\r\nJ"));
			break;
	}
}


// [Set Idma Level interrupt Address & enable Level interrupt]
PRIVATE void IIS_Set_LevelInterrupt(IIS_INTR_SRC eLvInt, DWORD uTriggerAddr)
{
	// [1. set interrupt trigger level addr]
	DWORD uOffset = (eLvInt==IIS_INT_LVL0) ? 0 :
		(eLvInt==IIS_INT_LVL1) ? 1 :
		(eLvInt==IIS_INT_LVL2) ? 2 :
		(eLvInt==IIS_INT_LVL3) ? 3 : 0xffff;
	
	switch(eLvInt)
	{
	    case IIS_INT_LVL0:
	        g_pIISReg->IISLVL0ADDR = uTriggerAddr;
	        break;

	    case IIS_INT_LVL1:
	        g_pIISReg->IISLVL1ADDR = uTriggerAddr;
	        break;

	    case IIS_INT_LVL2:
	        g_pIISReg->IISLVL2ADDR = uTriggerAddr;
	        break;

	    case IIS_INT_LVL3:
	        g_pIISReg->IISLVL3ADDR = uTriggerAddr;
	        break;
	        
	}			


	// [2. enable lv interrupt]
	g_pIISReg->IISAHB |= (1<<(uOffset+24));

}

PRIVATE BOOL IIS_Get_Internal_DMA_Pending()
{
    if( (g_pIISReg->IISAHB & (1 << 2)) )
        return TRUE;
    else
        return FALSE;
}

PRIVATE void IIS_Clear_Internal_DMA_Pending()
{
    g_pIISReg->IISAHB |= (1<<1);
} 

PRIVATE void IIS_Set_FIFO_To_Internal_DMA(BOOL bSet)
{
    if(bSet)
        g_pIISReg->IISMOD |= (1<<28);
    else
        g_pIISReg->IISMOD &= (0<<28);
}


void IIS_set_tx_LP_mode_control(IIS_TRANSFER_PAUSE_CONTROL mMode)
{
    DWORD uRegValue = 0;

    //DEBUGMSG(ZONE_FUNCTION,(TEXT("[IIS] IIS_set_tx_mode_control [%d]\r\n"), mMode));

    uRegValue = g_pIISReg->IISCON & ~(TXS_MOD_MASK);

    switch(mMode)
    {
        case IIS_TRANSFER_NOPAUSE :
            uRegValue = uRegValue |(TXS_DMA_NOPAUSE) | (TXS_CHANNEL_NOPAUSE) | (TXS_DMA_ACTIVE)|(1<<23);
            break;
        case IIS_TRANSFER_PAUSE :
            uRegValue = uRegValue | (TXS_DMA_PAUSE) | (TXS_CHANNEL_PAUSE) | (TXS_DMA_INACTIVE)|(0<<23);
            break;
        default :
            break;
    }


    g_pIISReg->IISCON = uRegValue;
}
