//--------------------------------------------------------------------------------------------------------------------
#include <BSP.h>
#include <I2CEMUL_TYPE.h>
#include <OAL_I2CEMUL.h>
#include <mmilib.h>

extern I2C_EMUL_MAPGPIO *I2CEMULMapGpioLIst[I2C_MAX_GROUP];
extern I2C_EMUL_UNMAPGPIO *I2CEMULUnmapGpioList[I2C_MAX_GROUP];
extern I2CEMUL_GPIO I2CEMULGpioList[I2C_MAX_GROUP];

VOID I2C_EMUL_MapVirtualGPIO4(PVOID pGpioBaseAddr)
{
	volatile S5PV210_GPIO_REG* pRegGpio = (volatile S5PV210_GPIO_REG *)pGpioBaseAddr;

	if (pRegGpio == NULL) 
	{
		RETAILMSG(TRUE, (TEXT("[I2CEMUL] GROUP4 INIT FAIL\n\r")));
	}

	//---SCL PARAMETER SETTING : GPJ3[7]----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G3].pSCLCON_REG = &pRegGpio->GPJ3CON; //  = (SCLCON & ~(MASK << INDEX)) | (X << INDEX)
	I2CEMULGpioList[I2CEMUL_G3].dwSCLCONIndex = 28;
	I2CEMULGpioList[I2CEMUL_G3].dwSCLCONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G3].pSCLPUD_REG = &pRegGpio->GPJ3PUD;
	I2CEMULGpioList[I2CEMUL_G3].dwSCLPUDIndex = 14;
	I2CEMULGpioList[I2CEMUL_G3].dwSCLPUDMask = 0x3;

	I2CEMULGpioList[I2CEMUL_G3].pSCLDAT_REG = &pRegGpio->GPJ3DAT;
	I2CEMULGpioList[I2CEMUL_G3].dwSCLDATIndex = 7;

	//---SDA PARAMETER SETTING : GPJ3[6]----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G3].pSDACON_REG = &pRegGpio->GPJ3CON;
	I2CEMULGpioList[I2CEMUL_G3].dwSDACONIndex = 24;
	I2CEMULGpioList[I2CEMUL_G3].dwSDACONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G3].pSDAPUD_REG = &pRegGpio->GPJ3PUD;
	I2CEMULGpioList[I2CEMUL_G3].dwSDAPUDIndex = 12;
	I2CEMULGpioList[I2CEMUL_G3].dwSDAPUDMask = 0x3;	

	I2CEMULGpioList[I2CEMUL_G3].pSDADAT_REG = &pRegGpio->GPJ3DAT;
	I2CEMULGpioList[I2CEMUL_G3].dwSDADATIndex = 6;

	//---ADD TO LIST--------------------------------------------------------------------------------------
}

VOID I2C_EMUL_UnmapVirtualGPIO4(VOID)
{
	//NOT IMPLEMENTED FOR FUTURE
	I2CEMULUnmapGpioList[I2CEMUL_G3] = I2C_EMUL_UnmapVirtualGPIO4;
}



