//--------------------------------------------------------------------------------------------------------------------
#include <BSP.h>
#include <I2CEMUL_TYPE.h>
#include <OAL_I2CEMUL.h>
#include <mmilib.h>

extern I2C_EMUL_MAPGPIO *I2CEMULMapGpioLIst[I2C_MAX_GROUP];
extern I2C_EMUL_UNMAPGPIO *I2CEMULUnmapGpioList[I2C_MAX_GROUP];
extern I2CEMUL_GPIO I2CEMULGpioList[I2C_MAX_GROUP];

VOID I2C_EMUL_MapVirtualGPIO3(PVOID pGpioBaseAddr)
{
	volatile S5PV210_GPIO_REG* pRegGpio = (volatile S5PV210_GPIO_REG *)pGpioBaseAddr;

	if (pRegGpio == NULL) 
	{
		RETAILMSG(TRUE, (TEXT("[I2CEMUL] GROUP3 INIT FAIL\n\r")));
	}

	//---SCL PARAMETER SETTING----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G2].pSCLCON_REG = &pRegGpio->GPK1CON; //  = (SCLCON & ~(MASK << INDEX)) | (X << INDEX)
	I2CEMULGpioList[I2CEMUL_G2].dwSCLCONIndex = 8;
	I2CEMULGpioList[I2CEMUL_G2].dwSCLCONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G2].pSCLPUD_REG = &pRegGpio->GPK1PUD;
	I2CEMULGpioList[I2CEMUL_G2].dwSCLPUDIndex = 4;
	I2CEMULGpioList[I2CEMUL_G2].dwSCLPUDMask = 0x3;

	I2CEMULGpioList[I2CEMUL_G2].pSCLDAT_REG = &pRegGpio->GPK1DAT;
	I2CEMULGpioList[I2CEMUL_G2].dwSCLDATIndex = 2;

	//---SDA PARAMETER SETTING----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G2].pSDACON_REG = &pRegGpio->GPK3CON;
	I2CEMULGpioList[I2CEMUL_G2].dwSDACONIndex = 12;
	I2CEMULGpioList[I2CEMUL_G2].dwSDACONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G2].pSDAPUD_REG = &pRegGpio->GPK3PUD;
	I2CEMULGpioList[I2CEMUL_G2].dwSDAPUDIndex = 6;
	I2CEMULGpioList[I2CEMUL_G2].dwSDAPUDMask = 0x3;	

	I2CEMULGpioList[I2CEMUL_G2].pSDADAT_REG = &pRegGpio->GPK3DAT;
	I2CEMULGpioList[I2CEMUL_G2].dwSDADATIndex = 3;

	//---ADD TO LIST--------------------------------------------------------------------------------------
}

VOID I2C_EMUL_UnmapVirtualGPIO3(VOID)
{
	//NOT IMPLEMENTED FOR FUTURE
	I2CEMULUnmapGpioList[I2CEMUL_G2] = I2C_EMUL_UnmapVirtualGPIO3;
}



