//--------------------------------------------------------------------------------------------------------------------
#include <BSP.h>
#include <I2CEMUL_TYPE.h>
#include <OAL_I2CEMUL.h>
//#include <mmilib.h>

extern I2C_EMUL_MAPGPIO *I2CEMULMapGpioLIst[I2C_MAX_GROUP];
extern I2C_EMUL_UNMAPGPIO *I2CEMULUnmapGpioList[I2C_MAX_GROUP];
extern I2CEMUL_GPIO I2CEMULGpioList[I2C_MAX_GROUP];

VOID I2C_EMUL_MapVirtualGPIO0(PVOID pGpioBaseAddr)
{
	volatile GPIO_REG* pRegGpio = (volatile GPIO_REG *)pGpioBaseAddr;

	if (pRegGpio == NULL) 
	{
		RETAILMSG(TRUE, (TEXT("[I2CEMUL] GROUP1 INIT FAIL\n\r")));
	}
	
	//---SCL PARAMETER SETTING----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G0].pSCLCON_REG = &pRegGpio->GPD1.GP_CON; //  = (SCLCON & ~(MASK << INDEX)) | (X << INDEX)
	I2CEMULGpioList[I2CEMUL_G0].dwSCLCONIndex = 20;                     // GPD1_5 ; SCL
	I2CEMULGpioList[I2CEMUL_G0].dwSCLCONMask = 0xF;

	I2CEMULGpioList[I2CEMUL_G0].pSCLPUD_REG = &pRegGpio->GPD1.GP_PUD;
	I2CEMULGpioList[I2CEMUL_G0].dwSCLPUDIndex = 10;
	I2CEMULGpioList[I2CEMUL_G0].dwSCLPUDMask = 0x3;

	I2CEMULGpioList[I2CEMUL_G0].pSCLDAT_REG = &pRegGpio->GPD1.GP_DAT;
	I2CEMULGpioList[I2CEMUL_G0].dwSCLDATIndex = 5;
	

	//---SDA PARAMETER SETTING----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G0].pSDACON_REG = &pRegGpio->GPD1.GP_CON;
	I2CEMULGpioList[I2CEMUL_G0].dwSDACONIndex = 16;                      // GPD1_4
	I2CEMULGpioList[I2CEMUL_G0].dwSDACONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G0].pSDAPUD_REG = &pRegGpio->GPD1.GP_PUD;
	I2CEMULGpioList[I2CEMUL_G0].dwSDAPUDIndex = 8;
	I2CEMULGpioList[I2CEMUL_G0].dwSDAPUDMask = 0x3;	

	I2CEMULGpioList[I2CEMUL_G0].pSDADAT_REG = &pRegGpio->GPD1.GP_DAT;
	I2CEMULGpioList[I2CEMUL_G0].dwSDADATIndex = 4;

	//---ADD TO LIST--------------------------------------------------------------------------------------
}

VOID I2C_EMUL_UnmapVirtualGPIO0(VOID)
{
	//NOT IMPLEMENTED FOR FUTURE
	I2CEMULUnmapGpioList[I2CEMUL_G0] = I2C_EMUL_UnmapVirtualGPIO0;
}



