;
; Use of this source code is subject to the terms of the Microsoft end-user
; license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
; If you did not accept the terms of the EULA, you are not authorized to use
; this source code. For a copy of the EULA, please see the LICENSE.RTF on your
; install media.
;
;******************************************************************************
;*
;* System On Chip(SOC)
;*
;* Copyright (c) 2002 Software Center, Samsung Electronics, Inc.
;* All rights reserved.
;*
;* This software is the confidential and proprietary information of Samsung 
;* Electronics, Inc("Confidential Information"). You Shall not disclose such 
;* Confidential Information and shall use it only in accordance with the terms 
;* of the license agreement you entered into Samsung.
;*
;******************************************************************************

    INCLUDE kxarm.h
    INCLUDE register_map.inc
    INCLUDE image_cfg.inc

    INCLUDE armmacros.s
    INCLUDE oal_cache.inc

    IMPORT g_oalCacheInfo    
    
PHY_RAM_START    EQU    DRAM_BASE_PA_START
VIR_RAM_START    EQU    DRAM_BASE_CA_START

    TEXTAREA

    LEAF_ENTRY Launch

;------------------------------------
;    Interrupt Disable
;------------------------------------
        ldr     r1, =0xFFFFFFFF

        ldr     r2, =vVIC0INTENCLEAR
        str     r1, [r2]

        ldr     r2, =vVIC1INTENCLEAR
        str     r1, [r2]

        ldr     r2, =vVIC2INTENCLEAR
        str     r1, [r2]
   
        ldr     r2, =vVIC3INTENCLEAR
        str     r1, [r2]
        
;------------------------------------
;    Disable MMU
;------------------------------------
	mov     r12, r0
	ldr     r2, = DisableMMU
	ldr     r3, = (VIR_RAM_START - PHY_RAM_START)

	sub     r2, r2, r3

	MOV     PC, R2
	NOP
	NOP
	NOP
	NOP     

DisableMMU
    ;--------------------------------------------------------------------------------------
    ; 1. Cache Clean and Invalidate D-Cache.
    ;--------------------------------------------------------------------------------------    
    MRC     p15, 1, r0, c0, c0, 1   ; Read CLIDR
    ANDS    r3, r0, #&7000000
    MOV     r3, r3, LSR #23         ; Cache level value (naturally aligned)
    BEQ     %F70
    MOV     r10, #0
10     
    ADD     r2, r10, r10, LSR #1    ; Work out 3xcachelevel
    MOV     r1, r0, LSR r2          ; bottom 3 bits are the Ctype for this level
    AND     r1, r1, #7              ; get those 3 bits alone
    CMP     r1, #2
    BLT     %F50                    ; no cache or only instruction cache at this level
    MCR     p15, 2, r10, c0, c0, 0  ; write the Cache Size selection register
    MOV     r1, #0
    ;MCR     p15, 0, r1, c7, c5, 4   ; PrefetchFlush to sync the change to the CacheSizeID reg
    DCD     0xf57ff06f              ; ISB (Instruction Synchronization Barrier)
    MRC     p15, 1, r1, c0, c0, 0   ; reads current Cache Size ID register
    AND     r2, r1, #&7             ; extract the line length field
    ADD     r2, r2, #4              ; add 4 for the line length offset (log2 16 bytes)
    LDR     r4, =0x3FF
    ANDS    r4, r4, r1, LSR #3      ; R4 is the max number on the way size (right aligned)
    CLZ     r5, r4                  ; R5 is the bit position of the way size increment
    LDR     r7, =0x00007FFF
    ANDS    r7, r7, r1, LSR #13     ; R7 is the max number of the index size (right aligned)
20         
    MOV     r9, r4                  ; R9 working copy of the max way size (right aligned)
30     
    ORR     r11, r10, r9, LSL r5    ; factor in the way number and cache number into R11
    ORR     r11, r11, r7, LSL r2    ; factor in the index number
    MCR     p15, 0, r11, c7, c14, 2 ; clean and invalidate by set/way
    SUBS    r9, r9, #1              ; decrement the way number
    BGE     %B30
    SUBS    r7, r7, #1              ; decrement the index
    BGE     %B20
50      
    ADD     r10, r10, #2            ; increment the cache number
    CMP     r3, r10
    BGT     %B10
70

    ;--------------------------------------------------------------------------------------
    ; 2. Disable branch prediction.
    ;--------------------------------------------------------------------------------------    
    MRC     p15, 0, r1, c1, c0, 0   ; read CP15 Register 1
    BIC     r1, r1, #1<<11
    MCR     p15, 0, r1, c1, c0, 0   ; BP disabled

    ;--------------------------------------------------------------------------------------
    ; 3. Prefetch buffer flush.
    ;--------------------------------------------------------------------------------------    
    MOV     r1, #0
    ;MCR     p15, 0, r1, c7, c5, 4   ; PrefetchFlush to sync the change to the CacheSizeID reg
    DCD     0xf57ff06f               ; ISB (Instruction Synchronization Barrier)

    ;--------------------------------------------------------------------------------------
    ; 4. I-TLB invalidate.
    ;--------------------------------------------------------------------------------------    
    MOV     r1, #0
    MCR     p15, 0, r2, c8, c5, 0   

    ;--------------------------------------------------------------------------------------
    ; 5. D-TLB invalidate.
    ;--------------------------------------------------------------------------------------    
    MOV     r1, #0
    MCR     p15, 0, r2, c8, c6, 0   

    ;--------------------------------------------------------------------------------------
    ; 6.7 Disable I and D Cache.
    ;--------------------------------------------------------------------------------------    
    MRC     p15, 0, r1, c1, c0, 0   ; read CP15 Register 1
    BIC     r1, r1, #1<<12          ; Disable I-Cache  
    BIC     r1, r1, #1<<2           ; Disable D-Cache      
    MCR     p15, 0, r1, c1, c0, 0   ; I/D Cache disabled

    ;--------------------------------------------------------------------------------------
    ; 8. DISABLE "MMU"
    ;--------------------------------------------------------------------------------------    
    MRC     p15, 0, r1, c1, c0, 0   ; read CP15 Register 1      
    BIC     r1, r1, #1              ; Disable MMU
    MCR     p15, 0, r1, c1, c0, 0   ; I/D Cache disabled
    NOP
    NOP
    NOP
    NOP

    mov     pc, r12                 ; Jump to program we are launching.

    ENTRY_END
    
    ;++
    ;  Routine:
    ;
    ;      ShowLights
    ;
    ;  Description:
    ;
    ;      Set the Hexadecimal LED array to the values specified
    ;
    ;  Arguments:
    ;
    ;      r0 = word containing 8 nibble values to write to the Hexadecimal LED
    ;      
    ;
    ;--

    LEAF_ENTRY ShowLights

    mov    pc, lr

    ENTRY_END


    LEAF_ENTRY CP15_Read_ID_Code
    mrc     p15,0,r0,c0,c0,0
    mov     pc, lr
    ENTRY_END
    
    LEAF_ENTRY CP15_Read_Cache_Type
    mrc     p15,0,r0,c0,c0,1
    mov     pc, lr
    ENTRY_END

    LEAF_ENTRY CP15_Read_TCM_Type
    mrc     p15,0,r0,c0,c0,2
    mov     pc, lr
    ENTRY_END

    LEAF_ENTRY CP15_Control_R1
    mrc     p15,0,r0,c1,c0,0
    mov     pc, lr
    ENTRY_END


    END