;------------------------------------------------------------------------------
;
;  File:  oemaddrtab_cfg_eboot.inc
;
;  This file is used to define g_oalAddressTable. This table is passed to
;  eboot's startup.s to estabilish physical to virtual memory mapping.
;  This table is used also in IOMEM OAL module to map between physical and virtual
;  memory addresses via OALPAtoVA/OALVAtoPA functions. So, EBOOT also can use
;  OALPAtoVA/OALVAtoPA functions.
;
;------------------------------------------------------------------------------

; Export Definition

        EXPORT  g_oalAddressTable[DATA]

;------------------------------------------------------------------------------
;
; TABLE FORMAT
;       cached address, physical address, size
;------------------------------------------------------------------------------

g_oalAddressTable

        ; Define only used IP block in EBOOT
        ; This mapping table will disappear when jumping to Kernel
        DCD 0x80000000, 0x20000000, 128 ; 128 MB DRAM
        DCD 0x90000000, 0xE0000000, 42  ; SFR1
        DCD 0x92A00000, 0xE8000000, 3   ; SROM/CF
        DCD 0x92D00000, 0xEA000000, 1   ; SECSS        
        DCD 0x92E00000, 0xEB000000, 5   ; SDMMC/TSI
        DCD 0x93300000, 0xEC000000, 4   ; USB OTG/USB HOST
        DCD 0x93700000, 0xED000000, 2   ; MODEM
        DCD 0x93900000, 0xEE000000, 16  ; AUDIO_SS
        DCD 0x94900000, 0xF0000000, 1   ; DMC0
        DCD 0x94A00000, 0xF1000000, 3   ; AXI_MSYS/AXI_MSFR/AXI_VSYS
        DCD 0x94D00000, 0xF1400000, 12  ; DMC1/TZPC0/SDM/MFC/ASYNC_AXI_APBIF
        DCD 0x95900000, 0xF2000000, 4   ; VIC
        DCD 0x95D00000, 0xF2800000, 4   ; TZIC
        DCD 0x96100000, 0xF3000000, 16  ; 3D
        DCD 0x97100000, 0xF8000000, 3   ; FIMD/MIE
        DCD 0x97400000, 0xF9000000, 2   ; TVENC/VP/MIXER
        DCD 0x97700000, 0xFA100000, 15  ; SFR2
        DCD 0x98600000, 0xFB100000, 4   ; Rotator/FIMC
        DCD 0x98A00000, 0xFB600000, 2   ; JPEG/IPC
        DCD 0x98B00000, 0xB0000000, 1   ; OneNAND Buffer
        DCD 0x98C00000, 0xB0400000, 1   ; OneNAND CMD
        DCD 0x98D00000, 0xB0600000, 1   ; OneNAND Controller
        DCD 0x98E00000, 0xB0E00000, 1   ; NFCON

        DCD 0x00000000, 0x00000000, 0    ; End of Table
;------------------------------------------------------------------------------
        END
